/*
 * Decompiled with CFR 0.152.
 */
package org.mule.tooling.ui.modules.core.widgets.meta;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.mule.tooling.core.MuleCorePlugin;
import org.mule.tooling.core.dom.IAttributeWrapper;
import org.mule.tooling.core.dom.IElementWrapper;
import org.mule.tooling.core.generator.IFlowTransformerContext;
import org.mule.tooling.core.generator.IModelGenerator;
import org.mule.tooling.core.utils.ExpressionUtils;
import org.mule.tooling.model.messageflow.IMessageFlowNode;
import org.mule.tooling.model.messageflow.IReadOnlyProperty;
import org.mule.tooling.model.messageflow.IReadOnlyPropertyCollection;
import org.mule.tooling.model.messageflow.MessageFlowEntity;
import org.mule.tooling.model.messageflow.decorator.PropertyCollectionMap;
import org.mule.tooling.ui.modules.core.widgets.AttributeContext;
import org.mule.tooling.ui.modules.core.widgets.IContentProposalProviderFactory;
import org.mule.tooling.ui.modules.core.widgets.IValidator;
import org.mule.tooling.ui.modules.core.widgets.meta.AttributeHelper;
import org.mule.tooling.ui.modules.core.widgets.meta.BooleanAttributeHelper;
import org.mule.tooling.ui.modules.core.widgets.meta.ButtonAttributeHelper;
import org.mule.tooling.ui.modules.core.widgets.meta.DateTimeAttributeHelper;
import org.mule.tooling.ui.modules.core.widgets.meta.DoubleAttributeHelper;
import org.mule.tooling.ui.modules.core.widgets.meta.EnumHelper;
import org.mule.tooling.ui.modules.core.widgets.meta.EnumOption;
import org.mule.tooling.ui.modules.core.widgets.meta.IntegerAttributeHelper;
import org.mule.tooling.ui.modules.core.widgets.meta.LongAttributeHelper;
import org.mule.tooling.ui.modules.core.widgets.meta.MetaDescriptionEntry;
import org.mule.tooling.ui.modules.core.widgets.meta.PasswordAttributeHelper;
import org.mule.tooling.ui.modules.core.widgets.meta.RadioButtonsAtr;
import org.mule.tooling.ui.modules.core.widgets.meta.ResourceAttributeHelper;
import org.mule.tooling.ui.modules.core.widgets.meta.SetAttributeHelper;
import org.mule.tooling.ui.modules.core.widgets.meta.Sort;
import org.mule.tooling.ui.modules.core.widgets.meta.TimeAttributeHelper;
import org.mule.tooling.ui.modules.core.widgets.meta.VersionFilter;
import org.mule.tooling.ui.modules.core.widgets.meta.XmlOrderComparator;
import org.osgi.framework.Version;

public class AttributeGroup
extends MetaDescriptionEntry
implements IModelGenerator {
    private LinkedHashMap<String, AttributeHelper> attrHelpersMap = new LinkedHashMap();
    private AttributeHelper lastHelper = null;
    private boolean collapsable = false;
    private String controlled;
    private boolean generatingComposite = false;
    private boolean defaultCollapsed;

    public AttributeGroup(String caption) {
        this.setCaption(caption);
    }

    public AttributeHelper addStringHelper(String id, String caption, String description, boolean required, IValidator validator, IContentProposalProviderFactory provider) {
        AttributeHelper hp = new AttributeHelper(id, String.class, required);
        hp.setCaption(caption);
        hp.setDescription(description);
        hp.validator = validator;
        hp.proposalProvider = provider;
        this.add(hp);
        return hp;
    }

    public AttributeHelper addPasswordStringHelper(String id, String caption, String description, boolean required, IValidator validator, IContentProposalProviderFactory provider) {
        PasswordAttributeHelper hp = new PasswordAttributeHelper(id, String.class, required);
        hp.setCaption(caption);
        hp.setDescription(description);
        hp.validator = validator;
        hp.proposalProvider = provider;
        this.add(hp);
        return hp;
    }

    public LinkedHashMap<String, AttributeHelper> getAttrHelpersMap() {
        return this.attrHelpersMap;
    }

    public BooleanAttributeHelper addBooleanHelper(String id, String caption, String description, Boolean defaultValue) {
        return this.addBooleanHelper(id, caption, description, defaultValue, false);
    }

    public BooleanAttributeHelper addBooleanHelper(String id, String caption, String description, Boolean defaultValue, boolean isNegative) {
        BooleanAttributeHelper hp = new BooleanAttributeHelper(id, Boolean.class, false);
        hp.setCaption(caption);
        hp.validator = new IValidator(){

            @Override
            public String validate(Object value, AttributeContext context, AttributeHelper helper) {
                if (value == null || value.toString().length() == 0 || value.toString().equals("true") || value.toString().equals("false")) {
                    return null;
                }
                if (ExpressionUtils.isExpressionOrProperty((String)value.toString())) {
                    return null;
                }
                return "boolean value or expression is expected";
            }
        };
        hp.setDefaultValue(defaultValue);
        hp.setDescription(description);
        hp.setNegative(isNegative);
        this.add(hp);
        return hp;
    }

    public IntegerAttributeHelper addIntHelper(String id, String caption, String description, boolean required, String defaultValueStr, String javaType, String min, String max, String step) {
        IntegerAttributeHelper hp = new IntegerAttributeHelper(id, Integer.class, required, javaType, min, max, step, defaultValueStr);
        hp.setCaption(caption);
        hp.setDescription(description);
        this.add(hp);
        return hp;
    }

    public DateTimeAttributeHelper addDateTimeHelper(String id, String caption, String description, boolean required, DateTimeAttributeHelper.InputType inputType, String outputFormat) {
        DateTimeAttributeHelper helper = new DateTimeAttributeHelper(id, Date.class, required);
        helper.setCaption(caption);
        helper.setDescription(description);
        helper.setInputType(inputType);
        helper.setOutputFormat(outputFormat);
        this.add(helper);
        return helper;
    }

    public LongAttributeHelper addLongHelper(String id, String caption, String description, boolean required, Long defaultValue, long min, long max, long step) {
        LongAttributeHelper hp = new LongAttributeHelper(id, Integer.class, required);
        hp.setCaption(caption);
        hp.setDefaultValue(defaultValue);
        hp.setDescription(description);
        hp.setMin(min);
        hp.setMax(max);
        hp.setStep(step);
        this.add(hp);
        return hp;
    }

    public TimeAttributeHelper addTimeHelper(String id, String caption, String description, boolean required, Integer defaultValue, int min, int max, boolean isShowMilliseconds) {
        TimeAttributeHelper hp = new TimeAttributeHelper(id, Integer.class, required);
        hp.setCaption(caption);
        hp.setDefaultValue(defaultValue);
        hp.setDescription(description);
        hp.setMin(min);
        hp.setMax(max);
        hp.setShowMilliseconds(isShowMilliseconds);
        this.add(hp);
        return hp;
    }

    public AttributeHelper addEnumHelper(String id, String caption, boolean required, String description, String defaultValue, boolean isAutoSort, Collection<EnumOption> options, boolean isRadio, boolean isH, boolean removeEmptyOption) {
        EnumHelper hp = null;
        if (isRadio) {
            RadioButtonsAtr radioButtonsAtr = new RadioButtonsAtr(id, String.class, required, isAutoSort, options);
            radioButtonsAtr.setHorizontal(isH);
            hp = radioButtonsAtr;
        } else {
            hp = new EnumHelper(id, String.class, required, isAutoSort, options, removeEmptyOption);
        }
        hp.setCaption(caption);
        hp.setDefaultValue(defaultValue);
        hp.setDescription(description);
        this.add(hp);
        return hp;
    }

    public AttributeHelper addEnumHelper(String id, String caption, boolean required, String description, String defaultValue, boolean isAutoSort, Collection<EnumOption> options, boolean isRadio, boolean isH) {
        return this.addEnumHelper(id, caption, required, description, defaultValue, isAutoSort, options, isRadio, isH, false);
    }

    public SetAttributeHelper addSetHelper(String id, String caption, boolean required, String description, List<EnumOption> options, Sort sortMethod, String delimiter) {
        SetAttributeHelper setHelper = new SetAttributeHelper(id, Set.class, required, options);
        setHelper.setCaption(caption);
        setHelper.setDescription(description);
        EnumOption.sortOptions(options, sortMethod);
        setHelper.setOptions(options);
        setHelper.setDelimiter(delimiter);
        this.add(setHelper);
        return setHelper;
    }

    public void add(AttributeHelper hp) {
        if (this.generatingComposite) {
            this.lastHelper = hp;
        } else {
            this.attrHelpersMap.put(hp.getId(), hp);
        }
    }

    protected void fromPropertiesToElement(PropertyCollectionMap map, IElementWrapper element) {
        for (AttributeHelper h : this.attrHelpersMap.values()) {
            h.fromPropertiesToElement(map, element);
        }
    }

    protected void fromElementToProperties(IElementWrapper element, PropertyCollectionMap map) {
        for (AttributeHelper h : this.attrHelpersMap.values()) {
            h.fromElementToProperties(element, map);
        }
    }

    public void generate(IElementWrapper element, MessageFlowEntity messageFlowEntity) {
        Version currentVersion = new Version(MuleCorePlugin.getDesignContext().getMuleProject().getServerDefinition().getVersion());
        for (AttributeHelper helper : this.getAttributes(currentVersion)) {
            helper.generate(element, messageFlowEntity);
        }
    }

    public List<AttributeHelper> getAttributes(Version currentVersion) {
        ArrayList<AttributeHelper> result = new ArrayList<AttributeHelper>();
        Collection<AttributeHelper> attributeHelpers = this.getAttrHelpersMap().values();
        Collection<AttributeHelper> filteredHelpers = VersionFilter.getInstance().filter(attributeHelpers, currentVersion);
        for (AttributeHelper attributeHelper : filteredHelpers) {
            result.add(attributeHelper);
        }
        return result;
    }

    public void fillElement(IElementWrapper el, IMessageFlowNode node, PropertyCollectionMap propertyCollectionMap, IFlowTransformerContext context, IReadOnlyPropertyCollection properties, HashSet<String> handledElements) {
        Collection<AttributeHelper> filteredHelpers = this.getFilteredHelpers(context);
        ArrayList<AttributeHelper> helpers = new ArrayList<AttributeHelper>(filteredHelpers.size());
        helpers.addAll(filteredHelpers);
        Collections.sort(helpers, new XmlOrderComparator());
        for (AttributeHelper attributeHelper : helpers) {
            attributeHelper.fillElement(el, node, propertyCollectionMap, context, properties, handledElements);
        }
    }

    public Collection<AttributeHelper> getFilteredHelpers(IFlowTransformerContext context) {
        Collection<AttributeHelper> attributeHelpers = this.attrHelpersMap.values();
        return VersionFilter.getInstance().filter(attributeHelpers, context);
    }

    public void merge(AttributeGroup attributeGroup) {
        LinkedHashMap<String, AttributeHelper> newMap = new LinkedHashMap<String, AttributeHelper>();
        for (AttributeHelper attributeHelper : attributeGroup.attrHelpersMap.values()) {
            newMap.put(attributeHelper.getId(), attributeHelper);
        }
        for (Map.Entry entry : this.attrHelpersMap.entrySet()) {
            if (newMap.containsKey(entry.getKey())) continue;
            newMap.put((String)entry.getKey(), (AttributeHelper)entry.getValue());
        }
        this.attrHelpersMap = newMap;
    }

    public void remove(String id) {
        this.attrHelpersMap.remove(id);
    }

    public void removeAll(Collection<String> ids) {
        for (String s : ids) {
            AttributeHelper removedHelper;
            if (s.equals("httpLabel") && (removedHelper = (AttributeHelper)this.attrHelpersMap.remove(s)) != null) continue;
            this.attrHelpersMap.remove(s);
        }
    }

    public Collection<AttributeHelper> elements() {
        return this.attrHelpersMap.values();
    }

    public AttributeGroup copy() {
        AttributeGroup gs = new AttributeGroup(this.caption);
        gs.setRange(this.getRange());
        gs.setEEOnly(this.isEEOnly());
        gs.setDescription(this.description);
        gs.id = this.id;
        gs.mode = this.mode;
        gs.setTopAnchor(this.getTopAnchor());
        gs.setBottomAnchor(this.getBottomAnchor());
        LinkedHashMap<String, AttributeHelper> map2 = this.attrHelpersMap;
        for (Map.Entry<String, AttributeHelper> entry : map2.entrySet()) {
            gs.attrHelpersMap.put(entry.getKey(), entry.getValue());
        }
        return gs;
    }

    public int size() {
        return this.attrHelpersMap.size();
    }

    public void setControlledBy(String attribute) {
        if (attribute != null && attribute.length() > 0) {
            this.controlled = attribute;
        }
    }

    public String getControlledBy() {
        return this.controlled;
    }

    public ButtonAttributeHelper addActionHelper(String name, String attribute, String decription, boolean required, Object object, Object object2) {
        ButtonAttributeHelper hp = new ButtonAttributeHelper(name, String.class, required);
        hp.setCaption(attribute);
        hp.setDescription(decription);
        this.add(hp);
        return hp;
    }

    public DoubleAttributeHelper addDoubleHelper(String id, String caption, String description, boolean required, Double defaultValue, double min, double max, double step) {
        DoubleAttributeHelper hp = new DoubleAttributeHelper(id, Double.class, required);
        hp.setCaption(caption);
        hp.setDefaultValue(defaultValue);
        hp.setDescription(description);
        hp.setMin(min);
        hp.setMax(max);
        hp.setStep(step);
        this.add(hp);
        return hp;
    }

    public void startGeneratingComposite() {
        this.generatingComposite = true;
    }

    public void finishGeneratingComposite() {
        this.generatingComposite = false;
    }

    public AttributeHelper getGeneratedCompositePart() {
        AttributeHelper result = this.lastHelper;
        this.lastHelper = null;
        return result;
    }

    public boolean isWellKnownAttribute(IAttributeWrapper attribute) {
        for (AttributeHelper helper : this.attrHelpersMap.values()) {
            if (!helper.isWellKnownAttribute(attribute)) continue;
            return true;
        }
        return false;
    }

    public boolean isWellKnownProperty(IReadOnlyProperty property, Version currentVersion) {
        for (AttributeHelper helper : this.attrHelpersMap.values()) {
            if (!helper.isWellKnownProperty(property, currentVersion)) continue;
            return true;
        }
        return false;
    }

    public AttributeHelper addResourceAttributeHelper(String name, String attribute, String decription, boolean required, String containerLevelValue, String resourceTypeValue, String initialPatternValue, IValidator validator) {
        ResourceAttributeHelper hp = new ResourceAttributeHelper(name, attribute, String.class, required, containerLevelValue, resourceTypeValue, initialPatternValue, validator);
        hp.setDescription(this.description);
        this.add(hp);
        return hp;
    }

    public boolean isCollapsable() {
        return this.collapsable;
    }

    public void setCollapsable(boolean collapsable) {
        this.collapsable = collapsable;
    }

    public boolean isCollapsed() {
        return this.defaultCollapsed;
    }

    public void setCollapsed(boolean isCollapsedByDefault) {
        this.defaultCollapsed = isCollapsedByDefault;
    }
}

