/*
 * Decompiled with CFR 0.152.
 */
package org.mule.tooling.ui.modules.core.widgets.meta;

import org.dom4j.Namespace;
import org.mule.tooling.ui.modules.core.widgets.meta.AttributeCategory;
import org.w3c.dom.Element;

public class AttributeCategoryBuilder {
    private String caption;
    private String mode;
    private String description;
    private String versions;
    private boolean eeOnly;
    private String topAnchor;

    public AttributeCategory build() {
        AttributeCategory attributeCategory = new AttributeCategory("", null, new Namespace[0]);
        attributeCategory.setCaption(this.caption);
        attributeCategory.setMode(this.mode);
        attributeCategory.setDescription(this.description);
        if (this.versions != null) {
            attributeCategory.setRange(this.versions);
        }
        if (this.eeOnly) {
            attributeCategory.setEEOnly(this.eeOnly);
        }
        if (this.topAnchor != null) {
            attributeCategory.setTopAnchor(this.topAnchor);
        }
        return attributeCategory;
    }

    public AttributeCategoryBuilder loadFromElement(Element element) {
        this.caption(element.getAttribute("caption"));
        this.mode(element.getAttribute("mode"));
        this.description(element.getAttribute("description"));
        this.versions(element.getAttribute("versions"));
        this.topAnchor(element.getAttribute("topAnchor"));
        return this;
    }

    public AttributeCategoryBuilder caption(String caption) {
        this.caption = caption;
        return this;
    }

    public AttributeCategoryBuilder mode(String mode) {
        this.mode = mode;
        return this;
    }

    public AttributeCategoryBuilder description(String description) {
        this.description = description;
        return this;
    }

    public AttributeCategoryBuilder versions(String versions) {
        if (versions.length() > 0) {
            int indexOf = versions.indexOf(59);
            if (indexOf != -1) {
                this.eeOnly = true;
                this.versions = versions.substring(0, indexOf);
            } else {
                this.versions = versions;
            }
        }
        return this;
    }

    public AttributeCategoryBuilder topAnchor(String topAnchor) {
        if (topAnchor.length() > 0) {
            this.topAnchor = topAnchor;
        }
        return this;
    }
}

