/*
 * Decompiled with CFR 0.152.
 */
package org.mule.tooling.ui.modules.core.widgets.meta;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import javax.xml.namespace.QName;
import org.dom4j.Namespace;
import org.eclipse.osgi.service.resolver.VersionRange;
import org.mule.tooling.core.dom.IAttributeWrapper;
import org.mule.tooling.core.dom.IElementWrapper;
import org.mule.tooling.core.generator.IFlowTransformerContext;
import org.mule.tooling.core.generator.IModelGenerator;
import org.mule.tooling.core.generator.INodeXmlGenerator;
import org.mule.tooling.model.messageflow.IMessageFlowNode;
import org.mule.tooling.model.messageflow.IReadOnlyProperty;
import org.mule.tooling.model.messageflow.IReadOnlyPropertyCollection;
import org.mule.tooling.model.messageflow.MessageFlowEntity;
import org.mule.tooling.model.messageflow.decorator.PropertyCollectionMap;
import org.mule.tooling.ui.modules.core.widgets.meta.AttributeGroup;
import org.mule.tooling.ui.modules.core.widgets.meta.AttributeHelper;
import org.mule.tooling.ui.modules.core.widgets.meta.MetaDescriptionEntry;
import org.mule.tooling.ui.modules.core.widgets.meta.VersionFilter;
import org.osgi.framework.Version;

public class AttributeCategory
extends MetaDescriptionEntry
implements IModelGenerator,
INodeXmlGenerator {
    private LinkedHashMap<String, AttributeGroup> groups = new LinkedHashMap();
    protected final List<Namespace> nameSpace = new ArrayList<Namespace>();
    protected final Namespace primary;
    protected String localName;
    protected VersionRange range;

    public String getLocalName() {
        return this.localName;
    }

    public void setLocalName(String localName) {
        this.localName = localName;
    }

    public AttributeCategory(String localName, Namespace p, Namespace ... ns) {
        this.nameSpace.add(p);
        this.primary = p;
        this.localName = localName;
        this.nameSpace.addAll(Arrays.asList(ns));
    }

    public AttributeGroup newGroup(String caption) {
        AttributeGroup attributeGroup = new AttributeGroup(caption);
        this.addGroup(attributeGroup);
        return attributeGroup;
    }

    public void addGroup(AttributeGroup group) {
        this.groups.put(group.getCaption(), group);
    }

    public AttributeGroup getGroup(String caption) {
        if (this.groups.containsKey(caption)) {
            return this.groups.get(caption);
        }
        return this.newGroup(caption);
    }

    public Collection<AttributeGroup> getGroups() {
        return this.groups.values();
    }

    protected void fromElementToProperties(IElementWrapper element, PropertyCollectionMap map) {
        for (AttributeGroup h : this.getGroups()) {
            h.fromElementToProperties(element, map);
        }
    }

    public void generate(IElementWrapper element, MessageFlowEntity messageFlowEntity) {
        for (AttributeGroup attributeGroup : this.getGroups()) {
            attributeGroup.generate(element, messageFlowEntity);
        }
    }

    public List<Namespace> getNamespaces(MessageFlowEntity entity) {
        ArrayList<Namespace> arrayList = new ArrayList<Namespace>(this.nameSpace);
        for (AttributeGroup g : this.groups.values()) {
            for (AttributeHelper h : g.elements()) {
                h.addNamespaces(arrayList, entity);
            }
        }
        return arrayList;
    }

    public IElementWrapper generate(MessageFlowEntity entity, IFlowTransformerContext context) {
        QName qname = new QName(this.primary.getURI(), this.localName, this.primary.getPrefix());
        IElementWrapper element = context.getDocumentWrapper().createElement(qname);
        IMessageFlowNode node = (IMessageFlowNode)entity;
        IReadOnlyPropertyCollection properties = node.getProperties();
        PropertyCollectionMap propertyCollectionMap = new PropertyCollectionMap(properties);
        HashSet<String> handledElements = new HashSet<String>();
        Collection<AttributeGroup> attributeGroups = this.getGroups();
        Collection<AttributeGroup> filteredAttributeGroups = VersionFilter.getInstance().filter(attributeGroups, context);
        for (AttributeGroup attributeGroup : filteredAttributeGroups) {
            attributeGroup.fillElement(element, node, propertyCollectionMap, context, properties, handledElements);
        }
        return element;
    }

    public void merge(AttributeCategory attributes) {
        LinkedHashMap<String, AttributeGroup> newMap = new LinkedHashMap<String, AttributeGroup>();
        for (String s : attributes.groups.keySet()) {
            if (this.groups.containsKey(s)) {
                AttributeGroup attributeGroup = this.groups.get(s);
                attributeGroup.merge(attributes.groups.get(s));
                newMap.put(s, attributeGroup);
                continue;
            }
            newMap.put(s, attributes.groups.get(s));
        }
        for (String s : this.groups.keySet()) {
            if (newMap.containsKey(s)) continue;
            newMap.put(s, this.groups.get(s));
        }
        this.groups = newMap;
    }

    public AttributeCategory copy() {
        AttributeCategory result = new AttributeCategory(this.localName, this.primary, this.nameSpace.toArray(new Namespace[this.nameSpace.size()]));
        for (String s : this.groups.keySet()) {
            result.groups.put(s, this.groups.get(s).copy());
        }
        result.caption = this.caption;
        result.setTopAnchor(this.getTopAnchor());
        result.setBottomAnchor(this.getBottomAnchor());
        result.setRange(this.getRange());
        result.setEEOnly(this.isEEOnly());
        return result;
    }

    public boolean isEmpty() {
        boolean hasContents = false;
        for (AttributeGroup s : this.groups.values()) {
            if (!s.elements().iterator().hasNext()) continue;
            hasContents = true;
        }
        return !hasContents;
    }

    public boolean isWellKnownAttribute(IAttributeWrapper attribute) {
        for (AttributeGroup attributeGroup : this.getGroups()) {
            if (!attributeGroup.isWellKnownAttribute(attribute)) continue;
            return true;
        }
        return false;
    }

    public boolean isWellKnownProperty(IReadOnlyProperty property, Version currentVersion) {
        for (AttributeGroup attributeGroup : this.getGroups()) {
            if (!attributeGroup.isWellKnownProperty(property, currentVersion)) continue;
            return true;
        }
        return false;
    }

    public List<AttributeHelper> getAttributes(Version currentVersion) {
        ArrayList<AttributeHelper> attributes = new ArrayList<AttributeHelper>();
        for (AttributeGroup modelAttributeGroup : this.getGroups()) {
            attributes.addAll(modelAttributeGroup.getAttributes(currentVersion));
        }
        return attributes;
    }

    public void update(IMessageFlowNode node) {
    }
}

