/*
 * Decompiled with CFR 0.152.
 */
package org.mule.tooling.ui.modules.core.widgets.meta;

import java.util.List;
import org.mule.tooling.model.messageflow.Property;
import org.mule.tooling.model.messageflow.PropertyCollection;
import org.mule.tooling.model.messageflow.decorator.PropertyCollectionMap;
import org.mule.tooling.ui.modules.core.widgets.meta.AbstractValuePersistence;

public final class AsyncThreadingProfileValuePersistence
extends AbstractValuePersistence {
    private static final String useAsyncThreadingProfile = "useAsyncThreadingProfile";
    private static final String defaultAsyncThreadingProfile = "defaultAsyncThreadingProfile";
    private static final String asyncThreadingProfileId = "@http://www.mulesoft.org/schema/mule/core/async-threading-profile";
    private static final String suffix = ";1";
    private static final String TRUE = "true";

    private boolean selected(PropertyCollectionMap map, String profile) {
        return map.getProperty(profile, "").equals(TRUE);
    }

    private boolean isSynchronous(PropertyCollectionMap parentProperties) {
        String sync = parentProperties.getProperty("synchronous", "false");
        return TRUE.equalsIgnoreCase(sync);
    }

    @Override
    public String getId(PropertyCollectionMap newProperties, PropertyCollectionMap parentProperties, String id) {
        if (this.selected(newProperties, useAsyncThreadingProfile) && !this.isSynchronous(parentProperties)) {
            return "@http://www.mulesoft.org/schema/mule/core/async-threading-profile;1";
        }
        return "";
    }

    @Override
    public PropertyCollection adjust(List<PropertyCollection> defs2, String id) {
        for (PropertyCollection ca : defs2) {
            if (!ca.getName().startsWith(asyncThreadingProfileId)) continue;
            ca.getProperties().add(this.createProperty(useAsyncThreadingProfile, TRUE));
            return ca;
        }
        PropertyCollection propertyCollection2 = new PropertyCollection();
        propertyCollection2.getProperties().add(this.createProperty(defaultAsyncThreadingProfile, TRUE));
        return propertyCollection2;
    }

    private Property createProperty(String name, String value) {
        Property property = new Property();
        property.setName(name);
        property.setValue(value);
        return property;
    }

    @Override
    public String convertModelToXML(String str) {
        return null;
    }

    @Override
    public String convertXMLToModel(String str) {
        return null;
    }
}

