/*
 * Decompiled with CFR 0.152.
 */
package org.mule.tooling.ui.modules.core.widgets.meta;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import javax.xml.namespace.QName;
import org.apache.commons.lang.StringUtils;
import org.dom4j.Namespace;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.osgi.service.resolver.VersionRange;
import org.mule.tooling.core.MuleCorePlugin;
import org.mule.tooling.core.builder.messageflow.ICanMatchElement;
import org.mule.tooling.core.builder.messageflow.ICanMatchNested;
import org.mule.tooling.core.builder.messageflow.IQNameMeta;
import org.mule.tooling.core.builder.messageflow.IXmlOrder;
import org.mule.tooling.core.dom.ElementUtils;
import org.mule.tooling.core.dom.QNameUtils;
import org.mule.tooling.core.generator.IModelGenerator;
import org.mule.tooling.core.generator.INodeXmlGenerator;
import org.mule.tooling.core.module.Artifact;
import org.mule.tooling.core.module.EditorsXmlConstants;
import org.mule.tooling.core.module.IContributionElementHandler;
import org.mule.tooling.core.module.IModuleLoaderHandler;
import org.mule.tooling.editor.model.element.Stereotype;
import org.mule.tooling.messageflow.dialog.IDialogController;
import org.mule.tooling.model.module.ICanEvalGlobalRefs;
import org.mule.tooling.model.module.IKnowsVersionRange;
import org.mule.tooling.model.module.IPropertyPagesProvider;
import org.mule.tooling.model.module.IRequirementsProvider;
import org.mule.tooling.model.module.Keyword;
import org.mule.tooling.model.module.NodeDefinition;
import org.mule.tooling.model.module.RequiredAlternatives;
import org.mule.tooling.model.module.RequiredJar;
import org.mule.tooling.model.module.RequiredNativeLibrary;
import org.mule.tooling.model.module.Requirement;
import org.mule.tooling.model.module.filter.INodeDefinitionFilter;
import org.mule.tooling.model.module.filter.LocationFilterFactory;
import org.mule.tooling.model.module.filter.NodeDefinitionFilterFactory;
import org.mule.tooling.ui.modules.core.internal.metadata.ComponentIdBasedKey;
import org.mule.tooling.ui.modules.core.metadata.MetadataCacheKeyProvider;
import org.mule.tooling.ui.modules.core.widgets.meta.AbstractComponentMeta;
import org.mule.tooling.ui.modules.core.widgets.meta.AttributeCategory;
import org.mule.tooling.ui.modules.core.widgets.meta.AttributeCategoryBuilder;
import org.mule.tooling.ui.modules.core.widgets.meta.AttributeGroupRequirement;
import org.mule.tooling.ui.modules.core.widgets.meta.DefaultDialogController;
import org.mule.tooling.ui.modules.core.widgets.meta.IComponentValidator;
import org.mule.tooling.ui.modules.core.widgets.meta.creators.AttributeReader;
import org.mule.tooling.ui.modules.core.widgets.meta.propertypage.ContributionHandlerPropertyPageProvider;
import org.mule.tooling.ui.modules.internal.meta.StereotypeParser;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;

public abstract class AbstractContributionHandler<T extends NodeDefinition>
implements IContributionElementHandler<T>,
EditorsXmlConstants {
    public static final String DEFAULT_VERSION_RANGE = "[1.0.0,99.0.0]";
    public static final String DEFAULT_EE_VERSION_RANGE = "[1.0.0,99.0.0];EE";
    public static final String DEFAULT_CE_VERSION_RANGE = "[1.0.0,99.0.0]";
    public static final String EE = "EE";
    public static final String OPERATION_CATEGORIES_SEPARATOR = ",";

    private LinkedHashMap<String, AttributeCategory> loadCommonProperties(T definition, Element element, Artifact muleArtifact, String namespace, List<AttributeGroupRequirement> attrGroupRequirements) throws CoreException {
        String imagePath;
        String iconPath;
        String defaultDocName;
        definition.setExtendsDefinition(element.getAttribute("extends"));
        String isAbstract = element.getAttribute("abstract");
        definition.setAbstract(Boolean.parseBoolean(isAbstract));
        if (element.hasAttribute("defaultDocName")) {
            defaultDocName = element.getAttribute("defaultDocName");
            definition.setDefaultDocName(defaultDocName);
        }
        if (element.hasAttribute("defaultDocName")) {
            defaultDocName = element.getAttribute("defaultDocName");
            definition.setDefaultDocName(defaultDocName);
        }
        if (element.hasAttribute("completionProposalDocName")) {
            String completionProposalDocName = element.getAttribute("completionProposalDocName");
            definition.setCompletionProposalDocName(completionProposalDocName);
        }
        if (element.hasAttribute("showProposalInXML")) {
            String showProposalInXML = element.getAttribute("showProposalInXML");
            definition.setShownInXML(Boolean.parseBoolean(showProposalInXML));
        }
        if (element.hasAttribute("visibleInPalette")) {
            String visible = element.getAttribute("visibleInPalette");
            definition.setVisibleInPalette(Boolean.parseBoolean(visible));
        }
        if (element.hasAttribute("allowsName")) {
            String allowsName = element.getAttribute("allowsName");
            definition.setAllowsName(Boolean.parseBoolean(allowsName));
        }
        if (element.hasAttribute("allowsDescription")) {
            String allowsDescription = element.getAttribute("allowsDescription");
            definition.setAllowsDescription(Boolean.parseBoolean(allowsDescription));
        }
        if (element.hasAttribute("elementMatcher")) {
            definition.setElementMatcher(element.getAttribute("elementMatcher"));
        }
        if (element.hasAttribute("acceptedByElements")) {
            String validContainerValue = element.getAttribute("acceptedByElements");
            INodeDefinitionFilter validContainerFilter = NodeDefinitionFilterFactory.createFilter((String)validContainerValue);
            definition.setAcceptedByFilter(validContainerFilter);
        }
        if (element.hasAttribute("location")) {
            String locationFilter = element.getAttribute("location");
            definition.setLocationFilter(LocationFilterFactory.createFilter((String)locationFilter));
        }
        definition.setTitleColor(element.getAttribute("titleColor"));
        if (element.hasAttribute("displayNameAttribute")) {
            definition.setDisplayNameAtribute(element.getAttribute("displayNameAttribute"));
        }
        String isHiddenFromXML = element.getAttribute("hiddenFromXML");
        definition.setHiddenFromXML(Boolean.parseBoolean(isHiddenFromXML));
        LinkedHashMap<String, AttributeCategory> result = new LinkedHashMap<String, AttributeCategory>();
        for (Element el : ElementUtils.toElemList((NodeList)element.getChildNodes())) {
            String attribute;
            String elementName = el.getNodeName();
            if (elementName.equals("attribute-category")) {
                String caption = el.getAttribute("caption");
                AttributeCategory atrs = new AttributeCategoryBuilder().loadFromElement(el).build();
                result.put(caption, atrs);
                AttributeReader.readAttributes(atrs, null, el.getChildNodes(), muleArtifact);
                continue;
            }
            if (elementName.equals("stereotype")) {
                Stereotype stereotype = new StereotypeParser().processStereotype(el);
                definition.setStereotype(stereotype);
                continue;
            }
            if (elementName.equals("wrap-in-attrs")) {
                AttributeCategory strs = new AttributeCategory("", null, new Namespace[0]);
                AttributeReader.readAttributes(strs, null, el.getChildNodes(), muleArtifact);
                result.put("wrap-in-attrs", strs);
                continue;
            }
            if (elementName.equals("required-set-alternatives")) {
                AttributeGroupRequirement t = new AttributeGroupRequirement(muleArtifact);
                for (Element itemElem : ElementUtils.toElemList((NodeList)el.getChildNodes())) {
                    attribute = itemElem.getAttribute("value");
                    t.addRequiredAttrsAlternative(attribute);
                }
                String attribute2 = el.getAttribute("exclusive");
                if (attribute2.length() != 0) {
                    t.setExclusive(Boolean.parseBoolean(attribute2));
                }
                if ((attribute2 = el.getAttribute("required")).length() != 0) {
                    t.setRequired(Boolean.parseBoolean(attribute2));
                } else {
                    t.setRequired(true);
                }
                attribute2 = el.getAttribute("message");
                if (attribute2.length() > 0) {
                    t.setCustomMessage(attribute2);
                }
                if ((attribute2 = el.getAttribute("messageProvider")).length() > 0) {
                    t.setCustomClass(attribute2);
                }
                if ((attribute2 = el.getAttribute("requiredForDataSense")).length() > 0) {
                    t.setRequiredForDataSense(Boolean.parseBoolean(attribute2));
                }
                attrGroupRequirements.add(t);
                continue;
            }
            if (elementName.equals("require")) {
                List<Requirement> requirements = AbstractContributionHandler.processRequirements(el);
                definition.addRequirements(requirements);
            }
            if (elementName.equals("error-types")) {
                List<String> errorTypes = this.processErrorTypes(el);
                definition.addErrorTypes(errorTypes);
                continue;
            }
            if (elementName.equals("keywords")) {
                ArrayList<Keyword> keywords = new ArrayList<Keyword>();
                for (Element item : ElementUtils.toElemList((NodeList)el.getChildNodes())) {
                    attribute = item.getAttribute("value");
                    Keyword keyword = new Keyword(attribute);
                    String weight = item.getAttribute("weight");
                    keyword.setWeight(Integer.parseInt(weight));
                    String topHit = item.getAttribute("topHit");
                    keyword.setTopHit(Boolean.parseBoolean(topHit));
                    keywords.add(keyword);
                }
                definition.setKeywords(keywords);
                continue;
            }
            AttributeCategory atrs = (AttributeCategory)result.get("");
            if (atrs == null) {
                atrs = new AttributeCategory("", null, new Namespace[0]);
                result.put("", atrs);
                atrs.setCaption("");
                atrs.setMode("");
                atrs.setDescription("");
            }
            AttributeReader.readAttributes(atrs, null, el, muleArtifact);
        }
        definition.setId(namespace + "/" + element.getAttribute("localId"));
        if (definition.getId() == null) {
            throw new CoreException(MuleCorePlugin.createStatus((int)4, (String)"No id specified for node.", null));
        }
        definition.setName(element.getAttribute("caption"));
        definition.setDescription(element.getAttribute("description"));
        definition.setCategoryId(element.getAttribute("category"));
        if (definition.getCategoryId().length() == 0) {
            definition.setCategoryId(this.getDefaultCategory(element));
        }
        definition.setPaletteCategoryId(element.getAttribute("paletteCategory"));
        if (definition.getPaletteCategoryId().length() == 0) {
            definition.setPaletteCategoryId(this.getDefaultPaletteCategory(element));
        }
        if (StringUtils.isNotBlank((String)(iconPath = element.getAttribute("icon")))) {
            definition.setIconPath(muleArtifact.getId(), iconPath);
        }
        if (StringUtils.isNotBlank((String)(imagePath = element.getAttribute("image")))) {
            definition.setImagePath(muleArtifact.getId(), imagePath);
        }
        if (definition.getStereotype() == null) {
            definition.setStereotype(this.getDefaultStereotype());
        }
        return result;
    }

    private List<String> processErrorTypes(Element el) {
        ArrayList errorTypes = Lists.newArrayList();
        for (Element child : ElementUtils.toElemList((NodeList)el.getChildNodes())) {
            String childName = child.getNodeName();
            if (!childName.equals("error-type")) continue;
            String errorName = child.getAttribute("name");
            errorTypes.add(errorName);
        }
        return errorTypes;
    }

    public static List<Requirement> processRequirements(Element element) {
        ArrayList requirements = Lists.newArrayList();
        for (Element child : ElementUtils.toElemList((NodeList)element.getChildNodes())) {
            String displayName;
            boolean required;
            String childName = child.getNodeName();
            String requiredAttribute = child.getAttribute("required");
            boolean bl = required = StringUtils.isEmpty((String)requiredAttribute) ? true : Boolean.valueOf(requiredAttribute);
            if (childName.equals("nativeLib")) {
                displayName = child.getAttribute("name");
                String emptyLocationLabel = child.getAttribute("emptyLocationLabel");
                RequiredNativeLibrary lib = new RequiredNativeLibrary(displayName, emptyLocationLabel, required);
                requirements.add(lib);
                continue;
            }
            if (childName.equals("jar")) {
                displayName = child.getAttribute("name");
                String className = child.getAttribute("className");
                String fileName = child.getAttribute("fileName");
                String emptyLocationLabel = child.getAttribute("emptyLocationLabel");
                String suggestedCoordinates = child.getAttribute("suggestedCoordinates");
                RequiredJar requiredClass = new RequiredJar(displayName, className, fileName, emptyLocationLabel, suggestedCoordinates, required);
                requirements.add(requiredClass);
                continue;
            }
            if (!childName.equals("or")) continue;
            List<Requirement> alternativeRequirements = AbstractContributionHandler.processRequirements(child);
            AbstractContributionHandler.validateAlternativeRequirements(alternativeRequirements);
            RequiredAlternatives alternativeRequirement = new RequiredAlternatives(child.getAttribute("name"), alternativeRequirements, required);
            requirements.add(alternativeRequirement);
        }
        return requirements;
    }

    public static void validateAlternativeRequirements(List<Requirement> alternativeRequirements) {
        Object lastRequirement = null;
        for (Requirement requirement : alternativeRequirements) {
            if ("or".equals(requirement.getTypeId())) {
                throw new IllegalArgumentException("Cannot nest requirement alternatives");
            }
            if (lastRequirement == null || !lastRequirement.getTypeId().equals(requirement.getTypeId())) continue;
            throw new IllegalArgumentException("All child elements of Requirement Alternative should be of the same type (" + lastRequirement.getTypeId() + " != " + requirement.getTypeId() + ")");
        }
    }

    protected abstract String getDefaultCategory(Element var1);

    protected String getDefaultPaletteCategory(Element element) {
        String paletteCategoryAttribute = element.getAttribute("paletteCategory");
        return StringUtils.isEmpty((String)paletteCategoryAttribute) ? this.getDefaultCategory(element) : paletteCategoryAttribute;
    }

    protected QName createQName(Namespace ns, String localName) {
        if (ns == null || localName == null) {
            String msg = "Cannot create QName for namespace '" + (ns != null ? ns.getName() : "*null*") + "' and localName '" + (localName != null ? localName : "*null*") + "'";
            MuleCorePlugin.logWarning((String)msg, (Throwable)new Throwable(msg).fillInStackTrace());
            return null;
        }
        return QNameUtils.get((String)localName, (String)ns.getPrefix(), (String)ns.getURI());
    }

    protected void configureMeta(T nodeDefinition, AbstractComponentMeta componentMeta) {
        nodeDefinition.registerService(INodeXmlGenerator.class, (Object)componentMeta);
        nodeDefinition.registerService(IModelGenerator.class, (Object)componentMeta);
        nodeDefinition.registerService(ICanMatchElement.class, (Object)componentMeta);
        nodeDefinition.registerService(ICanMatchNested.class, (Object)componentMeta);
        nodeDefinition.registerService(IQNameMeta.class, (Object)componentMeta);
        nodeDefinition.registerService(IXmlOrder.class, (Object)componentMeta);
        nodeDefinition.registerService(AbstractComponentMeta.class, (Object)componentMeta);
        nodeDefinition.registerService(ICanEvalGlobalRefs.class, (Object)componentMeta);
        nodeDefinition.registerService(IRequirementsProvider.class, (Object)componentMeta);
        nodeDefinition.setPropertyPagesProvider((IPropertyPagesProvider)new ContributionHandlerPropertyPageProvider(componentMeta));
        this.addSpecificMeta(nodeDefinition);
    }

    protected void addSpecificMeta(T nodeDefinition) {
        nodeDefinition.registerService(MetadataCacheKeyProvider.class, (Object)ComponentIdBasedKey.getInstance());
    }

    public T handleElement(Namespace ns, Element element, Artifact muleArtifact, IModuleLoaderHandler handler) throws CoreException {
        String allowAny;
        String componentValidatorName;
        String persistenceTransformer;
        String operationCategoriesAttribute;
        T nodeDefinition = this.createNodeDefinition(ns, element, muleArtifact, handler);
        ArrayList<AttributeGroupRequirement> rs = new ArrayList<AttributeGroupRequirement>();
        LinkedHashMap<String, AttributeCategory> commonProperties = this.loadCommonProperties(nodeDefinition, element, muleArtifact, ns.getURI(), rs);
        String attribute = element.getAttribute("doNotInherit");
        String wrapIn = element.getAttribute("wrapIn");
        if (wrapIn.length() > 0) {
            nodeDefinition.setWrapIn(wrapIn);
        }
        HashSet<String> doNotInherit = new HashSet<String>();
        if (attribute.length() > 0) {
            String[] stringArray = attribute.split(OPERATION_CATEGORIES_SEPARATOR);
            int n = stringArray.length;
            int n2 = 0;
            while (n2 < n) {
                String s = stringArray[n2];
                if (s.length() > 0) {
                    doNotInherit.add(s);
                }
                ++n2;
            }
        }
        AttributeCategory remove = (AttributeCategory)commonProperties.remove("wrap-in-attrs");
        AbstractComponentMeta componentMeta = this.createComponentMeta(ns, nodeDefinition, commonProperties, doNotInherit);
        nodeDefinition.registerService(IDialogController.class, (Object)new DefaultDialogController());
        String add = element.getAttribute("additionalNamespaces");
        if (add.length() > 0) {
            String[] split;
            String[] stringArray = split = add.split(";");
            int n = split.length;
            int n3 = 0;
            while (n3 < n) {
                String s = stringArray[n3];
                int indexOf = s.indexOf(58);
                String pref = s.substring(0, indexOf);
                String url = s.substring(indexOf + 1);
                componentMeta.addExtraNamespace(Namespace.get((String)pref, (String)url));
                ++n3;
            }
        }
        componentMeta.setCategoryNames((operationCategoriesAttribute = element.getAttribute("categories")).isEmpty() ? Collections.emptyList() : Arrays.asList(operationCategoriesAttribute.split(OPERATION_CATEGORIES_SEPARATOR)));
        componentMeta.setConnectivityTesting(element.getAttribute("connectivityTesting"));
        componentMeta.setConnectivityTestingLabel(element.getAttribute("connectivityTestingLabel"));
        componentMeta.setMetadataStatus(element.getAttribute("metaData"));
        componentMeta.setUsesMetadataTypes(StringUtils.isBlank((String)element.getAttribute("usesMetadataTypes")) ? true : Boolean.valueOf(element.getAttribute("usesMetadataTypes")));
        componentMeta.setMetadataKeyDisplay(element.getAttribute("metaDataKeyDisplay"));
        String supportCustomMetadata = element.getAttribute("supportsUserDefinedMetaData");
        if (StringUtils.isNotBlank((String)supportCustomMetadata)) {
            Boolean supportUserDefinedMetadata = Boolean.valueOf(supportCustomMetadata);
            componentMeta.setSupportsUserDefinedMetaData(supportUserDefinedMetadata);
        }
        if (StringUtils.isNotBlank((String)(persistenceTransformer = element.getAttribute("persistenceTransformer")))) {
            componentMeta.setPersistenceTransformer(persistenceTransformer);
        }
        attribute = element.getAttribute("versions");
        if (remove != null) {
            componentMeta.setWrapAttributes(remove);
        }
        if ((attribute = attribute.length() == 0 ? "[1.0.0,99.0.0]" : attribute.replace(".EE", ";EE")).length() > 0) {
            int indexOf = attribute.indexOf(59);
            if (indexOf != -1) {
                attribute = attribute.substring(0, indexOf);
                componentMeta.setEE(true);
            }
            componentMeta.setRange(new VersionRange(attribute));
        }
        if ((attribute = element.getAttribute("deprecatedVersions")) != null && attribute.length() > 0) {
            if (attribute.contains(EE)) {
                attribute = attribute.replace(".EE", ";EE");
            }
            componentMeta.setDeprecatedRange(new VersionRange(attribute));
        }
        if ((componentValidatorName = element.getAttribute("componentValidator")) != null && componentValidatorName.length() > 0) {
            this.configureValidator(componentMeta, componentValidatorName);
        }
        if ((allowAny = element.getAttribute("allowAny")).length() > 0) {
            componentMeta.setAllowAny(Boolean.parseBoolean(allowAny));
        }
        for (AttributeGroupRequirement t : rs) {
            componentMeta.addGroupAlternativeRequirement(t);
        }
        nodeDefinition.registerService(IKnowsVersionRange.class, (Object)componentMeta);
        this.configureMeta(nodeDefinition, componentMeta);
        handler.addDefinition(nodeDefinition);
        return nodeDefinition;
    }

    private void configureValidator(AbstractComponentMeta componentMeta, String componentValidatorName) {
        try {
            Class<?> componentValidatorClass = Class.forName(componentValidatorName);
            IComponentValidator componentValidator = (IComponentValidator)componentValidatorClass.newInstance();
            componentMeta.setComponentValidator(componentValidator);
        }
        catch (ClassNotFoundException | IllegalAccessException | InstantiationException e) {
            e.printStackTrace();
        }
    }

    protected abstract AbstractComponentMeta createComponentMeta(Namespace var1, T var2, LinkedHashMap<String, AttributeCategory> var3, HashSet<String> var4);

    protected T createNodeDefinition(Namespace ns, Element element, Artifact muleArtifact, IModuleLoaderHandler handler) {
        T nodeDefinition = this.createNodeDefinition(ns, element);
        nodeDefinition.setBundleSymbolicName(muleArtifact.getId());
        return nodeDefinition;
    }

    protected abstract T createNodeDefinition(Namespace var1, Element var2);

    protected abstract Stereotype getDefaultStereotype();
}

