/*
 * Decompiled with CFR 0.152.
 */
package org.mule.tooling.ui.modules.core.widgets.meta;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import org.mule.tooling.core.dom.IElementWrapper;
import org.mule.tooling.core.generator.IFlowTransformerContext;
import org.mule.tooling.core.module.Artifact;
import org.mule.tooling.model.messageflow.IMessageFlowNode;
import org.mule.tooling.model.messageflow.IReadOnlyProperty;
import org.mule.tooling.model.messageflow.IReadOnlyPropertyCollection;
import org.mule.tooling.model.messageflow.MessageFlowEntity;
import org.mule.tooling.model.messageflow.decorator.PropertyCollectionMap;
import org.mule.tooling.ui.modules.core.widgets.meta.AttributeGroup;
import org.mule.tooling.ui.modules.core.widgets.meta.AttributeHelper;
import org.mule.tooling.ui.modules.core.widgets.meta.creators.AttributeReader;
import org.osgi.framework.Version;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public abstract class AbstractCompositeAttributeHelper
extends AttributeHelper {
    protected List<AttributeHelper> children;

    public AbstractCompositeAttributeHelper(String id, Class<?> type, boolean required, String description) {
        super(id, type, required);
        this.setDescription(description);
        this.setHiddenForUser(true);
    }

    public final List<AttributeHelper> getChildren() {
        return this.children;
    }

    public AbstractCompositeAttributeHelper parse(Element element, AttributeGroup currentGroup, Artifact muleArtifact) {
        this.parseSpecificAttributes(element);
        this.children = this.parseChildNodes(element, currentGroup, muleArtifact);
        currentGroup.add(this);
        return this;
    }

    protected abstract void parseSpecificAttributes(Element var1);

    protected List<AttributeHelper> parseChildNodes(Element element, AttributeGroup currentGroup, Artifact muleArtifact) {
        NodeList childNodes = element.getChildNodes();
        int nChildren = childNodes.getLength();
        ArrayList<AttributeHelper> compositeParts = new ArrayList<AttributeHelper>();
        currentGroup.startGeneratingComposite();
        try {
            int i = 0;
            while (i < nChildren) {
                Node child = childNodes.item(i);
                AttributeReader.parseAttr(currentGroup, null, child, muleArtifact);
                AttributeHelper helper = currentGroup.getGeneratedCompositePart();
                if (helper != null) {
                    compositeParts.add(helper);
                }
                ++i;
            }
        }
        finally {
            currentGroup.finishGeneratingComposite();
        }
        return compositeParts;
    }

    @Override
    public void fillElement(IElementWrapper el, IMessageFlowNode node, PropertyCollectionMap propertyCollectionMap, IFlowTransformerContext context, IReadOnlyPropertyCollection collection, HashSet<String> handledElements) {
        for (AttributeHelper helper : this.children) {
            helper.fillElement(el, node, propertyCollectionMap, context, collection, handledElements);
        }
    }

    @Override
    public void generate(IElementWrapper element, MessageFlowEntity messageFlowEntity) {
        for (AttributeHelper helper : this.children) {
            helper.generate(element, messageFlowEntity);
        }
    }

    @Override
    public boolean isWellKnownProperty(IReadOnlyProperty property, Version currentVersion) {
        boolean isIncluded;
        boolean bl = isIncluded = this.getRange() == null || this.getRange().isIncluded(currentVersion);
        if (isIncluded) {
            for (AttributeHelper childAttr : this.getChildren()) {
                if (!childAttr.isWellKnownProperty(property, currentVersion)) continue;
                return true;
            }
        }
        return false;
    }
}

