/*
 * Decompiled with CFR 0.152.
 */
package org.mule.tooling.ui.modules.core.widgets.meta;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.WeakHashMap;
import java.util.stream.Collectors;
import javax.xml.namespace.QName;
import org.apache.commons.lang.StringUtils;
import org.dom4j.Attribute;
import org.dom4j.CDATA;
import org.dom4j.Comment;
import org.dom4j.Element;
import org.dom4j.Namespace;
import org.dom4j.tree.DefaultText;
import org.eclipse.osgi.service.resolver.VersionRange;
import org.mule.tooling.core.Category;
import org.mule.tooling.core.MuleCorePlugin;
import org.mule.tooling.core.builder.messageflow.ICanMatchElement;
import org.mule.tooling.core.builder.messageflow.ICanMatchNested;
import org.mule.tooling.core.builder.messageflow.IQNameMeta;
import org.mule.tooling.core.builder.messageflow.IXmlOrder;
import org.mule.tooling.core.dom.IAttributeListWrapper;
import org.mule.tooling.core.dom.IAttributeWrapper;
import org.mule.tooling.core.dom.IConfigurableElement;
import org.mule.tooling.core.dom.IDocumentWrapper;
import org.mule.tooling.core.dom.IElementWrapper;
import org.mule.tooling.core.dom.INodeListWrapper;
import org.mule.tooling.core.generator.IFlowTransformerContext;
import org.mule.tooling.core.generator.IModelGenerator;
import org.mule.tooling.core.generator.INodeXmlGenerator;
import org.mule.tooling.core.generator.ISplitterModelGenerator;
import org.mule.tooling.core.generator.ISplitterXmlGenerator;
import org.mule.tooling.core.generator.MuleNamespaces;
import org.mule.tooling.core.generator.NewFlowTransformerContext;
import org.mule.tooling.core.model.IMuleProject;
import org.mule.tooling.core.module.IMuleModuleManager;
import org.mule.tooling.core.runtime.server.IServerDefinition;
import org.mule.tooling.core.utils.CoreUtils;
import org.mule.tooling.model.messageflow.CompartmentLane;
import org.mule.tooling.model.messageflow.Container;
import org.mule.tooling.model.messageflow.GlobalElement;
import org.mule.tooling.model.messageflow.IMessageFlowNode;
import org.mule.tooling.model.messageflow.IReadOnlyProperty;
import org.mule.tooling.model.messageflow.IReadOnlyPropertyCollection;
import org.mule.tooling.model.messageflow.MessageFlowEntity;
import org.mule.tooling.model.messageflow.MessageFlowFactory;
import org.mule.tooling.model.messageflow.NestedContainer;
import org.mule.tooling.model.messageflow.Property;
import org.mule.tooling.model.messageflow.PropertyCollection;
import org.mule.tooling.model.messageflow.Route;
import org.mule.tooling.model.messageflow.SplitterNode;
import org.mule.tooling.model.messageflow.decorator.PropertyCollectionMap;
import org.mule.tooling.model.messageflow.util.PropertiesUtils;
import org.mule.tooling.model.module.GlobalDefinition;
import org.mule.tooling.model.module.ICanEvalGlobalRefs;
import org.mule.tooling.model.module.IKnowsVersionRange;
import org.mule.tooling.model.module.IRequirementsProvider;
import org.mule.tooling.model.module.NestedDefinition;
import org.mule.tooling.model.module.NodeDefinition;
import org.mule.tooling.model.module.PatternDefinition;
import org.mule.tooling.model.module.Requirement;
import org.mule.tooling.model.module.RouteDefinition;
import org.mule.tooling.model.module.SplitterDefinition;
import org.mule.tooling.ui.modules.core.metadata.MetadataHelpers;
import org.mule.tooling.ui.modules.core.widgets.editors.TransientAttributeHelper;
import org.mule.tooling.ui.modules.core.widgets.meta.AbstractCompositeAttributeHelper;
import org.mule.tooling.ui.modules.core.widgets.meta.AttributeCategory;
import org.mule.tooling.ui.modules.core.widgets.meta.AttributeGroup;
import org.mule.tooling.ui.modules.core.widgets.meta.AttributeGroupRequirement;
import org.mule.tooling.ui.modules.core.widgets.meta.AttributeHelper;
import org.mule.tooling.ui.modules.core.widgets.meta.AttributesPersistenceTransformer;
import org.mule.tooling.ui.modules.core.widgets.meta.ChildElementAttributeHelper;
import org.mule.tooling.ui.modules.core.widgets.meta.FlowAttributeHelper;
import org.mule.tooling.ui.modules.core.widgets.meta.GlobalRefAttributeHelper;
import org.mule.tooling.ui.modules.core.widgets.meta.GroupTabsAttributeHelper;
import org.mule.tooling.ui.modules.core.widgets.meta.HCompositeHelper;
import org.mule.tooling.ui.modules.core.widgets.meta.IComponentValidator;
import org.mule.tooling.ui.modules.core.widgets.meta.MultiWayHelper;
import org.mule.tooling.ui.modules.core.widgets.meta.XmlOrderComparator;
import org.mule.tooling.ui.modules.core.widgets.meta.propertypage.RequirementsHelper;
import org.osgi.framework.Version;

public abstract class AbstractComponentMeta
implements IModelGenerator,
INodeXmlGenerator,
ICanMatchElement,
IKnowsVersionRange,
ISplitterXmlGenerator,
ISplitterModelGenerator,
ICanMatchNested,
IQNameMeta,
ICanEvalGlobalRefs,
IXmlOrder,
IRequirementsProvider {
    protected String returnType;
    protected List<String> categoryNames;
    protected String connectivityTesting;
    protected String connectivityTestingLabel;
    protected String metadataStatus;
    protected boolean usesMetadataTypes;
    protected String forceMetadataRefreshAtrributes;
    protected LinkedHashMap<String, AttributeCategory> attrs = new LinkedHashMap();
    protected ArrayList<AttributeGroupRequirement> alternatives = new ArrayList();
    protected VersionRange range;
    protected VersionRange deprecatedRange;
    protected String metadataKeyDisplay = null;
    protected AttributeCategory wrapAttributes;
    protected String wrapIn;
    protected boolean isEE;
    protected AttributesPersistenceTransformer persistenceTransformer;
    protected IComponentValidator componentValidator;
    protected boolean inheritanceInited;
    protected final NodeDefinition definition;
    protected final Namespace namespace;
    protected final HashSet<String> doNotInherit;
    protected boolean allowAny;
    protected Set<Namespace> additional = new HashSet<Namespace>();
    private boolean supportsUserDefinedMetadata;
    private static WeakHashMap<IMessageFlowNode, List<?>> elements = new WeakHashMap();

    public AbstractComponentMeta(Namespace ns, NodeDefinition def, LinkedHashMap<String, AttributeCategory> loadCommonProperties, HashSet<String> doNotInherit) {
        this.definition = def;
        this.attrs.putAll(loadCommonProperties);
        this.namespace = ns;
        this.doNotInherit = doNotInherit;
    }

    public boolean allowed(QName qName) {
        for (NestedDefinition nestedDefinition : this.getAllowedChidren().keySet()) {
            if (nestedDefinition.isAbstract() || nestedDefinition.isHiddenFromXML() || !nestedDefinition.matches(qName)) continue;
            return true;
        }
        return false;
    }

    public List<String> getCategoryNames() {
        return this.categoryNames;
    }

    public void setCategoryNames(List<String> categoryNames) {
        this.categoryNames = categoryNames;
    }

    public String getConnectivityTesting() {
        return this.connectivityTesting;
    }

    public void setConnectivityTesting(String connectivityTesting) {
        this.connectivityTesting = connectivityTesting;
    }

    public String getMetadataStatus() {
        return this.metadataStatus;
    }

    public void setMetadataStatus(String metadataStatus) {
        this.metadataStatus = metadataStatus;
    }

    public boolean isUsesMetadataTypes() {
        return this.usesMetadataTypes;
    }

    public void setUsesMetadataTypes(boolean usesMetadataTypes) {
        this.usesMetadataTypes = usesMetadataTypes;
    }

    public boolean isEE() {
        return this.isEE;
    }

    public void setEE(boolean isEE) {
        this.isEE = isEE;
    }

    public IComponentValidator getComponentValidator() {
        return this.componentValidator;
    }

    public void setComponentValidator(IComponentValidator componentValidator) {
        this.componentValidator = componentValidator;
    }

    public String getWrapIn() {
        return this.wrapIn;
    }

    public void setWrapIn(String wrapIn) {
        this.wrapIn = wrapIn;
    }

    public AttributeCategory getWrapAttributes() {
        return this.wrapAttributes;
    }

    public void setWrapAttributes(AttributeCategory wrapAttributes) {
        this.wrapAttributes = wrapAttributes;
    }

    public VersionRange getRange() {
        return this.range;
    }

    public void setRange(VersionRange range) {
        this.range = range;
    }

    public VersionRange getDeprecatedRange() {
        return this.deprecatedRange;
    }

    public void setDeprecatedRange(VersionRange range) {
        this.deprecatedRange = range;
    }

    public boolean supported(String version) {
        return AbstractComponentMeta.supported(this.range, this.isEE, version);
    }

    public static boolean supported(VersionRange range, boolean isEE, String version) {
        boolean ee = false;
        if (version == null) {
            return true;
        }
        int indexOf = version.indexOf(59);
        if (indexOf != -1) {
            ee = true;
            version = version.substring(0, indexOf);
        }
        if (isEE && !ee) {
            return false;
        }
        if (version != null && range != null) {
            return range.isIncluded(new Version(version));
        }
        return true;
    }

    public boolean isDeprecatedIn(String version) {
        return CoreUtils.isDeprecated((VersionRange)this.deprecatedRange, (String)version);
    }

    public int matches(IElementWrapper el) {
        if (this.definition.isAbstract()) {
            return -1;
        }
        return 0;
    }

    public NodeDefinition getDefinition() {
        return this.definition;
    }

    public boolean isAllowAny() {
        return this.allowAny;
    }

    public void setAllowAny(boolean allowAny) {
        this.allowAny = allowAny;
    }

    public void addGroupAlternativeRequirement(AttributeGroupRequirement req) {
        req.setMeta(this);
        this.alternatives.add(req);
    }

    public List<AttributeGroupRequirement> getAttributeGroupRequirements() {
        return this.alternatives;
    }

    public Map<String, AttributeCategory> getAttributeCategoryMap() {
        this.initInheritanceIfNeeded();
        return this.attrs;
    }

    protected void initInheritanceIfNeeded() {
        if (!this.inheritanceInited) {
            this.mergeNodeAttributesWithParentTypeAttributes();
            ArrayList<AttributeCategory> anchoredCategories = new ArrayList<AttributeCategory>();
            ArrayList<AttributeCategory> toAdd = new ArrayList<AttributeCategory>(this.attrs.values());
            for (AttributeCategory attributeCategory : this.attrs.values()) {
                if (attributeCategory.getTopAnchor() == null) {
                    anchoredCategories.add(attributeCategory);
                    continue;
                }
                toAdd.add(attributeCategory);
            }
            for (AttributeCategory a : toAdd) {
                String topAnchor = a.getTopAnchor();
                for (AttributeCategory m : new ArrayList(anchoredCategories)) {
                    if (!m.getCaption().equals(topAnchor)) continue;
                    anchoredCategories.add(anchoredCategories.indexOf(m) + 1, a);
                }
            }
            this.attrs = new LinkedHashMap();
            for (AttributeCategory a : anchoredCategories) {
                this.attrs.put(a.getCaption(), a);
            }
            this.inheritanceInited = true;
        }
    }

    protected void mergeNodeAttributesWithParentTypeAttributes() {
        List<? extends NodeDefinition> superElements = this.getSuperElements();
        for (NodeDefinition nodeDefinition : superElements) {
            AbstractComponentMeta service = (AbstractComponentMeta)nodeDefinition.getService(AbstractComponentMeta.class);
            if (service == null) continue;
            if (this.range == null && service.range != null) {
                this.range = service.range;
            }
            service.initInheritanceIfNeeded();
            LinkedHashMap<String, AttributeCategory> newMap = new LinkedHashMap<String, AttributeCategory>();
            for (String string : service.attrs.keySet()) {
                if (this.attrs.containsKey(string)) {
                    AttributeCategory currentElement = this.attrs.get(string);
                    AttributeCategory attributes = service.attrs.get(string).copy();
                    this.removeNotInherited(attributes);
                    currentElement.merge(attributes);
                    newMap.put(string, currentElement);
                    continue;
                }
                AttributeCategory copy = service.attrs.get(string).copy();
                this.removeNotInherited(copy);
                newMap.put(string, copy);
            }
            for (Map.Entry entry : this.attrs.entrySet()) {
                if (newMap.containsKey(entry.getKey())) continue;
                newMap.put((String)entry.getKey(), (AttributeCategory)entry.getValue());
            }
            this.attrs = newMap;
        }
    }

    protected List<? extends NodeDefinition> getSuperElements() {
        IMuleModuleManager moduleManager = MuleCorePlugin.getModuleManager();
        return moduleManager.getExtendedDefinitions(this.definition);
    }

    private void removeNotInherited(AttributeCategory copy) {
        for (AttributeGroup g : copy.getGroups()) {
            g.removeAll(this.doNotInherit);
        }
    }

    public void generate(IElementWrapper element, MessageFlowEntity messageFlowEntity) {
        this.initInheritanceIfNeeded();
        for (AttributeCategory attribute : this.attrs.values()) {
            attribute.generate(element, messageFlowEntity);
        }
        if (messageFlowEntity instanceof IMessageFlowNode) {
            PropertyCollection properties = ((IMessageFlowNode)messageFlowEntity).getPropertiesForEdit(element);
            IAttributeListWrapper attributes = element.getAttributes();
            for (IAttributeWrapper attribute : attributes) {
                if (!this.isUnknownAttribute(attribute)) continue;
                properties.addProperty(new Property(attribute.getTagName(), attribute.getText()));
            }
        }
    }

    public void update(IMessageFlowNode node) {
        this.initInheritanceIfNeeded();
        IElementWrapper element = node.getElement();
        HashSet<String> handledElements = new HashSet<String>();
        HashSet<String> handledAttributes = new HashSet<String>();
        IReadOnlyPropertyCollection properties = node.getProperties();
        PropertyCollectionMap propertyCollectionMap = new PropertyCollectionMap(properties);
        IFlowTransformerContext context = NewFlowTransformerContext.create((IMuleProject)MuleCorePlugin.getDesignContext().getMuleProject(), (IDocumentWrapper)element.getDocument());
        this.fillAttributes(context, handledElements, handledAttributes, node, properties, propertyCollectionMap, element);
        this.fillUnknownAttributes(context, element, properties);
    }

    private boolean isUnknownAttribute(IAttributeWrapper attribute) {
        for (AttributeCategory modelAttribute : this.attrs.values()) {
            if (!modelAttribute.isWellKnownAttribute(attribute)) continue;
            return false;
        }
        String name = attribute.getTagName();
        return !PropertiesUtils.isInternalProperty((String)name) && !PropertiesUtils.isWellKnownDocAttribute((String)name);
    }

    protected boolean isUnknownProperty(IReadOnlyPropertyCollection properties, IReadOnlyProperty property, Version currentVersion) {
        for (AttributeCategory modelAttribute : this.attrs.values()) {
            if (!modelAttribute.isWellKnownProperty(property, currentVersion)) continue;
            return false;
        }
        String name = property.getName();
        return !PropertiesUtils.isInternalProperty((String)name) && !PropertiesUtils.isWellKnownDocAttribute((String)name) && !"exchange-pattern".equals(name);
    }

    public void generate(IElementWrapper element, PropertyCollectionMap propertyCollectionMap) {
        this.initInheritanceIfNeeded();
        Collection<AttributeCategory> ts = this.attrs.values();
        HashSet<String> childAttributes = new HashSet<String>();
        for (AttributeCategory t : ts) {
            Collection<AttributeGroup> gs = t.getGroups();
            for (AttributeGroup g : gs) {
                Collection<AttributeHelper> as = g.elements();
                for (AttributeHelper a : as) {
                    String id = a.getId();
                    childAttributes.add(id);
                }
            }
        }
        for (AttributeCategory a : ts) {
            a.fromElementToProperties(element, propertyCollectionMap);
        }
    }

    public List<Namespace> getNamespaces(MessageFlowEntity entity) {
        this.initInheritanceIfNeeded();
        IMessageFlowNode node = (IMessageFlowNode)entity;
        IReadOnlyPropertyCollection properties = node.getProperties();
        PropertyCollectionMap propertyCollectionMap = new PropertyCollectionMap(properties);
        LinkedHashSet<Namespace> result = new LinkedHashSet<Namespace>();
        for (AttributeCategory s : this.attrs.values()) {
            for (AttributeGroup g : s.getGroups()) {
                for (AttributeHelper h : g.elements()) {
                    String value;
                    String id = h.getId();
                    if (id.equals("tracking:enable-default-events")) {
                        value = propertyCollectionMap.getProperty(id, null);
                        if (value == null || !Boolean.parseBoolean(value)) continue;
                        result.add(new Namespace("tracking", "http://www.mulesoft.org/schema/mule/ee/tracking"));
                        continue;
                    }
                    if (!id.equals("tracking:transaction-id") || (value = propertyCollectionMap.getProperty(id, null)) == null) continue;
                    result.add(new Namespace("tracking", "http://www.mulesoft.org/schema/mule/ee/tracking"));
                }
            }
        }
        for (AttributeCategory a : this.attrs.values()) {
            List<Namespace> namespaces = a.getNamespaces(entity);
            result.addAll(namespaces);
        }
        result.add(this.namespace);
        result.remove(null);
        result.addAll(this.getAdditionalNamespaces());
        AbstractComponentMeta parentMetaObject = MetadataHelpers.getMetaObjectFrom(node);
        if (parentMetaObject != null) {
            result.addAll(parentMetaObject.getAdditionalNamespaces());
        }
        return new ArrayList<Namespace>(result);
    }

    public IElementWrapper generate(MessageFlowEntity entity, IFlowTransformerContext context) {
        this.initInheritanceIfNeeded();
        HashSet<String> handledElements = new HashSet<String>();
        HashSet<String> handledAttributes = new HashSet<String>();
        IMessageFlowNode node = (IMessageFlowNode)entity;
        IReadOnlyPropertyCollection properties = node.getProperties();
        PropertyCollectionMap propertyCollectionMap = new PropertyCollectionMap(properties);
        return this.internalDoHandle(entity, context, handledElements, handledAttributes, node, properties, propertyCollectionMap);
    }

    protected IElementWrapper internalDoHandle(MessageFlowEntity entity, IFlowTransformerContext context, HashSet<String> handledElements, HashSet<String> handledAttributes, IMessageFlowNode node, IReadOnlyPropertyCollection properties, PropertyCollectionMap propertyCollectionMap) {
        return this.createElement(entity, context, handledElements, handledAttributes, node, properties, propertyCollectionMap);
    }

    public static void clearPreserve(IMessageFlowNode node) {
        elements.remove(node);
    }

    protected IElementWrapper createElement(MessageFlowEntity entity, IFlowTransformerContext context, HashSet<String> handledElements, HashSet<String> handledAttributes, IMessageFlowNode node, IReadOnlyPropertyCollection properties, PropertyCollectionMap propertyCollectionMap) {
        QName name = this.getQName(entity);
        IElementWrapper element = context.getDocumentWrapper().createElement(name);
        this.fillAttributes(context, handledElements, handledAttributes, node, properties, propertyCollectionMap, element);
        this.fillUnknownAttributes(context, element, properties);
        return element;
    }

    protected void fillUnknownAttributes(IFlowTransformerContext context, IElementWrapper element, IReadOnlyPropertyCollection properties) {
        IServerDefinition serverDefinition = CoreUtils.getServerDefinition((IFlowTransformerContext)context);
        String versionStr = serverDefinition.getVersion();
        Version currentVersion = new Version(versionStr);
        List propertyList = properties.getProperties();
        for (IReadOnlyProperty property : propertyList) {
            if (!this.isUnknownProperty(properties, property, currentVersion) || StringUtils.isEmpty((String)property.getName())) continue;
            IAttributeWrapper elementAttribute = element.getAttribute(property.getName());
            if (elementAttribute != null) {
                String elementAttributeValue = elementAttribute.getText();
                if (elementAttributeValue.equals(property.getValue())) continue;
                element.addAttribute(property.getName(), property.getValue());
                continue;
            }
            element.addAttribute(property.getName(), property.getValue());
        }
    }

    public void fillAttributes(IFlowTransformerContext context, HashSet<String> handledElements, HashSet<String> handledAttributes, IMessageFlowNode node, IReadOnlyPropertyCollection properties, PropertyCollectionMap propertyCollectionMap, IElementWrapper element) {
        ArrayList<AttributeHelper> attributes = new ArrayList<AttributeHelper>();
        Version currentVersion = new Version(context.getMuleProject().getServerDefinition().getVersion());
        for (AttributeCategory modelAttribute : this.getAttributeCategoryMap().values()) {
            attributes.addAll(modelAttribute.getAttributes(currentVersion));
        }
        Collections.sort(attributes, new XmlOrderComparator());
        for (AttributeHelper helper : attributes) {
            if (!this.canExecute(helper, node)) continue;
            handledAttributes.add(helper.getId());
            helper.fillElement(element, node, propertyCollectionMap, context, properties, handledElements);
        }
    }

    protected boolean canExecute(AttributeHelper helper, IMessageFlowNode node) {
        return true;
    }

    public IElementWrapper contributeRouteStart(CompartmentLane entity, IFlowTransformerContext context) {
        Optional<QName> routeQName = this.getRouteToCreate(entity, context);
        if (routeQName.isPresent()) {
            return this.createRouteElementWrapper(entity, routeQName.get(), context);
        }
        SplitterNode splitter = (SplitterNode)context.getEntityStack().peek();
        return splitter.getElement();
    }

    private Optional<QName> getRouteToCreate(CompartmentLane lane, IFlowTransformerContext context) {
        SplitterNode splitter = (SplitterNode)context.getEntityStack().peek();
        NodeDefinition splitterDef = splitter.getDefinition();
        if (splitterDef instanceof SplitterDefinition && lane instanceof Route) {
            RouteDefinition routeDefinition = ((Route)lane).getDefinition();
            return Optional.of(routeDefinition.getMuleElement());
        }
        if (this.isLegacySplitter(splitterDef)) {
            return Optional.of(MuleNamespaces.getMuleDefault((String)"route"));
        }
        return Optional.empty();
    }

    private IElementWrapper createRouteElementWrapper(CompartmentLane entity, QName routeQName, IFlowTransformerContext context) {
        IElementWrapper routeElement = context.getDocumentWrapper().createElement(routeQName);
        if (routeElement instanceof IConfigurableElement) {
            IConfigurableElement configurable = (IConfigurableElement)routeElement;
            configurable.setMinimumChildElementsToShow(1);
        }
        if (entity instanceof IMessageFlowNode) {
            IMessageFlowNode node = (IMessageFlowNode)entity;
            IReadOnlyPropertyCollection properties = node.getProperties();
            PropertyCollectionMap propertiesMap = new PropertyCollectionMap(properties);
            this.fillAttributes(context, new HashSet<String>(), new HashSet<String>(), node, properties, propertiesMap, routeElement);
            this.fillUnknownAttributes(context, routeElement, properties);
        }
        return routeElement;
    }

    private boolean isLegacySplitter(NodeDefinition definition) {
        return definition instanceof PatternDefinition && ((PatternDefinition)definition).isCausesSplit();
    }

    protected void preserveChildNodes(MessageFlowEntity entity, HashSet<String> handledElements, HashSet<String> handledAttributes, Element el) {
        GlobalElement d;
        GlobalDefinition globalDefinition;
        List<?> list = elements.get(entity);
        if (entity instanceof Container || entity instanceof NestedContainer) {
            return;
        }
        if (entity instanceof GlobalElement && (globalDefinition = (GlobalDefinition)(d = (GlobalElement)entity).getDefinition()).getCategoryId().equals(Category.EXCEPTIONS.getCategoryString())) {
            return;
        }
        if (list != null) {
            for (Object ea : list) {
                Attribute atr;
                if (ea instanceof Attribute) {
                    atr = (Attribute)ea;
                    atr.setParent(null);
                    if (handledAttributes.contains(atr.getName())) continue;
                    el.add(atr);
                    continue;
                }
                if (ea instanceof CDATA) {
                    if (handledElements.contains("CDATA") || this.hasCDataAttribute(handledAttributes) || this.containsText(el)) continue;
                    atr = (CDATA)ea;
                    atr.setParent(null);
                    el.add((CDATA)atr);
                    continue;
                }
                if (ea instanceof Comment) {
                    atr = (Comment)ea;
                    atr.setParent(null);
                    el.add((Comment)atr);
                    continue;
                }
                if (ea instanceof Element) {
                    atr = (Element)ea;
                    if (handledElements.contains(atr.getQualifiedName()) || handledElements.contains("core:" + atr.getQualifiedName()) || handledElements.contains("scripting:" + atr.getName())) continue;
                    atr.setParent(null);
                    el.add((Element)atr);
                    continue;
                }
                if (!(ea instanceof Namespace)) continue;
                atr = (Namespace)ea;
                el.add((Namespace)atr);
            }
        }
    }

    private boolean hasCDataAttribute(HashSet<String> handledAttributes) {
        for (String attributeName : handledAttributes) {
            AttributeHelper attribute = this.getAttribute(attributeName);
            if (attribute == null || !attribute.isCData()) continue;
            return true;
        }
        return false;
    }

    private boolean containsText(Element el) {
        List content = el.content();
        for (Object object : content) {
            if (!(object instanceof DefaultText)) continue;
            return true;
        }
        return false;
    }

    public boolean isAllowedChild(NestedDefinition nd) {
        if (this.allowAny) {
            return true;
        }
        return this.isExplicitlyAllowed(nd);
    }

    public boolean isAllowedChildCompletion(NestedDefinition nd) {
        this.initInheritanceIfNeeded();
        boolean containsKey = this.getAllowedChidren().containsKey(nd);
        if (containsKey) {
            return true;
        }
        List alternativeIds = nd.getAlternativeIds();
        for (NodeDefinition d : alternativeIds) {
            if (!this.getAllowedChidren().containsKey(d)) continue;
            return true;
        }
        return false;
    }

    public boolean allowMultiple(NestedDefinition nd) {
        this.initInheritanceIfNeeded();
        ChildElementAttributeHelper childElementAttributeHelper = this.getAllowedChidren().get(nd);
        if (childElementAttributeHelper != null) {
            return childElementAttributeHelper.multiple;
        }
        return true;
    }

    private HashMap<NestedDefinition, ChildElementAttributeHelper> getAllowedChidren() {
        HashMap<NestedDefinition, ChildElementAttributeHelper> rs = new HashMap<NestedDefinition, ChildElementAttributeHelper>();
        for (AttributeCategory s : this.attrs.values()) {
            for (AttributeGroup g : s.getGroups()) {
                for (AttributeHelper h : g.elements()) {
                    List<NestedDefinition> allowedDefinitions;
                    AttributeHelper chd;
                    if (h instanceof ChildElementAttributeHelper) {
                        chd = (ChildElementAttributeHelper)h;
                        allowedDefinitions = ((ChildElementAttributeHelper)chd).getAllowedDefinitions();
                        for (NestedDefinition n : allowedDefinitions) {
                            rs.put(n, (ChildElementAttributeHelper)chd);
                        }
                        continue;
                    }
                    if (!(h instanceof MultiWayHelper)) continue;
                    chd = (MultiWayHelper)h;
                    if (((MultiWayHelper)chd).needsWrapper()) {
                        NestedDefinition wrapperDefinition = MuleCorePlugin.getModuleManager().getNestedDefinition(((MultiWayHelper)chd).getWrapIn());
                        ChildElementAttributeHelper wrapperHelper = new ChildElementAttributeHelper(((MultiWayHelper)chd).getWrapIn(), true);
                        rs.put(wrapperDefinition, wrapperHelper);
                        continue;
                    }
                    allowedDefinitions = ((MultiWayHelper)chd).getAllowedDefinitions();
                    for (NestedDefinition d : allowedDefinitions) {
                        AttributeHelper childHelper = ((MultiWayHelper)chd).getChildHelperFor(d.getId());
                        if (!(childHelper instanceof ChildElementAttributeHelper)) continue;
                        rs.put(d, (ChildElementAttributeHelper)childHelper);
                    }
                }
            }
        }
        return rs;
    }

    public HashSet<AttributeHelper> getRequiredChildren() {
        HashSet<AttributeHelper> required = new HashSet<AttributeHelper>();
        for (AttributeCategory s : this.attrs.values()) {
            for (AttributeGroup g : s.getGroups()) {
                for (AttributeHelper h : g.elements()) {
                    if (h instanceof ChildElementAttributeHelper) {
                        ChildElementAttributeHelper chd = (ChildElementAttributeHelper)h;
                        if (!chd.isRequired()) continue;
                        required.add(chd);
                        continue;
                    }
                    if (h instanceof MultiWayHelper || !(h instanceof AttributeHelper) || h.isAttribute() || !h.isRequired()) continue;
                    required.add(h);
                }
            }
        }
        return required;
    }

    public HashSet<MultiWayHelper> getMultiwayHelpers() {
        HashSet<MultiWayHelper> helpers = new HashSet<MultiWayHelper>();
        for (AttributeHelper helper : this.getAllAttributes()) {
            if (!(helper instanceof MultiWayHelper)) continue;
            helpers.add((MultiWayHelper)helper);
        }
        return helpers;
    }

    public AttributeHelper getAttribute(String name) {
        this.initInheritanceIfNeeded();
        for (AttributeCategory a : this.attrs.values()) {
            for (AttributeGroup g : a.getGroups()) {
                for (AttributeHelper h : g.elements()) {
                    AttributeHelper found;
                    if (h instanceof HCompositeHelper) {
                        found = this.findInComposite(name, (HCompositeHelper)h);
                        if (found == null) continue;
                        return found;
                    }
                    if (h instanceof GroupTabsAttributeHelper) {
                        found = this.findInComposite(name, (GroupTabsAttributeHelper)h);
                        if (found == null) continue;
                        return found;
                    }
                    if (!name.equals(h.getId()) && !name.equals(h.getSaveAs())) continue;
                    return h;
                }
            }
        }
        return null;
    }

    public int getXmlOrder(String childDefinition) {
        int xmlOrder = -1;
        AttributeHelper attribute = this.getAttribute(childDefinition);
        if (attribute != null) {
            xmlOrder = attribute.getXmlOrder();
        }
        return xmlOrder;
    }

    private AttributeHelper findInComposite(String name, AbstractCompositeAttributeHelper attrHelper) {
        for (AttributeHelper h : attrHelper.getChildren()) {
            if (h instanceof AbstractCompositeAttributeHelper) {
                return this.findInComposite(name, (AbstractCompositeAttributeHelper)h);
            }
            if (!h.getId().equals(name)) continue;
            return h;
        }
        return null;
    }

    public List<CompartmentLane> generateRoutes(IElementWrapper element, SplitterNode splitterNode, String runtimeVersion) {
        ArrayList<CompartmentLane> routes = new ArrayList<CompartmentLane>();
        INodeListWrapper childElements = element.getChildElements();
        NodeDefinition splitterDef = splitterNode.getDefinition();
        if (this.isLegacySplitter(splitterDef)) {
            for (IElementWrapper child : childElements) {
                String qualifiedName = child.getTagName();
                if (!qualifiedName.equals("route")) continue;
                routes.add(MessageFlowFactory.createCompartmentLane((IElementWrapper)child));
            }
        }
        return routes;
    }

    protected boolean nodeMatches(IElementWrapper node, Namespace namespace, String name) {
        return node.getNamespaceURI().equals(namespace.getURI()) && name.equals(node.getName()) || name.length() == 0;
    }

    public String getPrefix() {
        return this.namespace.getPrefix();
    }

    public List<AttributeHelper> getAllAttributes() {
        this.initInheritanceIfNeeded();
        ArrayList<AttributeHelper> result = new ArrayList<AttributeHelper>();
        for (AttributeCategory category : this.attrs.values()) {
            for (AttributeGroup group : category.getGroups()) {
                for (AttributeHelper attribute : group.elements()) {
                    result.add(attribute);
                }
            }
        }
        return result;
    }

    public AttributeHelper[] editableDirectAttributes() {
        this.initInheritanceIfNeeded();
        ArrayList<AttributeHelper> l = new ArrayList<AttributeHelper>();
        for (AttributeCategory q : this.attrs.values()) {
            for (AttributeGroup g : q.getGroups()) {
                for (AttributeHelper h : g.elements()) {
                    if (h instanceof TransientAttributeHelper || h instanceof ChildElementAttributeHelper || h.isCData() || h.getNestedTagName() != null) continue;
                    l.add(h);
                }
            }
        }
        return l.toArray(new AttributeHelper[l.size()]);
    }

    public ChildElementAttributeHelper[] getChildElements() {
        ArrayList<AttributeHelper> result = new ArrayList<AttributeHelper>();
        this.initInheritanceIfNeeded();
        for (AttributeCategory categories : this.attrs.values()) {
            for (AttributeGroup groups : categories.getGroups()) {
                for (AttributeHelper helpers : groups.elements()) {
                    if (!(helpers instanceof ChildElementAttributeHelper)) continue;
                    result.add(helpers);
                }
            }
        }
        return result.toArray(new ChildElementAttributeHelper[result.size()]);
    }

    public void addExtraNamespace(Namespace ns) {
        this.additional.add(ns);
    }

    public Collection<Namespace> getAdditionalNamespaces() {
        return this.additional;
    }

    public boolean isExplicitlyAllowed(NestedDefinition nd) {
        this.initInheritanceIfNeeded();
        boolean containsKey = this.getAllowedChidren().containsKey(nd);
        if (!containsKey) {
            List alternativeIds = nd.getAlternativeIds();
            for (NodeDefinition d : alternativeIds) {
                if (!this.getAllowedChidren().containsKey(d)) continue;
                return true;
            }
        }
        List<AttributeHelper> allAttributes = this.getAllAttributes();
        for (AttributeHelper helper : allAttributes) {
            String nestedTagName = helper.getNestedTagName();
            if (!StringUtils.isNotBlank((String)nestedTagName) || !nd.getId().endsWith("/" + nestedTagName)) continue;
            return true;
        }
        return containsKey;
    }

    public Map<String, String> evalGlobalRefs() {
        List<AttributeHelper> allAttributes = this.getAllAttributes();
        HashMap<String, String> globalRefs = new HashMap<String, String>();
        for (AttributeHelper attributeHelper : allAttributes) {
            if (!(attributeHelper instanceof GlobalRefAttributeHelper)) continue;
            GlobalRefAttributeHelper globalRefAttributeHelper = (GlobalRefAttributeHelper)attributeHelper;
            globalRefs.put(globalRefAttributeHelper.getId(), globalRefAttributeHelper.getAttrName());
        }
        return globalRefs;
    }

    public Map<String, String> getGlobalRefsNames(IMessageFlowNode node) {
        HashMap<String, String> globalRefsNames = new HashMap<String, String>();
        IReadOnlyPropertyCollection properties = node.getProperties();
        for (Map.Entry<String, String> globalRef : this.evalGlobalRefs().entrySet()) {
            String propertyValue;
            IReadOnlyProperty property = (IReadOnlyProperty)properties.getProperty(globalRef.getKey());
            if (property == null || (propertyValue = property.getValue()) == null || propertyValue.isEmpty()) continue;
            globalRefsNames.put(propertyValue, globalRef.getValue());
        }
        return globalRefsNames;
    }

    public List<String> evalFlowRefs() {
        List<AttributeHelper> allAttributes = this.getAllAttributes();
        ArrayList<String> flowRefs = new ArrayList<String>();
        for (AttributeHelper attributeHelper : allAttributes) {
            if (!(attributeHelper instanceof FlowAttributeHelper)) continue;
            flowRefs.add(attributeHelper.getId());
        }
        return flowRefs;
    }

    public List<String> getFlowRefsNames(IMessageFlowNode node) {
        ArrayList<String> flowRefsNames = new ArrayList<String>();
        IReadOnlyPropertyCollection properties = node.getProperties();
        for (String string : this.evalFlowRefs()) {
            IReadOnlyProperty property = (IReadOnlyProperty)properties.getProperty(string);
            if (property == null) continue;
            flowRefsNames.add(property.getValue());
        }
        return flowRefsNames;
    }

    public void copyUnknownAttributeProperties(IReadOnlyPropertyCollection source, PropertyCollectionMap target, Version currentVersion) {
        List properties = source.getProperties();
        for (IReadOnlyProperty property : properties) {
            if (!this.isUnknownProperty(source, property, currentVersion) || target.getPropertyOpt(property.getName()).isPresent()) continue;
            target.addProperty(PropertiesUtils.toWritableProperty((IReadOnlyProperty)property));
        }
    }

    public String getMetadataKeyDisplay() {
        return this.metadataKeyDisplay;
    }

    public void setMetadataKeyDisplay(String metadataKeyDisplay) {
        this.metadataKeyDisplay = metadataKeyDisplay;
    }

    public String getConnectivityTestingLabel() {
        return this.connectivityTestingLabel;
    }

    public void setConnectivityTestingLabel(String connectivityTestingLabel) {
        this.connectivityTestingLabel = connectivityTestingLabel;
    }

    public void setSupportsUserDefinedMetaData(boolean supports) {
        this.supportsUserDefinedMetadata = supports;
    }

    public Boolean supportsUserDefinedMetadata() {
        return this.supportsUserDefinedMetadata;
    }

    public boolean hasHelper(Class<? extends AttributeHelper> helperClass) {
        return this.getAllAttributes().stream().anyMatch(helperClass::isInstance);
    }

    public boolean hasPersistenceTransformer() {
        return this.persistenceTransformer != null;
    }

    public AttributesPersistenceTransformer getPersistenceTransformer() {
        return this.persistenceTransformer;
    }

    public void setPersistenceTransformer(String persistenceTransformer) {
        this.persistenceTransformer = AttributeHelper.createPersistenceTransformer(persistenceTransformer);
    }

    public Collection<Requirement> getRequirements() {
        return this.getAllAttributes().stream().filter(RequirementsHelper.class::isInstance).map(RequirementsHelper.class::cast).flatMap(x -> x.getRequirements().stream()).collect(Collectors.toList());
    }
}

