/*
 * Decompiled with CFR 0.152.
 */
package org.mule.tooling.ui.modules.core.widgets.expressions.ui;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import javax.xml.namespace.QName;
import org.eclipse.swt.custom.StyleRange;
import org.eclipse.swt.widgets.Display;
import org.eclipse.wst.xml.core.internal.provisional.document.IDOMAttr;
import org.eclipse.wst.xml.core.internal.provisional.document.IDOMElement;
import org.eclipse.wst.xml.core.internal.provisional.document.IDOMText;
import org.mule.tooling.core.MuleCorePlugin;
import org.mule.tooling.core.dom.QNameUtils;
import org.mule.tooling.messageflow.editor.IExpressionHighligherImpl;
import org.mule.tooling.model.module.NestedDefinition;
import org.mule.tooling.model.module.NodeDefinition;
import org.mule.tooling.ui.modules.core.widgets.meta.AbstractComponentMeta;
import org.mule.tooling.ui.modules.core.widgets.meta.AttributeHelper;
import org.mule.tooling.ui.widgets.util.ThemeUtils;

public class HighlighterImpl
implements IExpressionHighligherImpl {
    private static final String MVEL_EVALUATOR_PREFIX = "mel:";
    private String version;
    static HashSet<Character> punctuators = new HashSet();

    static {
        punctuators.add(Character.valueOf(','));
        punctuators.add(Character.valueOf('.'));
        punctuators.add(Character.valueOf('+'));
        punctuators.add(Character.valueOf('-'));
        punctuators.add(Character.valueOf('*'));
        punctuators.add(Character.valueOf('/'));
        punctuators.add(Character.valueOf('%'));
        punctuators.add(Character.valueOf('>'));
        punctuators.add(Character.valueOf('<'));
        punctuators.add(Character.valueOf('('));
        punctuators.add(Character.valueOf(')'));
        punctuators.add(Character.valueOf('='));
        punctuators.add(Character.valueOf('!'));
    }

    public String getVersion() {
        return this.version;
    }

    public void setVersion(String version) {
        this.version = version;
    }

    public HighlighterImpl(String version) {
        this.version = version;
    }

    public HighlighterImpl() {
        this.version = null;
    }

    public StyleRange[] highlightAttributeValue(IDOMElement element, IDOMAttr atr) {
        AttributeHelper hl;
        block6: {
            QName qName;
            block5: {
                String namespaceURI = element.getNamespaceURI();
                String localName = element.getLocalName();
                if (atr.getName().equals("expression")) {
                    ArrayList<StyleRange> rs = new ArrayList<StyleRange>();
                    this.highlightInsideExpression(atr.getValueRegionStartOffset() + 1, 0, rs, atr.getValue(), 0, -1, 0, '\u0000');
                    HighlighterImpl.correctRanges(atr.getValue(), HighlighterImpl.removeQuotes(atr.getValueRegionText()), atr.getValueRegionStartOffset() + 1, rs);
                    return rs.toArray(new StyleRange[rs.size()]);
                }
                if (namespaceURI == null) {
                    return new StyleRange[0];
                }
                qName = QNameUtils.get((String)localName, null, (String)namespaceURI);
                hl = null;
                NodeDefinition nodeDefinition = this.getSingle(qName);
                if (nodeDefinition == null) {
                    nodeDefinition = (NodeDefinition)MuleCorePlugin.getModuleManager().getGlobalQNameMappings(this.version).get(qName);
                }
                if (nodeDefinition == null) break block5;
                AbstractComponentMeta service = (AbstractComponentMeta)nodeDefinition.getService(AbstractComponentMeta.class);
                if (service == null) break block6;
                hl = service.getAttribute(atr.getName());
                break block6;
            }
            Collection nested = MuleCorePlugin.getModuleManager().getNested();
            for (NestedDefinition d : nested) {
                AbstractComponentMeta service;
                if (!d.matches(qName) || (service = (AbstractComponentMeta)d.getService(AbstractComponentMeta.class)) == null) continue;
                hl = service.getAttribute(atr.getName());
                break;
            }
        }
        if (hl != null) {
            int offset = atr.getValueRegionStartOffset() + 1;
            String value = atr.getValue();
            return this.highlightInsideExpresssion(offset, value);
        }
        return null;
    }

    private static String removeQuotes(String textInQuotes) {
        return textInQuotes.substring(1, textInQuotes.length() - 1);
    }

    /*
     * Unable to fully structure code
     */
    private static void correctRanges(String prettyText, String xmlAttrText, int offset, ArrayList<StyleRange> ranges) {
        shifts = new int[prettyText.length() + 1];
        shifts[0] = 0;
        i = 0;
        j = 0;
        while (i < prettyText.length()) {
            block5: {
                j0 = j;
                if (prettyText.charAt(i) == xmlAttrText.charAt(j) && prettyText.charAt(i) != '&') break block5;
                if (xmlAttrText.charAt(j) == '&') ** GOTO lbl11
                return;
lbl-1000:
                // 1 sources

                {
                    ++j;
lbl11:
                    // 2 sources

                    ** while (j < xmlAttrText.length() && xmlAttrText.charAt((int)j) != ';')
                }
lbl12:
                // 1 sources

                if (j == xmlAttrText.length()) {
                    return;
                }
            }
            shifts[i + 1] = ++j - j0;
            ++i;
        }
        i = 0;
        while (i < prettyText.length()) {
            v0 = i + 1;
            shifts[v0] = shifts[v0] + shifts[i];
            ++i;
        }
        for (StyleRange range : ranges) {
            start0 = range.start - offset;
            length0 = range.length;
            if (shifts.length <= start0 - offset + length0) continue;
            range.start = shifts[start0] + offset;
            range.length = shifts[start0 + length0] - shifts[start0];
        }
    }

    private NodeDefinition getSingle(QName qName) {
        ArrayList arrayList = (ArrayList)MuleCorePlugin.getModuleManager().getQNameMappings(this.version).get(qName);
        if (arrayList == null || arrayList.isEmpty()) {
            return null;
        }
        return (NodeDefinition)arrayList.get(0);
    }

    public StyleRange[] highlightInsideExpresssion(int offset, String value) {
        ArrayList<StyleRange> rgs = this.highlightSubstitution(offset, value);
        int p = 0;
        int level = 0;
        int count = -1;
        int a = 0;
        while (a < value.length()) {
            char c = value.charAt(a);
            if (c == '[' && p == 35) {
                if (level == 0) {
                    count = a - 1;
                }
                ++level;
            }
            if (c == ']' && count != -1 && --level == 0) {
                String substr = value.substring(count, a);
                int mc = -1;
                int qS = -1;
                int ds = -1;
                char prev = '\u0000';
                this.highlightInsideExpression(offset, count, rgs, substr, mc, qS, ds, prev);
                StyleRange styleRange = new StyleRange(count + offset, a - count + 1, null, ThemeUtils.getCurrentTheme().getHighlightBackgroundColor());
                rgs.add(styleRange);
                count = -1;
            }
            p = c;
            ++a;
        }
        return rgs.toArray(new StyleRange[rgs.size()]);
    }

    public StyleRange[] highlightExpresssion(int offset, String value, String evaluator) {
        ArrayList<StyleRange> rgs = this.highlightSubstitution(offset, value);
        this.highlightInsideExpression(offset, 0, rgs, value, 0, -1, 0, '\u0000');
        StyleRange styleRange = new StyleRange(offset, value.length(), null, ThemeUtils.getCurrentTheme().getHighlightBackgroundColor());
        rgs.add(styleRange);
        return rgs.toArray(new StyleRange[rgs.size()]);
    }

    protected void highlightInsideExpression(int offset, int count, ArrayList<StyleRange> rgs, String substr, int mc, int qS, int ds, char prev) {
        int i = 0;
        while (i < substr.length()) {
            block15: {
                StyleRange styleRange;
                char charAt;
                block12: {
                    block14: {
                        block13: {
                            charAt = substr.charAt(i);
                            if (charAt == '[') {
                                mc = i;
                            }
                            if (charAt == ':' && MVEL_EVALUATOR_PREFIX.equals(substr.substring(mc + 1, i + 1))) {
                                styleRange = new StyleRange(mc + count + offset + 1, i - mc, Display.getCurrent().getSystemColor(14), null);
                                rgs.add(styleRange);
                            }
                            if (qS != -1) break block12;
                            if (!Character.isDigit(charAt)) break block13;
                            if (!Character.isJavaIdentifierPart(prev) && (punctuators.contains(Character.valueOf(prev)) || Character.isWhitespace(prev)) && ds == -1) {
                                ds = i;
                            }
                            break block12;
                        }
                        if (ds == -1) break block14;
                        if (charAt == '.' && i < substr.length() - 1 && Character.isDigit(substr.charAt(i + 1))) break block15;
                        styleRange = new StyleRange(ds + count + offset, i - ds, ThemeUtils.getCurrentTheme().getMagentaColor(), Display.getCurrent().getSystemColor(19));
                        rgs.add(styleRange);
                        ds = -1;
                    }
                    if (punctuators.contains(Character.valueOf(charAt))) {
                        styleRange = new StyleRange(i + count + offset, 1, ThemeUtils.getCurrentTheme().getMagentaColor(), Display.getCurrent().getSystemColor(19));
                        rgs.add(styleRange);
                    }
                }
                if (charAt == '\'') {
                    if (qS == -1) {
                        qS = i;
                    } else {
                        styleRange = new StyleRange(qS + count + offset + 1, i - 1 - qS, ThemeUtils.getCurrentTheme().getGreenColor(), Display.getCurrent().getSystemColor(19));
                        rgs.add(styleRange);
                        qS = -1;
                    }
                }
                prev = charAt;
            }
            ++i;
        }
    }

    protected ArrayList<StyleRange> highlightSubstitution(int offset, String value) {
        int p = 0;
        int count = -1;
        ArrayList<StyleRange> rgs = new ArrayList<StyleRange>();
        int a = 0;
        while (a < value.length()) {
            char c = value.charAt(a);
            if (c == '{' && p == 36) {
                count = a - 1;
            }
            if (c == '}' && count != -1) {
                StyleRange styleRange = new StyleRange(count + offset, a - count + 1, Display.getCurrent().getSystemColor(6), null);
                rgs.add(styleRange);
                count = -1;
            }
            p = c;
            ++a;
        }
        return rgs;
    }

    public StyleRange[] highlightTextValue(IDOMElement element, IDOMText ts) {
        return this.highlightInsideExpresssion(ts.getStartOffset(), ts.getSource());
    }
}

