/*
 * Decompiled with CFR 0.152.
 */
package org.mule.tooling.ui.modules.core.widgets.expressions.ui;

import com.onpositive.commons.namespace.ide.ui.editors.xml.model.IProblemReporter;
import java.util.ArrayList;
import java.util.Iterator;
import org.eclipse.jface.text.Document;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.text.ITextHover;
import org.eclipse.jface.text.ITextViewer;
import org.eclipse.jface.text.Position;
import org.eclipse.jface.text.Region;
import org.eclipse.jface.text.TextPresentation;
import org.eclipse.jface.text.contentassist.ContentAssistEvent;
import org.eclipse.jface.text.contentassist.ContentAssistant;
import org.eclipse.jface.text.contentassist.ICompletionListener;
import org.eclipse.jface.text.contentassist.ICompletionProposal;
import org.eclipse.jface.text.contentassist.IContentAssistProcessor;
import org.eclipse.jface.text.contentassist.IContentAssistant;
import org.eclipse.jface.text.contentassist.IContextInformation;
import org.eclipse.jface.text.contentassist.IContextInformationValidator;
import org.eclipse.jface.text.reconciler.DirtyRegion;
import org.eclipse.jface.text.reconciler.IReconciler;
import org.eclipse.jface.text.reconciler.IReconcilingStrategy;
import org.eclipse.jface.text.reconciler.MonoReconciler;
import org.eclipse.jface.text.source.Annotation;
import org.eclipse.jface.text.source.AnnotationModel;
import org.eclipse.jface.text.source.AnnotationPainter;
import org.eclipse.jface.text.source.IAnnotationHover;
import org.eclipse.jface.text.source.IAnnotationModel;
import org.eclipse.jface.text.source.ISourceViewer;
import org.eclipse.jface.text.source.IVerticalRuler;
import org.eclipse.jface.text.source.SourceViewer;
import org.eclipse.jface.text.source.SourceViewerConfiguration;
import org.eclipse.jface.text.source.VerticalRuler;
import org.eclipse.swt.custom.LineStyleEvent;
import org.eclipse.swt.custom.LineStyleListener;
import org.eclipse.swt.custom.StyleRange;
import org.eclipse.swt.custom.StyledText;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.events.PaintEvent;
import org.eclipse.swt.events.PaintListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Layout;
import org.mule.tooling.ui.modules.core.widgets.AttributeContext;
import org.mule.tooling.ui.modules.core.widgets.expressions.MuleExpressionProcessor;
import org.mule.tooling.ui.modules.core.widgets.expressions.MuleExpressionValidator;
import org.mule.tooling.ui.modules.core.widgets.expressions.ui.HighlighterImpl;

public class ExpressionWidget {
    protected SourceViewer sv;
    private AttributeContext context;

    public ExpressionWidget(AttributeContext context) {
        this.context = context;
    }

    public void createPartControl(Composite parent) {
        Composite m = new Composite(parent, 2048);
        FillLayout layout = new FillLayout();
        layout.marginWidth = 0;
        m.setLayout((Layout)layout);
        this.sv = new SourceViewer(m, (IVerticalRuler)new VerticalRuler(0), this.getStyle());
        this.sv.setDocument((IDocument)new Document(""), (IAnnotationModel)new AnnotationModel());
        this.sv.getTextWidget().addLineStyleListener(new LineStyleListener(){

            public void lineGetStyle(LineStyleEvent event) {
                StyleRange[] highlightInsideExpresssion = ExpressionWidget.this.doHighlight(event);
                if (highlightInsideExpresssion != null) {
                    TextPresentation ps = new TextPresentation();
                    int a = 0;
                    while (a < highlightInsideExpresssion.length) {
                        ps.mergeStyleRange(highlightInsideExpresssion[a]);
                        ++a;
                    }
                    Iterator allStyleRangeIterator = ps.getAllStyleRangeIterator();
                    ArrayList<StyleRange> ls = new ArrayList<StyleRange>();
                    while (allStyleRangeIterator.hasNext()) {
                        ls.add((StyleRange)allStyleRangeIterator.next());
                    }
                    event.styles = ls.toArray(new StyleRange[ls.size()]);
                    int a2 = 0;
                    while (a2 < highlightInsideExpresssion.length) {
                        highlightInsideExpresssion[a2].start += event.lineOffset;
                        ++a2;
                    }
                }
            }
        });
        SourceViewerConfiguration configuration = new SourceViewerConfiguration(){
            ContentAssistant assistent = new ContentAssistant();
            {
                this.assistent.addCompletionListener(new ICompletionListener(){

                    public void selectionChanged(ICompletionProposal proposal, boolean smartToggle) {
                    }

                    public void assistSessionStarted(ContentAssistEvent event) {
                        ExpressionWidget.this.completionStarted();
                    }

                    public void assistSessionEnded(ContentAssistEvent event) {
                        ExpressionWidget.this.completionFinished();
                    }
                });
                this.assistent.setContentAssistProcessor(new IContentAssistProcessor(){

                    public ICompletionProposal[] computeCompletionProposals(ITextViewer viewer, int offset) {
                        String string = viewer.getDocument().get();
                        ArrayList<ICompletionProposal> result = new ArrayList<ICompletionProposal>();
                        new MuleExpressionProcessor((this).ExpressionWidget.this.context, (ITextViewer)(this).ExpressionWidget.this.sv).addExpressionProposals((ITextViewer)(this).ExpressionWidget.this.sv, result, offset, null, string.substring(0, offset), 1, string, ExpressionWidget.this.getEvaluator());
                        return result.toArray(new ICompletionProposal[result.size()]);
                    }

                    public IContextInformation[] computeContextInformation(ITextViewer viewer, int offset) {
                        return new IContextInformation[0];
                    }

                    public char[] getCompletionProposalAutoActivationCharacters() {
                        return new char[]{'$', '.', ':'};
                    }

                    public char[] getContextInformationAutoActivationCharacters() {
                        return new char[]{'$', '.', ':'};
                    }

                    public String getErrorMessage() {
                        return null;
                    }

                    public IContextInformationValidator getContextInformationValidator() {
                        return null;
                    }
                }, "__dftl_partition_content_type");
            }

            public ITextHover getTextHover(ISourceViewer sourceViewer, String contentType) {
                return new ITextHover(){

                    public IRegion getHoverRegion(ITextViewer textViewer, int offset) {
                        Iterator annotationIterator = (this).ExpressionWidget.this.sv.getVisualAnnotationModel().getAnnotationIterator();
                        while (annotationIterator.hasNext()) {
                            Annotation ann = (Annotation)annotationIterator.next();
                            Position position = (this).ExpressionWidget.this.sv.getVisualAnnotationModel().getPosition(ann);
                            if (!position.includes(offset)) continue;
                            return new Region(position.offset, position.length);
                        }
                        return null;
                    }

                    public String getHoverInfo(ITextViewer textViewer, IRegion hoverRegion) {
                        Iterator annotationIterator = (this).ExpressionWidget.this.sv.getVisualAnnotationModel().getAnnotationIterator();
                        while (annotationIterator.hasNext()) {
                            Annotation ann = (Annotation)annotationIterator.next();
                            Position position = (this).ExpressionWidget.this.sv.getVisualAnnotationModel().getPosition(ann);
                            if (!position.includes(hoverRegion.getOffset())) continue;
                            return ann.getText();
                        }
                        return null;
                    }
                };
            }

            public IContentAssistant getContentAssistant(ISourceViewer sourceViewer) {
                return this.assistent;
            }

            public IReconciler getReconciler(ISourceViewer sourceViewer) {
                return new MonoReconciler(new IReconcilingStrategy(){

                    public void setDocument(IDocument document) {
                    }

                    public void reconcile(DirtyRegion dirtyRegion, IRegion subRegion) {
                        String string = (this).ExpressionWidget.this.sv.getDocument().get();
                        this.process(string);
                    }

                    private void process(String string) {
                        ExpressionWidget.this.doRevalidate(string);
                    }

                    public void reconcile(IRegion partition) {
                        String string = (this).ExpressionWidget.this.sv.getDocument().get();
                        this.process(string);
                    }
                }, false);
            }

            public IAnnotationHover getAnnotationHover(ISourceViewer sourceViewer) {
                return new IAnnotationHover(){

                    public String getHoverInfo(ISourceViewer sourceViewer, int lineNumber) {
                        return "Some error";
                    }
                };
            }
        };
        this.sv.getTextWidget().addKeyListener(new KeyListener(){

            public void keyReleased(KeyEvent e) {
            }

            public void keyPressed(KeyEvent e) {
                if (e.keyCode == 262144) {
                    ExpressionWidget.this.sv.doOperation(13);
                }
            }
        });
        this.sv.getTextWidget().addPaintListener(new PaintListener(){

            public void paintControl(PaintEvent e) {
                SquigglesStrategy squigglesStrategy = new SquigglesStrategy();
                IAnnotationModel annotationModel = ExpressionWidget.this.sv.getVisualAnnotationModel();
                Iterator annotationIterator = annotationModel.getAnnotationIterator();
                while (annotationIterator.hasNext()) {
                    Annotation ann = (Annotation)annotationIterator.next();
                    Position position = annotationModel.getPosition(ann);
                    squigglesStrategy.draw(ann, e.gc, ExpressionWidget.this.sv.getTextWidget(), position.offset, position.length, Display.getCurrent().getSystemColor(3));
                }
            }
        });
        this.sv.configure(configuration);
        this.sv.getTextWidget().redraw();
    }

    public int getStyle() {
        return 64;
    }

    protected void doValidateExpression(String string) {
        IProblemReporter iProblemReporter = new IProblemReporter(){

            public void accept(int severity, int start, int end, String message, int number) {
                Annotation annotation = new Annotation(true);
                annotation.setText(message);
                ExpressionWidget.this.sv.getVisualAnnotationModel().addAnnotation(annotation, new Position(start - 1, end - start + 1));
            }
        };
        new MuleExpressionValidator(iProblemReporter, 0).validate(null, this.context.getProject().getProject(), string, null, this.getEvaluator());
    }

    protected String getEvaluator() {
        return null;
    }

    public Control getControl() {
        return this.sv.getControl().getParent();
    }

    public void setText(String txt) {
        this.sv.getDocument().set(txt);
    }

    public String getText() {
        return this.sv.getDocument().get();
    }

    protected StyleRange[] doHighlight(LineStyleEvent event) {
        HighlighterImpl im = new HighlighterImpl(this.context.getVersion());
        StyleRange[] highlightInsideExpresssion = im.highlightInsideExpresssion(0, event.lineText);
        return highlightInsideExpresssion;
    }

    protected void doRevalidate(String string) {
        AnnotationModel annotationModel = (AnnotationModel)this.sv.getVisualAnnotationModel();
        annotationModel.removeAllAnnotations();
        this.doValidateExpression(string);
        Display.getDefault().syncExec(new Runnable(){

            @Override
            public void run() {
                StyledText textWidget = ExpressionWidget.this.sv.getTextWidget();
                if (textWidget != null) {
                    textWidget.redraw();
                }
            }
        });
    }

    public Control getTextWidget() {
        return this.sv.getTextWidget();
    }

    protected void completionStarted() {
    }

    protected void completionFinished() {
    }

    public static class SquigglesStrategy
    implements AnnotationPainter.IDrawingStrategy {
        public void draw(Annotation annotation, GC gc, StyledText textWidget, int offset, int length, Color color) {
            if (gc != null) {
                if (length < 1) {
                    return;
                }
                Point left = textWidget.getLocationAtOffset(offset);
                Point right = textWidget.getLocationAtOffset(offset + length);
                Rectangle rect = textWidget.getTextBounds(offset, offset + length - 1);
                left.x = rect.x;
                right.x = rect.x + rect.width;
                int[] polyline = this.computePolyline(left, right, textWidget.getBaseline(offset), textWidget.getLineHeight(offset));
                gc.setLineWidth(0);
                gc.setLineStyle(1);
                gc.setForeground(color);
                gc.drawPolyline(polyline);
            } else {
                textWidget.redrawRange(offset, length, true);
            }
        }

        private int[] computePolyline(Point left, Point right, int baseline, int lineHeight) {
            int peaks = (right.x - left.x) / 4;
            if (peaks == 0 && right.x - left.x > 2) {
                peaks = 1;
            }
            int leftX = left.x;
            int length = (2 * peaks + 1) * 2;
            if (length < 0) {
                return new int[0];
            }
            int[] coordinates = new int[length];
            int top = left.y + Math.min(baseline + 1, lineHeight - 2 - 1);
            int bottom = top + 2;
            int i = 0;
            while (i < peaks) {
                int index = 4 * i;
                coordinates[index] = leftX + 4 * i;
                coordinates[index + 1] = bottom;
                coordinates[index + 2] = coordinates[index] + 2;
                coordinates[index + 3] = top;
                ++i;
            }
            coordinates[length - 2] = Math.min(Math.max(0, right.x - 1), left.x + 4 * peaks);
            coordinates[length - 1] = bottom;
            return coordinates;
        }
    }
}

