/*
 * Decompiled with CFR 0.152.
 */
package org.mule.tooling.ui.modules.core.widgets.expressions;

import com.onpositive.commons.namespace.ide.ui.editors.xml.model.DomainEditingModelObject;
import com.onpositive.commons.namespace.ide.ui.editors.xml.model.IProblemReporter;
import com.onpositive.commons.namespace.ide.ui.internal.core.text.IDocumentAttributeNode;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.IStatus;
import org.mule.tooling.core.MuleRuntime;
import org.mule.tooling.core.utils.ValidationUtils;

public class MuleExpressionValidator {
    private final IProblemReporter reporter;
    private final int number;

    public MuleExpressionValidator(IProblemReporter iProblemReporter, int number) {
        this.reporter = iProblemReporter;
        this.number = number;
    }

    public void validate(IDocumentAttributeNode node, IProject project, String value, DomainEditingModelObject domainEditingModel, String evaluator) {
        int endExpression;
        int startExpression;
        if (node == null) {
            startExpression = 0;
            endExpression = value.length();
        } else {
            startExpression = node.getValueOffset();
            endExpression = node.getValueOffset() + node.getValueLength();
        }
        this.validatePlaceHolders(startExpression, endExpression, value);
        this.validateExpressions(startExpression, endExpression, project, value, domainEditingModel);
    }

    private void validatePlaceHolders(int startExpression, int endExpression, String value) {
        int count = -1;
        int p = 0;
        int a = 0;
        while (a < value.length()) {
            char c = value.charAt(a);
            if (c == '{' && p == 36) {
                count = a - 1;
            }
            if (c == '}' && count != -1) {
                count = -1;
            }
            p = c;
            ++a;
        }
        if (count != -1) {
            this.reportError(startExpression, endExpression, count, "Substitution expression should be closed");
        }
    }

    private void validateExpressions(int startExpression, int endExpression, IProject project, String value, DomainEditingModelObject domainEditingModel) {
        String modelID = domainEditingModel.getNamespace() + "/" + domainEditingModel.getLocalName();
        IStatus validationResult = new ValidationUtils(MuleRuntime.create((IProject)project)).validate(value, modelID);
        if (!validationResult.isOK()) {
            this.reportError(startExpression, endExpression, validationResult.getMessage());
        }
    }

    private void reportError(int startExpression, int endExpression, String message) {
        this.reportError(startExpression, endExpression, 0, message);
    }

    private void reportError(int startExpression, int endExpression, int count, String message) {
        int start = startExpression + count + 1;
        this.reporter.accept(4, start, endExpression, message, this.number);
    }
}

