/*
 * Decompiled with CFR 0.152.
 */
package org.mule.tooling.ui.modules.core.widgets.expressions;

import java.util.ArrayList;
import java.util.HashMap;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.Platform;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.text.ITextViewer;
import org.eclipse.jface.text.contentassist.ICompletionProposal;
import org.eclipse.jface.text.hyperlink.IHyperlinkDetector;
import org.eclipse.swt.graphics.Image;
import org.eclipse.ui.plugin.AbstractUIPlugin;
import org.mule.tooling.core.MuleCorePlugin;
import org.mule.tooling.ui.modules.core.widgets.AttributeContext;
import org.mule.tooling.ui.modules.core.widgets.IValidator;
import org.mule.tooling.ui.modules.core.widgets.expressions.IExpressionLanguage;
import org.mule.tooling.ui.modules.core.widgets.expressions.ISyntaxColorer;

public final class ExpressionRegistry {
    private static final String EXTENSION_POINT_ID = "org.mule.tooling.ui.modules.core.expressionLanguage";
    private static ExpressionRegistry instance;
    HashMap<String, Object> elements = new HashMap();
    HashMap<String, Object> celements = new HashMap();
    HashMap<String, Image> images = new HashMap();

    private ExpressionRegistry() {
        IConfigurationElement[] configurationElementsFor;
        IConfigurationElement[] iConfigurationElementArray = configurationElementsFor = Platform.getExtensionRegistry().getConfigurationElementsFor(EXTENSION_POINT_ID);
        int n = configurationElementsFor.length;
        int n2 = 0;
        while (n2 < n) {
            IConfigurationElement r = iConfigurationElementArray[n2];
            String attribute = r.getAttribute("lang");
            this.elements.put(attribute, r);
            this.celements.put(attribute, r);
            ++n2;
        }
    }

    public IExpressionLanguage getLanguage(String lang) {
        if (lang.equals("custom")) {
            return new IExpressionLanguage(){

                @Override
                public ISyntaxColorer getSyntaxHighlighter() {
                    return null;
                }

                @Override
                public IHyperlinkDetector getHyperlinkDetector() {
                    return null;
                }

                @Override
                public IValidator getExpressionValidator() {
                    return null;
                }

                @Override
                public boolean computeCompletionProposals(ArrayList<ICompletionProposal> result, int offset, String fullString, String startString, String expression, int startPosition, int endPosition, boolean closed, int indexOf, AttributeContext ctx, ITextViewer viewer) {
                    return false;
                }
            };
        }
        Object object = this.elements.get(lang);
        if (object != null) {
            if (object instanceof IExpressionLanguage) {
                IExpressionLanguage langv = (IExpressionLanguage)object;
                return langv;
            }
            IConfigurationElement el = (IConfigurationElement)object;
            try {
                IExpressionLanguage createExecutableExtension = (IExpressionLanguage)el.createExecutableExtension("class");
                this.elements.put(lang, createExecutableExtension);
                return createExecutableExtension;
            }
            catch (CoreException e) {
                MuleCorePlugin.getLog().log(e.getStatus());
            }
        }
        return null;
    }

    public Image getImage(String lang) {
        Image image = this.images.get(lang);
        if (image != null) {
            return image;
        }
        IConfigurationElement object = (IConfigurationElement)this.celements.get(lang);
        if (object != null) {
            String attribute = object.getAttribute("icon");
            ImageDescriptor imageDescriptorFromPlugin = AbstractUIPlugin.imageDescriptorFromPlugin((String)object.getContributor().getName(), (String)attribute);
            this.images.put(lang, imageDescriptorFromPlugin.createImage());
            return this.images.get(lang);
        }
        return null;
    }

    public String getDescription(String lang) {
        IConfigurationElement object = (IConfigurationElement)this.celements.get(lang);
        if (object != null) {
            String attribute = object.getAttribute("description");
            return attribute;
        }
        return "missed description";
    }

    public static synchronized ExpressionRegistry getInstance() {
        if (instance == null) {
            instance = new ExpressionRegistry();
        }
        return instance;
    }

    public String[] getLanguages() {
        return this.elements.keySet().toArray(new String[this.elements.size()]);
    }
}

