/*
 * Decompiled with CFR 0.152.
 */
package org.mule.tooling.ui.modules.core.widgets.editors.requirement;

import com.google.common.collect.Lists;
import com.google.common.util.concurrent.ThreadFactoryBuilder;
import java.beans.PropertyChangeListener;
import java.io.File;
import java.util.Collection;
import java.util.List;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.jface.layout.GridLayoutFactory;
import org.eclipse.jface.layout.LayoutConstants;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.mule.tooling.core.MuleCorePlugin;
import org.mule.tooling.core.event.CoreEventTypes;
import org.mule.tooling.core.event.IClasspathEventListener;
import org.mule.tooling.core.m2.dependency.MavenDependency;
import org.mule.tooling.core.model.IMuleProject;
import org.mule.tooling.model.messageflow.IMessageFlowNode;
import org.mule.tooling.model.messageflow.decorator.PropertyCollectionMap;
import org.mule.tooling.model.module.Requirement;
import org.mule.tooling.model.project.MuleExtension;
import org.mule.tooling.ui.modules.core.widgets.AttributeContext;
import org.mule.tooling.ui.modules.core.widgets.AttributesPropertyPage;
import org.mule.tooling.ui.modules.core.widgets.IFieldEditorVisitor;
import org.mule.tooling.ui.modules.core.widgets.editors.BaseAbstractFieldEditor;
import org.mule.tooling.ui.modules.core.widgets.editors.requirement.RequirementRow;
import org.mule.tooling.ui.modules.core.widgets.meta.propertypage.RequirementsHelper;
import org.mule.tooling.utils.eventbus.EventBusHelper;
import org.mule.tooling.utils.eventbus.IEventHandler;

public class RequirementsEditor
extends BaseAbstractFieldEditor
implements IClasspathEventListener {
    private AttributesPropertyPage page;
    private final Composite parentGroup;
    private final Control control;
    private final List<RequirementRow> requirementRows = Lists.newArrayList();
    private EventBusHelper eventBusHelper;
    private IMessageFlowNode node;
    private ExecutorService executorService;
    private static final int THREADS_FOR_VALIDATING_ROWS = 3;

    public RequirementsEditor(AttributesPropertyPage page, AttributeContext context, RequirementsHelper helper, Composite parentGroup) {
        super(helper);
        this.page = page;
        this.parentGroup = parentGroup;
        this.executorService = Executors.newFixedThreadPool(3, new ThreadFactoryBuilder().build());
        this.control = this.createControl(parentGroup, context);
        this.eventBusHelper = new EventBusHelper();
        this.eventBusHelper.registerListener(MuleCorePlugin.getEventBus(), CoreEventTypes.ON_JAR_ADDED, (IEventHandler)this);
        this.eventBusHelper.registerListener(MuleCorePlugin.getEventBus(), CoreEventTypes.ON_JAR_REMOVED, (IEventHandler)this);
        this.page.addDisposeListener(e -> this.executorService.shutdown());
    }

    protected Control createControl(Composite parentGroup, AttributeContext context) {
        Composite reqRowsComposite = new Composite(parentGroup, 0);
        reqRowsComposite.addDisposeListener(e -> this.eventBusHelper.unregister());
        Point defaultSpacing = LayoutConstants.getSpacing();
        GridLayoutFactory.fillDefaults().numColumns(4).spacing(defaultSpacing.x, 0).applyTo(reqRowsComposite);
        GridDataFactory.fillDefaults().grab(true, false).applyTo((Control)reqRowsComposite);
        Collection<Requirement> requirements = ((RequirementsHelper)this.getHelper()).getRequirements();
        IMuleProject project = context.getProject();
        for (Requirement requirement : requirements) {
            this.requirementRows.add(new RequirementRow(reqRowsComposite, requirement, project, this));
        }
        this.validateRows();
        return reqRowsComposite;
    }

    public void validateRows() {
        for (RequirementRow row : this.requirementRows) {
            row.validate(this.executorService);
        }
    }

    @Override
    public void loadFrom(IMessageFlowNode node, PropertyCollectionMap props) {
        this.node = node;
    }

    public IMessageFlowNode getNode() {
        return this.node;
    }

    @Override
    public void saveTo(IMessageFlowNode node, PropertyCollectionMap props) {
    }

    @Override
    public void addPropertyChangeListener(PropertyChangeListener listener) {
    }

    @Override
    public void removePropertChangeListener(PropertyChangeListener listener) {
    }

    @Override
    public Control getControl() {
        return this.control;
    }

    @Override
    public boolean isEnabled() {
        return true;
    }

    @Override
    public void setEnabled(boolean enabled) {
    }

    @Override
    public void setParentPage(AttributesPropertyPage attributesPropertyPage) {
    }

    @Override
    public AttributesPropertyPage getParentPage() {
        return this.page;
    }

    @Override
    public Control getContentControl() {
        return this.control;
    }

    @Override
    public void accept(IFieldEditorVisitor visitor) {
        visitor.visit(this);
    }

    public Composite getParent() {
        return this.parentGroup;
    }

    public void onJarAddedToClasspath(File file, IMuleProject muleProject) {
        this.validateRows();
    }

    public void onJarRemovedFromClasspath(File file, IMuleProject muleProject) {
        this.validateRows();
    }

    public void onExtensionRemovedFromClasspath(MuleExtension removedExtension, IMuleProject muleProject) {
    }

    public void onApiRemovedFromClasspath(MavenDependency removedExtension, IMuleProject muleProject) {
    }
}

