/*
 * Decompiled with CFR 0.152.
 */
package org.mule.tooling.ui.modules.core.widgets.editors.requirement;

import java.util.List;
import java.util.Optional;
import java.util.concurrent.ExecutorService;
import org.apache.commons.lang3.StringUtils;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Widget;
import org.mule.tooling.core.MuleCorePlugin;
import org.mule.tooling.core.dependencymanagement.RequirementDependencyManager;
import org.mule.tooling.core.io.MuleResourceUtils;
import org.mule.tooling.core.model.IMuleApplicationProject;
import org.mule.tooling.core.model.IMuleDomain;
import org.mule.tooling.core.model.IMuleDomainProject;
import org.mule.tooling.core.model.IMuleProject;
import org.mule.tooling.core.model.MuleProjectKind;
import org.mule.tooling.core.requirement.AbstractValidationCallback;
import org.mule.tooling.core.requirement.RequirementValidator;
import org.mule.tooling.core.requirement.ValidationCallback;
import org.mule.tooling.core.requirement.ValidationResult;
import org.mule.tooling.core.utils.CoreUtils;
import org.mule.tooling.model.messageflow.IMessageFlowNode;
import org.mule.tooling.model.module.Requirement;
import org.mule.tooling.ui.modules.core.widgets.editors.requirement.RequirementsEditor;
import org.mule.tooling.ui.widgets.ValidationFeedback;
import org.mule.tooling.ui.widgets.ValidationWidgetStatus;
import org.mule.tooling.ui.widgets.util.WidgetUtils;

public class RequirementRow {
    private static final String MODIFY_ACTION_LABEL = "Modify...";
    private static final String ADD_ACTION_LABEL = "Configure...";
    private static final String DATA_ORIGINAL_LOCATION_LABEL = "original_location_label";
    public static final int MAX_SELECTED_FILE_TEXT_LENGTH = 32;
    public static final String SELECTED_FILE_TEXT_PREFIX = "(";
    public static final String SELECTED_FILE_TEXT_SUFFIX = ")";
    public static final String SELECTED_FILE_TEXT_FILL_TOKEN = "...";
    private static final int BUTTON_PADDING = 5;
    private static final int ROW_HEIGHT = -1;
    private final ValidationFeedback img;
    private final Label nameLabel;
    private final Label selectedFileLabel;
    private final Button button;
    private final Requirement requirement;
    private final RequirementsEditor requirementsEditor;
    private IMuleProject project;
    private List<RequirementDependencyManager> requirementDependencyManagers;

    public RequirementRow(Composite parent, Requirement requirement, IMuleProject project, RequirementsEditor requirementsEditor) {
        this.project = project;
        this.requirement = requirement;
        this.requirementsEditor = requirementsEditor;
        this.requirementDependencyManagers = RequirementDependencyManager.RequirementDependencyManagerExtension.getAll();
        this.img = new ValidationFeedback(parent);
        GridDataFactory.swtDefaults().hint(-1, -1).applyTo(this.img.getControl());
        this.nameLabel = new Label(parent, 0);
        this.nameLabel.setText(requirement.getName());
        GridDataFactory.swtDefaults().hint(-1, -1).applyTo((Control)this.nameLabel);
        this.selectedFileLabel = new Label(parent, 0);
        this.selectedFileLabel.setForeground(Display.getCurrent().getSystemColor(16));
        GridDataFactory.swtDefaults().grab(true, false).hint(-1, -1).applyTo((Control)this.selectedFileLabel);
        this.button = new Button(parent, 0);
        this.button.setText(ADD_ACTION_LABEL);
        Point hint = WidgetUtils.getHintForControl((Control)this.button, (int)(Math.max(ADD_ACTION_LABEL.length(), MODIFY_ACTION_LABEL.length()) + 5));
        GridDataFactory.swtDefaults().align(0x1000008, 0x1000000).hint(hint.x + 5, -1).applyTo((Control)this.button);
        IMuleProject projectToModify = this.getProjectToModify(project, requirementsEditor.getParentPage().getMessageFlowNode());
        Menu menu = this.createPopupMenu(this.button, projectToModify, requirement);
        this.button.addListener(13, event -> {
            if (event.widget == this.button && !menu.isVisible() && !menu.isDisposed()) {
                menu.setVisible(true);
            }
        });
    }

    private Menu createPopupMenu(Button button, IMuleProject muleProject, Requirement requirement) {
        MenuManager menuMgr = new MenuManager("#PopupMenu");
        menuMgr.setRemoveAllWhenShown(true);
        menuMgr.addMenuListener(manager -> this.fillContextMenu(button, menuMgr, muleProject, requirement));
        Menu menu = menuMgr.createContextMenu((Control)button);
        button.setMenu(menu);
        return menu;
    }

    private void fillContextMenu(final Button button, MenuManager menuMgr, final IMuleProject muleProject, final Requirement requirement) {
        final RequirementDependencyManager.Action action = MODIFY_ACTION_LABEL.equals(button.getText()) ? RequirementDependencyManager.Action.MODIFY : RequirementDependencyManager.Action.ADD;
        this.requirementDependencyManagers.stream().filter(requirementManager -> requirementManager.applies(action, muleProject, requirement)).sorted().map(requirementManager -> {
            String label = requirementManager.getLabel(action);
            return new Action(label, (RequirementDependencyManager)requirementManager){
                private final /* synthetic */ RequirementDependencyManager val$requirementManager;
                {
                    this.val$requirementManager = requirementDependencyManager;
                    super($anonymous0);
                }

                public void run() {
                    RequirementRow.this.runRequirementManager(button, muleProject, requirement, action, this.val$requirementManager);
                }
            };
        }).forEach(arg_0 -> ((MenuManager)menuMgr).add(arg_0));
    }

    private void runRequirementManager(Button button, IMuleProject muleProject, Requirement requirement, RequirementDependencyManager.Action action, RequirementDependencyManager requirementManager) {
        Shell activeShell = button.getDisplay().getActiveShell();
        Object locationLabel = this.selectedFileLabel.getData(DATA_ORIGINAL_LOCATION_LABEL);
        Optional relativeLocation = locationLabel.equals(requirement.getEmptyLocationLabel()) ? Optional.empty() : Optional.ofNullable((String)locationLabel);
        Optional actionedDependency = requirementManager.run(action, activeShell, muleProject, this.requirementsEditor.getNode(), requirement, relativeLocation);
        actionedDependency.ifPresent(d -> this.requirementsEditor.validateRows());
    }

    private IMuleProject getProjectToModify(IMuleProject project, IMessageFlowNode messageFlowNode) {
        IMuleProject projectToModify = project;
        if (MuleProjectKind.APPLICATION.classifies(project)) {
            try {
                IMuleApplicationProject muleAppProject = (IMuleApplicationProject)MuleProjectKind.APPLICATION.adapt(project);
                IMuleDomain domain = muleAppProject.getDomain();
                if (!muleAppProject.hasDefaultDomain() && domain != null && MuleResourceUtils.checkConnectorBelongsToDomain((IMuleProject)project, (String)CoreUtils.getNameProperty((IMessageFlowNode)messageFlowNode)) && domain instanceof IMuleDomainProject) {
                    projectToModify = (IMuleDomainProject)domain;
                }
            }
            catch (Throwable e1) {
                MuleCorePlugin.logError((String)"Cannot get domain from project.", (Throwable)e1);
            }
        }
        return projectToModify;
    }

    public void validate(ExecutorService executorService) {
        ImageUpdater callback = new ImageUpdater(this.img, this.button, this.selectedFileLabel, this.requirement);
        RequirementValidator.validate((IMuleProject)this.project, (Requirement)this.requirement, (ValidationCallback)callback, (ExecutorService)executorService);
    }

    public static String prettyPrintLocation(String location) {
        if (StringUtils.isBlank((CharSequence)location)) {
            return location;
        }
        if (location.length() <= 32) {
            return SELECTED_FILE_TEXT_PREFIX + location + SELECTED_FILE_TEXT_SUFFIX;
        }
        int first = (int)((double)(32 - SELECTED_FILE_TEXT_FILL_TOKEN.length()) * 0.25);
        int second = 32 - (first + SELECTED_FILE_TEXT_FILL_TOKEN.length());
        return SELECTED_FILE_TEXT_PREFIX + location.substring(0, first) + SELECTED_FILE_TEXT_FILL_TOKEN + location.substring(location.length() - second) + SELECTED_FILE_TEXT_SUFFIX;
    }

    public Label getNameLabel() {
        return this.nameLabel;
    }

    public Button getButton() {
        return this.button;
    }

    private static class ImageUpdater
    extends AbstractValidationCallback<ValidationResult> {
        private final ValidationFeedback img;
        private final Button button;
        private Label selectedFileLabel;
        private Requirement requirement;

        public ImageUpdater(ValidationFeedback img, Button button, Label selectedFileLabel, Requirement requirement) {
            super(true);
            this.img = img;
            this.button = button;
            this.selectedFileLabel = selectedFileLabel;
            this.requirement = requirement;
        }

        public void doRun(ValidationResult result) {
            if (WidgetUtils.isAnyDisposedOrNull((Widget[])new Widget[]{this.button, this.selectedFileLabel})) {
                return;
            }
            ValidationWidgetStatus widgetStatus = ValidationWidgetStatus.create((int)result.getStatus(), (long)result.getTime(), (String)result.getMessage());
            this.img.setStatus(widgetStatus);
            if (result.isSuccessful()) {
                this.button.setText(RequirementRow.MODIFY_ACTION_LABEL);
            } else {
                this.button.setText(RequirementRow.ADD_ACTION_LABEL);
            }
            String locationLabel = result.getLocationLabel();
            this.selectedFileLabel.setData(RequirementRow.DATA_ORIGINAL_LOCATION_LABEL, (Object)locationLabel);
            this.selectedFileLabel.setText(locationLabel.equals(this.requirement.getEmptyLocationLabel()) ? locationLabel : RequirementRow.prettyPrintLocation(locationLabel));
            this.selectedFileLabel.setToolTipText(locationLabel);
            this.selectedFileLabel.getParent().layout();
        }
    }
}

