/*
 * Decompiled with CFR 0.152.
 */
package org.mule.tooling.ui.modules.core.widgets.editors.preferences;

import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.jface.layout.GridLayoutFactory;
import org.eclipse.jface.preference.FieldEditor;
import org.eclipse.jface.preference.FieldEditorPreferencePage;
import org.eclipse.jface.preference.RadioGroupFieldEditor;
import org.eclipse.jface.text.TextViewer;
import org.eclipse.jface.text.source.IVerticalRuler;
import org.eclipse.jface.text.source.SourceViewer;
import org.eclipse.jface.text.source.VerticalRuler;
import org.eclipse.jface.util.PropertyChangeEvent;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.events.ShellAdapter;
import org.eclipse.swt.events.ShellEvent;
import org.eclipse.swt.events.ShellListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPreferencePage;
import org.mule.tooling.ui.modules.core.ModulesActivator;
import org.mule.tooling.ui.widgets.util.WidgetUtils;

public class EditorsPreferencePage
extends FieldEditorPreferencePage
implements IWorkbenchPreferencePage {
    public static final String TEXT_FIELD_EDITOR_LINES_HEIGHT = "text.field.editor.lines.height";
    private Color shellDarkerBackgroundColor;
    private int textEditorsCurrentHeight;

    public EditorsPreferencePage() {
        super(1);
    }

    public void propertyChange(PropertyChangeEvent event) {
        super.propertyChange(event);
        if (event.getSource() instanceof RadioGroupFieldEditor && ((RadioGroupFieldEditor)event.getSource()).getPreferenceName().equals(TEXT_FIELD_EDITOR_LINES_HEIGHT)) {
            String newValue = (String)event.getNewValue();
            this.textEditorsCurrentHeight = Integer.parseInt(newValue);
        }
    }

    public void init(IWorkbench workbench) {
        this.setPreferenceStore(ModulesActivator.getDefault().getPreferenceStore());
        this.textEditorsCurrentHeight = this.getPreferenceStore().getInt(TEXT_FIELD_EDITOR_LINES_HEIGHT);
        this.setDescription("Editors preferences");
    }

    protected void performDefaults() {
        super.performDefaults();
        this.textEditorsCurrentHeight = this.getPreferenceStore().getDefaultInt(TEXT_FIELD_EDITOR_LINES_HEIGHT);
    }

    protected void createFieldEditors() {
        Group configurationGroup = new Group(this.getFieldEditorParent(), 32);
        configurationGroup.setText("Text Editors Settings");
        GridDataFactory.fillDefaults().grab(true, false).applyTo((Control)configurationGroup);
        GridLayoutFactory.swtDefaults().applyTo((Composite)configurationGroup);
        RadioGroupFieldEditor selectTextAreaSize = new RadioGroupFieldEditor(TEXT_FIELD_EDITOR_LINES_HEIGHT, "Editor Area Size", 3, (String[][])new String[][]{{"Small", "5"}, {"Medium", "10"}, {"Large", "15"}}, (Composite)configurationGroup);
        selectTextAreaSize.setPreferenceStore(this.getPreferenceStore());
        this.addField((FieldEditor)selectTextAreaSize);
        final Button previewButton = new Button((Composite)configurationGroup, 0);
        previewButton.setText("Preview");
        previewButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                EditorsPreferencePage.this.createShellWithSourceViewer((Control)previewButton);
            }
        });
    }

    private void createShellWithSourceViewer(Control control) {
        final Shell shell = new Shell(this.getShell(), 12);
        shell.setLayout((Layout)new GridLayout());
        GridLayoutFactory.fillDefaults().applyTo((Composite)shell);
        int width = 350;
        int height = WidgetUtils.getLinesHeightInPixels((Control)shell, (int)this.textEditorsCurrentHeight) + 10;
        shell.setSize(width, height);
        shell.setLocation(this.findLocation(control, height));
        Composite owner = new Composite((Composite)shell, 0);
        GridDataFactory.fillDefaults().grab(true, true).minSize(width, height).applyTo((Control)owner);
        GridLayoutFactory.fillDefaults().margins(5, 5).applyTo(owner);
        if (!this.colorExists(this.shellDarkerBackgroundColor)) {
            this.shellDarkerBackgroundColor = this.getShellDarkerBackgroundColor(shell);
        }
        owner.setBackground(this.shellDarkerBackgroundColor);
        SourceViewer sourceViewer = new SourceViewer(owner, (IVerticalRuler)new VerticalRuler(0), 768);
        sourceViewer.getTextWidget().setAlwaysShowScrollBars(false);
        WidgetUtils.addUndoAndRedoCapability((TextViewer)sourceViewer);
        GridDataFactory.fillDefaults().grab(true, true).applyTo(sourceViewer.getControl());
        shell.open();
        shell.addShellListener((ShellListener)new ShellAdapter(){

            public void shellClosed(ShellEvent e) {
                super.shellClosed(e);
                if (!shell.isDisposed()) {
                    shell.dispose();
                }
            }

            public void shellDeactivated(ShellEvent e) {
                super.shellDeactivated(e);
                if (!shell.isDisposed()) {
                    shell.dispose();
                }
            }
        });
    }

    private Color getShellDarkerBackgroundColor(Shell shell) {
        Color shellBackgroundColor = shell.getBackground();
        float[] hsb = java.awt.Color.RGBtoHSB(shellBackgroundColor.getRed(), shellBackgroundColor.getGreen(), shellBackgroundColor.getBlue(), null);
        hsb[2] = (float)((double)hsb[2] - (double)hsb[2] * 0.05);
        java.awt.Color color = java.awt.Color.getHSBColor(hsb[0], hsb[1], hsb[2]);
        return new Color((Device)Display.getDefault(), color.getRed(), color.getGreen(), color.getBlue());
    }

    private boolean colorExists(Color color) {
        return color != null && !color.isDisposed();
    }

    private Point findLocation(Control control, int shellHeight) {
        Point location = this.getControlLocation(control);
        Rectangle bounds = control.getBounds();
        return new Point(location.x, location.y + bounds.height);
    }

    private Point getControlLocation(Control control) {
        return control.getParent().toDisplay(control.getLocation());
    }

    public void dispose() {
        super.dispose();
        if (this.colorExists(this.shellDarkerBackgroundColor)) {
            this.shellDarkerBackgroundColor.dispose();
        }
    }
}

