/*
 * Decompiled with CFR 0.152.
 */
package org.mule.tooling.ui.modules.core.widgets.editors.options;

import java.util.HashSet;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.function.Function;
import java.util.function.Supplier;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.IJobChangeEvent;
import org.eclipse.core.runtime.jobs.IJobChangeListener;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.core.runtime.jobs.JobChangeAdapter;
import org.mule.tooling.client.ToolingValueProviderErrorNotification;
import org.mule.tooling.client.ValueProviderExecutor;
import org.mule.tooling.client.api.ServiceResponse;
import org.mule.tooling.client.api.ServiceResponseFactory;
import org.mule.tooling.client.api.value.Value;
import org.mule.tooling.client.startup.ToolingManager;
import org.mule.tooling.core.MuleCorePlugin;
import org.mule.tooling.core.ToolingJobsManager;
import org.mule.tooling.core.model.IMuleProject;
import org.mule.tooling.model.messageflow.IMessageFlowNode;
import org.mule.tooling.model.messageflow.MuleConfiguration;
import org.mule.tooling.model.messageflow.decorator.PropertyCollectionMap;
import org.mule.tooling.model.messageflow.path.MulePath;
import org.mule.tooling.runtime.tooling.ToolingWorkspace;
import org.mule.tooling.ui.modules.core.widgets.editors.options.CompletionEvent;
import org.mule.tooling.ui.modules.core.widgets.editors.options.ValueProviderCache;
import org.mule.tooling.ui.modules.core.widgets.editors.options.ValueProviderKey;
import org.mule.tooling.ui.preferences.MuleStudioPreference;
import org.mule.tooling.utils.eventbus.IEvent;

public class ValuesRetrievalManager {
    private static final String ON_EXCEPTION_ERROR_MESSAGE = "Error while resolving values";
    private final Set<ValueProviderKey> activeRequestsKeys = new HashSet<ValueProviderKey>();

    public static ValuesRetrievalManager getInstance() {
        return ValuesRetrievalManagerHolder.INSTANCE;
    }

    private ValuesRetrievalManager() {
    }

    public void queue(ValuesProviderRequest request) {
        if (!this.activeRequestsKeys.contains(request.getKey())) {
            CompletableFuture.runAsync(() -> {
                this.activeRequestsKeys.add(request.getKey());
                this.dispatchJob(request);
            }).thenRun(() -> {
                boolean bl = this.activeRequestsKeys.remove(request.getKey());
            });
        }
    }

    public CompletableFuture<ServiceResponse<?>> resolve(ValuesProviderRequest request) {
        return CompletableFuture.supplyAsync(() -> this.doResolve(request));
    }

    private void dispatchJob(ValuesProviderRequest request) {
        ValuesResolverJob valueResolverOperation = new ValuesResolverJob(request);
        try {
            valueResolverOperation.setJobGroup(ToolingJobsManager.getToolingJobGroup());
            valueResolverOperation.addJobChangeListener((IJobChangeListener)new ValueResolverJobListener(valueResolverOperation));
            valueResolverOperation.setPriority(20);
            valueResolverOperation.schedule();
            valueResolverOperation.join();
        }
        catch (InterruptedException e) {
            MuleCorePlugin.logError((String)ON_EXCEPTION_ERROR_MESSAGE, (Throwable)e);
        }
    }

    private ServiceResponse<?> doResolve(ValuesProviderRequest request) {
        ValuesResolverJob propagation = new ValuesResolverJob(request);
        try {
            propagation.setPriority(20);
            propagation.schedule();
            propagation.join();
        }
        catch (InterruptedException e) {
            MuleCorePlugin.logError((String)ON_EXCEPTION_ERROR_MESSAGE, (Throwable)e);
        }
        return propagation.getResponse();
    }

    private static class ValueResolverJobListener
    extends JobChangeAdapter {
        private final ValuesResolverJob valuesResolverJob;

        public ValueResolverJobListener(ValuesResolverJob valuesResolverJob) {
            this.valuesResolverJob = valuesResolverJob;
        }

        public void done(IJobChangeEvent event) {
            ServiceResponse<Set<Value>> response = this.valuesResolverJob.getResponse();
            if (response.isSuccess()) {
                Set set = (Set)response.getResult();
                if (!set.isEmpty()) {
                    ValueProviderKey key = this.valuesResolverJob.getRequest().getKey();
                    ValueProviderCache.getInstance().put(key, set);
                    MuleCorePlugin.getEventBus().fireEvent((IEvent)new CompletionEvent(key.getProviderName()));
                }
            } else {
                ValueProviderKey key = this.valuesResolverJob.getRequest().getKey();
                MuleCorePlugin.getEventBus().fireEvent((IEvent)new CompletionEvent(key.getProviderName(), new ToolingValueProviderErrorNotification(response.getMessage(), response.getStackTrace(), "")));
            }
        }
    }

    public static final class ValuesProviderRequest {
        private final IMuleProject project;
        private final MuleConfiguration muleConfiguration;
        private final ValueProviderKey key;
        private final IMessageFlowNode node;
        private final Supplier<IMessageFlowNode> newMessageFlowNodeSupplier;
        private final Function<IMessageFlowNode, PropertyCollectionMap> updatedPropertiesProvider;
        private final String providerName;
        private final MulePath path;

        public ValuesProviderRequest(IMuleProject project, MuleConfiguration muleConfiguration, ValueProviderKey key, IMessageFlowNode currentNode, String providerName, MulePath path, Supplier<IMessageFlowNode> newMessageFlowNodeSupplier, Function<IMessageFlowNode, PropertyCollectionMap> updatedPropertiesProvider) {
            this.project = project;
            this.muleConfiguration = muleConfiguration;
            this.key = key;
            this.node = currentNode;
            this.providerName = providerName;
            this.path = path;
            this.newMessageFlowNodeSupplier = newMessageFlowNodeSupplier;
            this.updatedPropertiesProvider = updatedPropertiesProvider;
        }

        public IMuleProject getProject() {
            return this.project;
        }

        public MuleConfiguration getMuleConfiguration() {
            return this.muleConfiguration;
        }

        public IMessageFlowNode getNode() {
            return this.node;
        }

        public String getProviderName() {
            return this.providerName;
        }

        public ValueProviderKey getKey() {
            return this.key;
        }

        public Supplier<IMessageFlowNode> getNewMessageFlowNodeSupplier() {
            return this.newMessageFlowNodeSupplier;
        }

        public Function<IMessageFlowNode, PropertyCollectionMap> getUpdatedPropertiesProvider() {
            return this.updatedPropertiesProvider;
        }

        public MulePath getPath() {
            return this.path;
        }
    }

    private static final class ValuesResolverJob
    extends Job {
        private static final String VALUES_RESOLVER_JOB = "Resolving values...";
        private final ValuesProviderRequest request;
        private ServiceResponse<Set<Value>> response;

        public ValuesResolverJob(ValuesProviderRequest request) {
            super(VALUES_RESOLVER_JOB);
            this.request = request;
        }

        protected IStatus run(IProgressMonitor monitor) {
            IMuleProject project = this.getRequest().getProject();
            MuleConfiguration muleConfiguration = this.getRequest().getMuleConfiguration();
            if (this.isStaleConfig(muleConfiguration, project)) {
                return Status.CANCEL_STATUS;
            }
            try {
                ValueProviderExecutor executor = ((ValueProviderExecutor.ValueProviderExecutorBuilder)((ValueProviderExecutor.ValueProviderExecutorBuilder)((ValueProviderExecutor.ValueProviderExecutorBuilder)((ValueProviderExecutor.ValueProviderExecutorBuilder)((ValueProviderExecutor.ValueProviderExecutorBuilder)((ValueProviderExecutor.ValueProviderExecutorBuilder)((ValueProviderExecutor.ValueProviderExecutorBuilder)((ValueProviderExecutor.ValueProviderExecutorBuilder)new ValueProviderExecutor.ValueProviderExecutorBuilder().toolingWorkspace(ToolingWorkspace.getInstance())).muleInstance(ToolingManager.getInstance().getToolingInstance())).project(this.request.getProject())).muleConfiguration(muleConfiguration)).generalErrorMessage(ValuesRetrievalManager.ON_EXCEPTION_ERROR_MESSAGE)).messageFlowNode(this.request.getNode())).newMessageFlowNodeSupplier(this.request.getNewMessageFlowNodeSupplier())).updatedPropertiesProvider(this.request.getUpdatedPropertiesProvider())).timeOutInMilliseconds(this.getTimeoutInMilliseconds()).providerName(this.request.getProviderName()).componentLocation(this.request.getPath().toString()).build();
                this.response = executor.runServiceRequest();
            }
            catch (Exception e) {
                MuleCorePlugin.logError((String)ValuesRetrievalManager.ON_EXCEPTION_ERROR_MESSAGE, (Throwable)e);
                this.setErrorResponse(e);
                return Status.CANCEL_STATUS;
            }
            return Status.OK_STATUS;
        }

        private boolean isStaleConfig(MuleConfiguration muleConfiguration, IMuleProject project) {
            return !muleConfiguration.belongsTo(project);
        }

        private int getTimeoutInMilliseconds() {
            return MuleStudioPreference.getDatasenseTimeoutInSeconds() * 1000;
        }

        private void setErrorResponse(Exception e) {
            MuleCorePlugin.logError((String)ValuesRetrievalManager.ON_EXCEPTION_ERROR_MESSAGE, (Throwable)e);
            this.response = ServiceResponseFactory.failure((Exception)e);
        }

        public ServiceResponse<Set<Value>> getResponse() {
            return this.response;
        }

        public ValuesProviderRequest getRequest() {
            return this.request;
        }
    }

    private static class ValuesRetrievalManagerHolder {
        private static ValuesRetrievalManager INSTANCE = new ValuesRetrievalManager();

        private ValuesRetrievalManagerHolder() {
        }
    }
}

