/*
 * Decompiled with CFR 0.152.
 */
package org.mule.tooling.ui.modules.core.widgets.editors.options;

import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.function.Function;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.mule.tooling.client.api.value.Value;
import org.mule.tooling.core.MuleCorePlugin;
import org.mule.tooling.core.model.IMuleProject;
import org.mule.tooling.core.utils.CoreUtils;
import org.mule.tooling.editor.model.element.Stereotype;
import org.mule.tooling.messageflow.editor.MessageFlowEditor;
import org.mule.tooling.messageflow.util.MessageFlowUtils;
import org.mule.tooling.model.messageflow.IMessageFlowEntity;
import org.mule.tooling.model.messageflow.IMessageFlowNode;
import org.mule.tooling.model.messageflow.MessageFlowEntity;
import org.mule.tooling.model.messageflow.MuleConfiguration;
import org.mule.tooling.model.messageflow.Property;
import org.mule.tooling.model.messageflow.PropertyCollection;
import org.mule.tooling.model.messageflow.decorator.PropertyCollectionMap;
import org.mule.tooling.model.messageflow.path.MulePath;
import org.mule.tooling.model.messageflow.util.PropertiesUtils;
import org.mule.tooling.model.module.NestedDefinition;
import org.mule.tooling.ui.modules.core.widgets.AttributesPropertyPage;
import org.mule.tooling.ui.modules.core.widgets.IFieldEditor;
import org.mule.tooling.ui.modules.core.widgets.editors.AbstractFieldEditor;
import org.mule.tooling.ui.modules.core.widgets.editors.options.ValueProviderKey;
import org.mule.tooling.ui.modules.core.widgets.editors.options.ValuesRetrievalManager;
import org.mule.tooling.ui.modules.core.widgets.meta.EnumHelper;
import org.mule.tooling.ui.modules.core.widgets.meta.EnumOption;

public class ValueProviderUtils {
    private static final String CONNECTION_COMPONENT_PATH = "connection";
    private static final String TYPE_STEREOTYPE = "CONNECTION";
    private static final String NAMESPACE_STEREOTYPE = "MULE";
    private static final Stereotype CONNECTION_STEREOTYPE = new Stereotype("MULE", "CONNECTION");

    public static boolean areAllPrerequisitedFieldsConfigured(IFieldEditor editor, PropertyCollection properties) {
        boolean areAllRequiredFieldsConfigured = true;
        if (editor.getHelper().getPrerequisites().isPresent()) {
            List prerequisites = (List)editor.getHelper().getPrerequisites().get();
            for (String requiredProperty : prerequisites) {
                if (!ValueProviderUtils.attributeAndChildAreNotInCollection(requiredProperty, properties) || ValueProviderUtils.propertyIsPresentAtAnyChildPropertyCollection(properties, requiredProperty)) continue;
                areAllRequiredFieldsConfigured = false;
                break;
            }
        }
        return areAllRequiredFieldsConfigured;
    }

    private static boolean propertyIsPresentAtAnyChildPropertyCollection(PropertyCollection properties, String requiredProperty) {
        return properties.getPropertyCollections().stream().filter(prop -> prop.getProperty(requiredProperty) != null && StringUtils.isNotEmpty((CharSequence)prop.getProperty(requiredProperty).getValue())).findFirst().isPresent();
    }

    private static boolean attributeAndChildAreNotInCollection(String requiredProperty, PropertyCollection properties) {
        Property property = properties.getProperty(requiredProperty);
        return (property == null || StringUtils.isEmpty((CharSequence)property.getValue())) && properties.getPropertyCollection(requiredProperty) == null;
    }

    public static ValueProviderKey createValueProviderRequestKey(IFieldEditor editor, IMessageFlowNode node, PropertyCollection properties, EnumHelper enumHelper) {
        ValueProviderKey.ValueProviderKeyBuilder valueKeyBuilder = ValueProviderKey.builder(enumHelper.getProviderName()).withElementId(node.getType());
        for (String prerequisite : (List)editor.getHelper().getPrerequisites().get()) {
            Property property = properties.getProperty(prerequisite);
            if (property != null) {
                valueKeyBuilder.withParameter(prerequisite, property.getValue());
                continue;
            }
            Optional<Property> findFirst = properties.getPropertyCollections().stream().flatMap(x -> x.getProperties().stream()).filter(prop -> prop.getName().equals(prerequisite)).findFirst();
            if (!findFirst.isPresent()) continue;
            property = findFirst.get();
            valueKeyBuilder.withParameter(prerequisite, property.getValue());
        }
        if (ValueProviderUtils.isConnectionParameter(editor, properties)) {
            valueKeyBuilder.withElementId(node.getType() + "/connection");
        }
        ValueProviderKey key = valueKeyBuilder.build();
        return key;
    }

    public static List<EnumOption> generateEnumOptionsList(PropertyCollection properties, EnumHelper enumHelper, Set<Value> values) {
        if (enumHelper.getKeyParts().isEmpty()) {
            return ValueProviderUtils.toEnumList(values);
        }
        return ValueProviderUtils.getEntriesFor(enumHelper, properties, values);
    }

    private static List<EnumOption> toEnumList(Set<Value> values) {
        return values.stream().map(value -> new EnumOption(value.getId(), value.getDisplayName())).collect(Collectors.toList());
    }

    private static List<EnumOption> getEntriesFor(EnumHelper enumHelper, PropertyCollection properties, Set<Value> values) {
        LinkedHashMap<String, String> configuredValues = new LinkedHashMap<String, String>();
        for (String keyPart : enumHelper.getKeyParts()) {
            Property property = properties.getProperty(keyPart);
            if (property == null) {
                Optional<Property> findFirst = properties.getPropertyCollections().stream().flatMap(x -> x.getProperties().stream()).filter(prop -> prop.getName().equals(keyPart)).findFirst();
                if (findFirst.isPresent()) {
                    property = findFirst.get();
                } else {
                    return Collections.emptyList();
                }
            }
            configuredValues.put(keyPart, property.getValue());
        }
        if (enumHelper.getKeyParts().size() != configuredValues.size()) {
            return Collections.emptyList();
        }
        Set<Value> returnValues = ValueProviderUtils.locatedMatchingSetOfValues(configuredValues, values);
        return ValueProviderUtils.toEnumList(returnValues);
    }

    private static Set<Value> locatedMatchingSetOfValues(Map<String, String> configuredValues, Set<Value> values) {
        Set currentLevel = values;
        Set<Object> returnValues = Collections.emptySet();
        int matchedLevels = 0;
        block0: for (String key : configuredValues.keySet()) {
            String value = configuredValues.get(key);
            for (Value entry : currentLevel) {
                if (!entry.getId().equals(value)) continue;
                ++matchedLevels;
                currentLevel = entry.getChilds();
                continue block0;
            }
        }
        if (matchedLevels == configuredValues.size()) {
            returnValues = currentLevel;
        }
        return returnValues;
    }

    public static void dispatchValueProviderRequest(IFieldEditor editor, IMessageFlowNode node, Supplier<IMessageFlowNode> generateNodeToTestSupplier, IMessageFlowNode updatedCurrentNode, Function<IMessageFlowNode, PropertyCollectionMap> updatedPropertiesProvider, PropertyCollection properties, ValueProviderKey key) {
        MessageFlowEditor flowEditorFromActivePage = MessageFlowUtils.getFlowEditorFromActivePage();
        if (flowEditorFromActivePage != null) {
            try {
                AttributesPropertyPage attributesPropertyPage = editor.getParentPage();
                if (attributesPropertyPage != null) {
                    IMuleProject muleProject = flowEditorFromActivePage.getMuleProject();
                    MuleConfiguration muleConfiguration = flowEditorFromActivePage.getMuleConfiguration();
                    Optional<MulePath> nodePath = ValueProviderUtils.getNodePath(editor, node, updatedCurrentNode, properties, muleConfiguration);
                    if (nodePath.isPresent()) {
                        ValuesRetrievalManager.ValuesProviderRequest request = new ValuesRetrievalManager.ValuesProviderRequest(muleProject, muleConfiguration, key, node, ((EnumHelper)editor.getHelper()).getProviderName(), nodePath.get(), generateNodeToTestSupplier, updatedPropertiesProvider);
                        ValuesRetrievalManager.getInstance().queue(request);
                    }
                }
            }
            catch (Exception e) {
                MuleCorePlugin.logError((String)"Error getting values for editor...", (Throwable)e);
            }
        }
    }

    private static Optional<MulePath> getNodePath(IFieldEditor editor, IMessageFlowNode node, IMessageFlowNode updatedCurrentNode, PropertyCollection properties, MuleConfiguration muleConfiguration) {
        MulePath nodePath = muleConfiguration.getPathFor((IMessageFlowEntity)((MessageFlowEntity)updatedCurrentNode));
        MulePath originalPath = muleConfiguration.getPathFor((IMessageFlowEntity)((MessageFlowEntity)node));
        if (originalPath != null) {
            nodePath = originalPath;
        } else if (CoreUtils.isGlobal((IMessageFlowNode)node)) {
            nodePath = MulePath.fromPath((String)CoreUtils.getNameProperty((IMessageFlowNode)updatedCurrentNode));
        }
        if (ValueProviderUtils.isConnectionParameter(editor, properties)) {
            nodePath = nodePath.createChild(CONNECTION_COMPONENT_PATH);
        }
        return Optional.ofNullable(nodePath);
    }

    private static boolean isConnectionParameter(IFieldEditor editor, PropertyCollection properties) {
        if (editor instanceof AbstractFieldEditor) {
            if (ValueProviderUtils.isConnectionParameter0((AbstractFieldEditor)editor, properties)) {
                return true;
            }
            for (PropertyCollection propertyCollection : properties.getPropertyCollections()) {
                if (!ValueProviderUtils.isConnectionParameter(editor, propertyCollection)) continue;
                return true;
            }
            return false;
        }
        return false;
    }

    private static boolean isConnectionParameter0(AbstractFieldEditor editor, PropertyCollection properties) {
        NestedDefinition nodeDefinition;
        String defId;
        String propertyCollectionKey = properties.getName();
        String string = defId = propertyCollectionKey != null ? PropertiesUtils.getNodeDefinitionId((String)propertyCollectionKey) : null;
        if (defId != null && (nodeDefinition = MuleCorePlugin.getModuleManager().getNestedDefinition(defId)) != null && ValueProviderUtils.hasAConnectionStereoType(nodeDefinition.getStereotype())) {
            return ValueProviderUtils.checkExistency(editor, properties);
        }
        return false;
    }

    private static boolean hasAConnectionStereoType(Stereotype stereotype) {
        if (CONNECTION_STEREOTYPE.equals((Object)stereotype)) {
            return true;
        }
        Stereotype parent = stereotype.getParent();
        if (parent != null) {
            return ValueProviderUtils.hasAConnectionStereoType(parent);
        }
        return false;
    }

    private static boolean checkExistency(AbstractFieldEditor editor, PropertyCollection properties) {
        if (properties.getProperty(editor.getHelper().getId()) != null) {
            return true;
        }
        for (PropertyCollection propertyCollection : properties.getPropertyCollections()) {
            if (!ValueProviderUtils.checkExistency(editor, propertyCollection)) continue;
            return true;
        }
        return false;
    }
}

