/*
 * Decompiled with CFR 0.152.
 */
package org.mule.tooling.ui.modules.core.widgets.editors.options;

import com.google.common.collect.ImmutableMap;
import java.util.LinkedHashMap;
import java.util.Map;

public class ValueProviderKey {
    private final String elementId;
    private final String providerName;
    private final Map<String, String> parameterValues;

    private ValueProviderKey(String elementId, String providerName, Map<String, String> parameterValues) {
        this.elementId = elementId;
        this.providerName = providerName;
        this.parameterValues = ImmutableMap.copyOf(parameterValues);
    }

    public Map<String, String> getParameterValues() {
        return this.parameterValues;
    }

    public String getProviderName() {
        return this.providerName;
    }

    public String getElementId() {
        return this.elementId;
    }

    public String toString() {
        return "ValueProviderKey [elementId=" + this.elementId + ", providerName=" + this.providerName + ", parameterValues=" + String.valueOf(this.parameterValues) + "]";
    }

    public int hashCode() {
        int result = 1;
        result = 31 * result + (this.elementId == null ? 0 : this.elementId.hashCode());
        result = 31 * result + (this.parameterValues == null ? 0 : this.parameterValues.hashCode());
        result = 31 * result + (this.providerName == null ? 0 : this.providerName.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        ValueProviderKey other = (ValueProviderKey)obj;
        if (this.elementId == null ? other.elementId != null : !this.elementId.equals(other.elementId)) {
            return false;
        }
        if (this.parameterValues == null ? other.parameterValues != null : !this.parameterValues.equals(other.parameterValues)) {
            return false;
        }
        return !(this.providerName == null ? other.providerName != null : !this.providerName.equals(other.providerName));
    }

    public static ValueProviderKeyBuilder builder(String providerName) {
        return new ValueProviderKeyBuilder().withProviderName(providerName);
    }

    public static class ValueProviderKeyBuilder {
        private String providerName;
        private String elementId;
        private Map<String, String> parameters = new LinkedHashMap<String, String>();

        private ValueProviderKeyBuilder() {
        }

        public ValueProviderKeyBuilder withElementId(String elementId) {
            this.elementId = elementId;
            return this;
        }

        public ValueProviderKeyBuilder withProviderName(String providerName) {
            this.providerName = providerName;
            return this;
        }

        public ValueProviderKeyBuilder withParameter(String name, String value) {
            this.parameters.put(name, value);
            return this;
        }

        public ValueProviderKey build() {
            return new ValueProviderKey(this.elementId, this.providerName, this.parameters);
        }
    }
}

