/*
 * Decompiled with CFR 0.152.
 */
package org.mule.tooling.ui.modules.core.widgets.editors.options;

import java.util.List;
import java.util.function.Function;
import java.util.function.Supplier;
import org.mule.tooling.messageflow.module.MessageFlowNodeComposite;
import org.mule.tooling.messageflow.util.MessageFlowUtils;
import org.mule.tooling.model.messageflow.IMessageFlowNode;
import org.mule.tooling.model.messageflow.PropertyCollection;
import org.mule.tooling.model.messageflow.decorator.PropertyCollectionMap;
import org.mule.tooling.ui.modules.core.widgets.AttributesPropertyPage;
import org.mule.tooling.ui.modules.core.widgets.IFieldEditor;
import org.mule.tooling.ui.modules.core.widgets.editors.EditorHelper;
import org.mule.tooling.ui.modules.core.widgets.editors.options.ValueProviderKey;
import org.mule.tooling.ui.modules.core.widgets.editors.options.ValueProviderUtils;
import org.mule.tooling.ui.modules.core.widgets.meta.EnumHelper;
import org.mule.tooling.ui.modules.core.widgets.meta.IDialogAction;

public class RefreshValuesAction
implements IDialogAction {
    @Override
    public void click(IFieldEditor editor, AttributesPropertyPage page) {
        IMessageFlowNode node = page.getMessageFlowNode();
        if (node != null) {
            List<MessageFlowNodeComposite> pages = EditorHelper.getAllCurrentEditorPages(editor);
            Supplier generateNodeToTestSupplier = MessageFlowUtils.generateNodeToTestSupplier((IMessageFlowNode)node);
            IMessageFlowNode updatedCurrentNode = (IMessageFlowNode)generateNodeToTestSupplier.get();
            Function updatedPropertiesProvider = MessageFlowUtils.updatedPropertiesProvider(pages);
            PropertyCollection properties = ((PropertyCollectionMap)updatedPropertiesProvider.apply(updatedCurrentNode)).asPropertyCollection();
            updatedCurrentNode.setProperties(properties);
            EnumHelper enumHelper = (EnumHelper)editor.getHelper();
            boolean areAllRequiredFieldsConfigured = ValueProviderUtils.areAllPrerequisitedFieldsConfigured(editor, properties);
            if (areAllRequiredFieldsConfigured) {
                ValueProviderKey key = ValueProviderUtils.createValueProviderRequestKey(editor, node, properties, enumHelper);
                ValueProviderUtils.dispatchValueProviderRequest(editor, node, generateNodeToTestSupplier, updatedCurrentNode, updatedPropertiesProvider, properties, key);
            }
        }
    }
}

