/*
 * Decompiled with CFR 0.152.
 */
package org.mule.tooling.ui.modules.core.widgets.editors.options;

import java.util.Optional;
import org.mule.tooling.client.ToolingValueProviderErrorNotification;
import org.mule.tooling.ui.modules.core.widgets.editors.options.ValueProviderEventHandler;
import org.mule.tooling.ui.modules.core.widgets.editors.options.ValueProviderEventTypes;
import org.mule.tooling.utils.eventbus.EventType;
import org.mule.tooling.utils.eventbus.IEvent;

public final class CompletionEvent
implements IEvent<ValueProviderEventHandler> {
    private final String editorId;
    private final Optional<ToolingValueProviderErrorNotification> error;

    public CompletionEvent(String editorId) {
        this.editorId = editorId;
        this.error = Optional.empty();
    }

    public CompletionEvent(String editorId, ToolingValueProviderErrorNotification error) {
        this.editorId = editorId;
        this.error = Optional.of(error);
    }

    public EventType<ValueProviderEventHandler> getAssociatedType() {
        return ValueProviderEventTypes.VALUE_PROVIDER_EVENT;
    }

    public void dispatch(ValueProviderEventHandler handler) {
        if (this.error.isPresent()) {
            handler.onError(this.editorId, this.error.get());
        } else {
            handler.onSuccess(this.editorId);
        }
    }
}

