/*
 * Decompiled with CFR 0.152.
 */
package org.mule.tooling.ui.modules.core.widgets.editors.mimetype;

import java.util.Optional;
import org.apache.commons.lang.StringUtils;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.ToolBarManager;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.jface.layout.GridLayoutFactory;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.ToolBar;
import org.eclipse.ui.PlatformUI;
import org.mule.tooling.model.messageflow.IMessageFlowNode;
import org.mule.tooling.model.messageflow.decorator.PropertyCollectionMap;
import org.mule.tooling.ui.modules.core.widgets.AttributeContext;
import org.mule.tooling.ui.modules.core.widgets.editors.mimetype.IParameterRemovedListener;
import org.mule.tooling.ui.modules.core.widgets.editors.mimetype.KeyValueParameter;
import org.mule.tooling.ui.modules.core.widgets.editors.mimetype.MimeTypeEvents;
import org.mule.tooling.utils.eventbus.EventBus;
import org.mule.tooling.utils.eventbus.EventType;
import org.mule.tooling.utils.eventbus.IEvent;
import org.mule.tooling.weave.engine.WeaveModule;

public class ParameterComposite {
    private final EventBus eventBus;
    private final Composite parametersListGroup;
    private Composite wrapper;
    private Composite contentWrapper;
    private KeyValueParameter content;
    private ToolBar toolbar;
    private final AttributeContext attributeContext;
    private final IMessageFlowNode node;

    public ParameterComposite(Composite parent, EventBus eventBus, IMessageFlowNode messageFlowNode, AttributeContext attributeContext) {
        this.parametersListGroup = parent;
        this.eventBus = eventBus;
        this.node = messageFlowNode;
        this.attributeContext = attributeContext;
        this.createControls();
    }

    private void createControls() {
        this.wrapper = new Composite(this.parametersListGroup, 0);
        GridLayoutFactory.fillDefaults().numColumns(3).applyTo(this.wrapper);
        GridDataFactory.fillDefaults().grab(true, false).applyTo((Control)this.wrapper);
        if (this.toolbar != null) {
            this.toolbar.dispose();
        }
        if (this.contentWrapper != null) {
            this.contentWrapper.dispose();
            this.content = null;
        }
        this.contentWrapper = this.createParameterWrapper(this.wrapper);
        this.content = new KeyValueParameter();
        this.content.createControls(this.contentWrapper, this.node, this.attributeContext, this.eventBus);
        this.toolbar = this.createParameterToolbar(this.wrapper);
    }

    private ToolBar createParameterToolbar(Composite wrapper) {
        ToolBar toolbar = new ToolBar(wrapper, 4);
        ToolBarManager parametersToolbarManager = new ToolBarManager(toolbar);
        parametersToolbarManager.add((IAction)new RemoveParameterAction());
        parametersToolbarManager.update(true);
        return toolbar;
    }

    private Composite createParameterWrapper(Composite parent) {
        Composite wrapper = new Composite(parent, 0);
        GridLayoutFactory.fillDefaults().applyTo(wrapper);
        GridDataFactory.fillDefaults().grab(true, false).applyTo((Control)wrapper);
        return wrapper;
    }

    public void loadFrom(String parameterStoredId, PropertyCollectionMap propertyCollectionMap) {
        if (StringUtils.isBlank((String)parameterStoredId)) {
            return;
        }
    }

    public IStatus validate() {
        return Status.OK_STATUS;
    }

    public Composite getControl() {
        return this.wrapper;
    }

    private void notifyParameterRemoved() {
        this.eventBus.fireEvent((IEvent)new IEvent<IParameterRemovedListener>(){

            public EventType<IParameterRemovedListener> getAssociatedType() {
                return MimeTypeEvents.ON_PARAMETER_REMOVED;
            }

            public void dispatch(IParameterRemovedListener handler) {
                handler.onParameterRemoved(ParameterComposite.this);
            }
        });
    }

    public void setKey(String key) {
        this.content.setKey(key);
    }

    public void setValue(String value) {
        this.content.setValue(value);
    }

    public void setModule(Optional<WeaveModule> module) {
        this.content.setModule(module);
    }

    public String getKey() {
        return this.content.getKey();
    }

    public String getValue() {
        return this.content.getValue();
    }

    private class RemoveParameterAction
    extends Action {
        public RemoveParameterAction() {
            super("Remove Parameter");
            this.setImageDescriptor(PlatformUI.getWorkbench().getSharedImages().getImageDescriptor("IMG_ELCL_REMOVE"));
        }

        public void run() {
            ParameterComposite.this.wrapper.dispose();
            ParameterComposite.this.parametersListGroup.layout();
            ParameterComposite.this.notifyParameterRemoved();
        }
    }
}

