/*
 * Decompiled with CFR 0.152.
 */
package org.mule.tooling.ui.modules.core.widgets.editors.mimetype;

import jakarta.activation.MimeType;
import jakarta.activation.MimeTypeParseException;
import java.util.List;
import org.apache.commons.lang.StringUtils;
import org.mule.tooling.core.utils.ExpressionUtils;
import org.mule.tooling.ui.modules.core.widgets.editors.mimetype.ParameterComposite;

public class MimeTypeHelper {
    public static String getValueWithParameters(String value, List<ParameterComposite> parameters) {
        String result;
        StringBuilder emptyValue = new StringBuilder();
        String baseType = value;
        try {
            MimeType mimeType = new MimeType(baseType);
            MimeTypeHelper.processMimeTypeParameters(parameters, mimeType, emptyValue);
            result = mimeType.toString() + emptyValue.toString();
        }
        catch (MimeTypeParseException mimeTypeParseException) {
            MimeType defaultMimeType = new MimeType();
            emptyValue.setLength(0);
            MimeTypeHelper.processMimeTypeParameters(parameters, defaultMimeType, emptyValue);
            result = baseType + defaultMimeType.getParameters().toString() + emptyValue.toString();
        }
        return result;
    }

    private static void processMimeTypeParameters(List<ParameterComposite> parameters, MimeType mimeType, StringBuilder paramsWithPropPlaceholderOrEmpty) {
        for (ParameterComposite parameterComposite : parameters) {
            String key = parameterComposite.getKey();
            if (!StringUtils.isNotBlank((String)key)) continue;
            String value = parameterComposite.getValue();
            if (MimeTypeHelper.isBlankOrHasPropPlaceholder(value)) {
                paramsWithPropPlaceholderOrEmpty.append(MimeTypeHelper.mimeTypeParametersAsString(key, value));
                continue;
            }
            mimeType.setParameter(key, value);
        }
    }

    private static boolean isBlankOrHasPropPlaceholder(String value) {
        return StringUtils.isBlank((String)value) || ExpressionUtils.hasPropertyPlaceholder((String)value);
    }

    private static String mimeTypeParametersAsString(String key, String value) {
        StringBuilder parametersBuilder = new StringBuilder();
        parametersBuilder.append(";");
        parametersBuilder.append(key);
        parametersBuilder.append("=");
        parametersBuilder.append(MimeTypeHelper.quote(value));
        return parametersBuilder.toString();
    }

    private static String quote(String string) {
        return "\"" + string + "\"";
    }
}

