/*
 * Decompiled with CFR 0.152.
 */
package org.mule.tooling.ui.modules.core.widgets.editors.mimetype;

import java.util.Collections;
import java.util.Map;
import java.util.Optional;
import org.apache.commons.lang.StringUtils;
import org.eclipse.jface.fieldassist.ControlDecoration;
import org.eclipse.jface.fieldassist.FieldDecorationRegistry;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.jface.layout.GridLayoutFactory;
import org.eclipse.jface.viewers.ArrayContentProvider;
import org.eclipse.jface.viewers.ComboViewer;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.mule.tooling.model.messageflow.IMessageFlowNode;
import org.mule.tooling.ui.modules.core.widgets.AttributeContext;
import org.mule.tooling.ui.modules.core.widgets.editors.mimetype.ParametersHelper;
import org.mule.tooling.utils.eventbus.EventBus;
import org.mule.tooling.weave.engine.ModuleOption;
import org.mule.tooling.weave.engine.WeaveModule;

public class KeyValueParameter {
    private ComboViewer keyText;
    private ComboViewer valueText;
    private ControlDecoration infoDecoration;
    private Optional<WeaveModule> module = Optional.empty();

    public void createControls(Composite parent, IMessageFlowNode node, AttributeContext context, EventBus eventBus) {
        Composite wrapper = new Composite(parent, 0);
        GridLayoutFactory.fillDefaults().numColumns(2).equalWidth(true).applyTo(wrapper);
        GridDataFactory.fillDefaults().grab(true, true).applyTo((Control)wrapper);
        Composite keyWrapper = new Composite(wrapper, 0);
        GridLayoutFactory.fillDefaults().numColumns(2).applyTo(keyWrapper);
        GridDataFactory.fillDefaults().grab(true, false).applyTo((Control)keyWrapper);
        Label keyLabel = new Label(keyWrapper, 0);
        GridDataFactory.fillDefaults().applyTo((Control)keyLabel);
        keyLabel.setText("Key");
        this.keyText = new ComboViewer(keyWrapper, 0);
        GridDataFactory.fillDefaults().grab(true, false).applyTo(this.keyText.getControl());
        ParametersHelper.addModifyListener(this.keyText.getCombo(), this::onKeyModified);
        this.keyText.setContentProvider((IContentProvider)ArrayContentProvider.getInstance());
        this.keyText.setLabelProvider((IBaseLabelProvider)new LabelProvider(){

            public String getText(Object element) {
                return ((ModuleOption)element).getName();
            }
        });
        this.infoDecoration = new ControlDecoration(this.keyText.getControl(), 132096);
        this.infoDecoration.hide();
        this.infoDecoration.setMarginWidth(1);
        this.infoDecoration.setImage(FieldDecorationRegistry.getDefault().getFieldDecoration("DEC_INFORMATION").getImage());
        this.infoDecoration.setShowHover(true);
        Composite valueWrapper = new Composite(wrapper, 0);
        GridLayoutFactory.fillDefaults().numColumns(2).applyTo(valueWrapper);
        GridDataFactory.fillDefaults().grab(true, false).applyTo((Control)valueWrapper);
        Label valueLabel = new Label(valueWrapper, 0);
        GridDataFactory.fillDefaults().applyTo((Control)valueLabel);
        valueLabel.setText("Value");
        this.valueText = new ComboViewer(valueWrapper, 0);
        GridDataFactory.fillDefaults().grab(true, false).applyTo(this.valueText.getControl());
        this.valueText.setContentProvider((IContentProvider)ArrayContentProvider.getInstance());
    }

    private void onKeyModified(ModifyEvent event) {
        this.onKeyModified();
    }

    private void onKeyModified() {
        String newKey = this.keyText.getCombo().getText();
        Combo valueCombo = this.valueText.getCombo();
        String valueBeforeInputChange = valueCombo.getText();
        if (this.module.isPresent()) {
            ModuleOption moduleOption = this.lookupOption(newKey);
            if (moduleOption != null) {
                String defaultValue;
                this.infoDecoration.setDescriptionText(moduleOption.getDescription());
                this.infoDecoration.show();
                this.valueText.setInput((Object)moduleOption.getPossibleValues());
                String string = defaultValue = moduleOption.getDefaultValue() == null ? "" : moduleOption.getDefaultValue().toString();
                if (StringUtils.isEmpty((String)valueBeforeInputChange) && StringUtils.isNotEmpty((String)defaultValue)) {
                    valueCombo.setText(defaultValue);
                } else {
                    valueCombo.setText(valueBeforeInputChange);
                }
            } else {
                this.resetValueOptions(valueBeforeInputChange);
            }
        } else {
            this.resetValueOptions(valueBeforeInputChange);
        }
    }

    private ModuleOption lookupOption(String newKey) {
        if (this.module.isPresent()) {
            WeaveModule _module = this.module.get();
            Map readerOptions = _module.getReaderOptions();
            ModuleOption moduleOption = this.lookupOption(newKey, readerOptions);
            return moduleOption;
        }
        return null;
    }

    private ModuleOption lookupOption(String newKey, Map<String, ModuleOption> readerOptions) {
        return readerOptions.entrySet().stream().filter(entry -> ((String)entry.getKey()).equalsIgnoreCase(newKey)).findFirst().map(entry -> (ModuleOption)entry.getValue()).orElse(null);
    }

    private void resetValueOptions(String valueBeforeInputChange) {
        this.infoDecoration.setDescriptionText("");
        this.infoDecoration.hide();
        this.valueText.setInput((Object)new Object[0]);
        this.valueText.getCombo().setText(valueBeforeInputChange);
    }

    public void setKey(String key) {
        ModuleOption option = this.lookupOption(key);
        if (option != null) {
            this.keyText.setSelection((ISelection)new StructuredSelection((Object)option));
        } else {
            this.keyText.getCombo().setText(key);
        }
        this.onKeyModified();
    }

    public String getKey() {
        return this.keyText.getCombo().getText();
    }

    public String getValue() {
        return this.valueText.getCombo().getText();
    }

    public void setValue(String value) {
        this.valueText.getCombo().setText(value);
    }

    public void setModule(Optional<WeaveModule> module) {
        this.module = module;
        this.onModuleModified();
    }

    private void onModuleModified() {
        Map moduleOptionMap = this.module.map(_module -> _module.getReaderOptions()).orElse(Collections.emptyMap());
        String key = this.getKey();
        this.keyText.setInput((Object)moduleOptionMap.values().toArray());
        this.setKey(key);
    }
}

