/*
 * Decompiled with CFR 0.152.
 */
package org.mule.tooling.ui.modules.core.widgets.editors.dynamic;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.jface.layout.GridLayoutFactory;
import org.eclipse.jface.viewers.ArrayContentProvider;
import org.eclipse.jface.viewers.ComboViewer;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.StructuredViewer;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.mule.tooling.core.event.LayoutPropertiesEditorRequest;
import org.mule.tooling.messageflow.dialog.IHost;
import org.mule.tooling.model.messageflow.IMessageFlowNode;
import org.mule.tooling.model.messageflow.decorator.PropertyCollectionMap;
import org.mule.tooling.model.module.NodeDefinition;
import org.mule.tooling.ui.modules.core.widgets.AttributeCategoryProvider;
import org.mule.tooling.ui.modules.core.widgets.AttributeContext;
import org.mule.tooling.ui.modules.core.widgets.AttributesPropertyPage;
import org.mule.tooling.ui.modules.core.widgets.FixedAttributeCategoryProvider;
import org.mule.tooling.ui.modules.core.widgets.IFieldEditor;
import org.mule.tooling.ui.modules.core.widgets.IFieldEditorVisitor;
import org.mule.tooling.ui.modules.core.widgets.IPageAwareEditor;
import org.mule.tooling.ui.modules.core.widgets.IRefresheableEditor;
import org.mule.tooling.ui.modules.core.widgets.editors.IComponentModeEditor;
import org.mule.tooling.ui.modules.core.widgets.editors.IValueCalculator;
import org.mule.tooling.ui.modules.core.widgets.editors.LabelledFieldEditor;
import org.mule.tooling.ui.modules.core.widgets.editors.dynamic.DynamicEditorUtils;
import org.mule.tooling.ui.modules.core.widgets.meta.AbstractComponentMeta;
import org.mule.tooling.ui.modules.core.widgets.meta.AttributeCategory;
import org.mule.tooling.ui.modules.core.widgets.meta.AttributeHelper;
import org.mule.tooling.ui.modules.core.widgets.meta.DynamicEditorsAttributeHelper;
import org.mule.tooling.utils.UtilsPlugin;
import org.mule.tooling.utils.eventbus.IEvent;

public class DynamicFieldEditor
extends LabelledFieldEditor
implements IPageAwareEditor,
IComponentModeEditor,
IRefresheableEditor {
    private StructuredViewer comboViewer;
    private boolean inInInit;
    private Composite editorWrapper;
    private Composite wrapper;
    private AttributesPropertyPage innerPage;
    private Composite comboWrapper;
    private final String selectedEditorId;

    public DynamicFieldEditor(AttributeContext ctx, AttributeHelper atr, Composite parent) {
        super(ctx, atr, parent);
        this.selectedEditorId = DynamicEditorUtils.getId(atr.getId());
    }

    @Override
    public NodeDefinition getCurrentNode() {
        IStructuredSelection selection = (IStructuredSelection)this.comboViewer.getSelection();
        if (selection.isEmpty()) {
            return null;
        }
        DynamicEditorsAttributeHelper.NodeOption selectedNode = (DynamicEditorsAttributeHelper.NodeOption)selection.getFirstElement();
        return this.getHelper().getNode(selectedNode.getNodeId());
    }

    @Override
    public void setCurrentMode(NodeDefinition currentMode) {
        this.inInInit = true;
        try {
            this.selectOperation(currentMode);
        }
        finally {
            this.inInInit = false;
        }
    }

    @Override
    protected Control internalCreateControl(Composite parent) {
        this.wrapper = parent;
        GridLayoutFactory.fillDefaults().applyTo(this.wrapper);
        GridDataFactory.fillDefaults().grab(true, true).applyTo((Control)this.wrapper);
        this.comboWrapper = new Composite(this.wrapper, 0);
        GridLayoutFactory.fillDefaults().margins(9, 0).numColumns(2).applyTo(this.comboWrapper);
        GridDataFactory.fillDefaults().grab(true, false).applyTo((Control)this.comboWrapper);
        Label labelControl = new Label(this.comboWrapper, 0);
        GridDataFactory.fillDefaults().align(1, 0x1000000).applyTo((Control)labelControl);
        labelControl.setText(this.getHelper().getCaption() + ":");
        this.comboViewer = this.createViewer(this.comboWrapper);
        GridDataFactory.fillDefaults().grab(true, true).applyTo(this.comboViewer.getControl());
        this.comboViewer.setContentProvider((IContentProvider)new ArrayContentProvider());
        this.comboViewer.setLabelProvider((IBaseLabelProvider)new LabelProvider(){

            public String getText(Object element) {
                DynamicEditorsAttributeHelper.NodeOption node = (DynamicEditorsAttributeHelper.NodeOption)element;
                return node.getLabel();
            }
        });
        String muleVersion = this.getContext().getVersion();
        List<DynamicEditorsAttributeHelper.NodeOption> allowedNodes = this.getHelper().getAllowedNodes(muleVersion);
        this.comboViewer.setInput(allowedNodes);
        this.comboViewer.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                if (!event.getSelection().isEmpty()) {
                    DynamicFieldEditor.this.onSelectionChanged();
                }
            }
        });
        this.comboViewer.setSelection((ISelection)new StructuredSelection((Object)allowedNodes.get(0)));
        return this.wrapper;
    }

    private void createEditorWrapper() {
        this.editorWrapper = new Composite(this.wrapper, 0);
        GridLayoutFactory.fillDefaults().margins(5, 10).applyTo(this.editorWrapper);
        GridDataFactory.fillDefaults().grab(true, true).applyTo((Control)this.editorWrapper);
    }

    @Override
    public DynamicEditorsAttributeHelper getHelper() {
        return (DynamicEditorsAttributeHelper)this.attributeHelper;
    }

    private StructuredViewer createViewer(Composite parent) {
        return new ComboViewer(parent, 8);
    }

    @Override
    protected void adjustLabelLayout(GridData layoutData) {
        layoutData.verticalAlignment = 0x1000000;
    }

    protected void onSelectionChanged() {
        if (!this.inInInit && this.isEnabled) {
            NodeDefinition currentNode = this.getCurrentNode();
            this.updateUI(currentNode);
        }
    }

    private void clearUI() {
        AbstractComponentMeta.clearPreserve(this.node);
        if (this.editorWrapper != null && !this.editorWrapper.isDisposed()) {
            this.editorWrapper.dispose();
        }
    }

    private void updateUI(NodeDefinition currentNode) {
        this.clearUI();
        if (currentNode != null) {
            AbstractComponentMeta service = (AbstractComponentMeta)currentNode.getService(AbstractComponentMeta.class);
            this.createEditorWrapper();
            this.updateEditor(service);
        }
        UtilsPlugin.getEventBus().fireEvent((IEvent)new LayoutPropertiesEditorRequest());
    }

    protected void updateEditor(AbstractComponentMeta service) {
        Map<String, AttributeCategory> attributesMap = service.getAttributeCategoryMap();
        if (attributesMap.size() > 1 || attributesMap.isEmpty()) {
            throw new RuntimeException("Only one component is allowed in dynamicEditors! ");
        }
        FixedAttributeCategoryProvider attributesProvider = new FixedAttributeCategoryProvider(new ArrayList<AttributeCategory>(attributesMap.values()).get(0));
        this.innerPage = new AttributesPropertyPage(null, this.context.getProject(), this.editorWrapper, (AttributeCategoryProvider)attributesProvider){

            @Override
            public IHost getHost() {
                AttributesPropertyPage parentPage2 = DynamicFieldEditor.this.getParentPage();
                if (parentPage2 == null) {
                    return null;
                }
                IHost host2 = parentPage2.getHost();
                return host2;
            }

            @Override
            public String getName() {
                return DynamicFieldEditor.this.getParentPage().getName();
            }

            @Override
            public void validate() {
                super.validate();
                AttributesPropertyPage parentPage = DynamicFieldEditor.this.getParentPage();
                if (parentPage != null) {
                    parentPage.validate();
                    AttributesPropertyPage.validateLastOpenedFromRoot();
                }
            }

            @Override
            protected boolean isFiltered(AttributeHelper m) {
                return false;
            }

            @Override
            protected boolean isGeneral() {
                return false;
            }
        };
        this.innerPage.loadFrom(this.node, new PropertyCollectionMap());
        GridLayoutFactory.fillDefaults().applyTo((Composite)this.innerPage);
        GridDataFactory.fillDefaults().grab(true, false).applyTo((Control)this.innerPage);
    }

    public StructuredViewer getComboViewer() {
        return this.comboViewer;
    }

    @Override
    public String getValue() {
        return "";
    }

    @Override
    public void saveTo(IMessageFlowNode node, PropertyCollectionMap props) {
        NodeDefinition currentMode;
        if (this.isEnabled && (currentMode = this.getCurrentNode()) != null) {
            props.addProperty(this.selectedEditorId, currentMode.getId());
            if (this.innerPage != null) {
                this.innerPage.saveTo(node, props);
            }
        }
    }

    @Override
    public void loadFrom(IMessageFlowNode node, PropertyCollectionMap props) {
        if (this.isEnabled) {
            this.node = node;
            String editorId = props.getProperty(this.selectedEditorId, "");
            NodeDefinition nodeDef = this.getHelper().getNode(editorId);
            NodeDefinition currentMode = this.getCurrentNode();
            if (nodeDef != null && !nodeDef.equals((Object)currentMode)) {
                this.setCurrentMode(nodeDef);
                this.updateUI(nodeDef);
            }
            if (this.innerPage != null) {
                this.innerPage.loadFrom(node, props);
            }
        }
    }

    public void selectOperation(NodeDefinition element) {
        if (!this.getComboViewer().getControl().isDisposed()) {
            this.getComboViewer().setSelection((ISelection)new StructuredSelection((Object)this.getHelper().getNodeOption(element)));
        }
    }

    @Override
    public void accept(IFieldEditorVisitor visitor) {
        visitor.visit(this);
    }

    @Override
    public void setEnabled(boolean enabled) {
        super.setEnabled(enabled);
        if (!enabled) {
            String muleVersion = this.getContext().getVersion();
            List<DynamicEditorsAttributeHelper.NodeOption> allowedNodes = this.getHelper().getAllowedNodes(muleVersion);
            this.comboViewer.setSelection((ISelection)new StructuredSelection((Object)allowedNodes.get(0)));
            NodeDefinition currentNode = this.getCurrentNode();
            this.updateUI(currentNode);
        }
    }

    @Override
    public void setValue(String value) {
    }

    @Override
    public void setPropertyPage(AttributesPropertyPage page) {
    }

    @Override
    public void refreshEditor(String newValue, boolean shouldNotifyObservers) {
        IValueCalculator calculator = this.getHelper().getCalculator();
        if (calculator != null) {
            String editorId = calculator.value(newValue, this, this.getNode());
            NodeDefinition nodeDef = this.getHelper().getNode(editorId);
            NodeDefinition currentMode = this.getCurrentNode();
            if (nodeDef != null && !nodeDef.equals((Object)currentMode)) {
                this.setCurrentMode(nodeDef);
                this.updateUI(nodeDef);
            }
        }
        if (this.innerPage != null) {
            Collection<IFieldEditor> editors = this.innerPage.getEditors().values();
            for (IFieldEditor iFieldEditor : editors) {
                if (!(iFieldEditor instanceof IRefresheableEditor)) continue;
                ((IRefresheableEditor)iFieldEditor).refreshEditor(newValue, shouldNotifyObservers);
            }
        }
    }
}

