/*
 * Decompiled with CFR 0.152.
 */
package org.mule.tooling.ui.modules.core.widgets.editors.dynamic;

import com.google.common.collect.Lists;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.lang.StringUtils;
import org.mule.tooling.model.messageflow.IMessageFlowNode;
import org.mule.tooling.model.messageflow.decorator.PropertyCollectionMap;
import org.mule.tooling.model.messageflow.util.PropertiesUtils;
import org.mule.tooling.ui.modules.core.widgets.editors.dynamic.DynamicEditorPersistenceTransformer;
import org.mule.tooling.ui.modules.core.widgets.editors.dynamic.DynamicEditorUtils;
import org.mule.tooling.ui.modules.core.widgets.meta.AfterSaveCorrection;

public class DefaultDynamicEditorPersistenceTransformer
extends DynamicEditorPersistenceTransformer
implements AfterSaveCorrection {
    private final List<String> definitions;

    public DefaultDynamicEditorPersistenceTransformer(String id, String csvDefinitions) {
        super(DynamicEditorUtils.getId(id));
        if (StringUtils.isBlank((String)csvDefinitions)) {
            throw new IllegalArgumentException("The list of definitions cannot be empty.");
        }
        this.definitions = Lists.newArrayList((Object[])csvDefinitions.split(","));
    }

    @Override
    protected List<String> getDefinitions() {
        return this.definitions;
    }

    @Override
    public void afterSave(IMessageFlowNode node, PropertyCollectionMap newPropertiesMap) {
        Map childElementsProperties = newPropertiesMap.getPropertyCollections();
        String selectedEditorId = this.getSelectedEditorId(childElementsProperties);
        if (!childElementsProperties.isEmpty() && selectedEditorId == null) {
            return;
        }
        PropertyCollectionMap oldPropertiesMap = new PropertyCollectionMap(node.getProperties());
        for (Map.Entry entry : oldPropertiesMap.getPropertyCollections().entrySet()) {
            String oldPropertyId = PropertiesUtils.getNodeDefinitionId((String)((String)entry.getKey()));
            if (!this.definitions.contains(oldPropertyId) || oldPropertyId.equals(selectedEditorId)) continue;
            PropertyCollectionMap oldPropertyCollection = (PropertyCollectionMap)entry.getValue();
            oldPropertyCollection.setErased(true);
            oldPropertyCollection.removeProperty(this.getPropertyId());
            newPropertiesMap.addPropertyCollection((String)entry.getKey(), oldPropertyCollection);
        }
    }

    private String getSelectedEditorId(Map<String, PropertyCollectionMap> childElementsProperties) {
        Set<Map.Entry<String, PropertyCollectionMap>> entrySet = childElementsProperties.entrySet();
        String selectedEditorId = null;
        for (Map.Entry<String, PropertyCollectionMap> entry : entrySet) {
            String childElementId = entry.getKey();
            String definitionId = PropertiesUtils.getNodeDefinitionId((String)childElementId);
            PropertyCollectionMap childElementProperties = entry.getValue();
            if (!this.definitions.contains(definitionId) || childElementProperties.getProperty(this.getPropertyId(), "").isEmpty()) continue;
            selectedEditorId = definitionId;
        }
        return selectedEditorId;
    }
}

