/*
 * Decompiled with CFR 0.152.
 */
package org.mule.tooling.ui.modules.core.widgets.editors;

import java.net.MalformedURLException;
import java.net.URL;
import org.eclipse.jface.preference.StringFieldEditor;
import org.eclipse.swt.widgets.Composite;

public class UrlFieldEditor
extends StringFieldEditor {
    private static final String ERROR_MSG = "You must type a valid ";
    private static final Object URL_PREFIX = "http://";

    public UrlFieldEditor(String name, String labelText, Composite parent) {
        super(name, labelText, parent);
    }

    protected boolean doCheckState() {
        String urlLabel = this.getLabelText();
        String urlValue = this.getStringValue();
        if (urlValue.isEmpty()) {
            this.setErrorMessage("The " + urlLabel + " URL cannot be empty");
            return false;
        }
        if (urlValue.equals(URL_PREFIX)) {
            this.setErrorMessage(ERROR_MSG + urlLabel);
            return false;
        }
        try {
            new URL(urlValue);
        }
        catch (MalformedURLException malformedURLException) {
            this.setErrorMessage(ERROR_MSG + urlLabel);
            return false;
        }
        return true;
    }
}

