/*
 * Decompiled with CFR 0.152.
 */
package org.mule.tooling.ui.modules.core.widgets.editors;

import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Text;
import org.mule.tooling.ui.modules.core.widgets.AttributeContext;
import org.mule.tooling.ui.modules.core.widgets.IFieldEditorVisitor;
import org.mule.tooling.ui.modules.core.widgets.editors.LabelledFieldEditor;
import org.mule.tooling.ui.modules.core.widgets.meta.AttributeHelper;
import org.mule.tooling.ui.modules.core.widgets.meta.TimeAttributeHelper;

public class TimeFieldEditor
extends LabelledFieldEditor {
    private Text hoursText;
    private Text milsText;
    private Text secondsText;
    private Text minutesText;
    private Label milsLabel;
    private Composite cParent;
    private GridLayout switcherLayout;
    private Composite holder;
    private boolean isShowMilliseconds = false;

    public Text getHoursText() {
        return this.hoursText;
    }

    public Text getSecondsText() {
        return this.secondsText;
    }

    public Text getMinutesText() {
        return this.minutesText;
    }

    public Control getMilsText() {
        return this.milsText;
    }

    public TimeFieldEditor(AttributeContext ctx, AttributeHelper atr, Composite parent) {
        super(ctx, atr, parent);
        TimeAttributeHelper tatr = (TimeAttributeHelper)atr;
        this.isShowMilliseconds = tatr.isShowMilliseconds();
        this.milsText.setVisible(this.isShowMilliseconds);
        this.milsLabel.setVisible(this.isShowMilliseconds);
    }

    @Override
    protected Control internalCreateControl(Composite parent) {
        this.cParent = new Composite(parent, 0);
        GridLayout layout = new GridLayout(this.attributeHelper.isSupportsExpressions() ? 2 : 1, false);
        layout.marginWidth = 0;
        layout.marginHeight = 0;
        this.cParent.setLayout((Layout)layout);
        this.holder = new Composite(this.cParent, 4);
        this.switcherLayout = new GridLayout();
        this.switcherLayout.marginWidth = 0;
        this.switcherLayout.marginHeight = 0;
        this.switcherLayout.numColumns = 8;
        this.holder.setLayout((Layout)this.switcherLayout);
        GridData gd = new GridData();
        gd.widthHint = 30;
        this.hoursText = new Text(this.holder, 2048);
        this.hoursText.setTextLimit(3);
        this.hoursText.setLayoutData((Object)gd);
        this.hoursText.addListener(24, new Listener(){

            public void handleEvent(Event event) {
                TimeFieldEditor.this.doValidate();
            }
        });
        Label hoursLabel = new Label(this.holder, 128);
        hoursLabel.setText("hours");
        gd = new GridData();
        gd.widthHint = 30;
        this.minutesText = new Text(this.holder, 2048);
        this.minutesText.setTextLimit(2);
        this.minutesText.setLayoutData((Object)gd);
        this.minutesText.addListener(24, new Listener(){

            public void handleEvent(Event event) {
                TimeFieldEditor.this.doValidate();
            }
        });
        Label minutesLabel = new Label(this.holder, 128);
        minutesLabel.setText("minutes");
        gd = new GridData();
        gd.widthHint = 30;
        this.secondsText = new Text(this.holder, 2048);
        this.secondsText.setLayoutData((Object)gd);
        this.secondsText.setTextLimit(2);
        this.secondsText.addListener(24, new Listener(){

            public void handleEvent(Event event) {
                TimeFieldEditor.this.doValidate();
            }
        });
        Label secondsLabel = new Label(this.holder, 128);
        secondsLabel.setText("seconds");
        gd = new GridData();
        gd.widthHint = 30;
        this.milsText = new Text(this.holder, 2048);
        this.milsText.setLayoutData((Object)gd);
        this.milsText.setVisible(this.isShowMilliseconds);
        this.milsText.setTextLimit(3);
        this.milsText.addListener(24, new Listener(){

            public void handleEvent(Event event) {
                TimeFieldEditor.this.doValidate();
            }
        });
        this.milsLabel = new Label(this.holder, 128);
        this.milsLabel.setText("milliseconds");
        this.milsLabel.setVisible(this.isShowMilliseconds);
        this.holder.setLayoutData((Object)GridDataFactory.fillDefaults().grab(true, true).create());
        return this.cParent;
    }

    @Override
    public String getValue() {
        Integer hrsV = 0;
        Integer minV = 0;
        Integer secV = 0;
        Integer milV = 0;
        try {
            if (this.hoursText.getText() != null && this.hoursText.getText().length() > 0) {
                hrsV = Integer.parseInt(this.hoursText.getText());
            }
            if (this.minutesText.getText() != null && this.minutesText.getText().length() > 0) {
                minV = Integer.parseInt(this.minutesText.getText());
            }
            if (this.secondsText.getText() != null && this.secondsText.getText().length() > 0) {
                secV = Integer.parseInt(this.secondsText.getText());
            }
            if (this.milsText.getText() != null && this.milsText.getText().length() > 0) {
                milV = Integer.parseInt(this.milsText.getText());
            }
        }
        catch (Exception exception) {
            hrsV = 0;
            minV = 0;
            secV = 0;
            milV = 0;
        }
        Integer valueInteger = milV + secV * 1000 + minV * 60000 + hrsV * 3600000;
        return valueInteger.toString();
    }

    @Override
    public void setValue(String value) {
        Integer hrsV = 0;
        Integer minV = 0;
        Integer secV = 0;
        Integer milV = 0;
        Integer valueInteger = 0;
        try {
            valueInteger = Integer.parseInt(value);
        }
        catch (Exception exception) {
            valueInteger = 0;
        }
        milV = valueInteger % 1000;
        valueInteger = (int)Math.round(Math.floor(valueInteger / 1000));
        secV = valueInteger % 60;
        valueInteger = (int)Math.round(Math.floor(valueInteger / 60));
        minV = valueInteger % 60;
        hrsV = valueInteger / 60;
        this.hoursText.setText(hrsV.toString());
        this.minutesText.setText(minV.toString());
        this.secondsText.setText(secV.toString());
        this.milsText.setText(milV.toString());
    }

    @Override
    public void accept(IFieldEditorVisitor visitor) {
        visitor.visit(this);
    }
}

