/*
 * Decompiled with CFR 0.152.
 */
package org.mule.tooling.ui.modules.core.widgets.editors;

import java.util.List;
import java.util.Optional;
import java.util.function.Function;
import org.apache.commons.lang.StringUtils;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.jface.text.Document;
import org.eclipse.jface.text.DocumentEvent;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IDocumentListener;
import org.eclipse.jface.text.ITextListener;
import org.eclipse.jface.text.TextEvent;
import org.eclipse.jface.text.TextViewer;
import org.eclipse.jface.text.source.IAnnotationModel;
import org.eclipse.jface.text.source.IVerticalRuler;
import org.eclipse.jface.text.source.SourceViewer;
import org.eclipse.jface.text.source.SourceViewerConfiguration;
import org.eclipse.jface.text.source.VerticalRuler;
import org.eclipse.jface.text.source.projection.ProjectionAnnotationModel;
import org.eclipse.jface.viewers.ComboViewer;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.swt.custom.StyledText;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.ui.PlatformUI;
import org.mule.tooling.core.MuleCorePlugin;
import org.mule.tooling.core.event.MetadataKeyFieldEditorEditedEvent;
import org.mule.tooling.core.mel.partitioner.EvaluatorExtensionConfiguration;
import org.mule.tooling.core.mel.partitioner.MELDocumentPartitioner;
import org.mule.tooling.core.utils.IObjectRef;
import org.mule.tooling.messageflow.module.MessageFlowNodeComposite;
import org.mule.tooling.messageflow.util.MessageFlowUtils;
import org.mule.tooling.model.messageflow.IMessageFlowNode;
import org.mule.tooling.model.messageflow.decorator.PropertyCollectionMap;
import org.mule.tooling.ui.modules.core.ModulesActivator;
import org.mule.tooling.ui.modules.core.autocomplete.mel.AutocompleteConfiguration;
import org.mule.tooling.ui.modules.core.autocomplete.mel.MELExpressionPartitioner;
import org.mule.tooling.ui.modules.core.autocomplete.mel.MELValidator;
import org.mule.tooling.ui.modules.core.autocomplete.mel.MELViewerConfiguration;
import org.mule.tooling.ui.modules.core.widgets.AttributeContext;
import org.mule.tooling.ui.modules.core.widgets.IFieldEditorVisitor;
import org.mule.tooling.ui.modules.core.widgets.editors.AbstractFieldEditor;
import org.mule.tooling.ui.modules.core.widgets.editors.EditorHelper;
import org.mule.tooling.ui.modules.core.widgets.editors.EnumFieldEditor;
import org.mule.tooling.ui.modules.core.widgets.editors.TextViewerCreator;
import org.mule.tooling.ui.modules.core.widgets.meta.AttributeHelper;
import org.mule.tooling.ui.modules.core.widgets.meta.TextAttributeMeta;
import org.mule.tooling.ui.widgets.listener.IdleDocumentEventListener;
import org.mule.tooling.ui.widgets.listener.IdleTextEventListener;
import org.mule.tooling.ui.widgets.util.WidgetUtils;
import org.mule.tooling.utils.eventbus.IEvent;

public class TextElementFieldEditor
extends AbstractFieldEditor {
    private SourceViewer sourceViewer;
    private Button button;
    private IValidator validator;
    private Optional<IdleTextEventListener> typeChooserDispacher;

    public TextElementFieldEditor(AttributeContext ctx, AttributeHelper atr, Composite parent, IMessageFlowNode node) {
        super(ctx, atr, parent, node);
    }

    protected SourceViewer createViewer(Composite parentComposite) {
        TextViewerCreator customViewerCreator = this.attributeHelper.getCustomTextViewerCreator();
        if (customViewerCreator != null) {
            try {
                return (SourceViewer)customViewerCreator.create(parentComposite, this.node, this.getContext());
            }
            catch (ClassCastException e) {
                throw new RuntimeException("For TextElementFieldEditors you need to create SourceViewers", e);
            }
        }
        return this.createDefaultViewer(parentComposite);
    }

    protected SourceViewer createDefaultViewer(Composite parentComposite) {
        SourceViewer newViewer = new SourceViewer(parentComposite, (IVerticalRuler)new VerticalRuler(0), 768);
        newViewer.configure((SourceViewerConfiguration)new MELViewerConfiguration((IAnnotationModel)new ProjectionAnnotationModel(), new IObjectRef<EvaluatorExtensionConfiguration>(){

            public AutocompleteConfiguration get() {
                return new AutocompleteConfiguration(TextElementFieldEditor.this.node, TextElementFieldEditor.this.context.getMuleConfiguration(), TextElementFieldEditor.this.context.getProject(), TextElementFieldEditor.this);
            }
        }));
        Document document = new Document();
        newViewer.setDocument((IDocument)document);
        this.validator = new ExpressionValidator();
        if (this.attributeHelper.getId().contains("expression")) {
            new MELExpressionPartitioner().connect((IDocument)document);
        } else {
            new MELDocumentPartitioner().connect((IDocument)document);
        }
        IDocumentListener onDocumentChangeCallback = new IDocumentListener(){

            public void documentAboutToBeChanged(DocumentEvent event) {
            }

            public void documentChanged(DocumentEvent event) {
                TextElementFieldEditor.this.doValidate();
            }
        };
        document.addDocumentListener((IDocumentListener)new IdleDocumentEventListener(onDocumentChangeCallback, this.control));
        return newViewer;
    }

    @Override
    protected Control createControl(Composite parent) {
        this.createLabel(parent);
        Composite owner = new Composite(parent, 0);
        GridLayout layout = new GridLayout(1, false);
        layout.marginWidth = 0;
        layout.marginHeight = 0;
        owner.setLayout((Layout)layout);
        this.control = owner;
        Composite composite = new Composite(owner, 2048);
        composite.setLayout((Layout)new FillLayout());
        this.sourceViewer = this.createViewer(composite);
        StyledText textWidget = this.sourceViewer.getTextWidget();
        textWidget.setAlwaysShowScrollBars(false);
        textWidget.setFont(JFaceResources.getFont((String)"org.eclipse.jface.textfont"));
        WidgetUtils.addUndoAndRedoCapability((TextViewer)this.sourceViewer);
        this.sourceViewer.addTextListener((ITextListener)new IdleTextEventListener(new ITextListener(){

            public void textChanged(TextEvent event) {
                TextElementFieldEditor.this.doValidate();
            }
        }, this.sourceViewer.getControl()));
        this.typeChooserDispacher = this.attributeHelper.isTypeChooser() ? Optional.of(new IdleTextEventListener(new ITextListener(){

            public void textChanged(TextEvent event) {
                IMessageFlowNode updatedCurrentNode = (IMessageFlowNode)MessageFlowUtils.generateNodeToTestSupplier((IMessageFlowNode)TextElementFieldEditor.this.getNode()).get();
                List<MessageFlowNodeComposite> pages = EditorHelper.getAllCurrentEditorPages(TextElementFieldEditor.this);
                Function updatedPropertiesProvider = MessageFlowUtils.updatedPropertiesProvider(pages);
                MuleCorePlugin.getEventBus().fireEvent((IEvent)new MetadataKeyFieldEditorEditedEvent(TextElementFieldEditor.this.getParentPage().getMuleProject(), TextElementFieldEditor.this.getNode(), TextElementFieldEditor.this.getNode().getProperties(), ((PropertyCollectionMap)updatedPropertiesProvider.apply(updatedCurrentNode)).asPropertyCollection()));
            }
        }, this.sourceViewer.getControl())) : Optional.empty();
        composite.setLayoutData((Object)GridDataFactory.fillDefaults().grab(true, true).create());
        int height = WidgetUtils.getLinesHeightInPixels((Control)owner, (int)this.getEditorsLineHeight());
        int width = 200;
        try {
            height = Integer.parseInt(this.getHelper().getHeight());
            width = Integer.parseInt(this.getHelper().getWidth());
        }
        catch (NumberFormatException numberFormatException) {}
        owner.setLayoutData((Object)GridDataFactory.fillDefaults().grab(true, true).span(3, 1).minSize(width, height).create());
        return owner;
    }

    private int getEditorsLineHeight() {
        IPreferenceStore prefStore = ModulesActivator.getDefault().getPreferenceStore();
        return prefStore.getInt("text.field.editor.lines.height");
    }

    @Override
    public TextAttributeMeta getHelper() {
        return (TextAttributeMeta)super.getHelper();
    }

    protected void createLabel(Composite parent) {
        if (StringUtils.isBlank((String)this.attributeHelper.getCaption())) {
            return;
        }
        if (!this.attributeHelper.getAlternatives().isEmpty()) {
            this.button = new Button(parent, 16);
            this.button.setText(this.attributeHelper.getCaption() + ":");
            this.button.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent e) {
                    TextElementFieldEditor.this.setEnabled(TextElementFieldEditor.this.button.getSelection());
                }
            });
            this.button.setLayoutData((Object)GridDataFactory.fillDefaults().grab(true, false).span(3, 1).create());
        } else {
            Label label = new Label(parent, 0);
            label.setText(this.attributeHelper.getCaption() + ":");
            label.setLayoutData((Object)GridDataFactory.fillDefaults().grab(true, false).span(3, 1).create());
        }
    }

    private void installListenersInEnumFieldEditor(String language) {
        if (StringUtils.isEmpty((String)language) && EnumFieldEditor.lastEnum != null) {
            EnumFieldEditor.lastEnum.addSelectionChangedListener(new ISelectionChangedListener(){

                public void selectionChanged(SelectionChangedEvent event) {
                    TextElementFieldEditor.this.reinit();
                }
            });
            if (EnumFieldEditor.lastEnum instanceof ComboViewer) {
                ((ComboViewer)EnumFieldEditor.lastEnum).getCombo().addModifyListener(new ModifyListener(){

                    public void modifyText(ModifyEvent e) {
                        TextElementFieldEditor.this.reinit();
                    }
                });
            }
        }
    }

    @Override
    public String getValue() {
        String value = this.sourceViewer.getDocument().get();
        return value;
    }

    @Override
    public void setValue(String value) {
        this.sourceViewer.getDocument().set(value);
    }

    @Override
    public void setEnabled(boolean selection) {
        super.setEnabled(selection);
        if (this.button != null) {
            this.button.setSelection(selection);
        }
        StyledText textWidget = this.sourceViewer.getTextWidget();
        textWidget.setEnabled(selection);
        textWidget.setBackground(this.isEnabled ? Display.getCurrent().getSystemColor(1) : Display.getCurrent().getSystemColor(22));
    }

    @Override
    public void loadFrom(IMessageFlowNode node, PropertyCollectionMap props) {
        super.loadFrom(node, props);
        if (this.typeChooserDispacher.isPresent()) {
            this.sourceViewer.removeTextListener((ITextListener)this.typeChooserDispacher.get());
        }
        if (!this.attributeHelper.getAlternatives().isEmpty()) {
            boolean selected = this.getValue() != null && this.getValue().length() > 0;
            boolean alternativeIsConfigured = false;
            if (!selected) {
                for (String alternative : this.attributeHelper.getAlternatives()) {
                    if (props.getProperty(alternative, "").isEmpty()) continue;
                    alternativeIsConfigured = true;
                }
            }
            if (!alternativeIsConfigured) {
                selected = true;
            }
            this.button.setSelection(selected);
            this.setEnabled(selected);
        }
        if (this.typeChooserDispacher.isPresent()) {
            this.sourceViewer.addTextListener((ITextListener)this.typeChooserDispacher.get());
        }
    }

    protected void reinit() {
    }

    @Override
    protected boolean shouldReportErrorMessage() {
        return true;
    }

    @Override
    public void validate() {
        super.validate();
        this.validator.validate();
    }

    @Override
    public void accept(IFieldEditorVisitor visitor) {
        visitor.visit(this);
    }

    private class ExpressionValidator
    implements IValidator {
        private MELValidator melValidator;

        private ExpressionValidator() {
        }

        @Override
        public void validate() {
            this.getMelValidator().validateAsync(TextElementFieldEditor.this.sourceViewer.getDocument(), TextElementFieldEditor.this.getContext().getMuleConfiguration(), TextElementFieldEditor.this.getNode(), new MELValidator.IStatusCallback(){

                @Override
                public void onResult(final IStatus status) {
                    PlatformUI.getWorkbench().getDisplay().asyncExec(new Runnable(){

                        @Override
                        public void run() {
                            if (!TextElementFieldEditor.this.isDisposed()) {
                                if (!Status.OK_STATUS.equals(status)) {
                                    TextElementFieldEditor.this.setError(status.getMessage());
                                }
                                TextElementFieldEditor.this.validateParent();
                            }
                        }
                    });
                }
            });
        }

        public MELValidator getMelValidator() {
            if (this.melValidator == null) {
                this.melValidator = new MELValidator(TextElementFieldEditor.this.getParentPage().getMuleProject());
            }
            return this.melValidator;
        }
    }

    private static interface IValidator {
        public void validate();
    }
}

