/*
 * Decompiled with CFR 0.152.
 */
package org.mule.tooling.ui.modules.core.widgets.editors;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import org.apache.commons.lang3.StringUtils;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.jface.layout.GridLayoutFactory;
import org.eclipse.jface.viewers.CellEditor;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.ICellEditorListener;
import org.eclipse.jface.viewers.ICellModifier;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.swt.custom.CTabFolder;
import org.eclipse.swt.custom.CTabItem;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.mule.tooling.client.api.KeyValuePairsResult;
import org.mule.tooling.core.MuleCorePlugin;
import org.mule.tooling.model.messageflow.IMessageFlowNode;
import org.mule.tooling.model.messageflow.decorator.PropertyCollectionMap;
import org.mule.tooling.model.messageflow.util.PropertiesUtils;
import org.mule.tooling.ui.modules.core.widgets.AttributesPropertyPage;
import org.mule.tooling.ui.modules.core.widgets.editors.CustomEditor;
import org.mule.tooling.ui.modules.core.widgets.editors.PairLabelProvider;
import org.mule.tooling.ui.modules.core.widgets.meta.AttributeGroup;
import org.mule.tooling.ui.modules.core.widgets.meta.AttributeHelper;
import org.mule.tooling.ui.widgets.WidgetsImages;
import org.mule.tooling.ui.widgets.table.MapTableComposite;
import org.mule.tooling.ui.widgets.util.WidgetUtils;
import org.mule.tooling.weave.engine.WeaveEngineHelperManager;

public class TableToDWScriptEditor
extends CustomEditor {
    private static final String WARNING_MESSAGE = "Couldn't read key-values from XML";
    private MapTableComposite table;
    private boolean invalidLoading;
    private PropertyCollectionMap loadedProps;
    private static final int TABLE_LINES_HEIGHT = 7;

    public TableToDWScriptEditor(AttributesPropertyPage parentPage, AttributeHelper helper, AttributeGroup attributeGroup, Composite groupComposite) {
        super(parentPage, helper, attributeGroup, groupComposite);
    }

    @Override
    public void refreshEditor(String newValue, boolean shouldNotifyObservers) {
    }

    @Override
    protected Control createControl(AttributesPropertyPage parentPage) {
        Group wrapper;
        if (!this.isDisplayedInTabs()) {
            wrapper = new Group(this.getGroupComposite(), 0);
            wrapper.setText(this.getHelper().getCaption());
        } else {
            wrapper = new Composite(this.getGroupComposite(), 0);
        }
        GridLayoutFactory.fillDefaults().applyTo((Composite)wrapper);
        GridDataFactory.fillDefaults().span(3, 1).grab(true, true).hint(-1, WidgetUtils.getLinesHeightInPixels((Control)wrapper, (int)7)).applyTo((Control)wrapper);
        this.createTable((Composite)wrapper);
        return wrapper;
    }

    private boolean isDisplayedInTabs() {
        return StringUtils.isNotBlank((CharSequence)this.getHelper().getParent());
    }

    private void createTable(Composite tableComposite) {
        this.table = new MapTableComposite(tableComposite, 4, new String[]{"Name", "Value"}){

            public void refreshTableViewer() {
                super.refreshTableViewer();
                TableToDWScriptEditor.this.validateTable();
            }
        };
        this.table.setDefaultInputKey("\"Key\"");
        this.table.setDefaultInputValue("\"Value\"");
        GridDataFactory.fillDefaults().grab(true, true).applyTo((Control)this.table);
        final CellEditor[] cellEditors = this.table.getTableViewer().getCellEditors();
        int i = 0;
        while (i < cellEditors.length) {
            final int cell = i++;
            cellEditors[cell].addListener(new ICellEditorListener(){

                public void editorValueChanged(boolean oldValidState, boolean newValidState) {
                    if (newValidState) {
                        String actualValue = (String)cellEditors[cell].getValue();
                        this.fireModifyEvent(actualValue);
                    }
                }

                public void cancelEditor() {
                }

                public void applyEditorValue() {
                }

                private void fireModifyEvent(Object newValue) {
                    Object selected = ((IStructuredSelection)TableToDWScriptEditor.this.table.getTableViewer().getSelection()).getFirstElement();
                    if (selected instanceof MapTableComposite.Pair) {
                        if (cell == 0) {
                            ((MapTableComposite.Pair)selected).setKey(String.valueOf(newValue));
                        } else {
                            ((MapTableComposite.Pair)selected).setValue(String.valueOf(newValue));
                        }
                        TableToDWScriptEditor.this.validateTable();
                    }
                }
            });
        }
        this.table.getTableViewer().setComparator(null);
        this.table.getTableViewer().setLabelProvider((IBaseLabelProvider)new PairLabelProvider(this.table));
        this.table.getTableViewer().setCellModifier((ICellModifier)new MapTableComposite.PairCellModifier(this.table){

            protected void onSetKey(Object data, Object value) {
                super.onSetKey(data, value);
                TableToDWScriptEditor.this.invalidLoading = false;
            }

            protected void onSetValue(Object data, Object value) {
                super.onSetValue(data, value);
                TableToDWScriptEditor.this.invalidLoading = false;
            }
        });
    }

    protected void validateTable() {
        Map inputData = this.table.getInputData();
        String message = "";
        if (this.hasRepeatedKeys()) {
            message = "There are repeated keys.";
        } else {
            for (Map.Entry keyValue : inputData.entrySet()) {
                String wrongKeyValue = this.validateKeyValue((String)keyValue.getKey(), (String)keyValue.getValue());
                if (!StringUtils.isNotBlank((CharSequence)wrongKeyValue)) continue;
                message = wrongKeyValue;
                break;
            }
        }
        this.showTabWarning(message);
    }

    private void showTabWarning(String message) {
        CTabItem actualTab;
        if (this.isDisplayedInTabs() && (actualTab = this.getActualTab()) != null) {
            if (StringUtils.isBlank((CharSequence)message)) {
                if (!this.invalidLoading) {
                    actualTab.setImage(null);
                    actualTab.setToolTipText("");
                }
            } else {
                actualTab.setImage(WidgetsImages.getImage((String)"icons/errors/warning.png"));
                actualTab.setToolTipText(message);
            }
        }
    }

    private boolean hasRepeatedKeys() {
        ArrayList input = (ArrayList)this.table.getTableViewer().getInput();
        HashSet<String> set = new HashSet<String>();
        if (input != null) {
            for (MapTableComposite.Pair pair : input) {
                if (set.add(pair.getKey())) continue;
                return true;
            }
        }
        return false;
    }

    private String validateKeyValue(String k, String v) {
        boolean emptyKey = StringUtils.isBlank((CharSequence)k);
        boolean emptyValue = StringUtils.isBlank((CharSequence)v);
        if (emptyKey) {
            return "Key not defined";
        }
        if (emptyValue) {
            return "Value not defined";
        }
        return "";
    }

    private CTabItem getActualTab() {
        CTabFolder tabFolder = this.getTabFolder();
        CTabItem[] tabs = tabFolder.getItems();
        int i = 0;
        while (i < tabs.length) {
            if (tabs[i].getData("ID").equals(this.getHelper().getParent())) {
                return tabs[i];
            }
            ++i;
        }
        return null;
    }

    private CTabFolder getTabFolder() {
        Composite parent = this.control.getParent();
        while (parent != null) {
            if (parent instanceof CTabFolder) {
                return (CTabFolder)parent;
            }
            parent = parent.getParent();
        }
        return null;
    }

    @Override
    public void loadFrom(IMessageFlowNode node, PropertyCollectionMap props) {
        this.loadTable(props);
    }

    private void loadTable(PropertyCollectionMap props) {
        String script = props.getProperty(this.getHelper().getId(), "");
        if (StringUtils.isBlank((CharSequence)script)) {
            return;
        }
        Map<String, String> result = this.processScript(script);
        if (this.invalidLoading) {
            this.loadedProps = props;
        }
        this.table.setInputData(result);
    }

    private Map<String, String> processScript(String script) {
        Map<String, String> keyValues = new HashMap<String, String>();
        try {
            KeyValuePairsResult result = WeaveEngineHelperManager.parseKeyValuePairs((String)script.substring(2, script.length() - 1));
            if (result.isSuccess() && result.getKeyValuePairs().isPresent() && ((Map)result.getKeyValuePairs().get()).size() > 0) {
                Optional keyValuePairs = result.getKeyValuePairs();
                keyValues = (Map)keyValuePairs.get();
            } else {
                this.invalidLoading = true;
                MuleCorePlugin.logWarning((String)"Couldn't parse DW script as KeyValue pairs");
                this.showTabWarning(WARNING_MESSAGE);
            }
        }
        catch (Error ex) {
            this.invalidLoading = true;
            MuleCorePlugin.logError((String)"Couldn't parse DW script as KeyValue pairs", (Throwable)ex);
            this.showTabWarning(WARNING_MESSAGE);
        }
        return keyValues;
    }

    @Override
    public void saveTo(IMessageFlowNode node, PropertyCollectionMap props) {
        Map inputData = this.table.getInputData();
        if (inputData.isEmpty()) {
            if (this.invalidLoading) {
                PropertiesUtils.copyPropertyCollectionMap((PropertyCollectionMap)props, (PropertyCollectionMap)this.loadedProps);
            }
            return;
        }
        String script = this.getScriptFromTable(inputData);
        props.addProperty(this.getHelper().getId(), script);
    }

    private String getScriptFromTable(Map<String, String> inputData) {
        StringBuilder scriptBuilder = new StringBuilder();
        scriptBuilder.append("#[").append("output application/java").append(System.lineSeparator()).append("---").append(System.lineSeparator()).append("{").append(System.lineSeparator());
        List input = (List)this.table.getTableViewer().getInput();
        int i = 1;
        for (MapTableComposite.Pair keyValue : input) {
            String value = StringUtils.isBlank((CharSequence)keyValue.getValue()) ? "\"\"" : keyValue.getValue();
            String key = StringUtils.isBlank((CharSequence)keyValue.getKey()) ? "\"\"" : keyValue.getKey();
            scriptBuilder.append("\t").append(key).append(" : ").append(value);
            if (i < input.size()) {
                scriptBuilder.append(",");
            }
            ++i;
            scriptBuilder.append(System.lineSeparator());
        }
        scriptBuilder.append("}").append("]");
        return scriptBuilder.toString();
    }

    @Override
    public IStatus validate() {
        if (this.invalidLoading) {
            return new Status(2, "org.mule.tooling.core", "Couldn't read key-values from XML for " + this.getHelper().getCaption());
        }
        return Status.OK_STATUS;
    }
}

