/*
 * Decompiled with CFR 0.152.
 */
package org.mule.tooling.ui.modules.core.widgets.editors;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.jface.layout.GridLayoutFactory;
import org.eclipse.jface.viewers.ArrayContentProvider;
import org.eclipse.jface.viewers.ComboViewer;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.swt.custom.CLabel;
import org.eclipse.swt.custom.StackLayout;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.mule.tooling.core.event.LayoutPropertiesEditorRequest;
import org.mule.tooling.model.messageflow.IMessageFlowNode;
import org.mule.tooling.model.messageflow.decorator.PropertyCollectionMap;
import org.mule.tooling.ui.modules.core.widgets.IFieldEditor;
import org.mule.tooling.ui.modules.core.widgets.IFieldEditorVisitor;
import org.mule.tooling.ui.modules.core.widgets.editors.AbstractCompositeEditor;
import org.mule.tooling.ui.modules.core.widgets.editors.SwitchEditor;
import org.mule.tooling.ui.modules.core.widgets.meta.AttributeGroup;
import org.mule.tooling.ui.modules.core.widgets.meta.AttributeHelper;
import org.mule.tooling.ui.modules.core.widgets.meta.SwitchCaseHelper;
import org.mule.tooling.utils.UtilsPlugin;
import org.mule.tooling.utils.eventbus.IEvent;

public class SwitchCaseEditor
extends AbstractCompositeEditor {
    private Map<String, String> caseNames;
    private Map<String, Composite> stackCases;
    private Map<String, List<IFieldEditor>> caseEditors;
    private Map<String, PropertyCollectionMap> collections;
    private String currentCase;
    private StackLayout layout;
    private Composite composite;
    private ComboViewer caseSelector;

    public SwitchCaseEditor(AttributeHelper atr, Composite gr, AttributeGroup agroup, SwitchEditor.NewEditorCallback newEditorCallback) {
        super(atr, gr, agroup, newEditorCallback);
    }

    @Override
    protected AbstractCompositeEditor.CompositeAndItsParts createComposite(Composite gr, AttributeGroup agroup, SwitchEditor.NewEditorCallback newEditorCallback) {
        this.collections = new HashMap<String, PropertyCollectionMap>();
        SwitchCaseHelper scHelper = (SwitchCaseHelper)this.attributeHelper;
        this.caseNames = scHelper.getCaseNames();
        Map<String, List<AttributeHelper>> cases = scHelper.getCases();
        ArrayList<IFieldEditor> compositeParts = new ArrayList<IFieldEditor>();
        this.addCaseSelector(gr, cases);
        Composite composite = new Composite(gr, 0);
        GridData gridData = GridDataFactory.fillDefaults().grab(true, false).span(3, 1).create();
        composite.setLayoutData((Object)gridData);
        StackLayout layout = new StackLayout(){

            protected Point computeSize(Composite composite, int wHint, int hHint, boolean flushCache) {
                if (SwitchCaseEditor.this.layout.topControl == null) {
                    return new Point(0, 0);
                }
                Point size = SwitchCaseEditor.this.layout.topControl.computeSize(wHint, hHint, flushCache);
                int width = size.x + 2 * this.marginWidth;
                int height = size.y + 2 * this.marginHeight;
                if (wHint != -1) {
                    width = wHint;
                }
                if (hHint != -1) {
                    height = hHint;
                }
                return new Point(width, height);
            }
        };
        composite.setLayout((Layout)layout);
        HashMap<String, Composite> stackCases = new HashMap<String, Composite>();
        HashMap<String, List<IFieldEditor>> caseEditors = new HashMap<String, List<IFieldEditor>>();
        for (String key : cases.keySet()) {
            Composite oneCaseComposite = new Composite(composite, 0);
            GridLayout oneCaseLayout = GridLayoutFactory.fillDefaults().create();
            GridDataFactory.fillDefaults().grab(true, false).applyTo((Control)oneCaseComposite);
            oneCaseLayout.numColumns = 3;
            oneCaseLayout.makeColumnsEqualWidth = false;
            oneCaseLayout.horizontalSpacing = 9;
            oneCaseLayout.marginHeight = 0;
            oneCaseComposite.setLayout((Layout)oneCaseLayout);
            ArrayList<IFieldEditor> editors = new ArrayList<IFieldEditor>();
            for (AttributeHelper childAttributeHelper : cases.get(key)) {
                IFieldEditor childEditor = newEditorCallback.create(oneCaseComposite, childAttributeHelper, agroup);
                editors.add(childEditor);
            }
            compositeParts.addAll(editors);
            caseEditors.put(key, editors);
            stackCases.put(key, oneCaseComposite);
        }
        this.currentCase = this.caseNames.get(stackCases.keySet().iterator().next());
        layout.topControl = (Control)stackCases.get(this.currentCase);
        composite.layout();
        this.layout = layout;
        this.composite = composite;
        this.stackCases = stackCases;
        this.caseEditors = caseEditors;
        return new AbstractCompositeEditor.CompositeAndItsParts(this, composite, compositeParts);
    }

    private void addCaseSelector(Composite gr, Map<String, List<AttributeHelper>> cases) {
        Composite selectorComposite = new Composite(gr, 0);
        GridLayoutFactory.fillDefaults().numColumns(2).applyTo(selectorComposite);
        CLabel label = new CLabel(selectorComposite, 0);
        label.setText(this.getHelper().getId() + ": ");
        this.caseSelector = new ComboViewer(selectorComposite);
        GridDataFactory.fillDefaults().grab(true, true).applyTo(this.caseSelector.getControl());
        this.caseSelector.setContentProvider((IContentProvider)new ArrayContentProvider());
        this.caseSelector.setLabelProvider((IBaseLabelProvider)new LabelProvider());
        ArrayList<String> listCases = new ArrayList<String>();
        listCases.add("");
        listCases.addAll(this.caseNames.values());
        listCases.sort(String::compareToIgnoreCase);
        this.caseSelector.setInput(listCases);
        this.caseSelector.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                IStructuredSelection selection = (IStructuredSelection)event.getSelection();
                if (!selection.isEmpty()) {
                    String selectedCase = selection.getFirstElement().toString();
                    Optional<String> caseId = SwitchCaseEditor.this.caseNames.keySet().stream().filter(k -> SwitchCaseEditor.this.caseNames.get(k).equals(selectedCase)).findAny();
                    if (caseId.isPresent()) {
                        SwitchCaseEditor.this.setCurrentComposite(caseId.get());
                    } else {
                        SwitchCaseEditor.this.setCurrentComposite("");
                    }
                }
            }
        });
    }

    private static int nRows(Collection<List<AttributeHelper>> collection) {
        int rows = 1;
        for (List<AttributeHelper> editors : collection) {
            if (editors.size() <= rows) continue;
            rows = editors.size();
        }
        return rows;
    }

    @Override
    public void setEnabled(boolean enabled) {
    }

    private String getDefinitionId(String id) {
        String prefix = this.getPrefixId(id);
        return prefix + ";0";
    }

    private String getPrefixId(String id) {
        return "@http://www.mulesoft.org/schema/mule/http/" + id;
    }

    @Override
    public void loadFrom(IMessageFlowNode node, PropertyCollectionMap props) {
        super.loadFrom(node, props);
        this.collections.clear();
        this.caseSelector.setSelection((ISelection)new StructuredSelection((Object)""));
        for (String caseId : this.stackCases.keySet()) {
            Map propertyCollections = props.getPropertyCollections();
            for (String prop : propertyCollections.keySet()) {
                if (!prop.startsWith(this.getPrefixId(caseId))) continue;
                this.collections.put(caseId, (PropertyCollectionMap)propertyCollections.get(prop));
                this.caseSelector.setSelection((ISelection)new StructuredSelection((Object)this.caseNames.get(caseId)));
            }
        }
    }

    @Override
    public void saveTo(IMessageFlowNode node, PropertyCollectionMap props) {
        IStructuredSelection selection;
        boolean empty;
        List<IFieldEditor> list = this.caseEditors.get(this.currentCase);
        if (list != null) {
            for (IFieldEditor editor : list) {
                editor.saveTo(node, props);
            }
        }
        String selectedType = (empty = (selection = this.caseSelector.getStructuredSelection()).isEmpty()) ? "" : selection.getFirstElement().toString();
        for (String caseId : this.caseNames.keySet()) {
            PropertyCollectionMap propertyCollectionMap;
            if (this.caseNames.get(caseId).equals(selectedType) || caseId.equals("") || (propertyCollectionMap = this.collections.get(caseId)) == null) continue;
            propertyCollectionMap.setErased(true);
            String name = propertyCollectionMap.asPropertyCollection().getName();
            props.addPropertyCollection(name, propertyCollectionMap);
            this.collections.remove(caseId);
        }
    }

    public void setCurrentComposite(String caseId) {
        this.currentCase = caseId;
        Composite currentComposite = this.stackCases.get(caseId);
        this.layout.topControl = currentComposite;
        this.composite.pack();
        this.composite.layout();
        UtilsPlugin.getEventBus().fireEvent((IEvent)new LayoutPropertiesEditorRequest());
    }

    @Override
    public void accept(IFieldEditorVisitor visitor) {
        visitor.visit(this);
    }
}

