/*
 * Decompiled with CFR 0.152.
 */
package org.mule.tooling.ui.modules.core.widgets.editors;

import java.util.HashSet;
import java.util.Objects;
import java.util.Set;
import java.util.function.Predicate;
import org.apache.commons.lang3.StringUtils;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.jface.layout.GridLayoutFactory;
import org.eclipse.jface.text.Document;
import org.eclipse.jface.text.DocumentEvent;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IDocumentListener;
import org.eclipse.jface.text.TextViewer;
import org.eclipse.jface.text.source.SourceViewer;
import org.eclipse.swt.custom.LineStyleEvent;
import org.eclipse.swt.custom.StyleRange;
import org.eclipse.swt.custom.StyledText;
import org.eclipse.swt.events.TraverseListener;
import org.eclipse.swt.events.VerifyEvent;
import org.eclipse.swt.events.VerifyListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.ui.PlatformUI;
import org.mule.tooling.core.mel.partitioner.EvaluatorExtensionConfiguration;
import org.mule.tooling.core.utils.IObjectRef;
import org.mule.tooling.model.messageflow.IMessageFlowNode;
import org.mule.tooling.model.messageflow.decorator.PropertyCollectionMap;
import org.mule.tooling.ui.modules.core.autocomplete.mel.AutocompleteConfiguration;
import org.mule.tooling.ui.modules.core.autocomplete.mel.MELValidator;
import org.mule.tooling.ui.modules.core.autocomplete.mel.view.MELViewer;
import org.mule.tooling.ui.modules.core.widgets.AttributeContext;
import org.mule.tooling.ui.modules.core.widgets.IEditorValueModifiedListener;
import org.mule.tooling.ui.modules.core.widgets.IEditorValueModifiedObservable;
import org.mule.tooling.ui.modules.core.widgets.IFieldEditorVisitor;
import org.mule.tooling.ui.modules.core.widgets.IRefresheableEditor;
import org.mule.tooling.ui.modules.core.widgets.editors.ExpressionWrapperFieldEditor;
import org.mule.tooling.ui.modules.core.widgets.editors.IStealth;
import org.mule.tooling.ui.modules.core.widgets.editors.IValueCalculator;
import org.mule.tooling.ui.modules.core.widgets.editors.TextViewerCreator;
import org.mule.tooling.ui.modules.core.widgets.expressions.ui.ExpressionWidget;
import org.mule.tooling.ui.modules.core.widgets.expressions.ui.HighlighterImpl;
import org.mule.tooling.ui.modules.core.widgets.meta.AttributeHelper;
import org.mule.tooling.ui.widgets.listener.IdleDocumentEventListener;
import org.mule.tooling.ui.widgets.util.ThemeUtils;
import org.mule.tooling.ui.widgets.util.WidgetUtils;
import org.mule.tooling.utils.script.ScriptUtils;

public class StringFieldEditor
extends ExpressionWrapperFieldEditor
implements IStealth,
IEditorValueModifiedObservable,
IRefresheableEditor {
    protected Composite cParent;
    private ExpressionWidget expressionWidget;
    private boolean hidden = false;
    private Object[] layoutData = null;
    private Control[] controls = null;
    private TextViewer scriptViewer;
    private Set<IEditorValueModifiedListener> valueModifiedListeners;

    public StringFieldEditor(AttributeContext ctx, AttributeHelper atr, Composite parent, IMessageFlowNode node) {
        super(ctx, atr, parent, node);
    }

    protected boolean isMultiline() {
        return this.getHelper().isTextArea();
    }

    public Control getText() {
        return this.getTextWidget();
    }

    @Override
    protected Control getInfoDecorationControl() {
        return this.getTextWidget();
    }

    @Override
    protected Control internalCreateControl(Composite parent) {
        this.cParent = new Composite(parent, 0);
        GridLayoutFactory.fillDefaults().applyTo(this.cParent);
        GridDataFactory.fillDefaults().align(4, 4).grab(true, false).applyTo((Control)this.cParent);
        this.scriptViewer = this.createViewer();
        WidgetUtils.addUndoAndRedoCapability((TextViewer)this.scriptViewer);
        if (!this.getHelper().isTextArea()) {
            GridDataFactory.fillDefaults().align(4, 4).grab(true, false).applyTo((Control)this.getTextWidget());
        } else {
            GridDataFactory.fillDefaults().align(4, 4).grab(true, false).hint(-1, this.getHelper().getTextAreaHeight()).applyTo((Control)this.getTextWidget());
        }
        this.addModificationListeners(this.scriptViewer);
        return this.cParent;
    }

    protected TextViewer createViewer() {
        TextViewer textViewer;
        TextViewerCreator customViewerCreator = this.attributeHelper.getCustomTextViewerCreator();
        TextViewer textViewer2 = textViewer = customViewerCreator != null ? customViewerCreator.create(this.cParent, this.node, this.getContext()) : this.createDefaultViewer();
        if (StringUtils.isNotBlank((CharSequence)this.attributeHelper.getPlaceholder())) {
            new StyledTextMessage(textViewer.getTextWidget(), this.attributeHelper.getPlaceholder());
        }
        return textViewer;
    }

    protected TextViewer createDefaultViewer() {
        Object viewer;
        int viewerStyles;
        int n = viewerStyles = !this.getHelper().isTextArea() ? 2052 : 2818;
        if (this.attributeHelper.isSupportsExpressions()) {
            viewer = new MELViewer(this.cParent, (IObjectRef<EvaluatorExtensionConfiguration>)((IObjectRef)() -> new AutocompleteConfiguration(this.node, this.context.getMuleConfiguration(), this.context.getProject(), this)), viewerStyles);
        } else {
            viewer = new SourceViewer(this.cParent, null, viewerStyles);
            viewer.setDocument((IDocument)new Document());
            WidgetUtils.addUndoAndRedoCapability((TextViewer)viewer);
        }
        if (StringUtils.isNotBlank((CharSequence)this.attributeHelper.getPlaceholder())) {
            new StyledTextMessage(viewer.getTextWidget(), this.attributeHelper.getPlaceholder());
        }
        return viewer;
    }

    public boolean isActivePopup() {
        return this.attributeHelper.isSupportsExpressions() ? ((MELViewer)this.scriptViewer).isActivePopup() : false;
    }

    private void addModificationListeners(TextViewer scriptViewer) {
        if (this.supportExpressions()) {
            scriptViewer.getTextWidget().addVerifyListener((VerifyListener)new PasteActionListener());
        }
        IDocumentListener callback = new IDocumentListener(){

            public void documentAboutToBeChanged(DocumentEvent event) {
            }

            public void documentChanged(DocumentEvent event) {
                StringFieldEditor.this.doValidate();
                StringFieldEditor.this.notifyObservers();
            }
        };
        scriptViewer.getDocument().addDocumentListener((IDocumentListener)new IdleDocumentEventListener(callback, scriptViewer.getControl()));
    }

    @Override
    public void validate() {
        super.validate();
        if (this.attributeHelper.isSupportsExpressions()) {
            new MELValidator(this.getParentPage().getMuleProject()).validateAsync(this.scriptViewer.getDocument(), this.getContext().getMuleConfiguration(), this.getNode(), new MELValidator.IStatusCallback(){

                @Override
                public void onResult(IStatus validationResult) {
                    PlatformUI.getWorkbench().getDisplay().asyncExec((Runnable)new ValidationResultCallback(validationResult, StringFieldEditor.this));
                }
            });
        }
    }

    protected void popupClosed() {
    }

    protected void popupOpened() {
    }

    protected String getDefaultEvaluator() {
        return null;
    }

    protected StyleRange[] doHighlight(LineStyleEvent event) {
        HighlighterImpl im = new HighlighterImpl(this.context.getVersion());
        StyleRange[] highlightInsideExpresssion = im.highlightInsideExpresssion(0, event.lineText);
        return highlightInsideExpresssion;
    }

    @Override
    protected void switchFromExpression() {
    }

    @Override
    public String getLiteralValue() {
        if (this.scriptViewer != null && this.scriptViewer.getDocument() != null) {
            return this.scriptViewer.getDocument().get();
        }
        return "";
    }

    @Override
    public void setLiteralValue(String value) {
        try {
            this.scriptViewer.getDocument().set(value);
            this.scriptViewer.refresh();
        }
        catch (IllegalArgumentException ex) {
            ex.printStackTrace();
        }
    }

    @Override
    public void hide() {
        this.initControls();
        this.layoutData = new Object[this.controls.length];
        int i = 0;
        while (i < this.controls.length) {
            if (this.controls[i] != null && this.controls[i].getLayoutData() != null) {
                GridData gridData = (GridData)this.controls[i].getLayoutData();
                this.layoutData[i] = GridDataFactory.copyData((GridData)gridData);
                this.controls[i].setLayoutData((Object)GridDataFactory.fillDefaults().align(16384, 128).hint(1, 1).grab(false, false).create());
            }
            ++i;
        }
        this.hidden = true;
    }

    @Override
    public void show() {
        this.initControls();
        if (this.layoutData != null) {
            int i = this.controls.length - 1;
            while (i >= 0) {
                if (this.controls[i] != null) {
                    this.controls[i].setLayoutData((Object)GridDataFactory.copyData((GridData)((GridData)this.layoutData[i])));
                }
                --i;
            }
        }
        this.hidden = false;
    }

    private void initControls() {
        this.controls = new Control[]{this.label, this.internalControl, this.control, this.browse, this.createdLabel};
    }

    @Override
    public boolean isHidden() {
        return this.hidden;
    }

    @Override
    protected boolean shouldReportErrorMessage() {
        return true;
    }

    public ExpressionWidget getExpressionWidget() {
        return this.expressionWidget;
    }

    protected StyledText getTextWidget() {
        return this.scriptViewer.getTextWidget();
    }

    public void addTraverseListener(TraverseListener traverseListener) {
        this.getTextWidget().addTraverseListener(traverseListener);
    }

    public void setFocus() {
        this.getTextWidget().setFocus();
    }

    @Override
    protected void setInternalControlEnabled(boolean enabled) {
        super.setInternalControlEnabled(enabled);
        this.changeVisualState(enabled);
    }

    private void changeVisualState(boolean enabled) {
        this.getTextWidget().setEnabled(enabled);
        this.getTextWidget().setBackground(enabled ? ThemeUtils.getCurrentTheme().getListBackgroundColor() : ThemeUtils.getCurrentTheme().getWidgetBackgroundColor());
    }

    @Override
    public void addModificationListener(IEditorValueModifiedListener listener) {
        this.getValueModifiedListeners().add(listener);
    }

    private void notifyObservers() {
        for (IEditorValueModifiedListener valueModifiedListener : this.getValueModifiedListeners()) {
            valueModifiedListener.valueModified(this.getValue());
        }
    }

    private Set<IEditorValueModifiedListener> getValueModifiedListeners() {
        if (this.valueModifiedListeners == null) {
            this.valueModifiedListeners = new HashSet<IEditorValueModifiedListener>();
        }
        return this.valueModifiedListeners;
    }

    @Override
    public void refreshEditor(String newValue, boolean shouldNotifyObservers) {
        IValueCalculator calculator = this.getHelper().getCalculator();
        if (calculator != null) {
            this.setValue(calculator.value(newValue, this, this.node));
        }
    }

    @Override
    public void postInitLoadFrom(IMessageFlowNode node, PropertyCollectionMap props) {
        super.postInitLoadFrom(node, props);
        this.setNode(node);
    }

    @Override
    public void accept(IFieldEditorVisitor visitor) {
        visitor.visit(this);
    }

    public boolean hasListenerMatching(Predicate<IEditorValueModifiedListener> predicate) {
        return this.getValueModifiedListeners().stream().anyMatch(predicate);
    }

    private final class PasteActionListener
    implements VerifyListener {
        private PasteActionListener() {
        }

        public void verifyText(VerifyEvent event) {
            String pasted = event.text;
            if (ScriptUtils.isScript((String)pasted)) {
                Display.getCurrent().asyncExec(() -> StringFieldEditor.this.switchToExpression());
            }
        }
    }

    private static final class StyledTextMessage {
        private static final int MARGIN = 2;
        private final int[] INVALIDATE_EVENTS = new int[]{26, 27, 22, 23};
        private StyledText styledText;
        private final Listener invalidateListener;
        private final Color textColor;
        private String message;
        private int verticalOffsetLines;

        public StyledTextMessage(final StyledText styledText, String message) {
            this.styledText = Objects.requireNonNull(styledText);
            this.invalidateListener = new Listener(){

                public void handleEvent(Event event) {
                    styledText.redraw();
                }
            };
            this.textColor = this.getTextColor();
            this.message = message;
            this.initialize();
        }

        public boolean isMessageShowing() {
            return !this.message.isEmpty() && this.styledText.getContent().getCharCount() == 0;
        }

        private void initialize() {
            this.styledText.addListener(9, this::handlePaintEvent);
            this.styledText.addListener(11, event -> this.styledText.redraw());
            this.styledText.addListener(12, this::handleDispose);
            int[] nArray = this.INVALIDATE_EVENTS;
            int n = this.INVALIDATE_EVENTS.length;
            int n2 = 0;
            while (n2 < n) {
                int eventType = nArray[n2];
                this.styledText.getDisplay().addFilter(eventType, this.invalidateListener);
                ++n2;
            }
        }

        private Color getTextColor() {
            return this.styledText.getDisplay().getSystemColor(15);
        }

        private void handlePaintEvent(Event event) {
            if (this.isMessageShowing()) {
                this.drawHint(event.gc, event.x, event.y);
            }
        }

        private void handleDispose(Event event) {
            int[] nArray = this.INVALIDATE_EVENTS;
            int n = this.INVALIDATE_EVENTS.length;
            int n2 = 0;
            while (n2 < n) {
                int eventType = nArray[n2];
                this.styledText.getDisplay().removeFilter(eventType, this.invalidateListener);
                ++n2;
            }
            this.styledText = null;
        }

        private void drawHint(GC gc, int x, int y) {
            int verticalOffset = this.verticalOffsetLines * gc.getFontMetrics().getHeight();
            gc.setForeground(this.textColor);
            gc.drawText(this.message, x + 2, y + 2 - verticalOffset, 3);
        }
    }

    private static final class ValidationResultCallback
    implements Runnable {
        private final IStatus validationResult;
        private final StringFieldEditor editor;

        private ValidationResultCallback(IStatus validationResult, StringFieldEditor editor) {
            this.validationResult = validationResult;
            this.editor = editor;
        }

        @Override
        public void run() {
            if (!this.editor.isDisposed() && !Status.OK_STATUS.equals(this.validationResult)) {
                this.editor.setError(this.validationResult.getMessage());
                this.editor.validateParent();
            }
        }
    }
}

