/*
 * Decompiled with CFR 0.152.
 */
package org.mule.tooling.ui.modules.core.widgets.editors;

import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.mule.tooling.ui.modules.core.widgets.AttributeContext;
import org.mule.tooling.ui.modules.core.widgets.IFieldEditorVisitor;
import org.mule.tooling.ui.modules.core.widgets.editors.LabelledFieldEditor;
import org.mule.tooling.ui.modules.core.widgets.editors.MultipleSelectionsCombo;
import org.mule.tooling.ui.modules.core.widgets.meta.AttributeHelper;
import org.mule.tooling.ui.modules.core.widgets.meta.EnumOption;
import org.mule.tooling.ui.modules.core.widgets.meta.SetAttributeHelper;

public final class SetFieldEditor
extends LabelledFieldEditor {
    final MultipleSelectionsCombo cc;
    final List<String> items;
    final List<String> values;

    public SetFieldEditor(AttributeContext ctx, AttributeHelper atr, Composite parent) {
        super(ctx, atr, parent);
        Composite mainComposite = (Composite)this.control;
        SetAttributeHelper setHelper = (SetAttributeHelper)atr;
        List<EnumOption> options = setHelper.getOptions();
        this.items = new ArrayList<String>();
        this.values = new ArrayList<String>();
        for (EnumOption option : options) {
            this.items.add(option.caption);
            this.values.add(option.value);
        }
        this.cc = MultipleSelectionsCombo.create(mainComposite, atr.getDescription(), this.items);
    }

    @Override
    protected Control internalCreateControl(Composite parent) {
        return this.createMainComposite(parent);
    }

    private Control createMainComposite(Composite parent) {
        Composite mainComposite = new Composite(parent, 0x1000000);
        mainComposite.setLayout((Layout)new FillLayout());
        return mainComposite;
    }

    @Override
    public String getValue() {
        SetAttributeHelper setHelper = (SetAttributeHelper)this.attributeHelper;
        String delimiter = setHelper.getDelimiter();
        boolean[] selected = this.cc.getSelected();
        List<EnumOption> options = setHelper.getOptions();
        StringBuilder sb = new StringBuilder();
        int i = 0;
        while (i < selected.length) {
            if (selected[i]) {
                if (sb.length() != 0) {
                    sb.append(delimiter);
                }
                sb.append(options.get((int)i).value);
            }
            ++i;
        }
        return sb.toString();
    }

    public static List<String> split(String orig, String delimiter) {
        int index;
        LinkedList<String> result = new LinkedList<String>();
        String tail = orig;
        do {
            if ((index = tail.indexOf(delimiter)) != -1) {
                result.add(tail.substring(0, index));
                tail = tail.substring(index + delimiter.length());
                continue;
            }
            result.add(tail);
        } while (index != -1);
        return result;
    }

    @Override
    public void setValue(String value) {
        SetAttributeHelper setHelper = (SetAttributeHelper)this.attributeHelper;
        String delimiter = setHelper.getDelimiter();
        boolean[] selected = this.cc.getSelected();
        List<String> selectedValues = SetFieldEditor.split(value, delimiter);
        int i = 0;
        while (i < selectedValues.size()) {
            selectedValues.set(i, selectedValues.get(i).trim());
            ++i;
        }
        for (String v : selectedValues) {
            int index = this.values.indexOf(v);
            if (index == -1 || selected[index]) continue;
            this.cc.switchItem(index);
        }
        this.cc.refresh();
    }

    @Override
    public void accept(IFieldEditorVisitor visitor) {
        visitor.visit(this);
    }
}

