/*
 * Decompiled with CFR 0.152.
 */
package org.mule.tooling.ui.modules.core.widgets.editors;

import java.util.HashSet;
import java.util.Set;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.jface.layout.GridLayoutFactory;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;
import org.mule.tooling.core.utils.CoreUtils;
import org.mule.tooling.ui.modules.core.widgets.AttributeContext;
import org.mule.tooling.ui.modules.core.widgets.IEditorValueModifiedListener;
import org.mule.tooling.ui.modules.core.widgets.IEditorValueModifiedObservable;
import org.mule.tooling.ui.modules.core.widgets.IFieldEditorVisitor;
import org.mule.tooling.ui.modules.core.widgets.editors.LabelledFieldEditor;
import org.mule.tooling.ui.modules.core.widgets.meta.AttributeHelper;
import org.mule.tooling.ui.widgets.listener.IdleModifyEventListener;

public class ResourceFieldEditor
extends LabelledFieldEditor
implements IEditorValueModifiedObservable {
    private Composite cParent;
    private Text text;
    private IResource selectedResource;
    private Set<IEditorValueModifiedListener> valueModifiedListeners;

    public Control getText() {
        return this.text;
    }

    public void setText(Text text) {
        this.text = text;
    }

    public ResourceFieldEditor(AttributeContext ctx, AttributeHelper atr, Composite parent) {
        super(ctx, atr, parent);
    }

    @Override
    protected Control getInfoDecorationControl() {
        return this.text;
    }

    @Override
    protected Control internalCreateControl(Composite parent) {
        this.cParent = new Composite(parent, 0);
        this.cParent.setLayout((Layout)GridLayoutFactory.fillDefaults().numColumns(2).create());
        this.cParent.setLayoutData((Object)GridDataFactory.fillDefaults().create());
        this.text = new Text(this.cParent, 2048);
        this.text.setLayoutData((Object)GridDataFactory.fillDefaults().align(4, 0x1000000).grab(true, false).create());
        ModifyListener listener = new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                ResourceFieldEditor.this.doValidate();
                ResourceFieldEditor.this.notifyObservers();
            }
        };
        this.text.addModifyListener((ModifyListener)new IdleModifyEventListener(listener, (Control)this.text));
        return this.cParent;
    }

    @Override
    protected void createExtraContent(Composite parent) {
        if (this.getHelper().getValueFactory() != null) {
            Button browse = new Button(this.cParent, 0);
            browse.setText("...");
            browse.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent e) {
                    ResourceFieldEditor.this.manageSelectionChange();
                }
            });
            browse.setLayoutData((Object)GridDataFactory.fillDefaults().grab(false, false).create());
        }
    }

    @Override
    protected GridData getLayoutData() {
        boolean hasButton = this.attributeHelper.getValueFactory() != null;
        GridData create = GridDataFactory.fillDefaults().grab(true, false).span(hasButton ? 2 : 3, 1).hint(200, -1).create();
        return create;
    }

    private void manageSelectionChange() {
        Object object = this.attributeHelper.getValueFactory().getValue(this.context);
        if (object instanceof IResource) {
            IResource selectedResource = (IResource)object;
            this.setSelectedResource(selectedResource);
            IProject project = this.context.getProject().getProject();
            String path = CoreUtils.generateRelativePath((IProject)project, (IResource)selectedResource);
            this.setValue(path);
        }
    }

    @Override
    public String getValue() {
        return this.text.getText();
    }

    @Override
    public void setValue(String value) {
        this.text.setText(value);
        this.notifyObservers();
    }

    public IResource getSelectedResource() {
        return this.selectedResource;
    }

    public void setSelectedResource(IResource selectedResource) {
        this.selectedResource = selectedResource;
    }

    @Override
    public void addModificationListener(IEditorValueModifiedListener listener) {
        this.getValueModifiedListeners().add(listener);
    }

    private void notifyObservers() {
        for (IEditorValueModifiedListener valueModifiedListener : this.getValueModifiedListeners()) {
            valueModifiedListener.valueModified(this.getValue());
        }
    }

    private Set<IEditorValueModifiedListener> getValueModifiedListeners() {
        if (this.valueModifiedListeners == null) {
            this.valueModifiedListeners = new HashSet<IEditorValueModifiedListener>();
        }
        return this.valueModifiedListeners;
    }

    @Override
    public void accept(IFieldEditorVisitor visitor) {
        visitor.visit(this);
    }
}

