/*
 * Decompiled with CFR 0.152.
 */
package org.mule.tooling.ui.modules.core.widgets.editors;

import java.util.List;
import java.util.function.Function;
import org.apache.commons.lang.StringUtils;
import org.mule.tooling.core.MuleCorePlugin;
import org.mule.tooling.core.model.IMuleProject;
import org.mule.tooling.messageflow.module.MessageFlowNodeComposite;
import org.mule.tooling.messageflow.util.MessageFlowUtils;
import org.mule.tooling.metadata.utils.MetadataUtils;
import org.mule.tooling.model.messageflow.IMessageFlowNode;
import org.mule.tooling.model.messageflow.MuleConfiguration;
import org.mule.tooling.model.messageflow.decorator.PropertyCollectionMap;
import org.mule.tooling.ui.modules.core.metadata.MetadataHelpers;
import org.mule.tooling.ui.modules.core.widgets.AttributesPropertyPage;
import org.mule.tooling.ui.modules.core.widgets.editors.EditorHelper;
import org.mule.tooling.ui.modules.core.widgets.editors.IButtonEnablement;
import org.mule.tooling.ui.modules.core.widgets.meta.AttributeHelper;

public class RefreshTypesButtonEnablement
implements IButtonEnablement {
    @Override
    public boolean isEnabled(AttributeHelper attributeHelper, AttributesPropertyPage parentPage) {
        if (parentPage != null) {
            IMessageFlowNode nodeWithOldProperties = parentPage.getMessageFlowNode();
            List<MessageFlowNodeComposite> pages = EditorHelper.getAllCurrentEditorPages(parentPage);
            IMessageFlowNode nodeWithNewProperties = (IMessageFlowNode)MessageFlowUtils.generateNodeToTestSupplier((IMessageFlowNode)nodeWithOldProperties).get();
            Function updatedPropertiesProvider = MessageFlowUtils.updatedPropertiesProvider(pages);
            nodeWithNewProperties.setProperties(((PropertyCollectionMap)updatedPropertiesProvider.apply(nodeWithNewProperties)).asPropertyCollection());
            String configReferenceName = MetadataUtils.getGlobalReference((IMessageFlowNode)nodeWithNewProperties);
            if (StringUtils.isNotBlank((String)configReferenceName)) {
                MuleConfiguration muleConfiguration = parentPage.getContext().getMuleConfiguration();
                IMuleProject muleProject = MuleCorePlugin.getDesignContext().getMuleProject();
                return MetadataHelpers.configUsesMetadata(muleConfiguration, muleProject, configReferenceName);
            }
        }
        return false;
    }
}

