/*
 * Decompiled with CFR 0.152.
 */
package org.mule.tooling.ui.modules.core.widgets.editors;

import java.util.ArrayList;
import java.util.Collection;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.mule.tooling.model.messageflow.decorator.PropertyCollectionMap;
import org.mule.tooling.ui.modules.core.widgets.AttributeContext;
import org.mule.tooling.ui.modules.core.widgets.IFieldEditorVisitor;
import org.mule.tooling.ui.modules.core.widgets.editors.AbstractFieldEditor;
import org.mule.tooling.ui.modules.core.widgets.meta.AttributeHelper;
import org.mule.tooling.ui.modules.core.widgets.meta.EnumHelper;
import org.mule.tooling.ui.modules.core.widgets.meta.EnumOption;
import org.mule.tooling.ui.modules.core.widgets.meta.RadioButtonsAtr;

public class RadioGroupFieldEditor
extends AbstractFieldEditor {
    String value;
    ArrayList<Button> bm;

    public RadioGroupFieldEditor(AttributeContext ctx, AttributeHelper atr, Composite parent) {
        super(ctx, atr, parent);
    }

    @Override
    protected Control createControl(Composite parent) {
        this.bm = new ArrayList();
        Composite st = new Composite(parent, 0);
        GridLayout layout = new GridLayout();
        layout.marginWidth = 0;
        layout.marginHeight = 0;
        st.setLayout((Layout)layout);
        RadioButtonsAtr mm = (RadioButtonsAtr)this.attributeHelper;
        EnumHelper ss = (EnumHelper)this.attributeHelper;
        Collection<EnumOption> options = ss.getOptions();
        if (this.attributeHelper instanceof EnumHelper && ((EnumHelper)this.attributeHelper).isShowLabel()) {
            Label label = new Label(st, 0);
            label.setText(this.attributeHelper.getCaption());
        }
        for (final EnumOption o : options) {
            Button bs = new Button(st, 16);
            bs.setText(o.caption);
            this.bm.add(bs);
            if (o.value != null && o.value.equals(this.attributeHelper.getDefaultValue())) {
                bs.setSelection(true);
                this.value = this.attributeHelper.getDefaultValue().toString();
            }
            if (mm.isHorizontal()) {
                ++layout.numColumns;
            }
            bs.setData((Object)o.value);
            bs.addSelectionListener(new SelectionListener(){

                public void widgetSelected(SelectionEvent e) {
                    RadioGroupFieldEditor.this.value = o.value;
                    RadioGroupFieldEditor.this.validate();
                }

                public void widgetDefaultSelected(SelectionEvent e) {
                }
            });
        }
        st.setLayoutData((Object)GridDataFactory.fillDefaults().grab(true, false).span(3, 1).create());
        return st;
    }

    @Override
    public String getValue() {
        return this.value;
    }

    @Override
    public void setValue(String value) {
        this.value = value;
        for (Button b : this.bm) {
            b.setSelection(b.getData() != null && b.getData().equals(value));
        }
        this.validate();
    }

    @Override
    protected boolean shouldInitDefaultProperty(PropertyCollectionMap props, AttributeHelper helper) {
        return true;
    }

    @Override
    public void accept(IFieldEditorVisitor visitor) {
        visitor.visit(this);
    }
}

