/*
 * Decompiled with CFR 0.152.
 */
package org.mule.tooling.ui.modules.core.widgets.editors;

import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.mule.tooling.model.messageflow.IMessageFlowNode;
import org.mule.tooling.model.messageflow.decorator.PropertyCollectionMap;
import org.mule.tooling.ui.modules.core.widgets.AttributeContext;
import org.mule.tooling.ui.modules.core.widgets.IFieldEditorVisitor;
import org.mule.tooling.ui.modules.core.widgets.editors.BooleanFieldEditor;
import org.mule.tooling.ui.modules.core.widgets.editors.ChildElementFieldEditor;
import org.mule.tooling.ui.modules.core.widgets.editors.RadioBooleanAttributeHelper;
import org.mule.tooling.ui.modules.core.widgets.meta.AttributeGroup;
import org.mule.tooling.ui.modules.core.widgets.meta.AttributeHelper;

public final class RadioBooleanEditor
extends BooleanFieldEditor {
    private static final Map<String, List<RadioBooleanEditor>> radioGroups = new HashMap<String, List<RadioBooleanEditor>>();
    private final boolean transient0;
    private final String groupId;

    public RadioBooleanEditor(AttributeContext ctx, AttributeHelper atr, Composite parent, AttributeGroup agroup) {
        super(ctx, atr, RadioBooleanEditor.addLabel(atr, parent));
        Object groupPostfix;
        if (atr instanceof RadioBooleanAttributeHelper) {
            RadioBooleanAttributeHelper a = (RadioBooleanAttributeHelper)atr;
            this.transient0 = a.isTransient();
            groupPostfix = a.getRadioGroup() != null ? "@" + a.getRadioGroup() : "";
        } else {
            this.transient0 = false;
            groupPostfix = "";
        }
        String groupPrefix = ChildElementFieldEditor.getGroupPrefix();
        this.groupId = groupPrefix + agroup.getId() + (String)groupPostfix;
        if (!radioGroups.containsKey(this.groupId)) {
            radioGroups.put(this.groupId, new LinkedList());
        }
        final List<RadioBooleanEditor> group = radioGroups.get(this.groupId);
        LinkedList<RadioBooleanEditor> trash = new LinkedList<RadioBooleanEditor>();
        for (RadioBooleanEditor otherButton : group) {
            if (!otherButton.button.isDisposed()) continue;
            trash.add(otherButton);
        }
        for (RadioBooleanEditor toRemove : trash) {
            group.remove(toRemove);
        }
        group.add(this);
        this.button.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                for (RadioBooleanEditor otherButton : group) {
                    if (otherButton == RadioBooleanEditor.this || otherButton.getControl().isDisposed() || otherButton.getControl().getShell() != RadioBooleanEditor.this.getControl().getShell() || otherButton.button.isDisposed() || !otherButton.button.getSelection()) continue;
                    otherButton.button.setSelection(false);
                    otherButton.support.firePropertyChange("value", true, false);
                }
            }
        });
    }

    private static Composite addLabel(AttributeHelper atr, Composite parent) {
        String labelledWith = RadioBooleanEditor.getLabelledWith(atr);
        boolean fillLine = RadioBooleanEditor.isFillLine(atr);
        Integer margin = RadioBooleanEditor.getMargin(atr);
        int nColumns = labelledWith != null ? 2 : 1;
        Composite composite = new Composite(parent, 0);
        GridData compositeLayoutData = new GridData();
        GridLayout compositeLayout = new GridLayout(nColumns, true);
        compositeLayout.horizontalSpacing = 0;
        compositeLayout.verticalSpacing = 0;
        compositeLayout.marginHeight = 0;
        compositeLayout.marginTop = margin == null ? (fillLine ? 0 : -5) : margin;
        compositeLayout.marginBottom = 0;
        compositeLayout.marginWidth = 0;
        compositeLayout.marginLeft = 0;
        compositeLayout.marginRight = 0;
        compositeLayoutData.horizontalSpan = fillLine ? 3 : 1;
        compositeLayoutData.horizontalAlignment = 4;
        compositeLayoutData.grabExcessHorizontalSpace = false;
        composite.setLayoutData((Object)compositeLayoutData);
        composite.setLayout((Layout)compositeLayout);
        if (labelledWith != null) {
            Label label = new Label(composite, 0);
            GridData labelData = new GridData();
            labelData.horizontalSpan = 1;
            labelData.horizontalIndent = 0;
            labelData.verticalIndent = 10;
            labelData.grabExcessHorizontalSpace = true;
            label.setLayoutData((Object)labelData);
            label.setText(labelledWith);
        }
        return composite;
    }

    private static Integer getMargin(AttributeHelper atr) {
        if (atr instanceof RadioBooleanAttributeHelper) {
            RadioBooleanAttributeHelper a = (RadioBooleanAttributeHelper)atr;
            return a.getMargin();
        }
        return null;
    }

    private static boolean isFillLine(AttributeHelper atr) {
        if (atr instanceof RadioBooleanAttributeHelper) {
            RadioBooleanAttributeHelper a = (RadioBooleanAttributeHelper)atr;
            return a.isFillLine();
        }
        return false;
    }

    private static String getLabelledWith(AttributeHelper atr) {
        if (atr instanceof RadioBooleanAttributeHelper) {
            RadioBooleanAttributeHelper a = (RadioBooleanAttributeHelper)atr;
            String labelledWith = a.getLabelledWith();
            return labelledWith;
        }
        return null;
    }

    @Override
    protected int getStyle() {
        return 16;
    }

    @Override
    protected boolean shouldInitDefaultProperty(PropertyCollectionMap props, AttributeHelper helper) {
        return false;
    }

    @Override
    public void loadFrom(IMessageFlowNode node, PropertyCollectionMap props) {
        super.loadFrom(node, props);
    }

    @Override
    public void saveTo(IMessageFlowNode node, PropertyCollectionMap props) {
        if (!this.transient0) {
            super.saveTo(node, props);
        } else {
            props.addProperty(this.attributeHelper.getId(), this.getValue());
        }
    }

    @Override
    public void validate() {
        if (!this.transient0) {
            super.validate();
        }
    }

    @Override
    public void accept(IFieldEditorVisitor visitor) {
        visitor.visit(this);
    }

    public static void clearCached() {
        radioGroups.clear();
    }
}

