/*
 * Decompiled with CFR 0.152.
 */
package org.mule.tooling.ui.modules.core.widgets.editors;

import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.jface.layout.GridLayoutFactory;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.events.TraverseListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Text;
import org.mule.tooling.ui.modules.core.widgets.AttributeContext;
import org.mule.tooling.ui.modules.core.widgets.IFieldEditorVisitor;
import org.mule.tooling.ui.modules.core.widgets.editors.IStealth;
import org.mule.tooling.ui.modules.core.widgets.editors.LabelledFieldEditor;
import org.mule.tooling.ui.modules.core.widgets.meta.AttributeHelper;
import org.mule.tooling.ui.widgets.util.ThemeUtils;

public class PasswordFieldEditor
extends LabelledFieldEditor
implements IStealth {
    private Composite cParent;
    private boolean hidden = false;
    private Object[] layoutData = null;
    private Control[] controls = null;
    private Text text;
    private Button checkbox;

    public PasswordFieldEditor(AttributeContext ctx, AttributeHelper atr, Composite parent) {
        super(ctx, atr, parent);
    }

    protected boolean isMultiline() {
        return false;
    }

    @Override
    protected Control getInfoDecorationControl() {
        return this.getTextWidget();
    }

    @Override
    protected Control internalCreateControl(Composite parent) {
        this.cParent = new Composite(parent, 0);
        GridLayoutFactory.fillDefaults().numColumns(3).equalWidth(false).applyTo(this.cParent);
        GridDataFactory.fillDefaults().align(4, 4).grab(true, false).applyTo((Control)this.cParent);
        this.text = new Text(this.cParent, 2052);
        this.text.setEchoChar('\u25cf');
        GridDataFactory.fillDefaults().align(4, 4).grab(true, false).span(2, 1).applyTo((Control)this.getTextWidget());
        this.checkbox = new Button(this.cParent, 32);
        this.checkbox.setText("Show password");
        ThemeUtils.setCssClass((Object)this.checkbox, (String)"CheckBoxButton");
        GridDataFactory.fillDefaults().align(4, 4).grab(false, false).applyTo((Control)this.checkbox);
        this.checkbox.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                if (PasswordFieldEditor.this.checkbox.getSelection()) {
                    PasswordFieldEditor.this.text.setEchoChar('\u0000');
                } else {
                    PasswordFieldEditor.this.text.setEchoChar('\u25cf');
                }
            }
        });
        this.text.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                PasswordFieldEditor.this.validate();
            }
        });
        return this.cParent;
    }

    @Override
    public void validate() {
        super.validate();
        this.validateParent();
    }

    @Override
    protected void switchToExpression() {
    }

    protected String getDefaultEvaluator() {
        return null;
    }

    @Override
    protected void switchFromExpression() {
    }

    @Override
    public String getValue() {
        return this.text.getText();
    }

    @Override
    public void setValue(String value) {
        this.text.setText(value);
    }

    @Override
    public void hide() {
        this.initControls();
        this.layoutData = new Object[this.controls.length];
        int i = 0;
        while (i < this.controls.length) {
            if (this.controls[i] != null && this.controls[i].getLayoutData() != null) {
                GridData gridData = (GridData)this.controls[i].getLayoutData();
                this.layoutData[i] = GridDataFactory.copyData((GridData)gridData);
                this.controls[i].setLayoutData((Object)GridDataFactory.fillDefaults().align(16384, 128).hint(1, 1).grab(false, false).create());
            }
            ++i;
        }
        this.hidden = true;
    }

    @Override
    public void show() {
        this.initControls();
        if (this.layoutData != null) {
            int i = this.controls.length - 1;
            while (i >= 0) {
                if (this.controls[i] != null) {
                    this.controls[i].setLayoutData((Object)GridDataFactory.copyData((GridData)((GridData)this.layoutData[i])));
                }
                --i;
            }
        }
        this.hidden = false;
    }

    private void initControls() {
        this.controls = new Control[]{this.label, this.internalControl, this.control, this.browse, this.createdLabel};
    }

    @Override
    public boolean isHidden() {
        return this.hidden;
    }

    @Override
    protected boolean shouldReportErrorMessage() {
        return true;
    }

    protected Text getTextWidget() {
        return this.text;
    }

    public void addTraverseListener(TraverseListener traverseListener) {
        this.getTextWidget().addTraverseListener(traverseListener);
    }

    public void setFocus() {
        this.getTextWidget().setFocus();
    }

    @Override
    public void setEnabled(boolean isEnabled) {
        super.setEnabled(isEnabled);
        this.getTextWidget().setEnabled(isEnabled);
        this.getTextWidget().setBackground(isEnabled ? Display.getCurrent().getSystemColor(1) : Display.getCurrent().getSystemColor(22));
    }

    @Override
    public void accept(IFieldEditorVisitor visitor) {
        visitor.visit(this);
    }
}

