/*
 * Decompiled with CFR 0.152.
 */
package org.mule.tooling.ui.modules.core.widgets.editors;

import java.util.ArrayList;
import org.apache.commons.lang.StringUtils;
import org.eclipse.jface.viewers.ITableLabelProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.swt.graphics.Image;
import org.mule.tooling.ui.widgets.WidgetsImages;
import org.mule.tooling.ui.widgets.table.MapTableComposite;

public class PairLabelProvider
extends LabelProvider
implements ITableLabelProvider {
    private MapTableComposite table;

    public PairLabelProvider(MapTableComposite table) {
        this.table = table;
    }

    public Image getColumnImage(Object element, int columnIndex) {
        MapTableComposite.Pair pair = (MapTableComposite.Pair)element;
        String key = pair.getKey();
        if (StringUtils.isBlank((String)key) && StringUtils.isBlank((String)pair.getValue())) {
            return null;
        }
        StructuredSelection selection = (StructuredSelection)this.table.getTableViewer().getSelection();
        boolean isEditing = selection != null && !selection.isEmpty() && selection.getFirstElement().equals(pair);
        switch (columnIndex) {
            case 0: {
                ArrayList list = (ArrayList)this.table.getTableViewer().getInput();
                int keys = (int)list.stream().filter(p -> p.getKey().equals(key)).count();
                if (keys <= 1 && (!StringUtils.isBlank((String)key) || isEditing)) break;
                return WidgetsImages.getImage((String)"icons/errors/warning.png");
            }
            default: {
                if (!StringUtils.isBlank((String)pair.getValue()) || isEditing) break;
                return WidgetsImages.getImage((String)"icons/errors/warning.png");
            }
        }
        return null;
    }

    public String getColumnText(Object element, int columnIndex) {
        if (element instanceof MapTableComposite.Pair) {
            switch (columnIndex) {
                case 0: {
                    return ((MapTableComposite.Pair)element).getKey();
                }
            }
            return ((MapTableComposite.Pair)element).getValue();
        }
        return null;
    }
}

