/*
 * Decompiled with CFR 0.152.
 */
package org.mule.tooling.ui.modules.core.widgets.editors;

import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import org.eclipse.jface.text.Document;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.TextViewer;
import org.eclipse.swt.custom.StyledText;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Listener;
import org.mule.tooling.model.messageflow.CompartmentLane;
import org.mule.tooling.model.messageflow.Container;
import org.mule.tooling.model.messageflow.IMessageFlowEntity;
import org.mule.tooling.model.messageflow.IMessageFlowNode;
import org.mule.tooling.model.messageflow.IReadOnlyProperty;
import org.mule.tooling.model.messageflow.IReadOnlyPropertyCollection;
import org.mule.tooling.model.messageflow.MessageFlowNode;
import org.mule.tooling.model.messageflow.MuleConfiguration;
import org.mule.tooling.model.messageflow.util.PropertiesUtils;
import org.mule.tooling.model.module.NodeDefinition;
import org.mule.tooling.ui.modules.core.widgets.AttributeContext;
import org.mule.tooling.ui.modules.core.widgets.editors.StringFieldEditor;
import org.mule.tooling.ui.modules.core.widgets.meta.AttributeHelper;
import org.mule.tooling.ui.modules.core.widgets.meta.NameEditorsStackContainer;
import org.mule.tooling.ui.modules.core.widgets.meta.creators.AttributeReader;

public final class NameFieldEditor
extends StringFieldEditor {
    public NameFieldEditor(AttributeContext ctx, AttributeHelper atr, Composite parent) {
        super(ctx, atr, parent, null);
    }

    protected String getName(MessageFlowNode value2) {
        IReadOnlyPropertyCollection properties = value2.getProperties();
        if (properties != null) {
            IReadOnlyProperty property = PropertiesUtils.findPropertyReadOnlyByName((List)properties.getProperties(), (String)"name");
            return property != null ? property.getValue() : "";
        }
        return "";
    }

    @Override
    protected TextViewer createDefaultViewer() {
        TextViewer defaultViewer = new TextViewer(this.cParent, 2052);
        Document document = new Document();
        defaultViewer.setDocument((IDocument)document);
        final Control control2 = defaultViewer.getControl();
        final Listener verifyListener = new Listener(){

            public void handleEvent(Event event) {
                String currentText = ((StyledText)event.widget).getText();
                String newText = event.text;
                String newString = currentText.substring(0, event.start) + newText + currentText.substring(event.end, currentText.length());
                if (newString.length() > 0 && newText.length() > 0 && !newString.matches("[^,;&\\s]*")) {
                    event.doit = false;
                    return;
                }
            }
        };
        control2.addListener(25, verifyListener);
        control2.addDisposeListener(new DisposeListener(){

            public void widgetDisposed(DisposeEvent e) {
                control2.removeListener(25, verifyListener);
            }
        });
        return defaultViewer;
    }

    @Override
    protected Control createControl(Composite parent) {
        final NameFieldEditor z = this;
        Control createControl = super.createControl(parent);
        createControl.addDisposeListener(new DisposeListener(){

            public void widgetDisposed(DisposeEvent e) {
                LinkedList<NameEditorsStackContainer> toRemove = new LinkedList<NameEditorsStackContainer>();
                for (NameEditorsStackContainer nesc : AttributeReader.currentNameEditorsList) {
                    if (z != nesc.editor) continue;
                    toRemove.add(nesc);
                }
                AttributeReader.currentNameEditorsList.removeAll(toRemove);
            }
        });
        return createControl;
    }

    @Override
    protected String initPropertyDefault() {
        if (this.getParentPage().getHost() != null) {
            String nameSuggestion;
            IMessageFlowNode node2 = this.getParentPage().getHost().getNode();
            if (node2 != null && (nameSuggestion = node2.getType()) != null) {
                NodeDefinition ds = this.getNode().getDefinition();
                nameSuggestion = ds.getName();
                StringBuilder bld = new StringBuilder();
                int a = 0;
                while (a < nameSuggestion.length()) {
                    char charAt = nameSuggestion.charAt(a);
                    if (Character.isJavaIdentifierPart(charAt)) {
                        bld.append(charAt);
                    } else {
                        bld.append('_');
                    }
                    ++a;
                }
                nameSuggestion = bld.toString();
                Set<String> usedNames = this.getUsedNames();
                if (!usedNames.contains(nameSuggestion)) {
                    return nameSuggestion;
                }
                int a2 = 1;
                while (a2 < 1000) {
                    String newSuggestion = nameSuggestion + a2;
                    if (!usedNames.contains(newSuggestion)) {
                        return newSuggestion;
                    }
                    ++a2;
                }
            }
            return "init default";
        }
        return null;
    }

    private Set<String> getUsedNames() {
        HashSet<String> usedNames = new HashSet<String>();
        for (MuleConfiguration muleConfiguration : this.context.getProject().getConfigurationsCache().getConfigurations()) {
            List globalEntries = muleConfiguration.getGlobalEntries();
            for (IMessageFlowEntity entity : globalEntries) {
                if (!(entity instanceof MessageFlowNode)) continue;
                MessageFlowNode node = (MessageFlowNode)entity;
                String name = this.getName(node);
                usedNames.add(name);
            }
        }
        MuleConfiguration currentMuleConfiguration = this.context.getMuleConfiguration();
        List flows = currentMuleConfiguration.getFlows();
        for (Container flow : flows) {
            List lanes = flow.getLanes();
            for (CompartmentLane lane : lanes) {
                List entries = lane.getCompartmentLaneEntries();
                for (IMessageFlowEntity entry : entries) {
                    if (!(entry instanceof MessageFlowNode)) continue;
                    MessageFlowNode node = (MessageFlowNode)entry;
                    String name = this.getName(node);
                    usedNames.add(name);
                }
            }
        }
        for (NameEditorsStackContainer nesc : AttributeReader.currentNameEditorsList) {
            String id;
            if (nesc.editor == this) continue;
            String string = id = this.getHelper().getSaveAs() == null || this.getHelper().getSaveAs().length() == 0 ? this.getHelper().getId() : this.getHelper().getSaveAs();
            if (!id.equals(nesc.id)) continue;
            StringFieldEditor nescEditor = (StringFieldEditor)nesc.editor;
            usedNames.add(nescEditor.getPublicValue());
        }
        return usedNames;
    }
}

