/*
 * Decompiled with CFR 0.152.
 */
package org.mule.tooling.ui.modules.core.widgets.editors;

import java.util.ArrayList;
import java.util.Collection;
import org.eclipse.swt.custom.CCombo;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.widgets.Composite;

final class MultipleSelectionsCombo {
    private final CCombo cCombo;
    private final IntProc switchItem;
    private final Runnable refresh;
    private final boolean[] selected;

    private MultipleSelectionsCombo(CCombo cCombo, IntProc switchItem, Runnable refresh, boolean[] outSelected) {
        this.cCombo = cCombo;
        this.switchItem = switchItem;
        this.refresh = refresh;
        this.selected = outSelected;
    }

    public CCombo getCCombo() {
        return this.cCombo;
    }

    public void switchItem(int index) {
        this.switchItem.apply(index);
    }

    public void refresh() {
        this.refresh.run();
    }

    public boolean[] getSelected() {
        return this.selected;
    }

    public static MultipleSelectionsCombo create(Composite parent, String tip, Collection<String> items) {
        final ArrayList<String> itemsOriginal = new ArrayList<String>(items);
        final CCombo cc = new CCombo(parent, 0x800808);
        String[] itemsArr = items.toArray(new String[0]);
        cc.setItems(itemsArr);
        cc.setToolTipText(tip);
        final boolean[] outSelected = new boolean[items.size()];
        final Runnable refresh = new Runnable(){

            @Override
            public void run() {
                StringBuilder sb = new StringBuilder();
                int i = 0;
                while (i < outSelected.length) {
                    if (outSelected[i]) {
                        if (sb.length() != 0) {
                            sb.append(", ");
                        }
                        sb.append((String)itemsOriginal.get(i));
                    }
                    ++i;
                }
                cc.setText(sb.toString());
            }
        };
        final IntProc switchItem = new IntProc(){

            @Override
            public void apply(int index) {
                boolean bl = outSelected[index] = !outSelected[index];
                if (outSelected[index]) {
                    cc.setItem(index, "[remove] " + (String)itemsOriginal.get(index));
                } else {
                    cc.setItem(index, (String)itemsOriginal.get(index));
                }
            }
        };
        cc.addSelectionListener(new SelectionListener(){

            public void widgetDefaultSelected(SelectionEvent arg0) {
            }

            public void widgetSelected(SelectionEvent se) {
                String text = cc.getText();
                String selectedItem = text.startsWith("[remove] ") ? text.substring("[remove] ".length()) : text;
                int index = itemsOriginal.indexOf(selectedItem);
                switchItem.apply(index);
                refresh.run();
            }
        });
        return new MultipleSelectionsCombo(cc, switchItem, refresh, outSelected);
    }

    private static interface IntProc {
        public void apply(int var1);
    }
}

