/*
 * Decompiled with CFR 0.152.
 */
package org.mule.tooling.ui.modules.core.widgets.editors;

import com.google.common.base.Optional;
import com.google.common.collect.Sets;
import java.beans.PropertyChangeListener;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.lang.WordUtils;
import org.apache.commons.lang3.StringUtils;
import org.eclipse.jface.fieldassist.ControlDecoration;
import org.eclipse.jface.fieldassist.FieldDecorationRegistry;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.jface.layout.GridLayoutFactory;
import org.eclipse.jface.viewers.ArrayContentProvider;
import org.eclipse.jface.viewers.ComboViewer;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.swt.custom.StackLayout;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Link;
import org.eclipse.swt.widgets.Shell;
import org.mule.tooling.core.MuleCorePlugin;
import org.mule.tooling.core.event.LayoutPropertiesEditorRequest;
import org.mule.tooling.core.model.IMuleProject;
import org.mule.tooling.core.utils.ExpressionUtils;
import org.mule.tooling.model.messageflow.IMessageFlowNode;
import org.mule.tooling.model.messageflow.PropertyCollection;
import org.mule.tooling.model.messageflow.decorator.PropertyCollectionMap;
import org.mule.tooling.model.messageflow.util.PropertiesUtils;
import org.mule.tooling.model.module.GlobalDefinition;
import org.mule.tooling.model.module.NestedDefinition;
import org.mule.tooling.model.module.NodeDefinition;
import org.mule.tooling.ui.modules.core.widgets.AttributesPropertyPage;
import org.mule.tooling.ui.modules.core.widgets.IFieldEditor;
import org.mule.tooling.ui.modules.core.widgets.IFieldEditorVisitor;
import org.mule.tooling.ui.modules.core.widgets.IMessageFlowNodeAware;
import org.mule.tooling.ui.modules.core.widgets.editors.BaseAbstractFieldEditor;
import org.mule.tooling.ui.modules.core.widgets.editors.SwitchEditor;
import org.mule.tooling.ui.modules.core.widgets.meta.AbstractComponentMeta;
import org.mule.tooling.ui.modules.core.widgets.meta.AttributeCategory;
import org.mule.tooling.ui.modules.core.widgets.meta.AttributeGroup;
import org.mule.tooling.ui.modules.core.widgets.meta.AttributeHelper;
import org.mule.tooling.ui.modules.core.widgets.meta.ChildElementAttributeHelper;
import org.mule.tooling.ui.modules.core.widgets.meta.EnumOption;
import org.mule.tooling.ui.modules.core.widgets.meta.GlobalRefAttributeHelper;
import org.mule.tooling.ui.modules.core.widgets.meta.MultiWayHelper;
import org.mule.tooling.ui.palette.AddModulesHelper;
import org.mule.tooling.ui.properties.IDependencyManager;
import org.mule.tooling.ui.properties.ModuleDependencyManager;
import org.mule.tooling.ui.properties.ModuleWizardMode;
import org.mule.tooling.ui.properties.dependencies.AddDependencyWizardDialog;
import org.mule.tooling.ui.properties.dependencies.WizardDependencyMode;
import org.mule.tooling.ui.widgets.layout.ContentFitStackLayout;
import org.mule.tooling.ui.widgets.util.ThemeUtils;
import org.mule.tooling.utils.LazyValue;
import org.mule.tooling.utils.UtilsPlugin;
import org.mule.tooling.utils.eventbus.IEvent;

public class MultiWayEditor
extends BaseAbstractFieldEditor
implements IMessageFlowNodeAware {
    private static final int NO_DEFS_MESSAGE_WRAP_LENGTH = 105;
    private static final String NO_DEFINITIONS_MESSAGE = "There are no elements available to configure {0}. Consider <a>adding a module</a> that provides configuration elements for this field and reopen this dialog afterwards.";
    public static final String DEFAULT_TYPE_SUFFIX = " (Default)";
    public static final String NONE_ID = "none";
    public static final String EXPRESSION_OR_BEAN_REF_EXP = "Expression or Bean reference";
    public static final String NONE_CAPTION_EXP = "None";
    public static final String EXPRESSION_CAPTION_EXP = "Expression";
    public static final String GLOBAL_CAPTION_EXP = "Global reference";
    public static final String BEAN_CAPTION_EXP = "Bean reference";
    public static final String INLINE_CAPTION_EXP = "Edit inline";
    private StackLayout layout;
    private ComboViewer modeViewer;
    private Button checkBox;
    private Composite composite;
    private List<NestedDefinition> allowedDefinitions;
    private List<GlobalDefinition> allowedGlobalDefinitions;
    private Set<String> loadedChildren = Sets.newHashSet();
    private Map<String, ModeElements> editorInfoByMode = new HashMap<String, ModeElements>();
    private Map<String, EnumOption> options;
    private IMessageFlowNode node;
    private String currentMode;
    private final SwitchEditor.NewEditorCallback newEditorCallback;
    private final AttributeGroup attrGroup;
    private PropertyCollectionMap properties;
    private AttributesPropertyPage parentPage;

    public PropertyCollectionMap getProperties() {
        return this.properties;
    }

    public MultiWayEditor(AttributeHelper atr, Composite gr, AttributeGroup attrGroup, SwitchEditor.NewEditorCallback newEditorCallback) {
        super(atr);
        this.newEditorCallback = newEditorCallback;
        this.attrGroup = attrGroup;
        this.currentMode = NONE_ID;
        this.createComposite(gr, attrGroup, newEditorCallback);
    }

    private void createComposite(Composite gr, AttributeGroup agroup, SwitchEditor.NewEditorCallback newEditorCallback) {
        MultiWayHelper multiWayHelper = (MultiWayHelper)this.attributeHelper;
        this.allowedDefinitions = multiWayHelper.getAllowedDefinitions();
        this.allowedGlobalDefinitions = GlobalRefAttributeHelper.getAllowedGlobalDefinitions(multiWayHelper.isAllowsSubTypes(), multiWayHelper.getGlobalTypes());
        this.configureModeViewer(gr, multiWayHelper);
        Composite composite = new Composite(gr, 0);
        this.initializeUIElements(agroup, newEditorCallback, multiWayHelper, composite, multiWayHelper.getEditingModes());
        GridDataFactory.fillDefaults().grab(true, false).span(3, 1).applyTo((Control)composite);
        this.composite = composite;
    }

    protected void initializeUIElements(AttributeGroup agroup, SwitchEditor.NewEditorCallback newEditorCallback, MultiWayHelper multiWayHelper, Composite composite, Map<String, AttributeHelper> cases) {
        ContentFitStackLayout layout = new ContentFitStackLayout();
        composite.setLayout((Layout)layout);
        for (String key : new HashSet<String>(cases.keySet())) {
            AttributeHelper childAttributeHelper = cases.get(key);
            Composite container = this.hasNoFields(childAttributeHelper) ? this.createEmptyComposite(composite) : this.createGroupContainer(composite);
            GridDataFactory.fillDefaults().grab(true, false).span(3, 1).applyTo((Control)container);
            ModeElements value = new ModeElements(container, (LazyValue<IFieldEditor>)new LazyValue(() -> newEditorCallback.create(container, childAttributeHelper, agroup)), childAttributeHelper);
            this.editorInfoByMode.put(key, value);
        }
        this.layout = layout;
        composite.layout();
    }

    public void setModeValue(String mode) {
        this.getModeViewer().setSelection((ISelection)new StructuredSelection((Object)this.options.get(mode)));
    }

    protected Composite createGroupContainer(Composite composite) {
        Group container = new Group(composite, 0);
        GridLayout oneCaseLayout = new GridLayout();
        oneCaseLayout.numColumns = 3;
        oneCaseLayout.makeColumnsEqualWidth = false;
        oneCaseLayout.horizontalSpacing = 0;
        oneCaseLayout.marginHeight = 0;
        container.setLayout((Layout)oneCaseLayout);
        return container;
    }

    protected boolean hasNoFields(AttributeHelper childAttributeHelper) {
        if (childAttributeHelper instanceof ChildElementAttributeHelper) {
            NestedDefinition definition = MuleCorePlugin.getModuleManager().getNestedDefinition(childAttributeHelper.getId());
            AbstractComponentMeta service = (AbstractComponentMeta)definition.getService(AbstractComponentMeta.class);
            Map<String, AttributeCategory> attributesMap = service.getAttributeCategoryMap();
            return attributesMap.isEmpty();
        }
        return false;
    }

    protected Composite createEmptyComposite(Composite composite) {
        Composite oneCaseComposite = new Composite(composite, 0);
        GridLayout oneCaseLayout = new GridLayout();
        oneCaseLayout.numColumns = 3;
        oneCaseLayout.makeColumnsEqualWidth = false;
        oneCaseLayout.horizontalSpacing = 0;
        oneCaseLayout.marginHeight = 0;
        oneCaseComposite.setLayout((Layout)oneCaseLayout);
        return oneCaseComposite;
    }

    protected void configureModeViewer(Composite gr, MultiWayHelper multiWayHelper) {
        final List<EnumOption> options = this.configureEnumOptions(multiWayHelper);
        String caption = multiWayHelper.getCaption();
        if (this.usesCheckBox(multiWayHelper, options)) {
            this.checkBox = new Button(gr, 32);
            boolean emptyDefinitions = this.allowedDefinitions.isEmpty();
            this.checkBox.setEnabled(!emptyDefinitions);
            if (emptyDefinitions) {
                int hIndent = this.checkBox.computeSize((int)-1, (int)-1).x + 5;
                this.createEmptyAllowedDefinitionsMessage(gr, caption, hIndent);
            }
            ThemeUtils.setCssClass((Object)this.checkBox, (String)"CheckBoxButton");
            this.checkBox.setText(caption);
            this.checkBox.setToolTipText(this.getHelper().getDescription());
            this.checkBox.setSelection(false);
            this.checkBox.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent event) {
                    MultiWayEditor.this.setCurrentComposite(((EnumOption)options.get((int)1)).value);
                }

                public void widgetDefaultSelected(SelectionEvent event) {
                    MultiWayEditor.this.setCurrentComposite(((EnumOption)options.get((int)1)).value);
                }
            });
            if (this.hasOneItemWithNoConfigurableFields() && multiWayHelper.isHideOnEmpty()) {
                this.checkBox.setVisible(false);
            }
            GridDataFactory.fillDefaults().grab(true, false).span(3, 1).applyTo((Control)this.checkBox);
        } else {
            Composite group = new Composite(gr, 0);
            GridLayoutFactory.fillDefaults().numColumns(3).applyTo(group);
            GridDataFactory.fillDefaults().span(3, 1).applyTo((Control)group);
            Label descriptionLabel = new Label(group, 0);
            descriptionLabel.setText(caption);
            GridDataFactory.swtDefaults().applyTo((Control)descriptionLabel);
            this.modeViewer = new ComboViewer(group, 8);
            this.getModeViewer().getCombo().setToolTipText(this.getHelper().getDescription());
            this.getModeViewer().setContentProvider((IContentProvider)new ArrayContentProvider());
            this.getModeViewer().setInput(options);
            this.getModeViewer().setLabelProvider((IBaseLabelProvider)new CaptionLabelProvider());
            this.getModeViewer().setSelection((ISelection)new StructuredSelection((Object)options.get(0)));
            this.getModeViewer().getControl().setLayoutData((Object)this.getLayoutData());
            this.getModeViewer().addSelectionChangedListener(event -> {
                Object firstElement;
                IStructuredSelection selection = (IStructuredSelection)event.getSelection();
                if (selection != null && (firstElement = selection.getFirstElement()) != null) {
                    EnumOption option = (EnumOption)firstElement;
                    this.setCurrentComposite(option.value);
                }
            });
            if (this.hasNoAllowedNodeDefinitions(multiWayHelper) && !multiWayHelper.supportsExpressionMode() && !multiWayHelper.supportsBeanMode()) {
                this.createEmptyAllowedDefinitionsMessage(group, caption, 20);
                this.getModeViewer().getCombo().setEnabled(false);
            } else if (options.size() == 1) {
                this.getModeViewer().getCombo().setVisible(false);
            }
            GridDataFactory.fillDefaults().grab(true, false).span(2, 1).applyTo(this.getModeViewer().getControl());
        }
    }

    private boolean hasOneItemWithNoConfigurableFields() {
        return this.allowedDefinitions.size() == 1 && ((AbstractComponentMeta)this.allowedDefinitions.get(0).getService(AbstractComponentMeta.class)).getAllAttributes().isEmpty();
    }

    private boolean hasNoAllowedNodeDefinitions(MultiWayHelper multiWayHelper) {
        return !multiWayHelper.supportsGlobalMode() && this.allowedDefinitions.isEmpty() || multiWayHelper.supportsGlobalMode() && this.allowedGlobalDefinitions.isEmpty();
    }

    private void createEmptyAllowedDefinitionsMessage(Composite gr, String caption, int hIndent) {
        Link messageLink = new Link(gr, 64);
        String linkText = MessageFormat.format(NO_DEFINITIONS_MESSAGE, caption);
        messageLink.setText(WordUtils.wrap((String)linkText, (int)105));
        GridDataFactory.fillDefaults().grab(true, false).span(3, 1).indent(hIndent, 0).applyTo((Control)messageLink);
        messageLink.addSelectionListener(SelectionListener.widgetSelectedAdapter(e -> {
            IMuleProject muleProject = MuleCorePlugin.getDesignContext().getMuleProject();
            AddModulesHelper.create((IMuleProject)muleProject, () -> {
                AddDependencyWizardDialog dialog = AddDependencyWizardDialog.create((Shell)Display.getDefault().getActiveShell(), (WizardDependencyMode)new ModuleWizardMode((IDependencyManager)new ModuleDependencyManager(muleProject)));
                if (dialog.open() == 0) {
                    return dialog.getResult();
                }
                return Collections.emptyList();
            }).addModules();
        }));
        this.addWarningDecorator(messageLink);
    }

    public void addWarningDecorator(Link messageLink) {
        ControlDecoration decorator = new ControlDecoration((Control)messageLink, 128);
        Image image = FieldDecorationRegistry.getDefault().getFieldDecoration("DEC_WARNING").getImage();
        decorator.setImage(image);
        decorator.show();
    }

    protected boolean usesCheckBox(MultiWayHelper multiWayHelper, List<EnumOption> options) {
        return !multiWayHelper.isRequired() && options.size() == 2 && multiWayHelper.supportsInlineMode() && !multiWayHelper.getEmptyLabel().isPresent() && !multiWayHelper.hasDefaultType() && !multiWayHelper.supportsGlobalMode();
    }

    protected List<EnumOption> configureEnumOptions(MultiWayHelper multiWayHelper) {
        ArrayList<EnumOption> options = new ArrayList<EnumOption>();
        this.options = new LinkedHashMap<String, EnumOption>();
        boolean hasDefaultType = multiWayHelper.hasDefaultType();
        if (!multiWayHelper.isRequired() && !hasDefaultType) {
            this.registerOption(options, NONE_ID, multiWayHelper.getEmptyLabel().orElse(NONE_CAPTION_EXP));
        }
        if (this.unifyBeanAndExpressionMode(multiWayHelper)) {
            this.registerOption(options, "REF", EXPRESSION_OR_BEAN_REF_EXP);
        } else {
            if (multiWayHelper.supportsExpressionMode()) {
                this.registerOption(options, "REF", EXPRESSION_CAPTION_EXP);
            }
            if (multiWayHelper.supportsBeanMode()) {
                this.registerOption(options, "BEAN", BEAN_CAPTION_EXP);
            }
        }
        if (multiWayHelper.supportsInlineMode()) {
            this.registerInlineModes(multiWayHelper, options, hasDefaultType);
        }
        if (multiWayHelper.supportsGlobalMode()) {
            this.registerOption(options, "GLOBAL", GLOBAL_CAPTION_EXP);
        }
        return options;
    }

    private boolean unifyBeanAndExpressionMode(MultiWayHelper multiWayHelper) {
        return multiWayHelper.supportsBeanMode() && multiWayHelper.supportsExpressionMode();
    }

    private void registerOption(List<EnumOption> options, String modeId, String caption) {
        EnumOption option = new EnumOption(modeId, caption);
        options.add(option);
        this.options.put(modeId, option);
    }

    private void registerInlineModes(MultiWayHelper multiWayHelper, List<EnumOption> options, boolean hasDefaultType) {
        boolean useName = this.allowedDefinitions.size() > 1;
        for (NestedDefinition type : this.allowedDefinitions) {
            EnumOption option;
            Object caption;
            if (type.isAbstract()) continue;
            String qName = this.getQName(type);
            Object object = caption = useName ? type.getName() : INLINE_CAPTION_EXP;
            if (hasDefaultType && qName.equals(multiWayHelper.getDefaultType())) {
                caption = (String)caption + DEFAULT_TYPE_SUFFIX;
                option = new EnumOption(qName, (String)caption);
                options.add(0, option);
            } else {
                option = new EnumOption(qName, (String)caption);
                options.add(option);
            }
            this.options.put(qName, option);
        }
    }

    protected String getQName(NestedDefinition type) {
        return type.getMuleElement().getNamespaceURI() + "/" + type.getMuleElement().getLocalPart();
    }

    @Override
    public void loadFrom(IMessageFlowNode node, PropertyCollectionMap props) {
        MultiWayHelper multiWayHelper;
        block15: {
            this.node = node;
            this.properties = props;
            multiWayHelper = this.getHelper();
            Optional propertyOpt = props.getPropertyOpt(multiWayHelper.getId());
            Optional mode = props.getPropertyOpt("auxiliary;MODE;" + multiWayHelper.getId());
            if (!mode.isPresent()) break block15;
            switch ((String)mode.get()) {
                case "ATTR": {
                    this.loadFromAttribute(node, props, multiWayHelper, (Optional<String>)propertyOpt);
                    return;
                }
                case "CHILD": {
                    this.loadFromChild(node, props, multiWayHelper);
                    return;
                }
            }
        }
        if (this.checkBox != null) {
            this.checkBox.setSelection(false);
            if (!this.allowedDefinitions.isEmpty()) {
                this.initUISelection(multiWayHelper, false, (NodeDefinition)this.allowedDefinitions.get(0));
            }
        } else if (this.getHelper().hasDefaultType()) {
            this.getModeViewer().setSelection((ISelection)new StructuredSelection((Object)this.options.get(this.getHelper().getDefaultType())));
        } else {
            this.getModeViewer().setSelection((ISelection)new StructuredSelection((Object)this.options.values().iterator().next()));
        }
    }

    protected void loadFromAttribute(IMessageFlowNode node, PropertyCollectionMap props, MultiWayHelper multiWayHelper, Optional<String> propertyOpt) {
        String value = (String)propertyOpt.or((Object)"");
        boolean expression = ExpressionUtils.isExpression((String)value);
        if (expression && multiWayHelper.supportsExpressionMode() || this.unifyBeanAndExpressionMode(multiWayHelper)) {
            this.showAndLoadExpression(node, props);
        } else if (multiWayHelper.supportsBeanMode() && !multiWayHelper.supportsGlobalMode()) {
            this.showAndLoadBeanEditor(node, props);
        } else if (multiWayHelper.supportsGlobalMode()) {
            this.showAndLoadGlobalEditor(node, props);
        } else if (multiWayHelper.supportsExpressionMode()) {
            this.showAndLoadExpression(node, props);
        } else if (multiWayHelper.supportsBeanMode()) {
            this.showAndLoadBeanEditor(node, props);
        }
    }

    private void showAndLoadGlobalEditor(IMessageFlowNode node, PropertyCollectionMap props) {
        this.showAndLoadMode(node, props, "GLOBAL");
    }

    private void showAndLoadExpression(IMessageFlowNode node, PropertyCollectionMap props) {
        this.showAndLoadMode(node, props, "REF");
    }

    private void showAndLoadBeanEditor(IMessageFlowNode node, PropertyCollectionMap props) {
        this.showAndLoadMode(node, props, "BEAN");
    }

    private void showAndLoadMode(IMessageFlowNode node, PropertyCollectionMap props, String mode) {
        this.getModeViewer().setSelection((ISelection)new StructuredSelection((Object)this.options.get(mode)));
        this.getFieldEditorFor(mode).loadFrom(node, props);
    }

    private IFieldEditor getFieldEditorFor(String mode) {
        return this.editorInfoByMode.get(mode).getFieldEditor();
    }

    private void loadFromChild(IMessageFlowNode node, PropertyCollectionMap props, MultiWayHelper multiWayHelper) {
        boolean needsEditorLoad;
        boolean hasChild = false;
        PropertyCollection prop = this.getChildProp(props);
        NestedDefinition def = null;
        if (prop != null && (def = this.getNodeDef(prop)) != null) {
            hasChild = true;
        }
        if (needsEditorLoad = this.initUISelection(multiWayHelper, hasChild, (NodeDefinition)def)) {
            if (multiWayHelper.needsWrapper()) {
                List propertyCollectionsWithPrefix = props.getPropertyCollectionsWithPrefix("@" + multiWayHelper.getWrapIn());
                if (def != null && !propertyCollectionsWithPrefix.isEmpty()) {
                    this.getFieldEditorFor(def.getId()).loadFrom(node, (PropertyCollectionMap)propertyCollectionsWithPrefix.get(0));
                }
            } else if (def != null) {
                this.getFieldEditorFor(def.getId()).loadFrom(node, props);
            }
            if (def != null) {
                this.loadedChildren.add(def.getId());
            }
        }
    }

    private boolean initUISelection(MultiWayHelper multiWayHelper, boolean hasChild, NodeDefinition def) {
        boolean needsEditorLoad = true;
        if (this.checkBox != null) {
            this.checkBox.setSelection(hasChild);
            if (def != null) {
                this.setCurrentComposite(this.options.get((Object)def.getId()).value);
            }
            needsEditorLoad = hasChild;
        } else if (hasChild) {
            if (def != null) {
                this.getModeViewer().setSelection((ISelection)new StructuredSelection((Object)this.options.get(def.getId())));
            }
        } else if (!multiWayHelper.isRequired()) {
            EnumOption selectedOption = StringUtils.isNotEmpty((CharSequence)multiWayHelper.getDefaultType()) ? this.options.get(multiWayHelper.getDefaultType()) : this.options.get(NONE_ID);
            this.getModeViewer().setSelection((ISelection)new StructuredSelection((Object)selectedOption));
            needsEditorLoad = false;
        } else {
            this.getModeViewer().setSelection((ISelection)new StructuredSelection((Object)this.options.get(this.getEditorModes().iterator().next())));
        }
        return needsEditorLoad;
    }

    private String getSelectedMode() {
        Object firstElement;
        if (this.checkBox != null) {
            if (!this.checkBox.isDisposed()) {
                return this.checkBox.getSelection() ? this.getQName(this.allowedDefinitions.get(0)) : NONE_ID;
            }
            return NONE_ID;
        }
        IStructuredSelection selection = (IStructuredSelection)this.getModeViewer().getSelection();
        if (selection != null && (firstElement = selection.getFirstElement()) != null) {
            EnumOption option = (EnumOption)firstElement;
            return option.value;
        }
        return NONE_ID;
    }

    @Override
    public void saveTo(IMessageFlowNode node, PropertyCollectionMap props) {
        String selectedMode;
        switch (selectedMode = this.getSelectedMode()) {
            case "none": {
                props.addProperty("auxiliary;MODE;" + this.getHelper().getId(), "NONE");
                this.removeAttribute(props);
                this.removeChildPropertyCollection(node, props);
                break;
            }
            case "REF": 
            case "BEAN": 
            case "GLOBAL": {
                props.addProperty("auxiliary;MODE;" + this.getHelper().getId(), "ATTR");
                this.getFieldEditorFor(selectedMode).saveTo(node, props);
                this.removeChildPropertyCollection(node, props);
                break;
            }
            default: {
                props.addProperty("auxiliary;MODE;" + this.getHelper().getId(), "CHILD");
                this.removeAttribute(props);
                if (!this.getHelper().needsWrapper()) {
                    this.getFieldEditorFor(selectedMode).saveTo(node, props);
                    break;
                }
                this.saveWithWrapper(node, props, selectedMode);
            }
        }
        Optional backupState = props.getPropertyOpt("BACKUP_STATE");
        if (!backupState.isPresent()) {
            this.properties = props;
        }
    }

    private void removeChildPropertyCollection(IMessageFlowNode node, PropertyCollectionMap props) {
        MultiWayHelper helper = this.getHelper();
        if (helper.needsWrapper()) {
            String id = helper.getWrapIn();
            String prefix = PropertiesUtils.createCollectionId((String)id);
            this.markCollectionsAsErased(props, id, prefix);
        } else {
            for (NestedDefinition def : this.allowedDefinitions) {
                String id = def.getId();
                String prefix = PropertiesUtils.createCollectionId((String)id);
                this.markCollectionsAsErased(props, id, prefix);
            }
        }
    }

    private void markCollectionsAsErased(PropertyCollectionMap props, String id, String prefix) {
        List collections = props.getPropertyCollectionsWithPrefix(prefix);
        if (collections.isEmpty() && this.properties != null) {
            String propertyId = PropertiesUtils.createCollectionId((String)id);
            this.properties.getPropertyCollectionsWithPrefix(prefix).forEach(propertyCollectionMap2 -> {
                PropertyCollectionMap collection = new PropertyCollectionMap(propertyCollectionMap2.asPropertyCollection().getElement());
                collection.setErased(true);
                props.addPropertyCollection(propertyId, collection);
            });
        } else {
            for (PropertyCollectionMap property : collections) {
                property.setErased(true);
            }
        }
    }

    private void saveWithWrapper(IMessageFlowNode node, PropertyCollectionMap props, String selectedMode) {
        Optional backupState = props.getPropertyOpt("BACKUP_STATE");
        PropertyCollection newProperties = new PropertyCollection();
        String createId = PropertiesUtils.createNewCollectionId((String)this.getHelper().getWrapIn());
        newProperties.setName(createId);
        PropertyCollectionMap propertyCollectionMap = newProperties.toPropertyCollectionMap();
        if (backupState.isPresent()) {
            propertyCollectionMap.addProperty("BACKUP_STATE", Boolean.TRUE.toString());
        }
        this.getFieldEditorFor(selectedMode).saveTo(node, propertyCollectionMap);
        propertyCollectionMap.removeProperty("BACKUP_STATE");
        props.addPropertyCollection(createId, propertyCollectionMap);
    }

    private void removeAttribute(PropertyCollectionMap props) {
        props.addProperty("auxiliary;erased;" + this.attributeHelper.getId(), Boolean.TRUE.toString());
    }

    @Override
    public void setEnabled(boolean enabled) {
    }

    public void setCurrentComposite(String caseId) {
        Composite currentComposite;
        this.currentMode = caseId;
        ModeElements modeEditor = this.editorInfoByMode.get(caseId);
        Composite composite = currentComposite = modeEditor != null ? modeEditor.getComposite() : null;
        if (modeEditor == null && !NONE_ID.equals(caseId)) {
            AttributeHelper childAttributeHelper = this.editorInfoByMode.get(caseId).getHelper();
            Composite oneCaseComposite = this.createEmptyComposite(this.composite);
            ModeElements value = new ModeElements(oneCaseComposite, (LazyValue<IFieldEditor>)new LazyValue(() -> this.newEditorCallback.create(oneCaseComposite, childAttributeHelper, this.attrGroup)), childAttributeHelper);
            this.editorInfoByMode.put(caseId, value);
            currentComposite = oneCaseComposite;
            modeEditor = value;
            this.loadedChildren.add(caseId);
        }
        if (modeEditor != null) {
            IFieldEditor fieldEditor = modeEditor.getFieldEditor();
            fieldEditor.setParentPage(this.getParentPage());
            if (currentComposite != this.layout.topControl && fieldEditor instanceof IMessageFlowNodeAware) {
                ((IMessageFlowNodeAware)((Object)fieldEditor)).setMessageFlowNode(this.node);
                if (!this.loadedChildren.contains(caseId)) {
                    fieldEditor.loadFrom(this.node, this.properties);
                    this.loadedChildren.add(caseId);
                }
            }
            if (this.checkBox != null) {
                fieldEditor.setEnabled(this.checkBox.getSelection());
            }
        }
        if (currentComposite != this.layout.topControl) {
            this.layout.topControl = currentComposite;
            this.composite.layout(true, true);
            UtilsPlugin.getEventBus().fireEvent((IEvent)new LayoutPropertiesEditorRequest());
        }
        this.parentPage.validate();
    }

    @Override
    public void accept(IFieldEditorVisitor visitor) {
        visitor.visit(this);
    }

    private GridData getLayoutData() {
        return GridDataFactory.fillDefaults().align(4, 0x1000000).grab(true, false).span(3, 1).hint(200, -1).create();
    }

    private PropertyCollection getChildProp(PropertyCollectionMap props) {
        String name;
        List propertyCollections;
        PropertyCollection properties = props.asPropertyCollection();
        String wrapIn = this.getHelper().getWrapIn();
        if (StringUtils.isNotBlank((CharSequence)wrapIn)) {
            propertyCollections = properties.getPropertyCollections();
            for (PropertyCollection c : propertyCollections) {
                name = c.getName();
                if (name == null || name.length() <= 0 || !name.startsWith("@") || !wrapIn.equals(name = name.substring(1, name.lastIndexOf(59)))) continue;
                properties = c;
                break;
            }
        }
        propertyCollections = properties.getPropertyCollections();
        for (PropertyCollection c : propertyCollections) {
            name = c.getName();
            if (name == null || name.length() <= 0 || !name.startsWith("@")) continue;
            name = name.substring(1, name.lastIndexOf(59));
            for (NestedDefinition d : this.allowedDefinitions) {
                if (!d.getId().equals(name)) continue;
                return c;
            }
        }
        return null;
    }

    private NestedDefinition getNodeDef(PropertyCollection propertyCollection) {
        String name = propertyCollection.getName();
        if (name != null && name.length() > 0 && name.startsWith("@")) {
            name = name.substring(1, name.lastIndexOf(59));
        }
        if (name != null && name.length() > 0) {
            for (NestedDefinition def : this.allowedDefinitions) {
                if (!def.getId().equals(name)) continue;
                return def;
            }
        }
        return null;
    }

    @Override
    public MultiWayHelper getHelper() {
        return (MultiWayHelper)this.attributeHelper;
    }

    @Override
    public IMessageFlowNode getMessageFlowNode() {
        return this.node;
    }

    @Override
    public void setMessageFlowNode(IMessageFlowNode node) {
        IFieldEditor fieldEditor;
        this.node = node;
        ModeElements modeEditor = this.editorInfoByMode.get(this.getSelectedMode());
        if (modeEditor != null && (fieldEditor = modeEditor.getFieldEditor()) instanceof IMessageFlowNodeAware) {
            ((IMessageFlowNodeAware)((Object)fieldEditor)).setMessageFlowNode(node);
        }
    }

    public Map<String, EnumOption> getOptions() {
        return this.options;
    }

    public String getCurrentMode() {
        return this.currentMode;
    }

    @Override
    public void setParentPage(AttributesPropertyPage parentPage) {
        this.parentPage = parentPage;
        ModeElements modeEditor = this.editorInfoByMode.get(this.currentMode);
        if (modeEditor != null) {
            modeEditor.getFieldEditor().setParentPage(parentPage);
        }
    }

    @Override
    public AttributesPropertyPage getParentPage() {
        return this.parentPage;
    }

    @Override
    public Control getControl() {
        return this.composite;
    }

    @Override
    public Control getContentControl() {
        return this.composite;
    }

    @Override
    public void addPropertyChangeListener(PropertyChangeListener listener) {
    }

    @Override
    public void removePropertChangeListener(PropertyChangeListener listener) {
    }

    @Override
    public boolean isEnabled() {
        return true;
    }

    @Override
    public boolean isDisposed() {
        return this.getControl() == null || this.getControl().isDisposed();
    }

    public Collection<? extends IFieldEditor> getChildren() {
        ModeElements modeEditor = this.editorInfoByMode.get(this.currentMode);
        if (modeEditor != null) {
            IFieldEditor fieldEditor = modeEditor.getFieldEditor();
            if (fieldEditor != null) {
                return Arrays.asList(fieldEditor);
            }
            return Collections.emptyList();
        }
        return Collections.emptyList();
    }

    public Set<String> getEditorModes() {
        return this.editorInfoByMode.keySet();
    }

    public ComboViewer getModeViewer() {
        return this.modeViewer;
    }

    public final boolean hasCheckbox() {
        return this.checkBox != null;
    }

    public final List<GlobalDefinition> getAllowedGlobalDefinitions() {
        return this.allowedGlobalDefinitions;
    }

    private static final class CaptionLabelProvider
    extends LabelProvider {
        private CaptionLabelProvider() {
        }

        public String getText(Object element) {
            EnumOption m = (EnumOption)element;
            return m.caption;
        }
    }

    private static class ModeElements {
        private final Composite composite;
        private final LazyValue<IFieldEditor> fieldEditor;
        private final AttributeHelper helper;

        public ModeElements(Composite composite, LazyValue<IFieldEditor> fieldEditor, AttributeHelper helper) {
            this.composite = composite;
            this.fieldEditor = fieldEditor;
            this.helper = helper;
        }

        public Composite getComposite() {
            return this.composite;
        }

        public IFieldEditor getFieldEditor() {
            return (IFieldEditor)this.fieldEditor.getOrCompute();
        }

        public AttributeHelper getHelper() {
            return this.helper;
        }
    }
}

