/*
 * Decompiled with CFR 0.152.
 */
package org.mule.tooling.ui.modules.core.widgets.editors;

import java.util.List;
import org.apache.commons.lang.StringUtils;
import org.mule.tooling.core.event.IDataSenseJobListenerAdapter;
import org.mule.tooling.core.model.IMuleProject;
import org.mule.tooling.messageflow.dialog.ISimpleHost;
import org.mule.tooling.messageflow.module.MessageFlowNodeComposite;
import org.mule.tooling.messageflow.util.MessageFlowUtils;
import org.mule.tooling.model.messageflow.IMessageFlowEntity;
import org.mule.tooling.model.messageflow.IMessageFlowNode;
import org.mule.tooling.model.messageflow.MessageFlowNode;
import org.mule.tooling.model.messageflow.MuleConfiguration;
import org.mule.tooling.model.messageflow.path.MulePath;
import org.mule.tooling.ui.modules.core.metadata.MetadataHelpers;
import org.mule.tooling.ui.modules.core.metadata.MetadataRequestContext;
import org.mule.tooling.ui.modules.core.metadata.MetadataRetrievalManager;
import org.mule.tooling.ui.modules.core.widgets.AttributesPropertyPage;
import org.mule.tooling.ui.modules.core.widgets.editors.EditorHelper;
import org.mule.tooling.ui.modules.core.widgets.editors.EnumFieldEditor;
import org.mule.tooling.ui.modules.core.widgets.meta.EnumOption;

public final class MultiLevelTypeChooserDataSenseJobListener
extends IDataSenseJobListenerAdapter {
    private final EnumFieldEditor enumFieldEditor;
    private final List<String> keyParts;

    public MultiLevelTypeChooserDataSenseJobListener(EnumFieldEditor enumFieldEditor, List<String> keyParts) {
        this.enumFieldEditor = enumFieldEditor;
        this.keyParts = keyParts;
    }

    public void onDataSenseJobSuccessfulCompletion(IMuleProject muleProject, IMessageFlowNode node) {
        AttributesPropertyPage page = this.enumFieldEditor.getParentPage();
        if (this.projectAndNodeBelongsToPropertyPage(muleProject, node, page)) {
            MuleConfiguration muleConfiguration = page.getContext().getMuleConfiguration();
            MulePath mulePath = muleConfiguration.getPathFor((IMessageFlowEntity)node);
            if (mulePath == null) {
                return;
            }
            List<MessageFlowNodeComposite> pages = EditorHelper.getAllCurrentEditorPages(page);
            IMessageFlowNode updatedCurrentNode = MessageFlowUtils.getMessageFlowNodeWithUpdatedProperties((IMessageFlowNode)node, pages);
            MetadataRequestContext requestContext = MetadataRequestContext.newBuilder().withMuleProject(muleProject).withPropertyPage(page).withOriginalNode(node).withUpdatedNode(updatedCurrentNode).withEnumOptionsConsumer(x -> this.enumFieldEditor.refreshEditor(this.enumFieldEditor.getValue(), false)).withKeyComponents(this.keyParts).withMuleConfiguration(muleConfiguration).withComponentPath(mulePath.toPath()).build();
            List<EnumOption> cachedMetadataTypes = MetadataRetrievalManager.getEnumOptionsMetadataKeys(requestContext);
            if (cachedMetadataTypes != null && !cachedMetadataTypes.isEmpty()) {
                this.enumFieldEditor.toogleWarningIndicator(false);
                this.enumFieldEditor.refreshEditor(this.enumFieldEditor.getValue(), false);
            }
        }
    }

    private boolean projectAndNodeBelongsToPropertyPage(IMuleProject muleProject, IMessageFlowNode messageFlowNode, AttributesPropertyPage attributesPropertyPage) {
        IMessageFlowNode currentNode = attributesPropertyPage.getMessageFlowNode();
        MessageFlowNode updatedNode = MessageFlowUtils.generateNodeToTest((IMessageFlowNode)currentNode, (ISimpleHost)attributesPropertyPage.getHost());
        String currentMetadataCacheKey = MetadataHelpers.getMetadataCacheKey(currentNode);
        String metadataCacheKey = MetadataHelpers.getMetadataCacheKey((IMessageFlowNode)updatedNode);
        return attributesPropertyPage.getMuleProject().equals(muleProject) && StringUtils.isNotBlank((String)currentMetadataCacheKey) && currentMetadataCacheKey.equals(metadataCacheKey);
    }

    public void onDataSenseJobError(IMuleProject muleProject, IMessageFlowNode messageFlowNode) {
        if (MetadataHelpers.belongsToPropertyPage(muleProject, messageFlowNode, this.enumFieldEditor.getParentPage())) {
            this.enumFieldEditor.toogleWarningIndicator(true);
        }
    }
}

