/*
 * Decompiled with CFR 0.152.
 */
package org.mule.tooling.ui.modules.core.widgets.editors;

import java.util.List;
import java.util.Map;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerFilter;
import org.mule.tooling.model.module.PatternDefinition;

public class ModeFilter
extends ViewerFilter {
    private String currentGlobalType;
    private final Map<String, List<String>> allowedElementsByConfigType;

    public ModeFilter(Map<String, List<String>> allowedElementsByConfigType) {
        this.allowedElementsByConfigType = allowedElementsByConfigType;
    }

    public boolean select(Viewer viewer, Object parentElement, Object element) {
        if (this.currentGlobalType != null && !this.allowedElementsByConfigType.isEmpty() && element instanceof PatternDefinition) {
            PatternDefinition node = (PatternDefinition)element;
            List<String> allowedIn = this.allowedElementsByConfigType.get(node.getId());
            if (allowedIn == null || allowedIn.isEmpty()) {
                return true;
            }
            return allowedIn.contains(this.currentGlobalType);
        }
        return true;
    }

    public String getCurrentGlobalType() {
        return this.currentGlobalType;
    }

    public void setCurrentGlobalType(String currentGlobalType) {
        this.currentGlobalType = currentGlobalType;
    }
}

