/*
 * Decompiled with CFR 0.152.
 */
package org.mule.tooling.ui.modules.core.widgets.editors;

import jakarta.activation.MimeType;
import jakarta.activation.MimeTypeParameterList;
import jakarta.activation.MimeTypeParseException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import org.apache.commons.lang.StringUtils;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.ToolBarManager;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.dialogs.MessageDialogWithToggle;
import org.eclipse.jface.fieldassist.SimpleContentProposalProvider;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.jface.layout.GridLayoutFactory;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.viewers.ArrayContentProvider;
import org.eclipse.jface.viewers.ComboViewer;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.StructuredViewer;
import org.eclipse.jface.viewers.ViewerComparator;
import org.eclipse.nebula.jface.viewer.radiogroup.RadioGroupViewer;
import org.eclipse.osgi.service.resolver.VersionRange;
import org.eclipse.swt.custom.CLabel;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.ToolBar;
import org.eclipse.ui.PlatformUI;
import org.mule.tooling.core.MuleCorePlugin;
import org.mule.tooling.core.event.LayoutPropertiesEditorRequest;
import org.mule.tooling.core.model.IMuleProject;
import org.mule.tooling.core.utils.ExpressionUtils;
import org.mule.tooling.messageflow.util.MessageFlowUtils;
import org.mule.tooling.model.messageflow.IMessageFlowNode;
import org.mule.tooling.model.messageflow.PropertyCollection;
import org.mule.tooling.model.messageflow.decorator.PropertyCollectionMap;
import org.mule.tooling.ui.MuleUIPlugin;
import org.mule.tooling.ui.modules.core.properties.IPropertyValueChangeListener;
import org.mule.tooling.ui.modules.core.widgets.AttributeContext;
import org.mule.tooling.ui.modules.core.widgets.AttributesPropertyPage;
import org.mule.tooling.ui.modules.core.widgets.IEditorValueModifiedListener;
import org.mule.tooling.ui.modules.core.widgets.IEditorValueModifiedObservable;
import org.mule.tooling.ui.modules.core.widgets.IFieldEditor;
import org.mule.tooling.ui.modules.core.widgets.IFieldEditorVisitor;
import org.mule.tooling.ui.modules.core.widgets.IRefresheableEditor;
import org.mule.tooling.ui.modules.core.widgets.editors.AbstractFieldEditor;
import org.mule.tooling.ui.modules.core.widgets.editors.DataSenseTypeChangedEvent;
import org.mule.tooling.ui.modules.core.widgets.editors.IButtonEnablement;
import org.mule.tooling.ui.modules.core.widgets.editors.IOptionsCalculator;
import org.mule.tooling.ui.modules.core.widgets.editors.IValueCalculator;
import org.mule.tooling.ui.modules.core.widgets.editors.LabelledFieldEditor;
import org.mule.tooling.ui.modules.core.widgets.editors.mimetype.IParameterRemovedListener;
import org.mule.tooling.ui.modules.core.widgets.editors.mimetype.MimeTypeEvents;
import org.mule.tooling.ui.modules.core.widgets.editors.mimetype.MimeTypeHelper;
import org.mule.tooling.ui.modules.core.widgets.editors.mimetype.ParameterComposite;
import org.mule.tooling.ui.modules.core.widgets.meta.AttributeHelper;
import org.mule.tooling.ui.modules.core.widgets.meta.ButtonAttributeHelper;
import org.mule.tooling.ui.modules.core.widgets.meta.ChildElementAttributeHelper;
import org.mule.tooling.ui.modules.core.widgets.meta.EnumHelper;
import org.mule.tooling.ui.modules.core.widgets.meta.EnumOption;
import org.mule.tooling.ui.modules.core.widgets.meta.IEditorSelectionListener;
import org.mule.tooling.ui.modules.core.widgets.meta.IHasListener;
import org.mule.tooling.ui.modules.core.widgets.meta.Sort;
import org.mule.tooling.ui.widgets.WidgetsImages;
import org.mule.tooling.ui.widgets.listener.IdleModifyEventListener;
import org.mule.tooling.ui.widgets.util.WidgetUtils;
import org.mule.tooling.utils.SilentRunner;
import org.mule.tooling.utils.UtilsPlugin;
import org.mule.tooling.utils.eventbus.EventBus;
import org.mule.tooling.utils.eventbus.EventBusHelper;
import org.mule.tooling.utils.eventbus.IEvent;
import org.mule.tooling.utils.eventbus.IEventHandler;
import org.mule.tooling.weave.engine.WeaveEngineHelperManager;
import org.mule.tooling.weave.engine.WeaveModule;
import org.osgi.framework.Version;

public class MimeTypeFieldEditor
extends LabelledFieldEditor
implements IRefresheableEditor,
IEditorValueModifiedObservable,
IParameterRemovedListener {
    protected StructuredViewer cmb;
    protected String value;
    private boolean inSet;
    private boolean onSelectionChangeCalled = false;
    private Set<IEditorValueModifiedListener> valueModifiedListeners;
    private Action buttonAction;
    private String buttonEnablementClass;
    private SimpleContentProposalProvider contentProposal;
    private List<IPropertyValueChangeListener> propertyValueChangeListeners;
    private IdleModifyEventListener modifyListener;
    private EventBus eventBus;
    private EventBusHelper eventBusHelper;
    private List<PropertyCollection> previousDefinitions = new ArrayList<PropertyCollection>();
    private Composite parametersListWrapper;
    private List<ParameterComposite> parameters;
    private Composite buttonsWrapper;
    private ToolBar parametersToolbar;
    private Composite emptyCanvasComposite;

    public MimeTypeFieldEditor(AttributeContext ctx, AttributeHelper atr, Composite parent) {
        super(ctx, atr, parent);
        this.initialize();
    }

    protected void initialize() {
        this.parameters = new ArrayList<ParameterComposite>();
        this.eventBus = new EventBus();
        final EventBusHelper eventBusHelper = new EventBusHelper();
        eventBusHelper.registerListener(this.eventBus, MimeTypeEvents.ON_PARAMETER_REMOVED, (IEventHandler)this);
        this.getParentPage().addDisposeListener(new DisposeListener(){

            public void widgetDisposed(DisposeEvent e) {
                eventBusHelper.unregister();
                MimeTypeFieldEditor.this.getParentPage().removeDisposeListener(this);
            }
        });
    }

    public void toggleWarningIndicator(boolean showWarningIndicator) {
        Image image = null;
        String tooltip = "";
        if (showWarningIndicator) {
            image = WidgetsImages.getImage((String)"/icons/notification/warning-16x16.png");
            tooltip = "There was a problem fetching metadata for this element or its global connector, please check your configuration.";
        }
        if (this.label instanceof CLabel) {
            CLabel clabel = (CLabel)this.label;
            clabel.setImage(image);
            clabel.setToolTipText(tooltip);
            clabel.redraw();
        }
    }

    @Override
    protected void createExtraContent(Composite parent) {
        super.createExtraContent(parent);
        if (!(this.getHelper() instanceof EnumHelper)) {
            return;
        }
        final EnumHelper enumHelper = (EnumHelper)this.getHelper();
        final String buttonClass = enumHelper.getButtonClass();
        if (enumHelper.isTypeChooser() || StringUtils.isNotBlank((String)buttonClass)) {
            this.buttonEnablementClass = enumHelper.getButtonEnablementClass();
            if (!enumHelper.isButtonDisabled() && StringUtils.isNotBlank((String)buttonClass)) {
                ToolBarManager toolBarManager = new ToolBarManager();
                this.buttonAction = new Action(){

                    public void run() {
                        AttributesPropertyPage parentPage = MimeTypeFieldEditor.this.getParentPage();
                        enumHelper.click(MimeTypeFieldEditor.this, parentPage, buttonClass);
                        MimeTypeFieldEditor.this.refreshEditor(MimeTypeFieldEditor.this.getValue(), false);
                    }
                };
                String buttonCaption = enumHelper.getButtonCaption();
                if (StringUtils.isNotBlank((String)buttonCaption)) {
                    this.buttonAction.setText(buttonCaption);
                }
                this.buttonAction.setToolTipText(enumHelper.getButtonTooltip());
                ImageDescriptor buttonImage = enumHelper.getButtonImageDescriptor();
                if (buttonImage != null) {
                    this.buttonAction.setImageDescriptor(buttonImage);
                    this.buttonAction.setDisabledImageDescriptor(enumHelper.getButtonDisabledImageDescriptor());
                }
                toolBarManager.add((IAction)this.buttonAction);
                ToolBar toolbar = toolBarManager.createControl(parent);
                toolbar.setLayoutData((Object)GridDataFactory.fillDefaults().grab(false, false).indent(-7, 0).create());
                this.refreshButtonStatus();
            }
        }
    }

    private void refreshButtonStatus() {
        if (this.buttonAction != null && StringUtils.isNotBlank((String)this.buttonEnablementClass)) {
            this.buttonAction.setEnabled(StringUtils.isBlank((String)this.buttonEnablementClass) || this.buttonEnabled(this.buttonEnablementClass));
        }
    }

    private boolean buttonEnabled(String buttonEnablementClass) {
        boolean buttonEnabled = false;
        try {
            IButtonEnablement ac = (IButtonEnablement)ButtonAttributeHelper.class.getClassLoader().loadClass(buttonEnablementClass).newInstance();
            buttonEnabled = ac.isEnabled(this.getHelper(), this.getParentPage());
        }
        catch (Exception exception) {}
        return buttonEnabled;
    }

    private boolean isEnumHelper() {
        return this.attributeHelper instanceof EnumHelper;
    }

    protected boolean allowsCustomValues() {
        return true;
    }

    private String getOptionText(EnumOption m) {
        return m.caption;
    }

    @Override
    protected Control internalCreateControl(Composite parent) {
        EnumHelper enumHelper;
        Composite composite = new Composite(parent, 4);
        new Label(parent, 0);
        GridLayoutFactory.fillDefaults().applyTo(composite);
        boolean allowsCustom = this.allowsCustomValues();
        this.cmb = this.createViewer(this.attributeHelper, composite, allowsCustom);
        GridDataFactory.fillDefaults().applyTo(this.cmb.getControl());
        this.cmb.getControl().setToolTipText(this.getHelper().getDescription());
        if (this.isEnumHelper() && (enumHelper = (EnumHelper)this.getHelper()).isTypeChooser()) {
            this.eventBus = MuleCorePlugin.getEventBus();
            this.eventBusHelper = new EventBusHelper();
        }
        this.contentProposal = WidgetUtils.enableContentProposal((Control)this.cmb.getControl());
        this.cmb.setContentProvider((IContentProvider)new ArrayContentProvider());
        this.cmb.setLabelProvider((IBaseLabelProvider)new LabelProvider(){

            public String getText(Object element) {
                EnumOption m = (EnumOption)element;
                String name = MimeTypeFieldEditor.this.getOptionText(m);
                if (MimeTypeFieldEditor.this.mustShowOptionsValues() && !m.isEmptyOption()) {
                    name = MimeTypeFieldEditor.this.getOptionText(m);
                }
                return name;
            }
        });
        this.cmb.setComparator(new ViewerComparator());
        final ISelectionChangedListener selectionChangeListener = new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                MimeTypeFieldEditor.this.onSelectionChange(true);
            }
        };
        this.cmb.addSelectionChangedListener(selectionChangeListener);
        this.cmb.getControl().addDisposeListener(new DisposeListener(){

            public void widgetDisposed(DisposeEvent e) {
                MimeTypeFieldEditor.this.cmb.removeSelectionChangedListener(selectionChangeListener);
                if (MimeTypeFieldEditor.this.eventBusHelper != null) {
                    MimeTypeFieldEditor.this.eventBusHelper.unregister();
                    MimeTypeFieldEditor.this.eventBus = null;
                }
            }
        });
        Composite parametersGroup = new Composite(composite, 4);
        GridLayoutFactory.fillDefaults().applyTo(parametersGroup);
        GridDataFactory.fillDefaults().span(2, 1).grab(true, false).applyTo((Control)parametersGroup);
        this.createTitle(parametersGroup);
        this.parametersListWrapper = new Composite(parametersGroup, 0);
        GridLayoutFactory.fillDefaults().applyTo(this.parametersListWrapper);
        GridDataFactory.fillDefaults().grab(true, false).applyTo((Control)this.parametersListWrapper);
        this.createEmptyCanvasInformation();
        this.buttonsWrapper = new Composite(parametersGroup, 0);
        GridLayoutFactory.fillDefaults().applyTo(this.buttonsWrapper);
        GridDataFactory.fillDefaults().grab(true, false).applyTo((Control)this.buttonsWrapper);
        Button addParameterButton = new Button(this.buttonsWrapper, 0x100000);
        addParameterButton.setText("Add Parameter");
        addParameterButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ParameterComposite parameterComposite = MimeTypeFieldEditor.this.createParameterComposite();
                parameterComposite.setModule(WeaveEngineHelperManager.getModule((String)MimeTypeFieldEditor.this.value, (IMuleProject)MimeTypeFieldEditor.this.getParentPage().getMuleProject()));
                MimeTypeFieldEditor.this.addParameter(parameterComposite);
                MimeTypeFieldEditor.this.getParentPage().validate();
            }
        });
        this.initInput();
        return composite;
    }

    protected ParameterComposite createParameterComposite() {
        return new ParameterComposite(this.parametersListWrapper, this.eventBus, this.getParentPage().getMessageFlowNode(), this.getParentPage().getContext());
    }

    private void createEmptyCanvasInformation() {
        this.emptyCanvasComposite = new Composite(this.parametersListWrapper, 0);
        GridLayoutFactory.fillDefaults().margins(0, 0).extendedMargins(5, 5, 5, 5).applyTo(this.emptyCanvasComposite);
        GridDataFactory.fillDefaults().grab(true, true).applyTo((Control)this.emptyCanvasComposite);
        Label emptyCanvasLabel = new Label(this.emptyCanvasComposite, 0x1000000);
        emptyCanvasLabel.setText("Click in the button below to add a parameter");
        GridDataFactory.fillDefaults().align(0x1000000, 0x1000000).grab(true, true).applyTo((Control)emptyCanvasLabel);
        this.parametersToolbar.setEnabled(false);
    }

    private void addModifierListener() {
        if (this.cmb.getControl() instanceof Combo && this.modifyListener == null) {
            final Combo enumCombo = (Combo)this.cmb.getControl();
            final ModifyListener baseListener = new ModifyListener(){

                public void modifyText(ModifyEvent e) {
                    if (enumCombo != null && !enumCombo.isDisposed()) {
                        String newValue;
                        String baseType = newValue = ((Combo)e.getSource()).getText();
                        if (StringUtils.isNotBlank((String)newValue)) {
                            try {
                                MimeType mimeType = new MimeType(newValue);
                                baseType = mimeType.getBaseType();
                                Optional module = WeaveEngineHelperManager.getModule((String)baseType, (IMuleProject)MimeTypeFieldEditor.this.getParentPage().getMuleProject());
                                MimeTypeParameterList newParameters = mimeType.getParameters();
                                MimeTypeFieldEditor.this.addNewParameters(module, newParameters);
                                for (ParameterComposite parameterComposite : MimeTypeFieldEditor.this.parameters) {
                                    parameterComposite.setModule(WeaveEngineHelperManager.getModule((String)MimeTypeFieldEditor.this.value, (IMuleProject)MimeTypeFieldEditor.this.getParentPage().getMuleProject()));
                                }
                            }
                            catch (MimeTypeParseException mimeTypeParseException) {}
                        }
                        if (!newValue.equals(baseType) || !MimeTypeFieldEditor.this.value.equals(baseType)) {
                            MimeTypeFieldEditor.this.setValue(baseType);
                        }
                        if (baseType == null && MimeTypeFieldEditor.this.value != null || !baseType.equals(MimeTypeFieldEditor.this.value)) {
                            MimeTypeFieldEditor.this.notifyObservers();
                        }
                    }
                }
            };
            if ((enumCombo.getStyle() & 8) == 0) {
                this.modifyListener = new IdleModifyEventListener(1000L, baseListener, (Control)enumCombo);
                enumCombo.addModifyListener((ModifyListener)this.modifyListener);
                enumCombo.addDisposeListener(new DisposeListener(){

                    public void widgetDisposed(DisposeEvent e) {
                        enumCombo.removeModifyListener((ModifyListener)MimeTypeFieldEditor.this.modifyListener);
                    }
                });
            } else {
                enumCombo.addModifyListener(baseListener);
                enumCombo.addDisposeListener(new DisposeListener(){

                    public void widgetDisposed(DisposeEvent e) {
                        enumCombo.removeModifyListener(baseListener);
                    }
                });
            }
        }
    }

    protected void addNewParameters(Optional<WeaveModule> module, MimeTypeParameterList mimeTypeParameters) {
        ArrayList<String> newParameters = Collections.list(mimeTypeParameters.getNames());
        newParameters.forEach(name -> {
            ParameterComposite parameterComposite;
            Optional<ParameterComposite> existingParameter = this.parameters.stream().filter(parameter -> name.equals(parameter.getKey())).findAny();
            if (existingParameter.isPresent()) {
                parameterComposite = existingParameter.get();
            } else {
                parameterComposite = this.createParameterComposite();
                parameterComposite.setKey((String)name);
                this.addParameter(parameterComposite);
            }
            parameterComposite.setModule(module);
            parameterComposite.setValue(mimeTypeParameters.get(name));
        });
    }

    private void createTitle(Composite parent) {
        Composite titleWrapper = new Composite(parent, 0);
        GridLayoutFactory.fillDefaults().numColumns(2).margins(0, 0).extendedMargins(5, 5, 5, 0).applyTo(titleWrapper);
        GridDataFactory.fillDefaults().grab(true, false).applyTo((Control)titleWrapper);
        Label titleLabel = new Label(titleWrapper, 0);
        GridDataFactory.fillDefaults().align(1, 0x1000008).grab(true, false).applyTo((Control)titleLabel);
        titleLabel.setText("Parameters");
        this.parametersToolbar = new ToolBar(titleWrapper, 4);
        ToolBarManager parametersToolbarManager = new ToolBarManager(this.parametersToolbar);
        GridDataFactory.fillDefaults().grab(false, false).applyTo((Control)this.parametersToolbar);
        parametersToolbarManager.add((IAction)new RemoveAllParametersAction());
        parametersToolbarManager.update(true);
        Label separatorLabel = new Label(parent, 258);
        GridDataFactory.fillDefaults().applyTo((Control)separatorLabel);
        separatorLabel.setEnabled(false);
    }

    private StructuredViewer createViewer(AttributeHelper helper, Composite parent, boolean allowsCustom) {
        if (helper instanceof EnumHelper && ((EnumHelper)helper).isRadioGroup()) {
            return new RadioGroupViewer(parent, ((EnumHelper)helper).isHorizontal() ? 256 : 512);
        }
        return new ComboViewer(parent, allowsCustom ? 0 : 8);
    }

    @Override
    public void validate() {
        super.validate();
        this.getParentPage().validate();
    }

    protected void initInput() {
        String newValue;
        String baseType = newValue = this.getValue();
        if (StringUtils.isNotBlank((String)newValue)) {
            try {
                MimeType mimeType = new MimeType(newValue);
                baseType = mimeType.getBaseType();
                Optional module = WeaveEngineHelperManager.getModule((String)baseType, (IMuleProject)this.getParentPage().getMuleProject());
                MimeTypeParameterList newParameters = mimeType.getParameters();
                this.addNewParameters(module, newParameters);
                for (ParameterComposite parameterComposite : this.parameters) {
                    parameterComposite.setModule(WeaveEngineHelperManager.getModule((String)this.value, (IMuleProject)this.getParentPage().getMuleProject()));
                }
            }
            catch (MimeTypeParseException mimeTypeParseException) {}
        }
        this.refreshEditor(baseType, false);
        if (this.value != null) {
            this.setValue(baseType);
        }
    }

    @Override
    public final void refreshEditor(String value, boolean shouldNotifyObservers) {
        if (!ExpressionUtils.isExpressionOrProperty((String)value)) {
            List<EnumOption> options = this.calcOptions();
            this.refreshButtonStatus();
            this.updateContentProposals(options);
            if (this.cmb.getControl() instanceof Combo) {
                Combo combo = (Combo)this.cmb.getControl();
                String currentContent = combo.getText();
                ISelection selection = this.cmb.getSelection();
                this.cmb.setInput((Object)options.toArray());
                if (!selection.isEmpty()) {
                    this.cmb.setSelection(selection);
                } else if (StringUtils.isNotBlank((String)currentContent)) {
                    if (this.allowsCustomValues()) {
                        combo.setText(currentContent);
                    }
                } else if (options.size() == 1 && StringUtils.isEmpty((String)options.get((int)0).value)) {
                    this.cmb.setSelection((ISelection)new StructuredSelection((Object)options.get(0)));
                }
            } else {
                this.cmb.setInput((Object)options.toArray());
                if (options.size() == 1) {
                    this.cmb.setSelection((ISelection)new StructuredSelection((Object)options.get(0)));
                }
            }
            this.setSelection(value, options);
        }
    }

    protected void setSelection(String value, List<EnumOption> options) {
        String enumValue;
        EnumOption enumOption;
        IValueCalculator valueCalculator;
        if (this.attributeHelper instanceof EnumHelper && (valueCalculator = this.getAttributes().getValueCalculator()) != null && (enumOption = this.getEnumOptionFrom(options, enumValue = valueCalculator.value(value, this, this.node))) != null) {
            this.cmb.setSelection((ISelection)new StructuredSelection((Object)enumOption));
        }
    }

    private EnumOption getEnumOptionFrom(List<EnumOption> options, String enumValue) {
        for (EnumOption enumOption : options) {
            if (!enumOption.value.equals(enumValue)) continue;
            return enumOption;
        }
        return null;
    }

    private EnumHelper getAttributes() {
        return (EnumHelper)this.attributeHelper;
    }

    private boolean mustShowOptionsValues() {
        return this.isEnumHelper();
    }

    protected List<EnumOption> calcOptions() {
        EnumHelper eatr = this.getAttributes();
        IOptionsCalculator calc = eatr.getOptionsCalculator();
        if (calc != null) {
            if (this.getParentPage() != null) {
                List<EnumOption> options = calc.options(this, this.node);
                eatr.setOptions(options);
                EnumOption.sortOptions(options, Sort.ASC);
                return options;
            }
            return new ArrayList<EnumOption>();
        }
        Collection<EnumOption> options2 = eatr.getOptions();
        HashSet<EnumOption> options = new HashSet<EnumOption>();
        for (EnumOption o : options2) {
            if (o.getVersions() != null) {
                String attribute = o.getVersions();
                if ((attribute = attribute.replace(".EE", ";EE")).length() > 0) {
                    int indexOf = attribute.indexOf(59);
                    String version = this.context.getVersion();
                    if (indexOf != -1) {
                        attribute = attribute.substring(0, indexOf);
                        if (version.indexOf(59) == -1) continue;
                    }
                    VersionRange versionRange = new VersionRange(attribute);
                    if (version.charAt(version.length() - 1) == ';') {
                        version = version.substring(0, version.length() - 1);
                    }
                    if (!versionRange.isIncluded(new Version(version))) continue;
                }
            }
            options.add(o);
        }
        boolean removeEmptyOption = this.isEnumHelper() && this.getAttributes().isRemoveEmptyOption();
        boolean isAutoSort = this.isEnumHelper() && this.getAttributes().isAutoSort();
        ArrayList<EnumOption> sortedOptions = new ArrayList<EnumOption>(options);
        if (!removeEmptyOption && this.attributeHelper.shouldAddEmptyOption()) {
            sortedOptions.add(0, EnumOption.getEmptyOption(this.attributeHelper));
        }
        if (isAutoSort) {
            EnumOption.sortOptions(sortedOptions, Sort.ASC);
        } else {
            EnumOption.sortOptions(sortedOptions, Sort.NONE);
        }
        return sortedOptions;
    }

    @Override
    public String getPublicValue() {
        return this.getValue();
    }

    @Override
    public String getValue() {
        String text;
        if (Display.getCurrent() == null) {
            return this.value;
        }
        if (this.allowsCustomValues() && StringUtils.isNotBlank((String)(text = ((Combo)this.cmb.getControl()).getText()))) {
            Collection<EnumOption> options = null;
            options = this.attributeHelper instanceof EnumHelper ? this.getAttributes().getOptions() : this.calcOptions();
            for (EnumOption option : options) {
                String trimmedName;
                String totalName = this.getOptionText(option);
                if (!totalName.equals(trimmedName = text.trim()) && !this.getOptionText(option).equals(trimmedName)) continue;
                return option.value;
            }
            return text;
        }
        EnumOption option = this.getSelectedEnumOption();
        if (option == null || option.value == null) {
            return "";
        }
        return option.value;
    }

    public EnumOption getSelectedEnumOption() {
        IStructuredSelection selection = (IStructuredSelection)this.cmb.getSelection();
        EnumOption op = (EnumOption)selection.getFirstElement();
        return op;
    }

    @Override
    public void setValue(String value) {
        this.value = value;
        this.inSet = true;
        try {
            List<EnumOption> options = this.calcOptions(value);
            this.cmb.setInput((Object)options.toArray());
            this.updateContentProposals(options);
            for (EnumOption o : options) {
                if (o.value == null || !o.value.equals(value)) continue;
                this.cmb.setSelection((ISelection)new StructuredSelection((Object)o), true);
                return;
            }
            if (this.allowsCustomValues()) {
                ((ComboViewer)this.cmb).getCombo().setText(value);
                return;
            }
        }
        finally {
            this.inSet = false;
        }
    }

    @Override
    public void saveTo(IMessageFlowNode node, PropertyCollectionMap props) {
        if (this.isEnumHelper() && this.getAttributes().isChildElementChooser()) {
            this.saveWhenChildElementChooser(node, props);
        } else {
            if (this.getHelper().isTransient()) {
                return;
            }
            if (this.isEnabled) {
                boolean hasEmptyValue;
                String value = MimeTypeHelper.getValueWithParameters(this.getValue(), this.parameters);
                boolean bl = hasEmptyValue = value == null || value.length() == 0;
                if (this.hadValue) {
                    if (hasEmptyValue) {
                        props.addProperty("auxiliary;erased;" + this.attributeHelper.getId(), "true");
                    } else {
                        props.removeProperty("auxiliary;erased;" + this.attributeHelper.getId());
                    }
                }
                if (value == null) {
                    return;
                }
                props.addProperty(this.attributeHelper.getId(), value);
            }
        }
    }

    @Override
    public void loadFrom(IMessageFlowNode node, PropertyCollectionMap props) {
        if (this.isEnumHelper() && this.getAttributes().isChildElementChooser()) {
            this.loadWhenChildElementChooser(node, props);
            this.previousDefinitions = this.loadPreviousDefinitions(props);
        } else {
            super.loadFrom(node, props);
            this.initInput();
        }
        if (this.cmb instanceof ComboViewer) {
            this.addModifierListener();
        }
        this.refreshButtonStatus();
    }

    private void loadWhenChildElementChooser(IMessageFlowNode node, PropertyCollectionMap props) {
        if (this.isEnabled) {
            List<EnumOption> options = this.calcOptions();
            Set keySet = props.getPropertyCollections().keySet();
            for (String propertyCollectionName : keySet) {
                for (EnumOption option : options) {
                    if (!StringUtils.isNotBlank((String)option.value) || !propertyCollectionName.contains(option.value)) continue;
                    this.setValue(option.value);
                    return;
                }
            }
            this.setValue("");
        }
    }

    private void saveWhenChildElementChooser(IMessageFlowNode node, PropertyCollectionMap props) {
        if (this.isEnabled) {
            EnumOption option = this.getSelectedEnumOption();
            if (option != null && !option.isEmptyOption()) {
                this.clearPreviousDefinitions(props);
                PropertyCollection currentNestedElement = new PropertyCollection();
                currentNestedElement.setName(this.createId(this.value));
                currentNestedElement.setElement(MessageFlowUtils.createElement((IMessageFlowNode)node, (PropertyCollection)currentNestedElement, (int)this.getHelper().getXmlOrder()));
                props.addPropertyCollection(currentNestedElement.getName(), new PropertyCollectionMap(currentNestedElement));
            } else {
                this.clearPreviousDefinitions(props);
            }
        }
    }

    protected List<EnumOption> calcOptions(String valueToSet) {
        return this.calcOptions();
    }

    protected void onSelectionChange(boolean shouldNotify) {
        if (this.onSelectionChangeCalled) {
            return;
        }
        try {
            EnumHelper enumHelper;
            IEditorSelectionListener listener2;
            AttributeHelper helper;
            AttributesPropertyPage parentPage;
            this.onSelectionChangeCalled = true;
            String oldValue = this.value;
            if (!this.inSet) {
                this.value = this.getValue();
            }
            if ((parentPage = this.getParentPage()) != null) {
                if (!this.inSet) {
                    this.value = this.getValue();
                }
                for (IFieldEditor f : parentPage.getEditors().values()) {
                    if (!(f instanceof AbstractFieldEditor)) continue;
                    AbstractFieldEditor fa = (AbstractFieldEditor)f;
                    fa.validate();
                }
                parentPage.validate();
            }
            if ((helper = this.getHelper()) instanceof IHasListener && (listener2 = ((IHasListener)((Object)helper)).getListener()) != null) {
                listener2.selectionChanged(this);
            }
            for (IPropertyValueChangeListener propertyValueChangeListener : this.getPropertyValueChangeListeners()) {
                propertyValueChangeListener.propertyChanged(helper.getId(), "", this.getValue());
            }
            if (helper instanceof EnumHelper && (enumHelper = (EnumHelper)helper).isTypeChooser() && !oldValue.equals(this.value)) {
                this.eventBus.fireEvent((IEvent)DataSenseTypeChangedEvent.newInstance());
            }
        }
        finally {
            this.onSelectionChangeCalled = false;
        }
    }

    private List<IPropertyValueChangeListener> getPropertyValueChangeListeners() {
        if (this.propertyValueChangeListeners == null) {
            this.propertyValueChangeListeners = new ArrayList<IPropertyValueChangeListener>();
        }
        return this.propertyValueChangeListeners;
    }

    protected void notifyObservers() {
        for (IEditorValueModifiedListener valueModifiedListener : this.getValueModifiedListeners()) {
            valueModifiedListener.valueModified(this.getValue());
        }
    }

    @Override
    public void addModificationListener(IEditorValueModifiedListener listener) {
        this.getValueModifiedListeners().add(listener);
    }

    private Set<IEditorValueModifiedListener> getValueModifiedListeners() {
        if (this.valueModifiedListeners == null) {
            this.valueModifiedListeners = new HashSet<IEditorValueModifiedListener>();
        }
        return this.valueModifiedListeners;
    }

    public List<EnumOption> getOptions() {
        Object input = this.cmb.getInput();
        ArrayList<EnumOption> options = new ArrayList<EnumOption>();
        if (input instanceof Object[]) {
            Object[] objectArray = (Object[])input;
            int n = objectArray.length;
            int n2 = 0;
            while (n2 < n) {
                Object o = objectArray[n2];
                options.add((EnumOption)o);
                ++n2;
            }
            return options;
        }
        return null;
    }

    @Override
    protected boolean shouldInitDefaultProperty(PropertyCollectionMap props, AttributeHelper helper) {
        return true;
    }

    @Override
    public void accept(IFieldEditorVisitor visitor) {
        visitor.visit(this);
    }

    private void updateContentProposals(List<EnumOption> options) {
        String[] proposals = new String[options.size()];
        int i = 0;
        while (i < options.size()) {
            String totalName;
            proposals[i] = totalName = this.getOptionText(options.get(i));
            ++i;
        }
        if (this.contentProposal != null) {
            this.contentProposal.setProposals(proposals);
        }
    }

    public void setProperties(Map<String, String> properties) {
        MessageDialogWithToggle openYesNoQuestion;
        if (!this.parameters.isEmpty() && (openYesNoQuestion = MessageDialogWithToggle.openYesNoQuestion((Shell)WidgetUtils.getShell(), (String)"Replace all the properties", (String)"Do you want to remove current MIMEType properties and replace them with new ones?", (String)"Don't ask again, allways replace", (boolean)false, (IPreferenceStore)MuleUIPlugin.getDefault().getPreferenceStore(), (String)"allways_replace_reader_properties")).getReturnCode() == 2) {
            this.clearParameters();
        }
        SilentRunner.run(() -> {
            String selectedValue = this.getValue();
            if (!StringUtils.isBlank((String)selectedValue)) {
                MimeType mimeType = new MimeType(selectedValue);
                Optional module = WeaveEngineHelperManager.getModule((String)mimeType.getBaseType(), (IMuleProject)this.getParentPage().getMuleProject());
                properties.entrySet().stream().forEach(entry -> {
                    ParameterComposite parameterComposite;
                    Optional<ParameterComposite> existingParameter = this.parameters.stream().filter(parameter -> ((String)entry.getKey()).equals(parameter.getKey())).findAny();
                    if (existingParameter.isPresent()) {
                        parameterComposite = existingParameter.get();
                    } else {
                        parameterComposite = this.createParameterComposite();
                        parameterComposite.setKey((String)entry.getKey());
                        this.addParameter(parameterComposite);
                    }
                    parameterComposite.setModule(module);
                    parameterComposite.setValue((String)entry.getValue());
                });
            }
        });
    }

    @Override
    public void addPropertyChangeListener(IPropertyValueChangeListener propertyListener) {
        this.getPropertyValueChangeListeners().add(propertyListener);
    }

    @Override
    public void removeAllPropertyValueChangeListeners() {
        this.getPropertyValueChangeListeners().clear();
    }

    private List<PropertyCollection> loadPreviousDefinitions(PropertyCollectionMap props) {
        ArrayList<PropertyCollection> previousDefinitions = new ArrayList<PropertyCollection>();
        PropertyCollection properties = props.asPropertyCollection();
        ChildElementAttributeHelper.sortNestedProperties(properties);
        List propertyCollections = properties.getPropertyCollections();
        for (PropertyCollection c : propertyCollections) {
            String name = c.getName();
            if (name == null || name.length() <= 0 || !name.startsWith("@")) continue;
            previousDefinitions.add(c);
        }
        return previousDefinitions;
    }

    private String createId(String definition) {
        return "@" + definition + ";0";
    }

    private void clearPreviousDefinitions(PropertyCollectionMap props) {
        for (PropertyCollection oldPropertyCollection : this.previousDefinitions) {
            oldPropertyCollection.setErased(true);
            props.addPropertyCollection(oldPropertyCollection.getName(), new PropertyCollectionMap(oldPropertyCollection));
        }
    }

    protected void addParameter(ParameterComposite parameter) {
        if (this.parameters.isEmpty()) {
            this.emptyCanvasComposite.dispose();
        }
        this.parameters.add(parameter);
        this.parametersToolbar.setEnabled(true);
        this.recalculateEditorSize();
    }

    protected void recalculateEditorSize() {
        this.getParentPage().layout(true, true);
        UtilsPlugin.getEventBus().fireEvent((IEvent)new LayoutPropertiesEditorRequest());
    }

    @Override
    public void onParameterRemoved(ParameterComposite parameter) {
        this.parameters.remove(parameter);
        if (this.parameters.isEmpty()) {
            this.createEmptyCanvasInformation();
        }
        this.recalculateEditorSize();
        this.getParentPage().validate();
    }

    protected void clearParameters() {
        Control[] controlArray = this.parametersListWrapper.getChildren();
        int n = controlArray.length;
        int n2 = 0;
        while (n2 < n) {
            Control control = controlArray[n2];
            if (!control.isDisposed()) {
                control.dispose();
            }
            ++n2;
        }
        this.parameters.clear();
        this.createEmptyCanvasInformation();
        this.recalculateEditorSize();
        this.getParentPage().validate();
    }

    private class RemoveAllParametersAction
    extends Action {
        private static final String DELETE_ALL_CONFIRMATION_MESSAGE = "Are you sure you want to delete all parameters?";
        private static final String DELETE_ALL_CONFIRMATION_TITLE = "Remove all parameters";

        public RemoveAllParametersAction() {
            this.setImageDescriptor(PlatformUI.getWorkbench().getSharedImages().getImageDescriptor("IMG_ELCL_REMOVEALL"));
            this.setId(DELETE_ALL_CONFIRMATION_TITLE);
            this.setToolTipText(DELETE_ALL_CONFIRMATION_TITLE);
        }

        public void run() {
            boolean sure = MessageDialog.openQuestion((Shell)MimeTypeFieldEditor.this.getParentPage().getShell(), (String)DELETE_ALL_CONFIRMATION_TITLE, (String)DELETE_ALL_CONFIRMATION_MESSAGE);
            if (sure) {
                MimeTypeFieldEditor.this.clearParameters();
            }
        }
    }
}

