/*
 * Decompiled with CFR 0.152.
 */
package org.mule.tooling.ui.modules.core.widgets.editors;

import java.util.Collections;
import java.util.List;
import org.apache.commons.lang.StringUtils;
import org.mule.tooling.core.MuleCorePlugin;
import org.mule.tooling.core.model.IMuleProject;
import org.mule.tooling.messageflow.editor.MessageFlowEditor;
import org.mule.tooling.messageflow.module.MessageFlowNodeComposite;
import org.mule.tooling.messageflow.util.MessageFlowUtils;
import org.mule.tooling.model.messageflow.IMessageFlowEntity;
import org.mule.tooling.model.messageflow.IMessageFlowNode;
import org.mule.tooling.model.messageflow.MuleConfiguration;
import org.mule.tooling.ui.modules.core.metadata.MetadataRetrievalManager;
import org.mule.tooling.ui.modules.core.widgets.AttributesPropertyPage;
import org.mule.tooling.ui.modules.core.widgets.editors.AbstractFieldEditor;
import org.mule.tooling.ui.modules.core.widgets.editors.EditorHelper;
import org.mule.tooling.ui.modules.core.widgets.editors.IOptionsCalculator;
import org.mule.tooling.ui.modules.core.widgets.meta.EnumOption;

public class MetadataTypesCalculator
implements IOptionsCalculator {
    @Override
    public List<EnumOption> options(AbstractFieldEditor editor, IMessageFlowNode currentNode) {
        try {
            List<MessageFlowNodeComposite> pages;
            IMessageFlowNode updatedCurrentNode;
            String globalRefElementName;
            AttributesPropertyPage attributesPropertyPage;
            MessageFlowEditor flowEditorFromActivePage;
            if (currentNode != null && (flowEditorFromActivePage = MessageFlowUtils.getFlowEditorFromActivePage()) != null && (attributesPropertyPage = editor.getParentPage()) != null && StringUtils.isNotBlank((String)(globalRefElementName = attributesPropertyPage.getGlobalElementName(updatedCurrentNode = MessageFlowUtils.getMessageFlowNodeWithUpdatedProperties((IMessageFlowNode)currentNode, pages = EditorHelper.getAllCurrentEditorPages(editor)))))) {
                IMuleProject muleProject = flowEditorFromActivePage.getMuleProject();
                MuleConfiguration muleConfiguration = flowEditorFromActivePage.getMuleConfiguration();
                String componentPath = muleConfiguration.getPathsCache().getPath((IMessageFlowEntity)currentNode, muleProject).toPath();
                String metadataCacheKey = componentPath + ":" + currentNode.getName();
                return this.calculateOptions(currentNode, updatedCurrentNode, metadataCacheKey, muleProject, muleConfiguration, componentPath, editor.getHelper().getId());
            }
        }
        catch (Exception e) {
            MuleCorePlugin.logError((String)"Error getting DataSense types...", (Throwable)e);
        }
        return Collections.emptyList();
    }

    protected List<EnumOption> calculateOptions(IMessageFlowNode currentNode, IMessageFlowNode updatedCurrentNode, String metadataCacheKey, IMuleProject muleProject, MuleConfiguration muleConfiguration, String componentPath, String editorId) {
        return MetadataRetrievalManager.getConfiglessEnumOptionsMetadataKeys(muleProject, muleConfiguration, currentNode, updatedCurrentNode, metadataCacheKey, true, Collections.emptyList(), componentPath, editorId);
    }
}

