/*
 * Decompiled with CFR 0.152.
 */
package org.mule.tooling.ui.modules.core.widgets.editors;

import java.util.Arrays;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import org.eclipse.gef.commands.Command;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.ToolBarManager;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerFilter;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.plugin.AbstractUIPlugin;
import org.mule.tooling.core.generator.IFlowTransformerContext;
import org.mule.tooling.core.generator.NewFlowTransformerContext;
import org.mule.tooling.core.model.IMuleProject;
import org.mule.tooling.messageflow.command.AddGlobalElementCommand;
import org.mule.tooling.messageflow.command.UpdatePropertiesCommand;
import org.mule.tooling.messageflow.dialog.GlobalElementDialog;
import org.mule.tooling.messageflow.dialog.GlobalTypeChooser;
import org.mule.tooling.messageflow.editor.MessageFlowEditor;
import org.mule.tooling.messageflow.editor.MultiPageMessageFlowEditor;
import org.mule.tooling.model.messageflow.GlobalElement;
import org.mule.tooling.model.messageflow.IMessageFlowEntity;
import org.mule.tooling.model.messageflow.IReadOnlyPropertyCollection;
import org.mule.tooling.model.messageflow.MessageFlowFactory;
import org.mule.tooling.model.messageflow.MuleConfiguration;
import org.mule.tooling.model.messageflow.Property;
import org.mule.tooling.model.messageflow.PropertyCollection;
import org.mule.tooling.model.messageflow.decorator.EntityDecorator;
import org.mule.tooling.model.messageflow.decorator.GlobalElementDecorator;
import org.mule.tooling.model.messageflow.decorator.MuleConfigurationDecorator;
import org.mule.tooling.model.messageflow.decorator.PropertyCollectionMap;
import org.mule.tooling.model.module.CategoryDefinition;
import org.mule.tooling.model.module.GlobalDefinition;
import org.mule.tooling.ui.MuleImages;
import org.mule.tooling.ui.modules.core.widgets.AttributeContext;
import org.mule.tooling.ui.modules.core.widgets.IFieldEditorVisitor;
import org.mule.tooling.ui.modules.core.widgets.editors.AbstractFieldEditor;
import org.mule.tooling.ui.modules.core.widgets.meta.AttributeHelper;
import org.mule.tooling.ui.modules.core.widgets.meta.GlobalContributionHandler;

public final class ListEditor
extends AbstractFieldEditor {
    private static ImageDescriptor moveUpIcon = AbstractUIPlugin.imageDescriptorFromPlugin((String)"org.mule.tooling.ui.modules.core", (String)"icons/TMoveUp-16x16.gif");
    private static ImageDescriptor moveDownIcon = AbstractUIPlugin.imageDescriptorFromPlugin((String)"org.mule.tooling.ui.modules.core", (String)"icons/TMoveDown-16x16.gif");
    private static ImageDescriptor addToListIcon = AbstractUIPlugin.imageDescriptorFromPlugin((String)"org.mule.tooling.ui.modules.core", (String)"icons/TAddToList-16x16.gif");
    private static final List<ListEditor> listEditors = new LinkedList<ListEditor>();
    private org.eclipse.swt.widgets.List listBox = null;
    private Combo combo = null;

    public ListEditor(AttributeContext ctx, AttributeHelper atr, Composite parent) {
        super(ctx, atr, parent);
        listEditors.add(this);
        this.createControls(parent);
    }

    private void createControls(Composite parent) {
        Composite c = new Composite(parent, 0);
        GridData gridData = new GridData();
        gridData.grabExcessHorizontalSpace = true;
        gridData.grabExcessVerticalSpace = true;
        gridData.horizontalAlignment = 4;
        gridData.horizontalSpan = 3;
        c.setLayoutData((Object)gridData);
        c.setLayout((Layout)new GridLayout(1, false));
        Composite upper = new Composite(c, 0);
        upper.setLayoutData((Object)GridDataFactory.fillDefaults().grab(true, false).create());
        GridLayout upperLayout = new GridLayout(5, false);
        this.shrink(upperLayout);
        upper.setLayout((Layout)upperLayout);
        this.fillUpperComposite(upper);
        Composite lower = new Composite(c, 0);
        lower.setLayoutData((Object)GridDataFactory.fillDefaults().grab(true, false).create());
        GridLayout lowerLayout = new GridLayout(1, false);
        this.shrink(lowerLayout);
        lower.setLayout((Layout)lowerLayout);
        this.fillLowerComposite(lower);
    }

    private void shrink(GridLayout layout) {
        layout.marginLeft = 0;
        layout.marginRight = 0;
        layout.marginWidth = 0;
        layout.marginTop = 0;
        layout.marginHeight = 0;
        layout.marginBottom = 0;
        layout.horizontalSpacing = 0;
        layout.verticalSpacing = 0;
    }

    @Override
    protected Control createControl(Composite parent) {
        return parent;
    }

    private void fillUpperComposite(Composite upper) {
        Label label = new Label(upper, 0);
        label.setText("Global Transformers:");
        this.combo = new Combo(upper, 0);
        this.combo.setLayoutData((Object)GridDataFactory.fillDefaults().grab(true, false).create());
        ToolBarManager toolBar = new ToolBarManager();
        final Action addToList = new Action("Add to list", 1){

            public void run() {
                int selectionIndex = ListEditor.this.combo.getSelectionIndex();
                if (selectionIndex != -1) {
                    ListEditor.this.getListBox().add(ListEditor.this.combo.getItem(selectionIndex));
                }
            }
        };
        Action nevv = new Action("new", 1){

            public void run() {
                GlobalTypeChooser chooser = new GlobalTypeChooser(Display.getCurrent().getActiveShell(), ListEditor.this.context.getProject()){

                    protected void addionalFilters(TreeViewer typesTree) {
                        typesTree.addFilter(new ViewerFilter(){

                            public boolean select(Viewer viewer, Object parentElement, Object element) {
                                if (element instanceof CategoryDefinition) {
                                    CategoryDefinition categoryDefinition = (CategoryDefinition)element;
                                    String id = categoryDefinition.getId();
                                    return GlobalContributionHandler.isGlobalTransformer(id);
                                }
                                return true;
                            }
                        });
                        super.addionalFilters(typesTree);
                    }
                };
                if (chooser.open() == 0) {
                    GlobalDefinition global = chooser.getSelected();
                    IFlowTransformerContext transformerContext = NewFlowTransformerContext.create((IMuleProject)ListEditor.this.context.getProject(), (MuleConfiguration)ListEditor.this.context.getMuleConfiguration());
                    GlobalElement element = MessageFlowFactory.createGlobalElement((IFlowTransformerContext)transformerContext, (GlobalDefinition)global);
                    MuleConfiguration muleConfiguration = ListEditor.this.context.getMuleConfiguration();
                    GlobalElementDialog dialog = new GlobalElementDialog(Display.getCurrent().getActiveShell(), ListEditor.this.context.getProject(), element, () -> muleConfiguration);
                    if (dialog.open() == 0) {
                        PropertyCollectionMap updatedProperties = dialog.getUpdatedProperties();
                        PropertyCollection updated = updatedProperties.asPropertyCollection();
                        if (!updatedProperties.hasProperty("name")) {
                            Property nameProperty = new Property();
                            nameProperty.setName("name");
                            nameProperty.setValue(element.getName());
                            updated.getProperties().add(nameProperty);
                        }
                        element.setProperties(updated);
                        AddGlobalElementCommand command = new AddGlobalElementCommand(ListEditor.this.context.getDecorator() != null ? ListEditor.this.context.getDecorator() : new MuleConfigurationDecorator(muleConfiguration), element);
                        MultiPageMessageFlowEditor activeEditor = (MultiPageMessageFlowEditor)PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage().getActiveEditor();
                        MessageFlowEditor owner = activeEditor.getFlowEditor();
                        owner.getEditDomain().getCommandStack().execute((Command)command);
                        activeEditor.getGlobalEditor().refresh();
                        ListEditor.this.refreshCombos();
                        ListEditor.this.combo.select(ListEditor.this.combo.getItemCount() - 1);
                        addToList.run();
                    }
                }
            }
        };
        addToList.setToolTipText("Add the transformer selected in the combo to the list of transformers to be applied");
        addToList.setImageDescriptor(addToListIcon);
        nevv.setToolTipText("Open the window to create a global transformer");
        nevv.setImageDescriptor(MuleImages.DESC_ADD);
        toolBar.add((IAction)addToList);
        toolBar.add((IAction)nevv);
        toolBar.createControl(upper);
        this.refreshCombos();
    }

    protected void edit(String globalName) {
        HashSet<String> oldSet = new HashSet<String>(Arrays.asList(this.combo.getItems()));
        MuleConfiguration muleConfiguration = this.context.getMuleConfiguration();
        List globals = muleConfiguration.getGlobalEntries();
        block0: for (IMessageFlowEntity value : globals) {
            GlobalElement globalElement;
            PropertyCollectionMap propertyCollectionMap;
            String name;
            if (!(value instanceof GlobalElement) || !(name = (propertyCollectionMap = new PropertyCollectionMap((globalElement = (GlobalElement)value).getProperties())).getProperty("name", "")).equals(globalName)) continue;
            MultiPageMessageFlowEditor activeEditor = (MultiPageMessageFlowEditor)PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage().getActiveEditor();
            MessageFlowEditor owner = activeEditor.getFlowEditor();
            GlobalElementDialog dialog = new GlobalElementDialog(Display.getCurrent().getActiveShell(), this.context.getProject(), globalElement, () -> muleConfiguration);
            if (dialog.open() != 0) continue;
            IReadOnlyPropertyCollection previous = globalElement.getProperties();
            PropertyCollection updated = dialog.getUpdatedProperties().asPropertyCollection();
            GlobalElementDecorator decorator = new GlobalElementDecorator(globalElement);
            UpdatePropertiesCommand command = new UpdatePropertiesCommand(activeEditor.getMuleProject(), null, (EntityDecorator)decorator, previous, updated);
            owner.getEditDomain().getCommandStack().execute((Command)command);
            activeEditor.getGlobalEditor().refresh();
            this.refreshCombos();
            HashSet<String> newSet = new HashSet<String>(Arrays.asList(this.combo.getItems()));
            if (newSet.contains(globalName)) continue;
            for (String newElement : newSet) {
                if (oldSet.contains(newElement)) continue;
                int i = 0;
                while (i < this.combo.getItemCount()) {
                    if (this.combo.getItem(i).equals(newElement)) {
                        this.combo.select(i);
                        break;
                    }
                    ++i;
                }
                for (ListEditor listEditor : listEditors) {
                    org.eclipse.swt.widgets.List listBox2 = listEditor.getListBox();
                    int i2 = 0;
                    while (i2 < listBox2.getItemCount()) {
                        if (listBox2.getItem(i2).equals(globalName)) {
                            listBox2.setItem(i2, newElement);
                        }
                        ++i2;
                    }
                }
                continue block0;
            }
        }
    }

    @Override
    public boolean isDisposed() {
        return this.combo.isDisposed();
    }

    private String[] newItems() {
        List globals = this.context.getGlobalEntries();
        LinkedList<String> result = new LinkedList<String>();
        for (IMessageFlowEntity value : globals) {
            PropertyCollectionMap propertyCollectionMap;
            String name;
            GlobalElement globalElement;
            GlobalDefinition globalDefinition;
            String categoryId;
            if (!(value instanceof GlobalElement) || !GlobalContributionHandler.isGlobalTransformer(categoryId = (globalDefinition = (GlobalDefinition)(globalElement = (GlobalElement)value).getDefinition()).getCategoryId()) || (name = (propertyCollectionMap = new PropertyCollectionMap(globalElement.getProperties())).getProperty("name", null)) == null) continue;
            result.add(name);
        }
        return result.toArray(new String[0]);
    }

    private void refreshCombos() {
        String[] newItems = this.newItems();
        LinkedList<ListEditor> toRemove = new LinkedList<ListEditor>();
        for (ListEditor listEditor : listEditors) {
            if (listEditor.isDisposed()) {
                toRemove.add(listEditor);
                continue;
            }
            listEditor.combo.setItems(newItems);
        }
        for (ListEditor listEditor : toRemove) {
            listEditors.remove(listEditor);
        }
    }

    private void fillLowerComposite(Composite lower) {
        Label label = new Label(lower, 0);
        label.setText("Transformers to be applied:");
        ToolBarManager toolBar = new ToolBarManager();
        Action moveUp = new Action(){

            public void run() {
                int selectionIndex = ListEditor.this.getListBox().getSelectionIndex();
                if (selectionIndex != -1 && selectionIndex != 0) {
                    String current = ListEditor.this.getListBox().getItem(selectionIndex);
                    String previous = ListEditor.this.getListBox().getItem(selectionIndex - 1);
                    ListEditor.this.getListBox().setItem(selectionIndex, previous);
                    ListEditor.this.getListBox().setItem(selectionIndex - 1, current);
                    ListEditor.this.getListBox().setSelection(selectionIndex - 1);
                }
            }
        };
        moveUp.setImageDescriptor(moveUpIcon);
        moveUp.setToolTipText("Move the transformer selected in the list to the up position");
        Action moveDown = new Action(){

            public void run() {
                int selectionIndex = ListEditor.this.getListBox().getSelectionIndex();
                if (selectionIndex != -1 && selectionIndex != ListEditor.this.getListBox().getItemCount() - 1) {
                    String current = ListEditor.this.getListBox().getItem(selectionIndex);
                    String next = ListEditor.this.getListBox().getItem(selectionIndex + 1);
                    ListEditor.this.getListBox().setItem(selectionIndex, next);
                    ListEditor.this.getListBox().setItem(selectionIndex + 1, current);
                    ListEditor.this.getListBox().setSelection(selectionIndex + 1);
                }
            }
        };
        moveDown.setImageDescriptor(moveDownIcon);
        moveDown.setToolTipText("Move the transformer selected in the list to the down position");
        Action remove = new Action(){

            public void run() {
                int selectionIndex = ListEditor.this.getListBox().getSelectionIndex();
                if (selectionIndex != -1) {
                    ListEditor.this.getListBox().remove(selectionIndex);
                }
            }
        };
        remove.setImageDescriptor(MuleImages.DESC_DELETE);
        remove.setDisabledImageDescriptor(MuleImages.DESC_DELETE_DISABLED);
        remove.setToolTipText("Remove the transformer from the list (NOT the transformer itself)");
        Action edit = new Action(){

            public void run() {
                int selectionIndex = ListEditor.this.listBox.getSelectionIndex();
                if (selectionIndex != -1) {
                    String globalName = ListEditor.this.listBox.getItem(selectionIndex);
                    ListEditor.this.edit(globalName);
                }
            }
        };
        edit.setImageDescriptor(MuleImages.DESC_EDIT);
        edit.setDisabledImageDescriptor(MuleImages.DESC_EDIT_DISABLED);
        edit.setToolTipText("Open the transformer configuration window (the one that is selected in the list)");
        toolBar.add((IAction)moveUp);
        toolBar.add((IAction)moveDown);
        toolBar.add((IAction)remove);
        toolBar.add((IAction)edit);
        toolBar.createControl(lower);
        GridData gridData = GridDataFactory.fillDefaults().grab(true, false).create();
        gridData.heightHint = 62;
        this.listBox = new org.eclipse.swt.widgets.List(lower, 2560);
        this.listBox.setLayoutData((Object)gridData);
        this.listBox.setItems(new String[0]);
    }

    private org.eclipse.swt.widgets.List getListBox() {
        return this.listBox;
    }

    @Override
    public String getValue() {
        CharSequence[] splitted = this.listBox.getItems();
        String result = String.join((CharSequence)" ", splitted);
        return result;
    }

    @Override
    public void setValue(String value) {
        if (value == null || value.equals("")) {
            String[] transformers = new String[]{};
            this.listBox.setItems(transformers);
            return;
        }
        String[] transformers = value.split(" ");
        this.listBox.setItems(transformers);
    }

    @Override
    public void accept(IFieldEditorVisitor visitor) {
        visitor.visit(this);
    }

    public static void clearCached() {
        listEditors.clear();
    }
}

