/*
 * Decompiled with CFR 0.152.
 */
package org.mule.tooling.ui.modules.core.widgets.editors;

import org.apache.commons.lang.StringUtils;
import org.apache.commons.lang.WordUtils;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.jdt.core.IType;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.jface.layout.GridLayoutFactory;
import org.eclipse.swt.custom.CLabel;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Drawable;
import org.eclipse.swt.graphics.FontMetrics;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.ui.PlatformUI;
import org.mule.tooling.core.model.IMuleProject;
import org.mule.tooling.core.utils.CoreUtils;
import org.mule.tooling.model.messageflow.IMessageFlowNode;
import org.mule.tooling.model.messageflow.decorator.PropertyCollectionMap;
import org.mule.tooling.ui.modules.core.widgets.AttributeContext;
import org.mule.tooling.ui.modules.core.widgets.editors.AbstractFieldEditor;
import org.mule.tooling.ui.modules.core.widgets.editors.IFieldEditorLayouter;
import org.mule.tooling.ui.modules.core.widgets.meta.AttributeHelper;
import org.mule.tooling.ui.modules.core.widgets.meta.EnumHelper;
import org.mule.tooling.ui.modules.core.widgets.meta.GlobalRefAttributeHelper;
import org.mule.tooling.ui.modules.core.widgets.utils.JavaFactory;
import org.mule.tooling.ui.widgets.util.ThemeUtils;

public abstract class LabelledFieldEditor
extends AbstractFieldEditor
implements IFieldEditorLayouter {
    protected Control label;
    protected Button browse;
    protected Control createdLabel;
    protected Control internalControl;
    protected boolean hasCheckbox;
    private Button checkButton;
    private IType selectedType;
    private static final int DEFAULT_WIDTH = 200;

    public LabelledFieldEditor(AttributeContext ctx, AttributeHelper atr, Composite parent, IMessageFlowNode node) {
        super(ctx, atr, parent, node);
    }

    public LabelledFieldEditor(AttributeContext ctx, AttributeHelper atr, Composite parent) {
        super(ctx, atr, parent);
    }

    @Override
    public void setEnabled(boolean enabled) {
        Control label2 = this.getLabel();
        if (label2 instanceof Button) {
            Button bs = (Button)label2;
            bs.setEnabled(enabled);
            this.setInternalControlEnabled(enabled && bs.getSelection());
        } else {
            this.setInternalControlEnabled(enabled);
        }
        if (this.browse != null) {
            this.browse.setEnabled(enabled);
        }
    }

    protected void uncheckCheckBox() {
        this.checkButton.setSelection(false);
    }

    @Override
    protected Control createControl(Composite parent) {
        Control ts;
        this.hasCheckbox = false;
        if (this.attributeHelper != null && StringUtils.isNotEmpty((String)this.attributeHelper.getCaption()) && !this.attributeHelper.ignoreGroupCaption()) {
            GlobalRefAttributeHelper a;
            String checkboxName;
            Composite compositeForLabel = parent;
            if (this.attributeHelper instanceof GlobalRefAttributeHelper && (checkboxName = (a = (GlobalRefAttributeHelper)this.attributeHelper).getAdditionalCheckbox()) != null) {
                this.hasCheckbox = true;
                Composite newComposite = new Composite(parent, 0);
                GridLayout gl = new GridLayout(3, false);
                GridData gd = new GridData(192, -1);
                final Button button = new Button(newComposite, 32);
                ThemeUtils.setCssClass((Object)button, (String)"CheckBoxButton");
                button.setSelection(true);
                this.checkButton = button;
                button.setData((Object)new GridData());
                button.addSelectionListener((SelectionListener)new SelectionAdapter(){

                    public void widgetSelected(SelectionEvent e) {
                        boolean selected = button.getSelection();
                        LabelledFieldEditor.this.setEnabled(selected);
                    }
                });
                button.setText(checkboxName);
                newComposite.setLayout((Layout)gl);
                newComposite.setLayoutData((Object)gd);
                compositeForLabel = newComposite;
            }
            this.createdLabel = this.createLabel(compositeForLabel);
            if (this.hasCheckbox) {
                GridDataFactory.fillDefaults().grab(true, false).align(131072, 0x1000000).applyTo(this.createdLabel);
                this.setLabel((Control)compositeForLabel);
            } else {
                this.setLabel(this.createdLabel);
                GridDataFactory.fillDefaults().align(4, this.getLabelVerticalAlignment()).applyTo(this.createdLabel);
            }
            this.setLabelText(parent);
        }
        Composite editorWrapper = this.createEditorWrapper(parent);
        this.internalControl = ts = this.internalCreateControl(editorWrapper);
        ts.setLayoutData((Object)this.getLayoutData());
        this.createExtraContent(editorWrapper);
        return ts;
    }

    protected int getLabelVerticalAlignment() {
        return 4;
    }

    public Control getInternalControl() {
        return this.internalControl;
    }

    protected Composite createEditorWrapper(Composite parent) {
        return parent;
    }

    protected void createExtraContent(Composite parent) {
        if (this.getHelper().getValueFactory() != null) {
            this.browse = new Button(parent, 0);
            this.browse.setText("...");
            this.browse.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent e) {
                    Object selectedValue = LabelledFieldEditor.this.getHelper().getValueFactory().getValue(LabelledFieldEditor.this.context);
                    if (selectedValue != null) {
                        if (selectedValue instanceof String) {
                            LabelledFieldEditor.this.setValue(LabelledFieldEditor.this.calculateValue(selectedValue.toString()));
                        } else if (selectedValue instanceof IType) {
                            IType type = (IType)selectedValue;
                            LabelledFieldEditor.this.setValue(type.getFullyQualifiedName());
                            LabelledFieldEditor.this.setSelectedType(type);
                        } else if (selectedValue instanceof IResource) {
                            IResource selectedResource = (IResource)selectedValue;
                            LabelledFieldEditor.this.setValue(CoreUtils.generateRelativePath((IProject)LabelledFieldEditor.this.context.getProject().getProject(), (IResource)selectedResource));
                        }
                    }
                }
            });
            this.browse.setLayoutData((Object)GridDataFactory.fillDefaults().grab(false, false).indent(-7, 0).create());
        }
    }

    protected String calculateValue(String selectedValue) {
        if (this.getHelper().shouldBeRelativeToProject()) {
            String relativePath;
            IMuleProject project = this.getContext().getProject();
            String projectPath = project.getProject().getLocation().toOSString();
            if (StringUtils.isNotBlank((String)selectedValue) && selectedValue.startsWith(projectPath) && StringUtils.isNotEmpty((String)(relativePath = CoreUtils.generateRelativePath((IProject)project.getProject(), (String)selectedValue)))) {
                return relativePath;
            }
        }
        return selectedValue;
    }

    protected void setSelectedType(IType type) {
        this.selectedType = type;
    }

    public IType getSelectedType() {
        return this.selectedType;
    }

    protected void setLabelText(Composite parent) {
        String description;
        Control label = this.getLabel();
        String text = this.getHelper().getCaption();
        String string = description = StringUtils.isNotEmpty((String)this.getHelper().getWarningMessage()) ? this.getHelper().getWarningMessage() : this.getHelper().getDescription();
        if (this.hasCheckbox) {
            ((CLabel)this.createdLabel).setText(text + ":");
            return;
        }
        if (label instanceof Button) {
            ((Button)label).setText(text + ":");
        } else if (label instanceof CLabel) {
            String dots = ":";
            if (this.attributeHelper.isCaptionIsUp()) {
                dots = "";
            }
            ((CLabel)label).setText(text + dots);
            ((CLabel)label).setToolTipText(WordUtils.wrap((String)description, (int)this.calculateWidthTooltip(parent)));
        }
    }

    private int calculateWidthTooltip(Composite parent) {
        Display display = Display.getCurrent();
        if (display != null && display.getActiveShell() != null) {
            int shellWidth = (int)((double)display.getActiveShell().getBounds().width * 0.8);
            GC gc = new GC((Drawable)parent);
            gc.setFont(parent.getFont());
            FontMetrics fontMetrics = gc.getFontMetrics();
            gc.dispose();
            int charwidth = Dialog.convertWidthInCharsToPixels((FontMetrics)fontMetrics, (int)1);
            int width = 0;
            if (charwidth != 0) {
                width = shellWidth / charwidth;
            }
            if (width == 0) {
                return 200;
            }
            return width;
        }
        return 200;
    }

    protected Control createLabel(Composite parent) {
        if (this.attributeHelper.getAlternatives().isEmpty()) {
            Composite labelComposite = parent;
            if (this.attributeHelper.isCaptionIsUp()) {
                labelComposite = new Composite(parent, 0);
                GridLayoutFactory.fillDefaults().applyTo(labelComposite);
                GridDataFactory.fillDefaults().span(3, 1).applyTo((Control)labelComposite);
            }
            CLabel label = new CLabel(labelComposite, 128);
            if (this.attributeHelper.isDeprecatedIn(this.getContext().getProject().getServerDefinition().getVersion())) {
                this.setWarningLabelAndMessage(label, this.attributeHelper.getDeprecatedMessage());
            } else if (StringUtils.isNotEmpty((String)this.attributeHelper.getWarningMessage())) {
                this.setWarningLabelAndMessage(label, this.attributeHelper.getWarningMessage());
            }
            return label;
        }
        final Button button = new Button(parent, 16);
        button.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                LabelledFieldEditor.this.setInternalControlEnabled(button.getSelection());
            }
        });
        return button;
    }

    private void setWarningLabelAndMessage(CLabel label, String message) {
        label.setImage(PlatformUI.getWorkbench().getSharedImages().getImage("IMG_OBJS_WARN_TSK"));
        if (StringUtils.isNotBlank((String)message)) {
            label.setToolTipText(message);
        }
    }

    protected void setInternalControlEnabled(boolean enabled) {
        super.setEnabled(enabled);
    }

    @Override
    protected Control getInfoDecorationControl() {
        if (this.browse != null) {
            return this.browse;
        }
        return this.control;
    }

    protected GridData getLayoutData() {
        return GridDataFactory.fillDefaults().align(4, 0x1000000).grab(true, false).span(this.singleHorizontalSpan() ? 1 : 2, 1).hint(200, -1).create();
    }

    protected boolean singleHorizontalSpan() {
        boolean hasClassCreator;
        boolean hasButton = this.attributeHelper.getValueFactory() != null || this.attributeHelper instanceof EnumHelper && StringUtils.isNotBlank((String)((EnumHelper)this.attributeHelper).getButtonClass()) && !((EnumHelper)this.attributeHelper).isButtonDisabled();
        boolean bl = hasClassCreator = this.attributeHelper.getValueFactory() != null && this.attributeHelper.getValueFactory() instanceof JavaFactory;
        return hasButton && !hasClassCreator;
    }

    protected abstract Control internalCreateControl(Composite var1);

    public void setLabel(Control label) {
        this.label = label;
    }

    public Control getLabel() {
        return this.label;
    }

    @Override
    public int computeLabelSize() {
        int msize = 0;
        if (this.getLabel() != null && !this.getLabel().isDisposed()) {
            int labelX = this.getLabel().computeSize((int)-1, (int)-1).x;
            msize = Math.max(msize, labelX);
        }
        return msize;
    }

    @Override
    public void updateLabelSize(int size) {
        if (this.getLabel() != null && this.getLabel().getLayoutData() == null) {
            GridData layoutData = new GridData(size, -1);
            this.adjustLabelLayout(layoutData);
            this.getLabel().setLayoutData((Object)layoutData);
        }
    }

    protected void adjustLabelLayout(GridData layoutData) {
        layoutData.verticalAlignment = 0x1000000;
    }

    @Override
    public void loadFrom(IMessageFlowNode node, PropertyCollectionMap props) {
        super.loadFrom(node, props);
        if (!this.attributeHelper.getAlternatives().isEmpty()) {
            boolean selected;
            boolean bl = selected = this.getValue() != null && this.getValue().length() > 0;
            if (this.label != null) {
                ((Button)this.getLabel()).setSelection(selected);
            }
            this.setInternalControlEnabled(selected);
        }
    }

    @Override
    public Control getContentControl() {
        return this.label;
    }

    public Button getBrowseButton() {
        return this.browse;
    }
}

