/*
 * Decompiled with CFR 0.152.
 */
package org.mule.tooling.ui.modules.core.widgets.editors;

import java.util.ArrayList;
import java.util.List;
import org.apache.commons.lang.StringUtils;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.jface.layout.GridLayoutFactory;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.mule.tooling.ui.modules.core.widgets.AttributeContext;
import org.mule.tooling.ui.modules.core.widgets.IFieldEditor;
import org.mule.tooling.ui.modules.core.widgets.IFieldEditorVisitor;
import org.mule.tooling.ui.modules.core.widgets.editors.AbstractCompositeEditor;
import org.mule.tooling.ui.modules.core.widgets.editors.SwitchEditor;
import org.mule.tooling.ui.modules.core.widgets.meta.AbstractCompositeAttributeHelper;
import org.mule.tooling.ui.modules.core.widgets.meta.AttributeGroup;
import org.mule.tooling.ui.modules.core.widgets.meta.AttributeHelper;
import org.mule.tooling.ui.modules.core.widgets.meta.HCompositeHelper;

public class HContainer
extends AbstractCompositeEditor {
    public HContainer(AttributeContext context, AttributeHelper atr, Composite gr, AttributeGroup agroup, SwitchEditor.NewEditorCallback newEditorCallback) {
        super(atr, gr, agroup, newEditorCallback);
    }

    @Override
    public AbstractCompositeAttributeHelper getHelper() {
        return (AbstractCompositeAttributeHelper)super.getHelper();
    }

    @Override
    protected AbstractCompositeEditor.CompositeAndItsParts createComposite(Composite gr, AttributeGroup agroup, SwitchEditor.NewEditorCallback newEditorCallback) {
        ArrayList<IFieldEditor> compositeParts = new ArrayList<IFieldEditor>();
        int horizontalSpan = 3;
        if (StringUtils.isNotEmpty((String)this.attributeHelper.getCaption())) {
            Label label = new Label(gr, 0);
            label.setText(this.getCaptionLabelText(this.attributeHelper.getCaption()));
            horizontalSpan = 2;
        }
        Composite composite = new Composite(gr, 0);
        List<AttributeHelper> children = this.getHelper().getChildren();
        GridDataFactory.fillDefaults().grab(true, false).span(horizontalSpan, 1).applyTo((Control)composite);
        HCompositeHelper compositeHelper = (HCompositeHelper)this.attributeHelper;
        GridLayoutFactory.fillDefaults().numColumns(children.size()).equalWidth(compositeHelper.isEqualWidth()).margins(0, 0).spacing(0, 0).applyTo(composite);
        for (AttributeHelper childAttributeHelper : children) {
            Composite innerElementContainer = new Composite(composite, 0);
            if (compositeHelper.isFillHorizontal(childAttributeHelper.getId())) {
                innerElementContainer.setLayoutData((Object)new GridData(768));
            }
            GridLayoutFactory.fillDefaults().numColumns(3).margins(compositeHelper.getMarginWidth(), compositeHelper.getMarginHeight()).spacing(0, 0).applyTo(innerElementContainer);
            compositeParts.add(newEditorCallback.create(innerElementContainer, childAttributeHelper, agroup));
        }
        composite.layout();
        return new AbstractCompositeEditor.CompositeAndItsParts(this, composite, compositeParts);
    }

    private String getCaptionLabelText(String caption) {
        if (!caption.endsWith(":")) {
            return caption + ":";
        }
        return caption;
    }

    @Override
    public void accept(IFieldEditorVisitor visitor) {
        visitor.visit(this);
    }
}

