/*
 * Decompiled with CFR 0.152.
 */
package org.mule.tooling.ui.modules.core.widgets.editors;

import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang.StringUtils;
import org.eclipse.core.resources.IFile;
import org.eclipse.gef.commands.Command;
import org.eclipse.gef.commands.CommandStack;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.ToolBarManager;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.jface.layout.GridLayoutFactory;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerFilter;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.ide.IDE;
import org.mule.tooling.core.MuleCorePlugin;
import org.mule.tooling.core.Scope;
import org.mule.tooling.core.generator.IFlowTransformerContext;
import org.mule.tooling.core.generator.NewFlowTransformerContext;
import org.mule.tooling.core.model.IMuleProject;
import org.mule.tooling.core.utils.CoreUtils;
import org.mule.tooling.core.utils.ExpressionUtils;
import org.mule.tooling.messageflow.command.AddGlobalElementCommand;
import org.mule.tooling.messageflow.command.UpdatePropertiesCommand;
import org.mule.tooling.messageflow.dialog.GlobalElementDialog;
import org.mule.tooling.messageflow.dialog.GlobalTypeChooser;
import org.mule.tooling.messageflow.editor.MessageFlowEditor;
import org.mule.tooling.messageflow.editor.MultiPageMessageFlowEditor;
import org.mule.tooling.messageflow.util.GlobalElementUtils;
import org.mule.tooling.messageflow.util.MessageFlowUtils;
import org.mule.tooling.model.messageflow.GlobalElement;
import org.mule.tooling.model.messageflow.GlobalUnknown;
import org.mule.tooling.model.messageflow.IMessageFlowEntity;
import org.mule.tooling.model.messageflow.IMessageFlowNode;
import org.mule.tooling.model.messageflow.IReadOnlyPropertyCollection;
import org.mule.tooling.model.messageflow.MessageFlowFactory;
import org.mule.tooling.model.messageflow.MuleConfiguration;
import org.mule.tooling.model.messageflow.Property;
import org.mule.tooling.model.messageflow.PropertyCollection;
import org.mule.tooling.model.messageflow.decorator.EntityDecorator;
import org.mule.tooling.model.messageflow.decorator.GlobalElementDecorator;
import org.mule.tooling.model.messageflow.decorator.MessageFlowNodeDecorator;
import org.mule.tooling.model.messageflow.decorator.MuleConfigurationDecorator;
import org.mule.tooling.model.messageflow.decorator.PropertyCollectionMap;
import org.mule.tooling.model.module.CategoryDefinition;
import org.mule.tooling.model.module.GlobalDefinition;
import org.mule.tooling.model.module.NodeDefinition;
import org.mule.tooling.ui.MuleImages;
import org.mule.tooling.ui.modules.core.widgets.AttributeContext;
import org.mule.tooling.ui.modules.core.widgets.AttributesPropertyPage;
import org.mule.tooling.ui.modules.core.widgets.editors.EnumFieldEditor;
import org.mule.tooling.ui.modules.core.widgets.meta.AttributeHelper;
import org.mule.tooling.ui.modules.core.widgets.meta.EnumOption;
import org.mule.tooling.ui.modules.core.widgets.meta.GlobalRefAttributeHelper;
import org.mule.tooling.utils.collection.ListView;

public class GlobalRefEditor
extends EnumFieldEditor {
    private static final String CREATE_NEW_CONNECTOR_CONFIGURATION = "---- Create a new configuration ----";
    private static LinkedList<Boolean> editors = new LinkedList();
    static GlobalRefEditor currentEditor;
    private boolean wasCorrectlyInited;
    private Action addLink;
    private Action editLink;
    private AttributesPropertyPage page;
    private ToolBarManager toolBarManager;

    public GlobalRefEditor(AttributeContext context, AttributeHelper attributeHelper, Composite parent) {
        super(context, attributeHelper, parent);
    }

    @Override
    protected void internalInit() {
        super.internalInit();
        if (!this.wasCorrectlyInited) {
            this.initInput();
            this.wasCorrectlyInited = true;
        }
    }

    /*
     * Unable to fully structure code
     * Could not resolve type clashes
     */
    protected boolean isElementChildOf(String elementType, String requiredType) {
        if (elementType == null || elementType.length() == 0 || requiredType == null || requiredType.length() == 0) {
            return false;
        }
        if (elementType.equals(requiredType)) {
            return true;
        }
        moduleManager = MuleCorePlugin.getModuleManager();
        global /* !! */  = moduleManager.getGlobalDefinition(elementType);
        if (global /* !! */  == null) {
            MuleCorePlugin.logWarning((String)("Cannot find global definition for element: " + elementType), null);
            return false;
        }
        global1 = moduleManager.getGlobalDefinition(requiredType);
        if (global1 != null) ** GOTO lbl23
        return false;
lbl-1000:
        // 1 sources

        {
            elementType = global /* !! */ .getExtendsDefinition();
            if (elementType.equals(requiredType)) {
                return true;
            }
            extendedGlobals = moduleManager.getExtendedGlobals(global /* !! */ );
            if (extendedGlobals == null || extendedGlobals.isEmpty()) {
                return false;
            }
            for (NodeDefinition globalDefinition : extendedGlobals) {
                if (!globalDefinition.equals((Object)global /* !! */ )) continue;
                return false;
            }
            global /* !! */  = extendedGlobals != null && extendedGlobals.isEmpty() == false ? (NodeDefinition)extendedGlobals.get(0) : null;
lbl23:
            // 2 sources

            ** while (global /* !! */ .getExtendsDefinition() != null && global /* !! */ .getExtendsDefinition().length() > 0)
        }
lbl24:
        // 1 sources

        alternativeIds2 = global /* !! */ .getAlternativeIds();
        for (NodeDefinition d : alternativeIds2) {
            if (!d.getId().equals(requiredType)) continue;
            return true;
        }
        return false;
    }

    public static List<IMessageFlowEntity> getActualGlobals(AttributeContext context) {
        List configurations = context.getProject().getConfigurationsCache().getConfigurations();
        ArrayList<IMessageFlowEntity> unionGlobalElements = new ArrayList<IMessageFlowEntity>();
        for (MuleConfiguration muleConfiguration : configurations) {
            if (!CoreUtils.belongToSameVisibilityScope((MuleConfiguration)context.getMuleConfiguration(), (MuleConfiguration)muleConfiguration)) {
                Scope.Visibility configVisibility = Scope.Visibility.parse((String)muleConfiguration.getVisibility());
                if (configVisibility == Scope.Visibility.LOCAL) continue;
                unionGlobalElements.addAll(muleConfiguration.getGlobalEntries());
                continue;
            }
            unionGlobalElements.addAll(muleConfiguration.getGlobalEntries());
        }
        return unionGlobalElements;
    }

    public static List<MessageFlowEntityEditableData> getActualGlobalsWithEditInformation(AttributeContext context) {
        IMuleProject muleProject = context.getProject();
        List configurations = muleProject.getConfigurationsCache().getConfigurations();
        ArrayList<MessageFlowEntityEditableData> unionGlobalElements = new ArrayList<MessageFlowEntityEditableData>();
        for (MuleConfiguration muleConfiguration : configurations) {
            if (!CoreUtils.belongToSameVisibilityScope((MuleConfiguration)context.getMuleConfiguration(), (MuleConfiguration)muleConfiguration)) {
                Scope.Visibility configVisibility = Scope.Visibility.parse((String)muleConfiguration.getVisibility());
                if (configVisibility == Scope.Visibility.LOCAL) continue;
                unionGlobalElements.addAll(GlobalRefEditor.getGlobalElementsWithEditInformation(muleConfiguration));
                continue;
            }
            unionGlobalElements.addAll(GlobalRefEditor.getGlobalElementsWithEditInformation(muleConfiguration));
        }
        return unionGlobalElements;
    }

    private static List<MessageFlowEntityEditableData> getGlobalElementsWithEditInformation(MuleConfiguration muleConfiguration) {
        ArrayList<MessageFlowEntityEditableData> unionGlobalElements = new ArrayList<MessageFlowEntityEditableData>();
        boolean isReadOnlyConfiguration = muleConfiguration.isReadOnly();
        List globalEntries = muleConfiguration.getGlobalEntries();
        for (IMessageFlowEntity messageFlowEntity : globalEntries) {
            unionGlobalElements.add(new MessageFlowEntityEditableData(messageFlowEntity, isReadOnlyConfiguration));
        }
        return unionGlobalElements;
    }

    public Action getEditLink() {
        return this.editLink;
    }

    @Override
    public List<EnumOption> calcOptions() {
        return this.calcOptions(false);
    }

    protected List<EnumOption> calcOptions(boolean refresh) {
        ArrayList results = Lists.newArrayList();
        GlobalRefAttributeHelper globalRefHelper = this.checkRequiredType();
        List<MessageFlowEntityEditableData> globalEntries = GlobalRefEditor.getActualGlobalsWithEditInformation(this.context);
        for (MessageFlowEntityEditableData globalEntityEditableData : globalEntries) {
            IMessageFlowEntity entity = globalEntityEditableData.getMessageFlowEntity();
            Optional<String> nameOpt = this.getName(entity, globalRefHelper);
            if (!nameOpt.isPresent() || !this.isValidOption(entity, globalRefHelper)) continue;
            String name = nameOpt.get();
            boolean readOnly = globalEntityEditableData.isReadOnly();
            boolean isUnknown = this.isUnknown(entity);
            results.add(new EnumOption(name, name, readOnly, isUnknown));
        }
        if (ExpressionUtils.isPropertyPlaceholder((String)this.value)) {
            results.add(new EnumOption(this.value, this.value, Boolean.TRUE));
        } else if (StringUtils.isNotEmpty((String)this.value) && results.stream().noneMatch(x -> x.value.equals(this.value))) {
            results.add(new EnumOption(this.value, this.value, Boolean.TRUE));
        }
        if (results.isEmpty()) {
            results.add(new EnumOption("", CREATE_NEW_CONNECTOR_CONFIGURATION));
        } else if (results.size() > 1 || !this.hasKnownEntityResult(results)) {
            results.add(new EnumOption("", ""));
        }
        return Lists.newArrayList((Iterable)Sets.newLinkedHashSet((Iterable)results));
    }

    private boolean hasKnownEntityResult(List<EnumOption> results) {
        return results.stream().anyMatch(option -> !option.isUnknown());
    }

    private boolean isUnknown(IMessageFlowEntity entity) {
        return entity instanceof GlobalUnknown;
    }

    private Optional<String> getName(IMessageFlowEntity value, GlobalRefAttributeHelper globalRefHelper) {
        if (value instanceof GlobalElement) {
            GlobalElement globalElement = (GlobalElement)value;
            PropertyCollectionMap propMap = new PropertyCollectionMap(globalElement.getProperties());
            String attrName = globalRefHelper.getAttrName();
            com.google.common.base.Optional nameOrId = propMap.getPropertyOpt(attrName).or(propMap.getPropertyOpt("id")).or(propMap.getPropertyOpt("name"));
            return (Optional)nameOrId.transform(Optional::of).or(Optional::empty);
        }
        if (value instanceof GlobalUnknown) {
            GlobalUnknown u = (GlobalUnknown)value;
            String unknownName = u.getUnknownName();
            return Optional.ofNullable(unknownName);
        }
        return Optional.empty();
    }

    private boolean isValidOption(IMessageFlowEntity entity, GlobalRefAttributeHelper globalRefHelper) {
        if (entity instanceof GlobalElement) {
            if (this.node == entity) {
                return false;
            }
            GlobalElement globalElement = (GlobalElement)entity;
            PropertyCollectionMap propMap = new PropertyCollectionMap(globalElement.getProperties());
            String attrName = globalRefHelper.getAttrName();
            String nameOrId = (String)propMap.getPropertyOpt(attrName).or(propMap.getPropertyOpt("id")).orNull();
            String requiredTypes = globalRefHelper.getRequiredType(this.context.getVersion());
            if (requiredTypes == null || nameOrId == null) {
                return false;
            }
            String[] alternatives = requiredTypes.split(";");
            return this.isValidOption(globalElement, alternatives);
        }
        return entity instanceof GlobalUnknown;
    }

    private boolean isValidOption(GlobalElement globalElement, String[] alternatives) {
        boolean suitable = false;
        String type = globalElement.getType();
        String[] stringArray = alternatives;
        int n = alternatives.length;
        int n2 = 0;
        block0: while (n2 < n) {
            String requiredType;
            String alternative = stringArray[n2];
            if (alternative != null && alternative.startsWith("$")) {
                String[] listOfParentTypes;
                String parentTypes = alternative.substring(1);
                String[] stringArray2 = listOfParentTypes = parentTypes.split(",");
                var13_15 = listOfParentTypes.length;
                int n3 = 0;
                while (n3 < var13_15) {
                    String parentType = stringArray2[n3];
                    String requiredType2 = parentType.trim();
                    if (this.isElementChildOf(type, requiredType2)) {
                        suitable = true;
                        break block0;
                    }
                    ++n3;
                }
            } else if (alternative != null && alternative.startsWith("@")) {
                String[] categoriesList;
                HashSet<String> categories = new HashSet<String>();
                String sm = alternative.substring(1);
                String[] stringArray3 = categoriesList = sm.split(",");
                int n4 = categoriesList.length;
                var13_15 = 0;
                while (var13_15 < n4) {
                    String category = stringArray3[var13_15];
                    category = category.trim();
                    categories.add(category);
                    ++var13_15;
                }
                GlobalDefinition global = (GlobalDefinition)globalElement.getDefinition();
                if (categories.contains(global.getCategoryId())) {
                    suitable = true;
                    break;
                }
            } else if (alternative != null && this.isElementChildOf(type, requiredType = alternative)) {
                suitable = true;
                break;
            }
            ++n2;
        }
        return suitable;
    }

    private GlobalRefAttributeHelper checkRequiredType() {
        String type;
        GlobalRefAttributeHelper gr = (GlobalRefAttributeHelper)this.attributeHelper;
        if (this.node != null && (type = this.node.getType()) != null && gr.getRequiredType(this.context.getVersion()) == null) {
            int lastIndexOf = type.lastIndexOf(47);
            if (lastIndexOf == -1) {
                gr.setRequiredType(type);
                return gr;
            }
            if (this.attributeHelper.getId().equals("ref")) {
                String attribute = type.substring(0, lastIndexOf) + "/endpoint";
                gr.setRequiredType(attribute);
                return gr;
            }
            String attribute = type.substring(0, lastIndexOf) + "/connector";
            gr.setRequiredType(attribute);
        }
        return gr;
    }

    @Override
    protected void createExtraContent(Composite parent) {
        Composite composite = new Composite(parent, 0);
        GridLayoutFactory.swtDefaults().margins(2, 0).applyTo(composite);
        this.toolBarManager = new ToolBarManager();
        this.addLink = new AddGlobalElementAction("Add");
        this.addLink.setImageDescriptor(MuleImages.DESC_ADD);
        this.addLink.setDisabledImageDescriptor(MuleImages.DESC_ADD_DISABLED);
        this.editLink = new EditGlobalElementAction("Edit");
        this.editLink.setImageDescriptor(MuleImages.DESC_EDIT);
        this.editLink.setDisabledImageDescriptor(MuleImages.DESC_EDIT_DISABLED);
        this.toolBarManager.add((IAction)this.addLink);
        this.toolBarManager.add((IAction)this.editLink);
        this.toolBarManager.createControl(composite).addDisposeListener(e -> this.toolBarManager.dispose());
        super.createExtraContent(parent);
        this.editLink.setEnabled(StringUtils.isNotEmpty((String)this.value));
    }

    protected void refreshAndInitInput() {
        List<EnumOption> options = this.calcOptions(true);
        this.cmb.setInput((Object)options.toArray());
    }

    @Override
    protected GridData getLayoutData() {
        return GridDataFactory.fillDefaults().grab(true, false).create();
    }

    @Override
    public void setParentPage(AttributesPropertyPage attributesPropertyPage) {
        this.page = attributesPropertyPage;
    }

    @Override
    protected void onSelectionChange(boolean shouldNotify) {
        super.onSelectionChange(false);
        if (this.editLink != null) {
            this.editLink.setEnabled(this.shouldEnableGlobalElementEdit(this.value));
        }
    }

    private boolean shouldEnableGlobalElementEdit(String content) {
        boolean shouldEdit = false;
        if (StringUtils.isNotEmpty((String)content)) {
            List<EnumOption> options = this.calcOptions(content);
            for (EnumOption option : options) {
                if (option.value == null || !option.value.equals(content) || option.isReadOnly()) continue;
                shouldEdit = true;
                break;
            }
        }
        return shouldEdit;
    }

    @Override
    protected void setInternalControlEnabled(boolean enabled) {
        if (this.addLink != null && this.editLink != null && this.toolBarManager != null) {
            this.addLink.setEnabled(enabled);
            this.editLink.setEnabled(enabled && this.shouldEnableGlobalElementEdit(this.value));
            if (this.toolBarManager.getControl() != null) {
                this.toolBarManager.getControl().setEnabled(enabled);
            }
        }
        this.cmb.getControl().setEnabled(enabled);
        this.isEnabled = enabled;
    }

    public static void openingNewDialog(boolean isChild) {
        editors.addLast(isChild);
    }

    public static void closingDialog() {
        editors.removeLast();
    }

    public static boolean isChild() {
        return !editors.isEmpty() && editors.getLast() != false;
    }

    public static GlobalRefEditor getCurrentEditor() {
        return currentEditor;
    }

    public static void setCurrentEditor(GlobalRefEditor currentEditor) {
        GlobalRefEditor.currentEditor = currentEditor;
    }

    public void setState(boolean enabled, boolean selected) {
        this.setEnabled(enabled);
        Control labelThatIsNotLabel = this.getLabel();
        if (labelThatIsNotLabel instanceof Button) {
            Button button = (Button)labelThatIsNotLabel;
            button.setSelection(selected);
        }
    }

    @Override
    protected void setEmptyValue() {
        if (this.hasCheckbox) {
            this.setEnabled(false);
            this.uncheckCheckBox();
        }
    }

    private final class AddGlobalElementAction
    extends Action {
        private static final String NAME_ID = "name";

        private AddGlobalElementAction(String text) {
            super(text);
        }

        public void run() {
            MultiPageMessageFlowEditor activeEditor = MessageFlowUtils.getMultiPageMessageFlowEditor();
            MessageFlowEditor owner = activeEditor.getFlowEditor();
            GlobalRefAttributeHelper gr = GlobalRefEditor.this.checkRequiredType();
            String type = gr.getRequiredType(GlobalRefEditor.this.context.getVersion());
            GlobalDefinition global = null;
            if (type != null && type.startsWith("$")) {
                final HashSet<String> tpes = new HashSet<String>();
                String sm = type.substring(1);
                String[] stringArray = sm.split(",");
                int n = stringArray.length;
                int n2 = 0;
                while (n2 < n) {
                    String s = stringArray[n2];
                    s = s.trim();
                    tpes.add(s);
                    ++n2;
                }
                GlobalTypeChooser chooser = new GlobalTypeChooser(Display.getCurrent().getActiveShell(), GlobalRefEditor.this.context.getProject(), true){

                    protected void addionalFilters(TreeViewer typesTree2) {
                        final List globalCategoryDefinitions = MuleCorePlugin.getModuleManager().getGlobalCategories(((AddGlobalElementAction)AddGlobalElementAction.this).GlobalRefEditor.this.context.getVersion());
                        typesTree2.addFilter(new ViewerFilter(){

                            public boolean select(Viewer viewer, Object parentElement, Object element) {
                                if (element instanceof CategoryDefinition) {
                                    CategoryDefinition cd = (CategoryDefinition)element;
                                    List globalsForCategory = MuleCorePlugin.getModuleManager().getGlobalDefinitionsForPaletteCategory(cd.getId(), ((AddGlobalElementAction)(this).AddGlobalElementAction.this).GlobalRefEditor.this.context.getVersion());
                                    for (CategoryDefinition gcd : globalCategoryDefinitions) {
                                        if (gcd.getParentCategory() == null || !gcd.getParentCategory().equals(cd.getId()) || !this.select(viewer, null, gcd)) continue;
                                        return true;
                                    }
                                    for (GlobalDefinition d : globalsForCategory) {
                                        if (!this.select(viewer, null, d)) continue;
                                        return true;
                                    }
                                    return false;
                                }
                                LinkedList<String> reqTypes = new LinkedList<String>();
                                for (String typeStr : tpes) {
                                    reqTypes.add(typeStr);
                                }
                                NodeDefinition nd = (NodeDefinition)element;
                                return tpes.contains(nd.getId());
                            }
                        });
                        super.addionalFilters(typesTree2);
                    }
                };
                if (chooser.open() == 0) {
                    global = chooser.getSelected();
                }
            } else if (type != null && type.startsWith("@")) {
                final HashSet<String> categories = new HashSet<String>();
                String[] splittedExpr = type.substring(1).split(";");
                String sm = splittedExpr[0];
                String[] stringArray = sm.split(",");
                int n = stringArray.length;
                int n3 = 0;
                while (n3 < n) {
                    String s = stringArray[n3];
                    s = s.trim();
                    categories.add(s);
                    ++n3;
                }
                final HashSet<String> additionalTypes = new HashSet<String>();
                int i = 1;
                while (i < splittedExpr.length) {
                    String additionalType = splittedExpr[i].trim();
                    additionalTypes.add(additionalType);
                    ++i;
                }
                GlobalTypeChooser chooser = new GlobalTypeChooser(Display.getCurrent().getActiveShell(), GlobalRefEditor.this.context.getProject()){

                    protected void addionalFilters(TreeViewer typesTree2) {
                        typesTree2.addFilter(new ViewerFilter(){

                            public boolean select(Viewer viewer, Object parentElement, Object element) {
                                NodeDefinition nd;
                                String id;
                                if (element instanceof NodeDefinition && additionalTypes.contains(id = (nd = (NodeDefinition)element).getId())) {
                                    return true;
                                }
                                if (element instanceof CategoryDefinition) {
                                    CategoryDefinition cd = (CategoryDefinition)element;
                                    if (categories.contains(cd.getId())) {
                                        return true;
                                    }
                                    List globalsForCategory = MuleCorePlugin.getModuleManager().getGlobalDefinitionsForPaletteCategory(cd.getId(), ((AddGlobalElementAction)(this).AddGlobalElementAction.this).GlobalRefEditor.this.context.getVersion());
                                    List globalCategoryDefinitions = MuleCorePlugin.getModuleManager().getGlobalCategories(((AddGlobalElementAction)(this).AddGlobalElementAction.this).GlobalRefEditor.this.context.getVersion());
                                    for (CategoryDefinition gcd : globalCategoryDefinitions) {
                                        String parentCategory = gcd.getParentCategory();
                                        if (parentCategory == null || !parentCategory.equals(cd.getId()) || !this.select(viewer, null, gcd)) continue;
                                        return true;
                                    }
                                    for (GlobalDefinition d : globalsForCategory) {
                                        if (!this.select(viewer, null, d)) continue;
                                        return true;
                                    }
                                    return false;
                                }
                                nd = (NodeDefinition)element;
                                return categories.contains(nd.getCategoryId());
                            }
                        });
                        super.addionalFilters(typesTree2);
                    }
                };
                if (chooser.open() == 0) {
                    global = chooser.getSelected();
                }
            } else {
                global = MuleCorePlugin.getModuleManager().getGlobalDefinition(type);
            }
            if (global == null) {
                return;
            }
            IFlowTransformerContext transformerContext = NewFlowTransformerContext.create((IMuleProject)GlobalRefEditor.this.context.getProject(), (MuleConfiguration)GlobalRefEditor.this.context.getMuleConfiguration());
            GlobalElement element = MessageFlowFactory.createGlobalElement((IFlowTransformerContext)transformerContext, (GlobalDefinition)global);
            GlobalRefEditor.openingNewDialog(false);
            GlobalElementDialog dialog = new GlobalElementDialog(Display.getCurrent().getActiveShell(), GlobalRefEditor.this.context.getProject(), element, () -> ((AttributeContext)GlobalRefEditor.this.context).getMuleConfiguration());
            GlobalRefEditor.setCurrentEditor(GlobalRefEditor.this);
            try {
                if (dialog.open() == 0) {
                    PropertyCollectionMap updatedProperties = dialog.getUpdatedProperties();
                    PropertyCollection updated = updatedProperties.asPropertyCollection();
                    String attrName = gr.getAttrName();
                    if ((StringUtils.isEmpty((String)attrName) || attrName.equals(NAME_ID)) && !updatedProperties.hasProperty(NAME_ID)) {
                        Property nameProperty = new Property();
                        nameProperty.setName(NAME_ID);
                        nameProperty.setValue(element.getName());
                        updated.getProperties().add(nameProperty);
                    }
                    element.setProperties(updated);
                    MuleConfiguration muleConfiguration = GlobalRefEditor.this.context.getMuleConfiguration();
                    AddGlobalElementCommand command = new AddGlobalElementCommand(GlobalRefEditor.this.context.getDecorator() != null ? GlobalRefEditor.this.context.getDecorator() : new MuleConfigurationDecorator(muleConfiguration), element);
                    owner.getEditDomain().getCommandStack().execute((Command)command);
                    activeEditor.getGlobalEditor().refresh();
                    GlobalRefEditor.this.initInput();
                    String property = this.getInputProperty(gr, element, dialog);
                    GlobalRefEditor.this.setValue(property);
                }
            }
            finally {
                GlobalRefEditor.closingDialog();
                GlobalRefEditor.setCurrentEditor(null);
            }
        }

        private String getInputProperty(GlobalRefAttributeHelper gr, GlobalElement element, GlobalElementDialog dialog) {
            String attrName = gr.getAttrName();
            if (!StringUtils.isEmpty((String)attrName)) {
                return dialog.getUpdatedProperties().getProperty(attrName, element.getName());
            }
            return dialog.getUpdatedProperties().getProperty(NAME_ID, element.getName());
        }
    }

    public final class EditGlobalElementAction
    extends Action {
        private EditGlobalElementAction(String text) {
            super(text);
        }

        public void run() {
            String currentAttributeValue = GlobalRefEditor.this.getValue();
            GlobalRefAttributeHelper gr = GlobalRefEditor.this.checkRequiredType();
            String attributeName = gr.getAttrName();
            IMuleProject muleProject = GlobalRefEditor.this.context.getProject();
            IWorkbenchPage activePage = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage();
            IMessageFlowNode ownerNode = GlobalRefEditor.this.page.getMessageFlowNode();
            MessageFlowEditor activeEditor = MessageFlowUtils.getFlowEditorFromActivePage();
            MuleConfiguration ownerNodeConfig = (MuleConfiguration)activeEditor.getModelRoot().getEntity();
            CommandStack commandStack = activeEditor.getEditDomain().getCommandStack();
            GlobalEditorElement globalResult = this.findGlobal(currentAttributeValue, attributeName, muleProject, activePage);
            if (globalResult == null) {
                throw new IllegalArgumentException("The global element to edit is not contained in any editor");
            }
            MultiPageMessageFlowEditor editor = globalResult.getEditor();
            String newAttributeValue = this.editGlobalElement(globalResult.getElement(), attributeName, editor, editor.getFlowEditor().getMuleConfiguration());
            if (StringUtils.isNotBlank((String)newAttributeValue)) {
                if (!GlobalRefEditor.this.isDisposed()) {
                    GlobalRefEditor.this.refreshAndInitInput();
                    GlobalRefEditor.this.setValue(newAttributeValue);
                } else {
                    IReadOnlyPropertyCollection originalProperties = ownerNode.getProperties();
                    PropertyCollectionMap updatedPropertiesMap = new PropertyCollectionMap(originalProperties);
                    updatedPropertiesMap.addProperty(GlobalRefEditor.this.attributeHelper.getId(), newAttributeValue);
                    MuleConfigurationDecorator configDecorator = new MuleConfigurationDecorator(ownerNodeConfig);
                    MessageFlowNodeDecorator entityDecorator = new MessageFlowNodeDecorator(ownerNode);
                    UpdatePropertiesCommand updatePropertiesCommand = new UpdatePropertiesCommand(GlobalRefEditor.this.page.getMuleProject(), configDecorator, (EntityDecorator)entityDecorator, originalProperties, updatedPropertiesMap.asPropertyCollection());
                    commandStack.execute((Command)updatePropertiesCommand);
                }
            }
        }

        public GlobalEditorElement findGlobal(String currentAttributeValue, String attributeName, IMuleProject muleProject, IWorkbenchPage activePage) {
            GlobalEditorElement globalResult = this.findInOpenEditors(muleProject, attributeName, currentAttributeValue, activePage).orElseGet(() -> this.openContainingEditor(activePage, muleProject, attributeName, currentAttributeValue).orElse(null));
            return globalResult;
        }

        private Optional<GlobalEditorElement> findInOpenEditors(IMuleProject muleProject, String attributeName, String name, IWorkbenchPage activePage) {
            MultiPageMessageFlowEditor.OpenEditors openEditors = MultiPageMessageFlowEditor.selectOpenEditorsOfProject((String)muleProject.getName());
            List allOpenEditors = ListView.of((List)openEditors.editorsInFlowMode, (List)openEditors.editorsInXmlMode);
            for (MultiPageMessageFlowEditor editor : allOpenEditors) {
                Optional<GlobalElement> globalElement = this.findGlobalElement(editor.getMuleConfiguration(), attributeName, name);
                if (!globalElement.isPresent()) continue;
                Map resourceToConfigMap = muleProject.getConfigurationsCache().getResourceToConfigMap();
                resourceToConfigMap.forEach((k, v) -> {
                    if (v.equals(editor.getMuleConfiguration())) {
                        this.openGlobalElementEditor(activePage, (IFile)k);
                    }
                });
                return Optional.of(new GlobalEditorElement(editor, globalElement.get()));
            }
            return Optional.empty();
        }

        private Optional<GlobalEditorElement> openContainingEditor(IWorkbenchPage activePage, IMuleProject muleProject, String attributeName, String name) {
            Map resourceToConfigMap = muleProject.getConfigurationsCache().getResourceToConfigMap();
            for (Map.Entry entry : resourceToConfigMap.entrySet()) {
                Optional<GlobalElement> globalElement = this.findGlobalElement((MuleConfiguration)entry.getValue(), attributeName, name);
                if (!globalElement.isPresent()) continue;
                MultiPageMessageFlowEditor editor = this.openGlobalElementEditor(activePage, (IFile)entry.getKey());
                return Optional.of(new GlobalEditorElement(editor, globalElement.get()));
            }
            return Optional.empty();
        }

        private Optional<GlobalElement> findGlobalElement(MuleConfiguration conf, String idAttributeName, String oldName) {
            Collection<GlobalElement> filteredGlobalElements = this.getFilteredElements(conf.getGlobalEntries());
            return filteredGlobalElements.stream().filter(globalElement -> {
                PropertyCollectionMap propertyCollectionMap = new PropertyCollectionMap(globalElement.getProperties());
                String property = propertyCollectionMap.getProperty(idAttributeName, "");
                return property.equals(oldName);
            }).findFirst();
        }

        private MultiPageMessageFlowEditor openGlobalElementEditor(IWorkbenchPage activePage, IFile file) {
            try {
                MultiPageMessageFlowEditor openEditor = (MultiPageMessageFlowEditor)IDE.openEditor((IWorkbenchPage)activePage, (IFile)file, (String)"org.mule.tooling.messageflow.messageFlowEditor");
                openEditor.openGlobalElementsPage();
                return openEditor;
            }
            catch (PartInitException e) {
                throw new RuntimeException(e);
            }
        }

        private Collection<GlobalElement> getFilteredElements(List<IMessageFlowEntity> entries) {
            List globalElements = CoreUtils.filterByType(entries, GlobalElement.class);
            List<String> requiredTypes = this.getRequiredTypes();
            if (CollectionUtils.isEmpty(requiredTypes)) {
                return globalElements;
            }
            ArrayList<GlobalElement> filteredList = new ArrayList<GlobalElement>();
            for (GlobalElement globalElement : globalElements) {
                String globalElementType = globalElement.getType();
                if (!requiredTypes.contains(globalElementType) && !this.containsAnAlternativeId(requiredTypes, globalElement.getDefinition())) continue;
                filteredList.add(globalElement);
            }
            return filteredList;
        }

        private List<String> getRequiredTypes() {
            ArrayList<String> result = new ArrayList<String>();
            GlobalRefAttributeHelper globalRefHelper = GlobalRefEditor.this.checkRequiredType();
            String requiredType = globalRefHelper.getRequiredType(GlobalRefEditor.this.context.getVersion());
            if (requiredType.startsWith("$")) {
                String[] reqTypeList;
                String[] stringArray = reqTypeList = requiredType.substring(1).split(",");
                int n = reqTypeList.length;
                int n2 = 0;
                while (n2 < n) {
                    String reqTypeFromList = stringArray[n2];
                    result.add(reqTypeFromList.trim());
                    ++n2;
                }
            } else {
                result.add(requiredType);
            }
            return result;
        }

        private boolean containsAnAlternativeId(List<String> requiredTypes, NodeDefinition globalDefinition) {
            List alternativeIds = globalDefinition.getAlternativeIdsTypes();
            return CollectionUtils.containsAny(requiredTypes, (Collection)alternativeIds);
        }

        private String editGlobalElement(GlobalElement globalElement, String attributeName, MultiPageMessageFlowEditor editor, MuleConfiguration conf) {
            PropertyCollectionMap updatedPropertiesMap;
            PropertyCollection updatedProperties;
            IReadOnlyPropertyCollection previous;
            boolean okPressed;
            IMuleProject project = editor.getMuleProject();
            GlobalElementDialog dialog = new GlobalElementDialog(Display.getCurrent().getActiveShell(), project, globalElement, () -> conf);
            boolean bl = okPressed = dialog.open() == 0;
            if (okPressed && GlobalElementUtils.areAnyChanges((IReadOnlyPropertyCollection)(previous = globalElement.getProperties()), (PropertyCollection)(updatedProperties = (updatedPropertiesMap = dialog.getUpdatedProperties()).asPropertyCollection()), (GlobalElementDialog)dialog)) {
                GlobalElementDecorator globalDecorator = new GlobalElementDecorator(globalElement);
                MuleConfigurationDecorator configDecorator = new MuleConfigurationDecorator(conf);
                CommandStack commandStack = editor.getFlowEditor().getEditDomain().getCommandStack();
                UpdatePropertiesCommand command = new UpdatePropertiesCommand(project, configDecorator, (EntityDecorator)globalDecorator, previous, updatedProperties);
                commandStack.execute((Command)command);
                String updatedAttributeValue = updatedPropertiesMap.getProperty(attributeName, "");
                editor.getGlobalEditor().refresh();
                return updatedAttributeValue;
            }
            return null;
        }

        private final class GlobalEditorElement {
            private MultiPageMessageFlowEditor editor;
            private GlobalElement element;

            public GlobalEditorElement(MultiPageMessageFlowEditor editor, GlobalElement element) {
                this.editor = editor;
                this.element = element;
            }

            public MultiPageMessageFlowEditor getEditor() {
                return this.editor;
            }

            public GlobalElement getElement() {
                return this.element;
            }
        }
    }

    private static class MessageFlowEntityEditableData {
        private final IMessageFlowEntity messageFlowEntity;
        private final boolean isReadOnly;

        public MessageFlowEntityEditableData(IMessageFlowEntity messageFlowEntity, boolean isReadOnly) {
            this.messageFlowEntity = messageFlowEntity;
            this.isReadOnly = isReadOnly;
        }

        public IMessageFlowEntity getMessageFlowEntity() {
            return this.messageFlowEntity;
        }

        public boolean isReadOnly() {
            return this.isReadOnly;
        }
    }
}

