/*
 * Decompiled with CFR 0.152.
 */
package org.mule.tooling.ui.modules.core.widgets.editors;

import java.util.Objects;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.jface.layout.GridLayoutFactory;
import org.eclipse.swt.custom.StackLayout;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.ToolBar;
import org.eclipse.swt.widgets.ToolItem;
import org.mule.tooling.core.analytics.AnalyticsRecordsFactory;
import org.mule.tooling.core.analytics.Events;
import org.mule.tooling.core.event.LayoutPropertiesEditorRequest;
import org.mule.tooling.model.messageflow.IMessageFlowNode;
import org.mule.tooling.ui.modules.core.widgets.AttributeContext;
import org.mule.tooling.ui.modules.core.widgets.editors.FieldEditorContext;
import org.mule.tooling.ui.modules.core.widgets.editors.FieldEditorValueAware;
import org.mule.tooling.ui.modules.core.widgets.editors.IBasicFieldEditor;
import org.mule.tooling.ui.modules.core.widgets.editors.LabelledFieldEditor;
import org.mule.tooling.ui.modules.core.widgets.meta.AttributeHelper;
import org.mule.tooling.ui.modules.core.widgets.meta.FieldEditorManager;
import org.mule.tooling.ui.modules.core.widgets.meta.creators.FieldEditorCreator;
import org.mule.tooling.ui.widgets.layout.ContentFitStackLayout;
import org.mule.tooling.ui.widgets.theme.StudioDarkTheme;
import org.mule.tooling.ui.widgets.util.ThemeUtils;
import org.mule.tooling.utils.UtilsPlugin;
import org.mule.tooling.utils.eventbus.IEvent;
import org.mule.tooling.utils.script.ScriptUtils;

public abstract class ExpressionWrapperFieldEditor
extends LabelledFieldEditor {
    private static final String DATA_WEAVE_CREATOR_NAME = "dataWeaveCreator";
    private static final String SWITCH_TO_LITERAL_MODE = "Switch to literal mode.";
    private static final String SWITCH_TO_EXPRESSION_MODE = "Switch to expression mode.";
    private Composite editorContainer;
    private StackLayout editorContainerLayout;
    private Control weaveWrapper;
    private Composite editorWrapper;
    private FieldEditorValueAware weaveEditor;
    private FieldEditorValueAware literalEditor;
    private FieldEditorValueAware currentEditor;
    private ToolItem expressionSwitcher;
    private String loadedValue;
    private FieldEditorContext fieldEditorContext;

    public ExpressionWrapperFieldEditor(AttributeContext ctx, AttributeHelper atr, Composite parent) {
        this(ctx, atr, parent, null);
    }

    public ExpressionWrapperFieldEditor(AttributeContext ctx, AttributeHelper atr, Composite parent, IMessageFlowNode node) {
        super(ctx, atr, parent, node);
    }

    @Override
    protected Composite createEditorWrapper(Composite parent) {
        this.editorWrapper = parent;
        if (this.supportExpressions()) {
            this.createWeaveScriptHolder(parent);
        }
        this.literalEditor = new LiteralFieldEditorValueAware();
        this.setCurrentEditor(this.literalEditor);
        return this.editorWrapper;
    }

    private void createWeaveScriptHolder(Composite parent) {
        Composite contentWrapper = new Composite(parent, 0);
        if (!this.requiresExpression()) {
            ToolBar toolBar = new ToolBar(contentWrapper, 2304);
            this.expressionSwitcher = new ToolItem(toolBar, 32);
            this.expressionSwitcher.setToolTipText(SWITCH_TO_EXPRESSION_MODE);
            this.expressionSwitcher.setImage(fxImage);
            if (ThemeUtils.getCurrentTheme() instanceof StudioDarkTheme) {
                this.expressionSwitcher.setImage(fxDarkImage);
            }
            this.expressionSwitcher.addSelectionListener((SelectionListener)new ExpressionSwitcherSelectionListener());
            GridDataFactory.fillDefaults().align(4, 1).applyTo((Control)toolBar);
        }
        GridLayoutFactory.fillDefaults().numColumns(2).applyTo(contentWrapper);
        GridDataFactory.fillDefaults().grab(true, false).align(4, 1).span(2, 1).minSize(-1, this.getHeightHint(contentWrapper)).applyTo((Control)contentWrapper);
        this.editorContainer = new Composite(contentWrapper, 0);
        this.editorContainerLayout = new ContentFitStackLayout();
        this.editorContainer.setLayout((Layout)this.editorContainerLayout);
        GridDataFactory.fillDefaults().grab(true, true).indent(4, 0).applyTo((Control)this.editorContainer);
        this.editorWrapper = new Composite(this.editorContainer, 0);
        GridLayoutFactory.fillDefaults().numColumns(2).extendedMargins(5, 0, 0, 0).applyTo(this.editorWrapper);
        GridDataFactory.fillDefaults().grab(true, true).applyTo((Control)this.editorWrapper);
        this.fieldEditorContext = this.createFieldEditorContext(parent);
        this.editorContainerLayout.topControl = this.editorWrapper;
        this.editorContainer.layout();
    }

    private void createWeaveEditor(FieldEditorContext fieldEditorContext) {
        FieldEditorCreator dataWeaveCreator = FieldEditorManager.fromName(DATA_WEAVE_CREATOR_NAME);
        IBasicFieldEditor editor = dataWeaveCreator.create();
        this.weaveWrapper = editor.createControl(this.editorContainer, fieldEditorContext);
        this.weaveEditor = editor;
    }

    protected int getHeightHint(Composite contentWrapper) {
        return -1;
    }

    @Override
    protected int getLabelVerticalAlignment() {
        return this.supportExpressions() ? 1 : super.getLabelVerticalAlignment();
    }

    @Override
    public final void setValue(String value) {
        this.loadedValue = value;
        if (this.currentEditor != null) {
            if (this.requiresExpression()) {
                this.showWeaveEditor();
            } else if (ScriptUtils.isScript((String)value) && this.supportExpressions()) {
                this.showWeaveEditor();
                this.expressionSwitcher.setSelection(true);
            }
            this.currentEditor.setValue(value);
        }
    }

    public abstract void setLiteralValue(String var1);

    public abstract String getLiteralValue();

    @Override
    public final String getValue() {
        if (this.currentEditor != null) {
            return this.currentEditor.getValue();
        }
        return this.loadedValue;
    }

    @Override
    public int getDecoratorMarginWidth() {
        return this.currentEditor.getDecoratorMarginWidth();
    }

    protected boolean supportExpressions() {
        return this.getHelper().isSupportsExpressions() || this.getHelper().isSingleLineExp();
    }

    protected boolean requiresExpression() {
        return this.getHelper().isRequiresExpression();
    }

    @Override
    protected void switchToExpression() {
        this.expressionSwitcher.setSelection(true);
        this.expressionSwitcher.notifyListeners(13, new Event());
    }

    private void showWeaveEditor() {
        this.setExpressionSwitcherTooltipText(SWITCH_TO_LITERAL_MODE);
        this.createAndInitIfNotExisting();
        this.editorContainerLayout.topControl = this.weaveWrapper;
        this.weaveEditor.setValue(ScriptUtils.toScript((String)this.currentEditor.getValue()));
        this.editorContainer.layout();
        this.setCurrentEditor(this.weaveEditor);
    }

    private void createAndInitIfNotExisting() {
        if (this.weaveWrapper == null) {
            this.createWeaveEditor(this.fieldEditorContext);
            String currentScript = ScriptUtils.toScript((String)this.currentEditor.getValue());
            if (!Objects.equals(currentScript, this.loadedValue)) {
                this.setValue(currentScript);
            }
        }
    }

    protected void showLiteralEditor() {
        this.setExpressionSwitcherTooltipText(SWITCH_TO_EXPRESSION_MODE);
        this.editorContainerLayout.topControl = this.editorWrapper;
        this.editorContainer.layout();
        if (this.currentEditor != null) {
            this.literalEditor.setValue(ScriptUtils.getScriptContentOrText((String)this.currentEditor.getValue()));
        }
        this.setCurrentEditor(this.literalEditor);
    }

    private void setExpressionSwitcherTooltipText(String tooltipText) {
        if (this.expressionSwitcher != null) {
            this.expressionSwitcher.setToolTipText(tooltipText);
        }
    }

    private void setCurrentEditor(FieldEditorValueAware editor) {
        this.currentEditor = editor;
        Control eventControl = this.currentEditor.getEventControl();
        if (eventControl != null) {
            this.changeEventControl(eventControl);
        }
    }

    private int getDefaultDecoratorMarginWidth() {
        return super.getDecoratorMarginWidth();
    }

    protected boolean isExpressionSelected() {
        return this.expressionSwitcher.getSelection();
    }

    protected void setExpressionSwitcherSelection(boolean value) {
        this.expressionSwitcher.setSelection(value);
    }

    private final class ExpressionSwitcherSelectionListener
    extends SelectionAdapter {
        private ExpressionSwitcherSelectionListener() {
        }

        public void widgetSelected(SelectionEvent e) {
            if (ExpressionWrapperFieldEditor.this.isExpressionSelected()) {
                AnalyticsRecordsFactory.single((String)Events.EXPRESSION_SWITCH).track();
                ExpressionWrapperFieldEditor.this.showWeaveEditor();
            } else {
                AnalyticsRecordsFactory.single((String)Events.LITERAL_SWITCH).track();
                ExpressionWrapperFieldEditor.this.showLiteralEditor();
            }
            UtilsPlugin.getEventBus().fireEvent((IEvent)new LayoutPropertiesEditorRequest());
        }
    }

    private final class LiteralFieldEditorValueAware
    implements FieldEditorValueAware {
        private LiteralFieldEditorValueAware() {
        }

        @Override
        public void setValue(String value) {
            ExpressionWrapperFieldEditor.this.setLiteralValue(value);
        }

        @Override
        public String getValue() {
            return ExpressionWrapperFieldEditor.this.getLiteralValue();
        }

        @Override
        public Control getEventControl() {
            return ExpressionWrapperFieldEditor.this.getInternalControl();
        }

        @Override
        public int getDecoratorMarginWidth() {
            return ExpressionWrapperFieldEditor.this.getDefaultDecoratorMarginWidth();
        }
    }
}

