/*
 * Decompiled with CFR 0.152.
 */
package org.mule.tooling.ui.modules.core.widgets.editors;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Optional;
import org.apache.commons.lang3.StringUtils;
import org.eclipse.jface.viewers.CheckStateChangedEvent;
import org.eclipse.jface.viewers.CheckboxTreeViewer;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.ICheckStateListener;
import org.eclipse.jface.viewers.ICheckStateProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Composite;
import org.mule.tooling.core.MuleCorePlugin;
import org.mule.tooling.core.module.contribution.ErrorModel;
import org.mule.tooling.model.messageflow.IMessageFlowNode;
import org.mule.tooling.ui.modules.core.widgets.editors.CustomErrorModelFactory;
import org.mule.tooling.ui.modules.core.widgets.editors.ErrorTypesProvider;

public class ErrorTypesTree {
    private CheckboxTreeViewer typesTree;
    private ErrorTypeTreeContentProvider treeContentProvider;
    private ErrorModel[] options;
    private Object[] checkedOptions;
    private IMessageFlowNode node;
    private boolean multiSelect;
    private ErrorTypesProvider errorTypesProvider;

    public ErrorTypesTree(IMessageFlowNode node, boolean multiSelect) {
        this.node = node;
        this.multiSelect = multiSelect;
        this.errorTypesProvider = new ErrorTypesProvider(MuleCorePlugin.getDesignContext().getMuleProject());
    }

    public void createTypesTree(Composite shell, String typesText) {
        this.options = this.errorTypesProvider.getErrorTypesForNode(typesText, this.node);
        this.typesTree = new CheckboxTreeViewer(shell, 68098);
        this.typesTree.setAutoExpandLevel(2);
        this.treeContentProvider = new ErrorTypeTreeContentProvider();
        this.typesTree.setContentProvider((IContentProvider)this.treeContentProvider);
        this.typesTree.setLabelProvider((IBaseLabelProvider)new LabelProvider(){

            public String getText(Object element) {
                if (element instanceof ErrorModel) {
                    String namespace = ((ErrorModel)element).getNamespace();
                    String type = ((ErrorModel)element).getType();
                    if (namespace.equals("MULE") || namespace.equals("CORE")) {
                        return type;
                    }
                    return namespace + ":" + type;
                }
                return super.getText(element);
            }
        });
        this.typesTree.addCheckStateListener(new ICheckStateListener(){

            public void checkStateChanged(CheckStateChangedEvent event) {
                if (ErrorTypesTree.this.multiSelect) {
                    ErrorTypesTree.this.typesTree.setSubtreeChecked(event.getElement(), event.getChecked());
                    ErrorTypesTree.this.checkedOptions = ErrorTypesTree.this.typesTree.getCheckedElements();
                } else {
                    ErrorTypesTree.this.typesTree.setChecked(event.getElement(), event.getChecked());
                    ErrorTypesTree.this.checkedOptions = new Object[]{event.getElement()};
                }
                ErrorTypesTree.this.typesTree.refresh();
            }
        });
        this.typesTree.setCheckStateProvider(new ICheckStateProvider(){

            public boolean isGrayed(Object element) {
                if (ErrorTypesTree.this.multiSelect && element instanceof ErrorModel && ErrorTypesTree.this.treeContentProvider.hasChildren(element) && this.isChecked(element)) {
                    return !ErrorTypesTree.this.allChildrenChecked((ErrorModel)element);
                }
                return false;
            }

            public boolean isChecked(Object element) {
                if (ErrorTypesTree.this.multiSelect && element instanceof ErrorModel && ErrorTypesTree.this.treeContentProvider.hasChildren(element)) {
                    return ErrorTypesTree.this.hasChildChecked((ErrorModel)element);
                }
                return ErrorTypesTree.this.isCheckedOption(element);
            }
        });
        this.typesTree.getTree().setLayoutData((Object)new GridData(1808));
        this.typesTree.setInput((Object)this.options);
        this.checkedOptions = this.getCheckedOptions(typesText);
        if (this.checkedOptions != null) {
            this.typesTree.setCheckedElements(this.checkedOptions);
        }
    }

    public CheckboxTreeViewer getTypesTree() {
        return this.typesTree;
    }

    public String getTypesText() {
        if (!(this.checkedOptions != null || this.checkedOptions.length != 0 && this.checkedOptions[0] instanceof ErrorModel)) {
            return "ANY";
        }
        ArrayList<ErrorModel> result = new ArrayList<ErrorModel>();
        Object[] objectArray = this.checkedOptions;
        int n = this.checkedOptions.length;
        int n2 = 0;
        while (n2 < n) {
            ErrorModel error;
            Object option = objectArray[n2];
            if (option instanceof ErrorModel && !this.typesTree.getGrayed((Object)(error = (ErrorModel)option))) {
                Optional parent = error.getParent();
                if (parent.isPresent() && this.isCheckedOption(parent.get())) {
                    if (this.typesTree.getGrayed(parent.get())) {
                        result.add(error);
                    }
                } else {
                    result.add(error);
                }
            }
            ++n2;
        }
        return result.isEmpty() ? "ANY" : this.errorsListToText(result);
    }

    private String errorsListToText(List<ErrorModel> result) {
        StringBuilder sb = new StringBuilder();
        result.forEach(e -> {
            String namespace = e.getNamespace();
            if (StringUtils.isNotBlank((CharSequence)namespace) && !namespace.equals("MULE") && !namespace.equals("CORE")) {
                sb.append(namespace + ":");
            }
            sb.append(e.getType());
            sb.append(", ");
        });
        return sb.substring(0, sb.length() - 2).toString();
    }

    static boolean sameError(ErrorModel errorModel, String e) {
        ErrorModel custom = CustomErrorModelFactory.createErrorFrom(e);
        return ErrorTypesTree.sameError(errorModel, custom);
    }

    private static boolean sameError(ErrorModel errorModel, ErrorModel custom) {
        boolean sameNamespace = errorModel.getNamespace().equals(custom.getNamespace());
        boolean sameType = errorModel.getType().equals(custom.getType());
        return sameNamespace && sameType;
    }

    public ErrorModel[] getCheckedOptions(String text) {
        ArrayList checkedText = StringUtils.isNotBlank((CharSequence)text) ? Lists.newArrayList((Object[])text.split(", ")) : Lists.newArrayList();
        ArrayList checkedErrors = Lists.newArrayList();
        checkedText.forEach(errorName -> {
            List<ErrorModel> errorTypes = this.getErrorType((String)errorName);
            if (errorTypes != null && !errorTypes.isEmpty()) {
                checkedErrors.addAll(errorTypes);
            } else {
                checkedErrors.add(CustomErrorModelFactory.createErrorFrom(errorName));
            }
        });
        return checkedErrors.toArray(new ErrorModel[checkedErrors.size()]);
    }

    private List<ErrorModel> getErrorType(String errorName) {
        boolean notCore = errorName.contains(":");
        String namespace = "MULE";
        String identifier = errorName;
        if (notCore) {
            int indexOf = errorName.indexOf(":");
            namespace = errorName.substring(0, indexOf);
            identifier = errorName.substring(indexOf + 1, errorName.length());
        }
        ErrorModel[] errorModelArray = this.options;
        int n = this.options.length;
        int n2 = 0;
        while (n2 < n) {
            ErrorModel error = errorModelArray[n2];
            if (error.getType().equals(identifier) && error.getNamespace().equals(namespace)) {
                ArrayList errors = Lists.newArrayList();
                errors.addAll(this.getChildrenErrors(error));
                return errors;
            }
            ++n2;
        }
        return null;
    }

    private Collection<? extends ErrorModel> getChildrenErrors(ErrorModel error) {
        Object[] children;
        ArrayList result = Lists.newArrayList((Object[])new ErrorModel[]{error});
        Object[] objectArray = children = this.treeContentProvider.getChildren(error);
        int n = children.length;
        int n2 = 0;
        while (n2 < n) {
            Object child = objectArray[n2];
            if (child instanceof ErrorModel) {
                result.addAll(this.getChildrenErrors((ErrorModel)child));
            }
            ++n2;
        }
        return result;
    }

    protected boolean hasChildChecked(ErrorModel element) {
        Object[] children;
        Object[] objectArray = children = this.treeContentProvider.getChildren(element);
        int n = children.length;
        int n2 = 0;
        while (n2 < n) {
            Object error = objectArray[n2];
            if (this.isCheckedOption(error)) {
                return true;
            }
            ++n2;
        }
        return false;
    }

    protected boolean allChildrenChecked(ErrorModel element) {
        Object[] children;
        Object[] objectArray = children = this.treeContentProvider.getChildren(element);
        int n = children.length;
        int n2 = 0;
        while (n2 < n) {
            Object error = objectArray[n2];
            if (!this.isCheckedOption(error)) {
                return false;
            }
            ++n2;
        }
        return true;
    }

    private boolean isCheckedOption(Object element) {
        if (this.checkedOptions != null) {
            Object[] objectArray = this.checkedOptions;
            int n = this.checkedOptions.length;
            int n2 = 0;
            while (n2 < n) {
                Object option = objectArray[n2];
                if (element instanceof ErrorModel && option instanceof ErrorModel && ErrorTypesTree.sameError((ErrorModel)element, (ErrorModel)option)) {
                    return true;
                }
                ++n2;
            }
        }
        return false;
    }

    private class ErrorTypeTreeContentProvider
    implements ITreeContentProvider {
        private ErrorTypeTreeContentProvider() {
        }

        public Object[] getElements(Object inputElement) {
            ErrorModel[] errors;
            ArrayList<ErrorModel> result = new ArrayList<ErrorModel>();
            ErrorModel[] errorModelArray = errors = (ErrorModel[])inputElement;
            int n = errors.length;
            int n2 = 0;
            while (n2 < n) {
                ErrorModel error = errorModelArray[n2];
                if (!error.getParent().isPresent()) {
                    result.add(error);
                }
                ++n2;
            }
            return result.toArray();
        }

        public Object[] getChildren(Object parentElement) {
            ErrorModel[] options;
            if (!(parentElement instanceof ErrorModel)) {
                return null;
            }
            ErrorModel parent = (ErrorModel)parentElement;
            ArrayList<ErrorModel> children = new ArrayList<ErrorModel>();
            ErrorModel[] errorModelArray = options = (ErrorModel[])ErrorTypesTree.this.getTypesTree().getInput();
            int n = options.length;
            int n2 = 0;
            while (n2 < n) {
                ErrorModel option = errorModelArray[n2];
                Optional optionParent = option.getParent();
                if (optionParent.isPresent() && ErrorTypesTree.sameError((ErrorModel)optionParent.get(), parent)) {
                    children.add(option);
                }
                ++n2;
            }
            return children.toArray();
        }

        public Object getParent(Object element) {
            if (!(element instanceof ErrorModel)) {
                return null;
            }
            Optional parent = ((ErrorModel)element).getParent();
            if (parent.isPresent()) {
                return parent.get();
            }
            return null;
        }

        public boolean hasChildren(Object element) {
            if (!(element instanceof ErrorModel)) {
                return false;
            }
            ErrorModel parent = (ErrorModel)element;
            ErrorModel[] errorModelArray = ErrorTypesTree.this.options;
            int n = ErrorTypesTree.this.options.length;
            int n2 = 0;
            while (n2 < n) {
                ErrorModel option = errorModelArray[n2];
                Optional optionParent = option.getParent();
                if (optionParent.isPresent() && ErrorTypesTree.sameError((ErrorModel)optionParent.get(), parent)) {
                    return true;
                }
                ++n2;
            }
            return false;
        }
    }
}

